#
#       canon_pjl.py
#
#       2003.11.20
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.pjl.pjl_printer
import Lpy.pjl.pjl_class

import canon_models

class Vendor_PrinterType(Lpy.pjl.pjl_printer.PrinterType,canon_models.Canon_Model):
    def __init__(self,ptype = None,model = None):
        Lpy.pjl.pjl_printer.PrinterType.__init__(self)
        canon_models.Canon_Model.__init__(self)
        self.check_model(ptype,model)

class Vendor_model(Lpy.pjl.pjl_printer.PrinterModel,canon_models.Canon_Model):
    def __init__(self,ptype,model= None):
        Lpy.pjl.pjl_printer.PrinterModel.__init__(self)
        canon_models.Canon_Model.__init__(self)
        self.check_model(ptype,model)

class Vendor_lang(Lpy.pjl.pjl_printer.PrinterLang,canon_models.Canon_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.PrinterLang.__init__(self)
        canon_models.Canon_Model.__init__(self)
        self.check_model(ptype,model)
        self.value = self.value_list[0]

class Vendor_gs(Lpy.pjl.pjl_printer.GhostScript,canon_models.Canon_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.GhostScript.__init__(self)
        canon_models.Canon_Model.__init__(self)
        self.support = self.ON
        self.value = 'lips4'

class Vendor_PrinterPJL(Lpy.pjl.pjl_printer.PrinterPJL,canon_models.Canon_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.PrinterPJL.__init__(self)
        canon_models.Canon_Model.__init__(self)
    def check_model(self,ptype,model):
        ptype = self.get_keyname(ptype)
        if ptype == self.InkJet:
            self.support = self.Never
            self.tmp = self.Never
        else:
            self.support = self.OFF
            self.tmp = self.OFF

######

class Vendor_SNMP(Lpy.pjl.pjl_printer.SNMP,canon_models.Canon_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.SNMP.__init__(self)
        canon_models.Canon_Model.__init__(self)
        self.vendorID = 1602
    def check_model(self,ptype,model):
        self.support = self.OFF

class Vendor_IPP(Lpy.pjl.pjl_printer.IPP,canon_models.Canon_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.IPP.__init__(self)
        canon_models.Canon_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.OFF

class Vendor_Duplex(Lpy.pjl.pjl_printer.Duplex,canon_models.Canon_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.Duplex.__init__(self)
        canon_models.Canon_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

#####
class Vendor_Copies(Lpy.pjl.pjl_class.Copies,canon_models.Canon_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Copies.__init__(self)
        canon_models.Canon_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_Orientation(Lpy.pjl.pjl_class.Orientation,canon_models.Canon_Model):
    def __init__(self,model = None,dum= None):
        Lpy.pjl.pjl_class.Orientation.__init__(self)
        canon_models.Canon_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support =  self.ON

class Vendor_resolv(Lpy.pjl.pjl_class.Resolution,canon_models.Canon_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Resolution.__init__(self)
        canon_models.Canon_Model.__init__(self)
        resolv = ['300','600']
        self.support = self.ON
        self.set_vlist(resolv,1)
    def check_model(self,ptype,model):
        self.support = self.ON

## Color Printer
class Vendor_colorPrinter(Lpy.pjl.pjl_class.ColorPrinter,canon_models.Canon_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.ColorPrinter.__init__(self)
        canon_models.Canon_Model.__init__(self)
        self.pjl_cmd = None
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.OFF
        else:
            self.support = self.ON
