#! /usr/bin/env python
#
#       gtk_msg.py
#
#       2003.12.25
#       2004.6.25
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import gtk
import pango

import os,sys
import thread
import time

__program = "msg_window.py"

def get_font_desc(Font_name = "Sans 12"):
        desc = pango.FontDescription(Font_name)
        if not desc:
            for font in ("Couier 12","Serif 12"):
                desc = pango.FontDescription(Font_name)
                break
        return desc

def get_textview(Font_name = "Sans 12"):
        textview = gtk.TextView()
        colormap = textview.get_colormap()
        #textview.modify_base(gtk.STATE_NORMAL,colormap.alloc_color('#152636')) 
        #textview.modify_text(gtk.STATE_NORMAL,colormap.alloc_color("#FFDF8F")) 
        textview.modify_base(gtk.STATE_NORMAL,colormap.alloc_color('gray')) 
        textview.set_property("left-margin",6)
        p_con = textview.get_pango_context()
        desc = get_font_desc(Font_name)
        if desc:
            textview.modify_font(desc)
        return textview

## Output Message ##
class Output_Window:
    xsize = 600
    ysize = 200

    def __init__(self,msg1,msg2,mapfile,encoding):
        self.mapfile  = mapfile
        self.encoding = encoding
        window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        window.set_position(gtk.WIN_POS_CENTER)
        window.set_title("Output Message Window")
        window.set_size_request(self.xsize,self.ysize)
        window.connect("destroy", self.win_quit)
        window.connect("delete_event", self.win_quit)
        window.set_border_width(2)

        vbox = gtk.VBox(gtk.FALSE,0)
        sw = gtk.ScrolledWindow()
        sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        textview = get_textview()
        self.textbuffer = gtk.TextBuffer(None)
        self.textbuffer.set_text(msg1 + msg2)
        textview.set_buffer(self.textbuffer)
        textview.set_editable(0)
        textview.set_cursor_visible(0)
        sw.add(textview)
        textview.show()
        sw.show()

        vbox.pack_start(sw,gtk.TRUE,gtk.TRUE,0)

    ## button
        hbox = gtk.HBox(gtk.TRUE,0)
        clear_button = gtk.Button('',gtk.STOCK_CLEAR) # Clear
        clear_button.connect("clicked", self.win_clear)
        clear_button.show()
        hbox.pack_start(clear_button,gtk.TRUE,gtk.FALSE,0)

        close_button = gtk.Button('',gtk.STOCK_CLOSE) # Close
        close_button.connect("clicked", self.win_quit)
        close_button.show()
        hbox.pack_start(close_button,gtk.TRUE,gtk.FALSE,0)
        hbox.show()

        vbox.pack_start(hbox,gtk.FALSE,gtk.FALSE,0)
        vbox.show()
        window.show()
        window.add(vbox)

    def win_quit(self,widget,data = None):
        if os.path.exists(self.mapfile):
            os.remove(self.mapfile)
        gtk.main_main_quitquit()

    def win_clear(self,widget):
        self.textbuffer.delete(self.textbuffer.get_start_iter(),self.textbuffer.get_end_iter())

    def get_mmap(self,tt):
        while 1:
            time.sleep(tt)
            if os.path.exists(self.mapfile):
                fp = open(self.mapfile,"r")
                data = fp.read()
                fp.close()
                os.remove(self.mapfile)
                if data:
                    try:
                        data = unicode(data,self.encoding)
                    except UnicodeError:
                        pass
                    gtk.gdk.threads_enter()
                    self.textbuffer.insert(self.textbuffer.get_end_iter(),data)
                    gtk.gdk.threads_leave()

def output_main(argv,encoding,arg_len):
    if arg_len < 3:
        print "%s output_main() arg error." % __program
        return None
    else:
        try:
            msg1 = unicode(argv[0],encoding)
            msg2 = unicode(argv[1],encoding)
        except UnicodeError:
            msg1 = argv[0]
            msg2 = argv[1]
        mapfile = argv[2]

    gtk.gdk.threads_init()
    output_win = Output_Window(msg1,msg2,mapfile,encoding)
    thread.start_new_thread(output_win.get_mmap,(0.6,))
    gtk.main()

## Wait ##
class Wait_Window:
    xsize = 360
    ysize = 100

    def __init__(self,msg1,msg2,msg3 = None):
        window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        window.set_title("Message Window")
        window.set_size_request(self.xsize,self.ysize)
        window.set_position(gtk.WIN_POS_CENTER)
        window.connect("destroy", gtk.main_quit)
        window.connect("delete_event", gtk.main_quit)
        window.set_border_width(2)
        box = gtk.VBox(gtk.TRUE,0)
        colormap = box.get_colormap()
        self.red = colormap.alloc_color('red')
        self.blue = colormap.alloc_color("deepskyblue4")
        font_desc = get_font_desc("Sans 14")
        self.label1 = gtk.Label(msg1)
        self.label1.modify_font(font_desc)
        self.label1.show()
        box.pack_start(self.label1,gtk.TRUE,gtk.FALSE,0)

        if msg2:
            self.label2 = gtk.Label(msg2)
            self.label2.modify_fg(gtk.STATE_NORMAL,self.red)
            self.label2.modify_font(font_desc)
            self.label2.show()
            box.pack_start(self.label2,gtk.TRUE,gtk.FALSE,0)
        if msg3:
            self.label3 = gtk.Label(msg3)
            self.label3.modify_fg(gtk.STATE_NORMAL,self.blue)
            self.label3.modify_font(font_desc)
            self.label3.show()
            box.pack_start(self.label3,gtk.TRUE,gtk.FALSE,0)

        window.add(box)
        box.show()
        window.show()
        self.window = window

    def end_window(self):
        self.window.destroy()

    def change_color(self,flag):
        while 1:
            time.sleep(1.0)
            gtk.gdk.threads_enter()
            if flag:
                if self.label3:
                    self.label3.modify_fg(gtk.STATE_NORMAL,self.red)
                if self.label2:
                    self.label2.modify_fg(gtk.STATE_NORMAL,self.blue)
                flag = 0
            else:
                if self.label3:
                    self.label3.modify_fg(gtk.STATE_NORMAL,self.blue)
                if self.label2:
                    self.label2.modify_fg(gtk.STATE_NORMAL,self.red)
                flag = 1
            gtk.gdk.threads_leave()

def wait_main(argv,encoding,arg_len):
    if arg_len < 2:
        print "%s wait_main() arg error." % __program
        return None
    
    try:
        msg1 = unicode(argv[0],encoding)
        if argv[1]:
            msg2 = unicode(argv[1],encoding)
        else:
            msg2 = None
        if argv[2]:
            msg3 = unicode(argv[2],encoding)
        else:
            msg3 = None
    except UnicodeError:
            msg1 = argv[0]
            msg2 = argv[1]
            msg3 = argv[2]

    gtk.gdk.threads_init()
    wait_win = Wait_Window(msg1,msg2,msg3)
    thread.start_new_thread(wait_win.change_color,(1,))
    gtk.main()

## Main ##
if __name__ == "__main__":
    if len(sys.argv) <= 4:
        print "%s arg error.(%s)" % (__program, sys.argv)
        sys.exit(1)

    encoding = sys.argv[2]
    arg_len = len(sys.argv[3:])
    if sys.argv[1] == "wait_msg":
        wait_main(sys.argv[3:],encoding,arg_len)

    elif sys.argv[1] == "output_msg":
        output_main(sys.argv[3:],encoding,arg_len)
    else:
         print "%s arg error.(%s)" % (__program, sys.argv)
