#
#       page_advance.py
#
#       2003.5.17
#       2004.7.22
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import gtk

class PageAdvance:
    #title = "Advanced"
    import Lpy.pjl.pjl_title
    sub_title = (Lpy.pjl.pjl_title.u_security,Lpy.pjl.pjl_title.u_style)

    def page(self):
        base_vbox = gtk.VBox(gtk.FALSE, 0)
        base_vbox.set_border_width(self.S.Border)
        base_vbox.set_size_request(self.S.Hsize, self.S.Vsize)
        base_vbox.show()

        ## Printing style
        Stframe = self.style_margin()
        if Stframe:
            base_vbox.pack_start(Stframe, gtk.FALSE, gtk.FALSE,0)
 
        Diframe = self.style_division()
        if Diframe:
            base_vbox.pack_start(Diframe, gtk.FALSE, gtk.FALSE, 0)

        Hframe = self.style_hold()
        if Hframe:
            base_vbox.pack_start(Hframe, gtk.FALSE, gtk.FALSE, 0)

        Cframe = self.style_security()
        if Cframe:
            base_vbox.pack_start(Cframe, gtk.FALSE, gtk.FALSE, 0)

        return base_vbox

    ## style
    def style_margin(self):
        ## Abox
        Dev_box = gtk.HBox(gtk.FALSE, 0)
        Abox = gtk.VBox(gtk.TRUE, 0)
        Dev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 0)

        margin = 0
        for key in self.PJL.P_margin:
            if self.PJL.get_func(key).get_support() == self.S.ON:
                margin += 1

        A_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        A_table = self.GUI.create_table(3 + margin)
        Abox.pack_start(A_table,gtk.FALSE,gtk.FALSE,0)
        count = 0
        if self.PJL.get_func(self.PJL.P_resolution).get_support() == self.S.ON:
            self.GUI.make_table(A_table,count,A_group,self.PJL.P_resolution)
            Tframe = gtk.Frame(self.PJL.get_func(self.PJL.P_resolution).get_title())
            count += 1

        if self.PJL.get_func(self.PJL.P_density).get_support() == self.S.ON:
            self.density = self.GUI.make_spin(self.PJL.P_density)
            self.GUI.group_table(A_table,count,A_group,self.PJL.P_density,self.density)
            if count == 0:
                Tframe = gtk.Frame(self.PJL.get_func(self.PJL.P_density).get_title())
            count += 1
        if self.PJL.get_func(self.PJL.P_smoothing).get_support() == self.S.ON:
            self.GUI.make_table(A_table,count,A_group,self.PJL.P_smoothing)
            if count == 0:
                Tframe = gtk.Frame(self.sub_title[1])
            count += 1

        a_flag = 0
        ## Margin
        if margin >= 1:
            #marginDic = {}
            for key in self.PJL.P_margin:
                if self.PJL.get_func(key).get_support() == self.S.ON:
                    marginDic = self.GUI.make_spin(key,self.GUI.Integ,
                            self.PJL.get_func(key).get_vlist(),self.PJL.get_func(key).get_value(),self.S.ON)
                    self.GUI.group_table(A_table,count,A_group,key,marginDic,
                            self.PJL.get_func(key).get_title())
                    count += 1

        if self.PJL.get_func(self.PJL.P_marginLTop).get_support() == self.S.ON:
            marginLTop = self.GUI.make_spin(self.PJL.P_marginLTop,self.GUI.Integ)
            margin_label = self.GUI.spin_title(self.PJL.P_marginLTop,marginLTop,
                            self.PJL.get_func(self.PJL.P_marginLTop).get_title())
            Abox.pack_start(margin_label, gtk.TRUE, gtk.FALSE,0)
            a_flag = 1

        if count >= 1:
            Abox.show()
            A_table.show()
        else:
            if a_flag >= 1:
                Abox.show()

        ## Bbox
        Bbox = gtk.VBox(gtk.FALSE, 0)
        bcount = 0
        Dev_box.pack_start(Bbox, gtk.TRUE, gtk.FALSE, 0)
        if self.PJL.get_func(self.PJL.P_quality).get_support() == self.S.ON:
            quality_button,Tquality = self.GUI.table_set(self.PJL.P_quality)
            Bbox.pack_start(quality_button, gtk.TRUE, gtk.FALSE,0)
            bcount += 1
        if self.PJL.get_func(self.PJL.P_tonerSave).get_support() == self.S.ON:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_tonerSave),gtk.TRUE,gtk.FALSE,0)
            bcount += 1
        ## vendor unique function
        if self.PJL.get_func(self.PJL.P_photo).get_support() == self.S.ON:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_photo),gtk.TRUE,gtk.FALSE,0)
            bcount += 1
        if self.PJL.get_func(self.PJL.P_banner).get_support() == self.S.ON:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_banner), gtk.TRUE, gtk.FALSE, 0)
            bcount += 1
        if self.PJL.get_func(self.PJL.P_proof).get_support() == self.S.ON:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_proof), gtk.TRUE, gtk.FALSE, 0)
            bcount += 1
        if self.PJL.get_func(self.PJL.P_scaling).get_support() == self.S.ON:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_scaling), gtk.TRUE, gtk.FALSE, 0)
            bcount += 1
        if self.PJL.get_func(self.PJL.P_mirror).get_support() == self.S.ON:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_mirror), gtk.TRUE, gtk.FALSE, 0)
            bcount += 1
        if self.PJL.get_func(self.PJL.P_rotate).get_support() == self.S.ON:
            button,Trotate = self.GUI.table_set(self.PJL.P_rotate)
            Bbox.pack_start(button, gtk.TRUE, gtk.FALSE,0)
            bcount += 1

        if bcount >= 1:
            Bbox.show()

        if count >= 1 or a_flag >= 1 or bcount >= 1:
            Dev_box.show()
            Tframe.add(Dev_box)
            Tframe.show()
            return Tframe 
        return None

    ## Security
    def style_security(self):
        security   = self.PJL.get_func(self.PJL.P_security).get_support()
        panellock  = self.PJL.get_func(self.PJL.P_panelLock).get_support()
        accounting = self.PJL.get_func(self.PJL.P_accounting).get_support()

        if security != self.S.ON and panellock != self.S.ON and accounting != self.S.ON:
            return None

        Cframe = gtk.Frame(self.sub_title[0])
        Dev_box = gtk.HBox(gtk.FALSE,0)
        Dev_box.show()
        Cframe.add(Dev_box)

        ## Security Print
        if security == self.S.ON:
            Bbox = gtk.VBox(gtk.FALSE, 0)
            Bbox.show()
            Dev_box.pack_start(Bbox, gtk.TRUE, gtk.FALSE, 10)
            Bbox.pack_start(self.GUI.make_chkbutton2(self.PJL.P_security), gtk.TRUE, gtk.FALSE, 0)
            # User Name
            ULbox , uent = self.GUI.input_hbox(self.PJL.P_userName)
            Bbox.pack_start(ULbox, gtk.TRUE, gtk.FALSE ,0)
            # Passwd
            PLbox , pent = self.GUI.input_hbox(self.PJL.P_password)
            Bbox.pack_start(PLbox, gtk.TRUE, gtk.FALSE,0)

        ## panel Lock
        if panellock == self.S.ON or accounting == self.S.ON:
            Abox = gtk.VBox(gtk.FALSE, 0)
            Abox.show()
            Dev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 10)

            if panellock == self.S.ON:
                Abox.pack_start(self.GUI.make_chkbutton2(self.PJL.P_panelLock),gtk.TRUE,gtk.FALSE,0)
                PNLbox , pent = self.GUI.input_hbox(self.PJL.P_panelPass)
                Abox.pack_start(PNLbox, gtk.TRUE, gtk.FALSE,0)

            if accounting == self.S.ON:
                Abox.pack_start(self.GUI.make_chkbutton2(self.PJL.P_accounting),gtk.TRUE,gtk.FALSE,0)
                ACLbox , acc_ent = self.GUI.input_hbox(self.PJL.P_accountName)
                Abox.pack_start(ACLbox, gtk.TRUE, gtk.FALSE,0)
        Cframe.show()
        return Cframe

    ## Hold , disk_Lock
    def style_hold(self):
        holdData = self.PJL.get_func(self.PJL.P_hold).get_support()
        disklock = self.PJL.get_func(self.PJL.P_diskLock).get_support()
        if holdData != self.S.ON and disklock != self.S.ON:
            return None

        Hframe = gtk.Frame(self.PJL.get_func(self.PJL.P_hold).get_title())
        Dev_box = gtk.HBox(gtk.FALSE,0)
        Dev_box.show()
        Hframe.add(Dev_box)

        ## disklock
        if disklock == self.S.ON :
            Abox = gtk.VBox(gtk.FALSE, 0)
            Abox.show()
            Dev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 10)
            Abox.pack_start(self.GUI.make_chkbutton(self.PJL.P_diskLock), gtk.TRUE, gtk.FALSE, 0)

        ## Hold data
        if holdData == self.S.ON:
            Bbox = gtk.VBox(gtk.FALSE, 0)
            Bbox.show()
            Dev_box.pack_start(Bbox, gtk.TRUE, gtk.FALSE, 10)
            A_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
            A_table = self.GUI.create_table(3)
            Bbox.pack_start(A_table,gtk.FALSE,gtk.FALSE,0)
            self.GUI.make_table(A_table,0,A_group,self.PJL.P_hold)
            count = 1
            # P_holdType
            if self.PJL.get_func(self.PJL.P_holdType).get_support() == self.S.ON:
                self.GUI.make_table(A_table,count,A_group,self.PJL.P_holdType)
                count += 1
            # P_holdKey
            if self.PJL.get_func(self.PJL.P_holdKey).get_support() == self.S.ON:
                self.holdkey = self.GUI.make_spin(self.PJL.P_holdKey)
                self.GUI.group_table(A_table,count,A_group,self.PJL.P_holdKey,self.holdkey)

            A_table.show()

        Hframe.show()
        return Hframe

    ## Division
    def style_division(self):
        division   = self.PJL.get_func(self.PJL.P_division).get_support()
        delayPrint = self.PJL.get_func(self.PJL.P_delayPrint).get_support()

        if division != self.S.ON and delayPrint != self.S.ON:
            return None

        Diframe = gtk.Frame(self.PJL.get_func(self.PJL.P_division).get_title())
        Dev_box = gtk.HBox(gtk.FALSE, 0) #gtk.TRUE, 0)
        Dev_box.show()
        Diframe.add(Dev_box)

        if division == self.S.ON :
            Abox = gtk.VBox(gtk.FALSE, 0)
            Abox.show()
            Dev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 0)
            Abox.pack_start(self.GUI.make_chkbutton(self.PJL.P_division), gtk.TRUE, gtk.FALSE, 0)
            Lbox , ent = self.GUI.input_hbox(self.PJL.P_divisionName)
            Abox.pack_start(Lbox, gtk.TRUE, gtk.FALSE ,0)

        if delayPrint == self.S.ON:
            Bbox = gtk.VBox(gtk.FALSE, 0)
            Bbox.show()
            Dev_box.pack_start(Bbox, gtk.TRUE, gtk.FALSE, 0)
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_delayPrint), gtk.TRUE, gtk.FALSE, 0)
            self.delaytime = self.GUI.make_spin(self.PJL.P_delayTime)
            dtitile = self.GUI.spin_title(self.PJL.P_delayTime,self.delaytime)
            Bbox.pack_start(dtitile, gtk.TRUE, gtk.FALSE,0)
        Diframe.show()
        return Diframe
