#
#   paper_size.py
#
#   2003.12.2
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
default_paper = "a4"
UserSize = 'CustomPaper'

## a2ps paper
A2_papers = ['A4','A3','A5','Letter','Legal','Ledger','B4','B5',  # <= jisb4,5
    'Executive','Statement','Folio','Tabloid','Quarto','10x14'] # ,'A4dj','Letterdj']
## pjl Paper
pjl_papers = ["A4","A5","LETTER","LEGAL","A3","EXECTIVE","LEDGER",'FOOLSCAP',
    "JISB5","JISB4","ISOB5","ROC8k","ROC16K","EIGHTPOINT5X13","JISEXEC",
    "B5","C5","DL","MONARCH","COM10",
    "JPOST","JPOSTD","CUSTOM"]

## psutils Paper
psutils_papers = ('a4','a3','a5','letter','legal','b5', # JISB5
    'executive','statement','folio','tabloid','quarto','10x14')


# Jpost   3.94,5.83 (100x148mm)
# invoice 5.50,8.50

#  ref)
#   ghostscript/7.07/lib/gs_statd.ps
#   points(x,y) 1/72 of inch
gs_papers = {
"11x17": 	 (792,1224),  # tabloid
"ledger": 	 (1224,792),  # 11x17in landscape
"legal": 	 (612,1008),
"letter": 	 (612,792),   # 8.5x11
"lettersmall": (612,792),
"halfletter":  (396,612),
"note": 	   (540,720), # 7.5x10

"a0": 	 (2384,3370),
"a1": 	 (1684,2384),
"a2": 	 (1191,1684),
"a3": 	 (842,1191),
"a4": 	 (595,842),
"a5": 	 (420,595),
"a6": 	 (297,420),
"a7": 	 (210,297),
"a8": 	 (148,210),
"a9": 	 (105,148),
"a10":   (73 ,105),

"isob0": (2835,4008),
"isob1": (2004,2835),
"isob2": (1417,2004),
"isob3": (1001,1417),
"isob4": (709,1001),
"isob5": (499,709),
"isob6": (354,499),

"jisb0": (2920,4127),
"jisb1": (2064,2920),
"jisb2": (1460,2064),
"jisb3": (1032,1460),
"jisb4": (729,1032),
"jisb5": (516,729),
"jisb6": (363,516),

"c0": 	 (2599,3677),
"c1": 	 (1837,2599),
"c2": 	 (1298,1837),
"c3": 	 (918,1298),
"c4": 	 (649,918),
"c5": 	 (459,649),
"c6": 	 (323,459),

"archE": (2592,3456),
"archD": (1728,2592),
"archC": (1296,1728),
"archB": (864 ,1296),
"archA": (648 ,864),

"flsa": (612,936), #U.S. foolscap
"flse": (612,936), #European foolscap
}

gs_paper_alias = {
"b0": "jisb0",
"b1": "jisb1",
"b2": "jisb2",
"b3": "jisb3",
"b4": "jisb4",
"b5": "jisb5",
"b6": "jisb6",
"arche": "archE",
"archd": "archD",
"archc": "archC",
"archb": "archB",
"archa": "archA",
"folio": "flsa",
"foolscap": "flsa",
"tabloid" : "11x17",
"statement": "halfletter",
"executive": "note",
"lettersmall": "letter", # ImagingBBox of [25 25 587 767].
"a4small"    : "a4",     # ImagingBBox of [25 25 570 817].
}

gs_paper_unknown = {
"quarto": (610,780),
"10x14" : (720,1008),
}

def gs_support_name(name):
    if gs_papers.has_key(name):
        return name

    dat = name.lower()
    if gs_papers.has_key(dat):
        return dat

    if gs_paper_alias.has_key(dat):
        return gs_paper_alias[dat]
    return None

## unit ##
U_mm   = "mm"
U_cm   = "cm"
U_inch = "inch"
U_points = "points"

unitsList = (U_mm,U_cm,U_inch,U_points)

def convert_unit(fromUnit,toUnit,data):
    dat = float(data)
    if fromUnit == U_points:
        data = dat/72.0
        if toUnit == U_mm:
            ret = data*25.4
        elif toUnit == U_cm:
            ret = data*2.54
        elif toUnit == U_inch:
            ret = data
        return '%.4f' % ret

    elif fromUnit == U_inch:
        if toUnit == U_mm:
            ret = dat*25.4
        elif toUnit == U_cm:
            ret = dat*2.54
        elif toUnit == U_points:
            return str( int(dat*72.0 + 0.5))
        return '%.4f' % ret

    elif fromUnit == U_cm:
        if toUnit == U_mm:
            ret = dat*10
        elif toUnit == U_points:
            return str( int(dat*72.0/2.54))
        elif toUnit == U_inch:
            ret = dat/2.54
        return '%.4f' % ret

    elif fromUnit == U_mm:
        if toUnit == U_points:
            return str( int(dat*72.0/25.4))
        elif toUnit == U_inch:
            ret = dat/25.4
        elif toUnit == U_cm:
            ret = dat/10.0
        return '%.4f' % ret

def get_papersize(paper,unit = None):
    name = paper.lower()
    papername = gs_support_name(name)
    if papername:
        size = gs_papers[papername]
    else:
        if gs_paper_unknown.has_key(name):
            size = gs_paper_unknown[name]
        else:
            return None,None

    if unit == U_points:
        return str(size[0]),str(size[1])
    ## inch
    width  = size[0]/72.0
    height = size[1]/72.0

    if unit == U_mm:
        width  = width*25.4
        height = height*25.4
    elif unit == U_cm:
        width  = width*2.54
        height = height*2.54

    return '%.4f' % width,'%.4f' % height
