#
#       tc_printer.py
#
#       2003.8.16
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#######################################

## hostMIB
DeviceStatus = {
    "1":  "unknown",
    "2":  "running",
    "3":  "warning",
    "4":  "testing",
    "5":  "down" }

PrinterStatus = {
    "1":  "other",
    "2":  "unknown",
    "3":  "idle",
    "4":  "printing",
    "5":  "warmup"}

DetectedError = {
    "0x0":  "No Error",
    "0x1":  "Service Requested",
    "0x2":  "Offline",
    "0x4":  "Jammed",
    "0x8":  "Door Open",
    "0x10": "No Toner",
    "0x20": "Low Toner",
    "0x40": "No Paper",
    "0x80": "Low Paper",
    }

## PrinterMIB
PresentOnOff = {
    "1":  "other",
    "3":  "ON",
    "4":  "OFF",
    "5":  "NotPresent"}

MediaUnit = {
    "3":  "tenThousandthsOfInches", # .0001 inch
    "4":  "micrometers"}            # .001 mm

CapacityUnit = {
    "1":  "other",
    "2":  "unknown",
    "3":  "tenThousandthsOfInches", # .0001
    "4":  "micrometers",
    "8":  "sheets",
    "16":  "feet",
    "17":  "meters",
    "18":  "items",
    "19":  "percent"}

CapacityError = {
    "-1":  "no restriction", # other
    "-2":  "unknown"} # auto

SubUnitStatus = {
    "0":  "Available and Idle",
    "2":  "Available and Standby",
    "4":  "Available and Active",
    "6":  "Available and Busy",
    "1":  "Unavailable and OnRequest",
    "3":  "Unavailable because Broken",
    "5":  "Unknown",
    "8":   "Non-Critical Alerts",
    "16":  "Critical Alerts",
    "32":  "Intended state is Off-Line",
    "64":  "Transitioning to intended state"}

## General
GeneralReset = {
    "3":  "notResetting",
    "4":  "powerCycleReset", # Cold start
    "5":  "resetToNVRAM",    # Warm start
    "6":  "resetToFactoryDefaults"} # reset default

ConsoleDisable = {
    "3":  "enabled",
    "4":  "disabled",
    }

## Cover
CoverStatus = {
    "1":  "other",
    "3":  "doorOpen",
    "4":  "doorClosed",
    "5":  "interlockOpen",
    "6":  "interlockClosed"}

## Input
InputType = {
    "1":  "other",
    "2":  "Auto",    #"unknown",
    "3":  "Tray",    # "sheetFeedAutoRemovableTray",
    "4":  "MPTray",  # "sheetFeedAutoNonRemovableTray",
    "5":  "sheetFeedManual",   # Manual
    "6":  "Roll",    #"continuousRoll",
    "7":  "FanFold", #"continuousFanFold"
   }

## Output
OutputType = {
    "1":  "other",
    "2":  "Auto",    #"unknown",
    "3":  "Tray",    #"removableBin",
    "4":  "Tray",    #"unRemovableBin",
    "5":  "Roll",    #"continuousRollDevice",
    "6":  "MailBox",
    "7":  "FanFold", #"continuousFanFold"
    }

StackingOrder = {
    "2":  "unknown",
    "3":  "firstToLast",
    "4":  "lastToFirst"}

PageDeliveryOrientation = {
    "3":  "faceUp",
    "4":  "faceDown"}

## Marker
MarkerMarkTech = {
    "1":  "other",
    "2":  "unknown",
    "3":  "electrophotographicLED",
    "4":  "electrophotographicLaser",
    "5":  "electrophotographicOther",
    "6":  "impactMovingHeadDotMatrix9pin",
    "7":  "impactMovingHeadDotMatrix24pin",
    "8":  "impactMovingHeadDotMatrixOther",
    "9":  "impactMovingHeadFullyFormed",
    "10":  "impactBand",
    "11":  "impactOther",
    "12":  "inkjetAqueous",
    "13":  "inkjetSolid",
    "14":  "inkjetOther",
    "15":  "pen",
    "16":  "thermalTransfer",
    "17":  "thermalSensitive",
    "18":  "thermalDiffusion",
    "19":  "thermalOther",
    "20":  "electroerosion",
    "21":  "electrostatic",
    "22":  "photographicMicrofiche",
    "23":  "photographicImagesetter",
    "24":  "photographicOther",
    "25":  "ionDeposition",
    "26":  "eBeam",
    "27":  "typesetter"}

MarkerCounterUnit = {
    "3":  "tenThousandthsOfInches",
    "4":  "micrometers",
    "5":  "characters",
    "6":  "lines",
    "7":  "impressions",
    "8":  "sheets",
    "9":  "dotRow",
    "11":  "hours",
    "16":  "feet",
    "17":  "meters"}

MarkerSuppliesClass = {
    "1":  "other",
    "3":  "supplyThatIsConsumed",
    "4":  "receptacleThatIsFilled"}

MarkerSuppliesType = {
    "1":  "other",
    "2":  "unknown",
    "3":  "toner",
    "4":  "wasteToner",
    "5":  "ink",
    "6":  "inkCartridge",
    "7":  "inkRibbon",
    "8":  "wasteInk",
    "9":  "opc",
    "10":  "developer",
    "11":  "fuserOil",
    "12":  "solidWax",
    "13":  "ribbonWax",
    "14":  "wasteWax",
    "15":  "fuser",
    "16":  "coronaWire",
    "17":  "fuserOilWick",
    "18":  "cleanerUnit",
    "19":  "fuserCleaningPad",
    "20":  "transferUnit",
    "21":  "tonerCartridge",
    "22":  "fuserOiler",
    "23":  "water" ,
    "24":  "wasteWater",
    "25":  "GlueWaterAdditive",
    "26":  "wastePaper",
    "27":  "bindingSupply",
    "28":  "bandingSupply",
    "29":  "stitchingWire",
    "30":  "shrinkWrap",
    "31":  "paperWrap",
    "32":  "staples",
    "33":  "inserts",
    "34":  "covers"}

MarkerSuppliesSupplyUnit = {
    "3":   "tenThousandthsOfInches",
    "4":   "micrometers",
    "12":  "thousandthsOfOunces",
    "13":  "tenthsOfGrams",
    "14":  "hundrethsOfFluidOunces",
    "15":  "tenthsOfMilliliters",
    "16":  "feet",
    "17":  "meters",
    "18":  "items",
    "19":  "percent"}

MarkerColorantRole = {
    "1":  "other",
    "3":  "process",
    "4":  "spot"}

## MediaPath
MediaPathSpeed = {
    "3":  "tenThousandthsOfInchesPerHour",
    "4":  "micrometersPerHour",
    "5":  "charactersPerHour",
    "6":  "linesPerHour",
    "7":  "impressionsPerHour",
    "8":  "sheetsPerHour",
    "9":  "dotRowPerHour",
    "16":  "feetPerHour",
    "17":  "metersPerHour"}

MediaPathType = {
    "1":  "other",
    "2":  "unknown",
    "3":  "longEdgeDuplex", #"longEdgeBindingDuplex",
    "4":  "shortEdgeDuplex", #"shortEdgeBindingDuplex",
    "5":  "simplex"}

## Channel
ChannelType = {
    "1":  "other",
    "3":  "SerialPort",
    "4":  "ParallelPort",
    "5":  "IEEE1284Port",
    "6":  "SCSIPort",
    "7":  "AppleTalkPAP",
    "8":  "LPDServer",
    "9":   "NetwareRPrinter",
    "10":  "NetwarePServer",
    "11":  "Port9100",
    "12":  "AppSocket",
    "13":  "FTP",
    "14":  "TFTP",
    "15":  "DLCLLCPort",
    "16":  "IBM3270",
    "17":  "IBM5250",
    "18":  "Fax",
    "19":  "IEEE1394",
    "20":  "Transport1",
    "21":  "CPAP",
    "26":  "PCPrint",
    "27":  "ServerMessageBlock",
    "28":  "PSM",
    "31":  "SystemObjectManager",
    "32":  "DECLAT",
    "33":  "NPAP",
    "34":  "USB",
    "35":  "IRDA",
    "36":  "PrintXChange",
    "37":  "PortTCP",
    "38":  "BidirPortTCP",
    "39":  "UNPP",
    "40":  "AppleTalkADSP",
    "41":  "PortSPX",
    "42":  "PortHTTP",
    "43":  "NDPS",
    "44":  "IPP",
    "45":  "SMTP"}

ChannelState = {
    "1":  "other",
    "3":  "printDataAccepted",
    "4":  "noDataAccepted"}

## Interpreter
LangFamily = {
    "1":  "other",
    "2":  "unknown",
    "3":  "PCL", ##
    "4":  "HPGL",
    "5":  "PJL", ##
    "6":  "PS",
    "7":  "IDPS",
    "8":  "PPDS",
    "9":  "EscapeP",
    "10":  "Epson",
    "11":  "DDIF",
    "12":  "Interpress",
    "13":  "ISO6429",
    "14":  "LineData",
    "15":  "MODCA",
    "16":  "REGIS",
    "17":  "SCS",
    "18":  "SPDL",
    "19":  "TEK401",
    "20":  "PDS",
    "21":  "IGP",
    "22":  "CodeV",
    "23":  "DSCDSE",
    "24":  "WPS",
    "25":  "LN03",
    "26":  "CCITT",
    "27":  "QUIC",
    "28":  "CPAP",
    "29":  "DecPPL",
    "30":  "SimpleText",
    "31":  "NPAP",
    "32":  "DOC",
    "33":  "imPress",
    "34":  "Pinwriter",
    "35":  "NPDL",
    "36":  "NEC201PL",
    "37":  "Automatic",
    "38":  "Pages",
    "39":  "LIPS",
    "40":  "TIFF",
    "41":  "Diagnostic",
    "42":  "PSPrinter",
    "43":  "CaPSL",
    "44":  "EXCL",
    "45":  "LCDS",
    "46":  "XES",
    "47":  "PCLXL", # HP
    "48":  "ART",   # Xerox
    "49":  "TIPSI",
    "50":  "Prescribe",
    "51":  "LinePrinter",
    "52":  "IDP",
    "53":  "XJCL", # Xerox Job Control Language
    "54":  "PDF",
    "55":  "RPDL", # Ricoh
    "56":  "IntermecIPL",
    "57":  "UBIFingerprint",
    "58":  "UBIDirectProtocol",
    "59":  "Fujitsu",
    "60":  "CGM",
    "61":  "JPEG",
    "62":  "CALS1",
    "63":  "CALS2",
    "64":  "NIRS",
    "65":  "C4" }

Orientation = {
    "1":  "other",
    "3":  "portrait",
    "4":  "landscape"}

YesNo = {
    "3":  'yes',
    "4":  'no'}

## Console
ConsoleColor = {
    "1":  "other",
    "2":  "unknown",
    "3":  "white",
    "4":  "red",
    "5":  "green",
    "6":  "blue",
    "7":  "cyan",
    "8":  "magenta",
    "9":  "yellow",
    "10": "orange"}

ConsoleDisable = {
    "3":  "enabled",
    "4":  "disabled",
    }

## Alert
AlertServerityLevel = {
    "1":  "other",
    "3":  "critical",
    "4":  "warning",
    "5":  "warningBinaryChangeEvent"}

AlertTrainingLevel = {
    "1":  "other",
    "2":  "unknown",
    "3":  "untrained",    # easy
    "4":  "trained",      # operator
    "5":  "fieldService", # field service call
    "6":  "management",
    "7":  "NoInterventionRequired"}

AlertGroup = {
    "1":  "other",
    "3":  "hostResourcesMIBStorageTable",
    "4":  "hostResourcesMIBDeviceTable",
    "5":  "generalPrinter",
    "6":  "cover",
    "7":  "localization",
    "8":  "input",
    "9":  "output",
    "10":  "marker",
    "11":  "markerSupplies",
    "12":  "markerColorant",
    "13":  "mediaPath",
    "14":  "channel",
    "15":  "interpreter",
    "16":  "consoleDisplayBuffer",
    "17":  "consoleLights",
    "18":  "alert",
    "30":  "finDevice", # Finisher
    "31":  "finSupply",
    "32":  "finSupplyMediaInput",
    "33":  "finAttributetable" }

AlertCode = {
    "1":  "other",
    "2":  "unknown",
    "3":  "coverOpen",
    "4":  "coverClosed",
    "5":  "interlockOpen",
    "6":  "interlockClosed",
    "7":  "configurationChange",
    "8":  "jam",
    "9":   "subunitMissing",
    "10":  "subunitLifeAlmostOver",
    "11":  "subunitLifeOver",
    "12":  "subunitAlmostEmpty",
    "13":  "subunitEmpty",
    "14":  "subunitAlmostFull",
    "15":  "subunitFull",
    "16":  "subunitNearLimit",
    "17":  "subunitAtLimit",
    "18":  "subunitOpened",
    "19":  "subunitClosed",
    "20":  "subunitTurnedOn",
    "21":  "subunitTurnedOff",
    "22":  "subunitOffline",
    "23":  "subunitPowerSaver",
    "24":  "subunitWarmingUp",
    "25":  "subunitAdded",
    "26":  "subunitRemoved",
    "27":  "subunitResourceAdded",
    "28":  "subunitResourceRemoved",
    "29":  "subunitRecoverableFailure",
    "30":  "subunitUnrecoverableFailure",
    "31":  "subunitRecoverableStorageError",
    "32":  "subunitUnrecoverableStorageError",
    "33":  "subunitMotorFailure",
    "34":  "subunitMemoryExhausted",
    "35":  "subunitUnderTemperature",
    "36":  "subunitOverTemperature",
    "37":  "subunitTimingFailure",
    "38":  "subunitThermistorFailure",
    "501":  "doorOpen",
    "502":  "doorClosed",
    "503":  "powerUp",
    "504":  "powerDown",
    "505":  "printerNMSReset",
    "506":  "printerManualReset",
    "507":  "printerReadyToPrint",
    "801":  "inputMediaTrayMissing",
    "802":  "inputMediaSizeChange",
    "803":  "inputMediaWeightChange",
    "804":  "inputMediaTypeChange",
    "805":  "inputMediaColorChange",
    "806":  "inputMediaFormPartsChange",
    "807":  "inputMediaSupplyLow",
    "808":  "inputMediaSupplyEmpty",
    "809":  "inputMediaChangeRequest",
    "810":  "inputManualInputRequest",
    "811":  "inputTrayPositionFailure",
    "812":  "inputTrayElevationFailure",
    "813":  "inputCannotFeedSizeSelected",
    "901":  "outputMediaTrayMissing",
    "902":  "outputMediaTrayAlmostFull",
    "903":  "outputMediaTrayFull",
    "904":  "outputMailboxSelectFailure",
    "1001":  "markerFuserUnderTemperature",
    "1002":  "markerFuserOverTemperature",
    "1003":  "markerFuserTimingFailure",
    "1004":  "markerFuserThermistorFailure",
    "1005":  "markerAdjustingPrintQuality",
    "1101":  "markerTonerEmpty",
    "1102":  "markerInkEmpty",
    "1103":  "markerPrintRibbonEmpty",
    "1104":  "markerTonerAlmostEmpty",
    "1105":  "markerInkAlmostEmpty",
    "1106":  "markerPrintRibbonAlmostEmpty",
    "1107":  "markerWasteTonerReceptacleAlmostFull",
    "1108":  "markerWasteInkReceptacleAlmostFull",
    "1109":  "markerWasteTonerReceptacleFull",
    "1110":  "markerWasteInkReceptacleFull",
    "1111":  "markerOpcLifeAlmostOver",
    "1112":  "markerOpcLifeOver",
    "1113":  "markerDeveloperAlmostEmpty",
    "1114":  "markerDeveloperEmpty",
    "1115":  "markerTonerCartridgeMissing",
    "1301":  "mediaPathMediaTrayMissing",
    "1302":  "mediaPathMediaTrayAlmostFull",
    "1303":  "mediaPathMediaTrayFull",
    "1304":  "mediaPathCannotDuplexMediaSelected",
    "1501":  "interpreterMemoryIncrease",
    "1502":  "interpreterMemoryDecrease",
    "1503":  "interpreterCartridgeAdded",
    "1504":  "interpreterCartridgeDeleted",
    "1505":  "interpreterResourceAdded",
    "1506":  "interpreterResourceDeleted",
    "1507":  "interpreterResourceUnavailable",
    "1509":  "interpreterComplexPageEncountered",
    "1801":  "alertRemovalOfBinaryChangeEntry"}

##### Finisher MIB #####
FinDeviceType = {
    "1":  "other",
    "2":  "unknown",
    "3":  "stitcher",
    "4":  "folder",
    "5":  "binder",
    "6":  "trimmer",
    "7":  "dieCutter",
    "8":  "puncher",
    "9":  "perforater",
    "10":  "slitter",
    "11":  "separationCutter",
    "12":  "imprinter",
    "13":  "wrapper",
    "14":  "bander",
    "15":  "makeEnvelope",
    "16":  "stacker",
    "17":  "sheetRotator",
    "18":  "inserter"}

FinEdge = {
    "3":  "topEdge",
    "4":  "bottomEdge",
    "5":  "leftEdge",
    "6":  "rightEdge"}

FinStitchingType = {
    "1":  "other",
    "2":  "unknown",
    "4":  "stapleTopLeft",
    "5":  "stapleBottomLeft",
    "6":  "stapleTopRight",
    "7":  "stapleBottomRight",
    "8":  "saddleStitch",
    "9":  "edgeStitch",
    "10":  "stapleDual"}

FinStitchingDirType = {
    "2":  "unknown",
    "3":  "topDown",
    "4":  "bottomUp"}

FinStitchingAngleType = {
    "2":  "unknown",
    "3":  "horizontal",
    "4":  "vertical",
    "5":  "slanted"}

FinFoldingType = {
    "1":  "other",
    "2":  "unknown",
    "3":  "zFold",
    "4":  "halfFold",
    "5":  "letterFold"}

FinBindingType = {
    "1":  "other",
    "2":  "unknown",
    "4":  "tape",
    "5":  "plastic",
    "6":  "velo",
    "7":  "perfect",
    "8":  "spiral",
    "9":  "adhesive",
    "10":  "comb",
    "11":  "padding"}

FinPunchHoleType = {
    "1":  "other",
    "2":  "unknown",
    "3":  "round",
    "4":  "oblong",
    "5":  "square",
    "6":  "rectangular",
    "7":  "star"}

FinPunchPattern = {
    "1":  "other",
    "2":  "unknown",
    "4":  "twoHoleUSTop",    # --Letter/legal, 8.5 inch edge
    "5":  "threeHoleUS",     # --Letter/ledger, 11 inch edge
    "6":  "twoHoleDIN",      # --A4/A3, 297 mm edge
    "7":  "fourHoleDIN",     # --A4/A3, 297 mm edge
    "8":  "twentyTwoHoleUS", # --Letter/ledger, 11 inch edge
    "9":  "nineteenHoleUS",  # --Letter/ledger, 11 inch edge
    "10":  "twoHoleMetric", # --B5/B4, 257 mm edge
    "11":  "swedish4Hole",  # --A4/A3, 297 mm edge
    "12":  "twoHoleUSSide", # --Letter/ledger, 11 inch edge
    "13":  "fiveHoleUS",    # --Letter/ledger, 11 inch edge
    "14":  "sevenHoleUS",   # --Letter/ledger, 11 inch edge
    "15":  "mixed7H4S",     # --A4/A3, 297 mm edge
    "16":  "norweg6Hole",   # --A4/A3, 297 mm edge
    "17":  "metric26Hole",  # --B5/B4, 257 mm edge
    "18":  "metric30Hole"   # --A4/A3, 297 mm edge
    }

FinSlittingType = {
    "1":  "other",
    "2":  "unknown",
    "4":  "slitAndSeparate",
    "5":  "slitAndMerge"}

FinWrappingType = {
    "1":  "other",
    "2":  "unknown",
    "4":  "shrinkWrap",
    "5":  "paperWrap"}

FinStackOutputType = {
    "1":  "other",
    "2":  "unknown",
    "4":  "straight",
    "5":  "offset",
    "6":  "crissCross"}

FinAttributeType = {
    "1":  "other",
    "2":  "unknown",
    "3":  "deviceName",
    "4":  "deviceVendorName",
    "5":  "deviceModel",
    "6":  "deviceVersion",
    "7":  "deviceSerialNumber",
    "8":  "maximumSheets",
    "9":  "finProcessOffsetUnits",
    "10":  "finReferenceEdge",
    "11":  "finAxisOffset",
    "12":  "finJogEdge",
    "13":  "finHeadLocation",
    "14":  "finOperationRestrictions",
    "15":  "finNumberOfPositions",
    "16":  "namedConfiguration",
    "17":  "finMediaTypeRestriction",
    "18":  "finPrinterInputTraySupported",
    "19":  "finPreviousFinishingOperation",
    "20":  "finNextFinishingOperation",
    "30":  "stitchingType",
    "31":  "stitchingDirection",
    "40":  "foldingType",
    "50":  "bindingType",
    "80":  "punchHoleType",
    "81":  "punchHoleSizeLongDim",
    "82":  "punchHoleSizeShortDim",
    "83":  "punchPattern",
    "100":  "slittingType",
    "130":  "wrappingType",
    "160":  "stackOutputType",
    "161":  "stackOffset",
    "162":  "stackRotation"}

##############  index ##############
TC_index = {
    "DeviceStatus":  DeviceStatus,
    "PrinterStatus": PrinterStatus,
    "DetectedError": DetectedError,
## PrinterMIB
    "PresentOnOff":  PresentOnOff,
    "MediaUnit":     MediaUnit,
    "CapacityUnit":  CapacityUnit,
    "CapacityError": CapacityError,
    "SubUnitStatus": SubUnitStatus,
## General
    "GeneralReset": GeneralReset,
    "ConsoleDisable": ConsoleDisable,
## Cover
    "CoverStatus":  CoverStatus,
## Input
    "InputType":   InputType,
## Output
    "OutputType":  OutputType,
    "StackingOrder":  StackingOrder,
    "PageDeliveryOrientation": PageDeliveryOrientation,
   ## Marker
    "MarkerMarkTech":  MarkerMarkTech,
    "MarkerCounterUnit": MarkerCounterUnit,
    "MarkerSuppliesClass": MarkerSuppliesClass,
    "MarkerSuppliesType":  MarkerSuppliesType,
    "MarkerSuppliesSupplyUnit": MarkerSuppliesSupplyUnit,
    "MarkerColorantRole":  MarkerColorantRole,
   ## MediaPath
    "MediaPathSpeed": MediaPathSpeed,
    "MediaPathType":  MediaPathType,
   ## Channel
    "ChannelType":  ChannelType,
    "ChannelState": ChannelState,
   ## Interpreter
    "LangFamily":  LangFamily,
    "Orientation": Orientation,
    "YesNo":  YesNo,
   ## Console
    "ConsoleColor":   ConsoleColor,
    "ConsoleDisable": ConsoleDisable,
   ## Alert
    "AlertServerityLevel": AlertServerityLevel,
    "AlertTrainingLevel":  AlertTrainingLevel,
    "AlertGroup": AlertGroup,
    "AlertCode":  AlertCode,
   ##### Finisher MIB #####
    "FinDeviceType": FinDeviceType,
    "FinEdge":  FinEdge,
    "FinStitchingType":    FinStitchingType,
    "FinStitchingDirType": FinStitchingDirType,
    "FinStitchingAngleType": FinStitchingAngleType,
    "FinFoldingType":   FinFoldingType,
    "FinBindingType":   FinBindingType,
    "FinPunchHoleType": FinPunchHoleType,
    "FinPunchPattern":  FinPunchPattern,
    "FinSlittingType":  FinSlittingType,
    "FinWrappingType":  FinWrappingType,
    "FinStackOutputType": FinStackOutputType,
    "FinAttributeType":   FinAttributeType,
}
