#
#       print_mib.py
#
#       2004.4.29
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import types
import string

## Debug ##
def print_mib_debug(mib):
        keys= mib.keys()
        keys.sort()
        for key in keys:
            print key,mib[key]

def get_keylen(key):
    if isinstance(key, types.UnicodeType): 
        dlen = 0
        for ii in key:
            if ii in string.printable:
                dlen += 1
            else:
                dlen += 2
    else:
        dlen = len(key)
    return dlen

def set_text_text(key,text,num = None,maxlen = 18):
    dstart = maxlen - get_keylen(key)
    if dstart <= 0:
        dstart = 1
 
    if num == None:
        data = "   %s%s= %s" % (key,' '* dstart,text)
    else:
        data = " %s:%s%s= %s" % (num,key,' '* dstart,text)
    return data

def get_dict_text(dicts,flag = 1):
        data = []
        keys = dicts.keys()
        keys.sort()
        maxlen = 18
        for key in keys:
            if isinstance(dicts[key], types.DictType):
                continue
            ii = get_keylen(dicts[key][0]) + 1
            if ii > maxlen:
                maxlen = ii
 
        for key in keys:
            if isinstance(dicts[key],types.DictType):
                continue
            if flag == 2:
                data.append(set_text_text(dicts[key][0],dicts[key][1],None,maxlen))
            else:
                data.append(set_text_text(dicts[key][0],dicts[key][1],key,maxlen))
        return data

def get_dict2_text(dicts,flag = 1):
        data = []
        keys = dicts.keys()
        keys.sort()
        for key in keys:
            if flag == 2:
                data.append(get_dict_text(dicts[key],flag))
            else:
                data.append((" index " + key, get_dict_text(dicts[key])))
            
        return data

