#
#       snmp_check.py
#
#       2003.8.22
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import socket_cmd,snmp_pdu
import oid

class SNMP_Check:
    def __init__(self,host = "localhost",community = "public",port = 161):
        self.host = host
        self.port = port
        self.community = community
        self.socket = None
        self.error  = None

    def socket_open(self,version = 1,timeout = 1.0,retries = 3):
        self.version = version
        self.socket = socket_cmd.Socket_Client(self.host,self.port,timeout,retries)
        self.error = self.socket.get_error("last")
        return self.error

    def set_oid_name(self,name,flag=None):
        if name.startswith(".1.3"):
            return name
        else:
            return oid.get_key_oid(name,flag)

    def get_snmp_data(self,name,request = 'GetNextRequest'):
        oids = self.set_oid_name(name)
        if oids is None:
            self.error = "get_snmp_data::a oid (%s) is not defined." % name
            print self.error
            return None

        mib = self.get_snmpData(oids,'GetRequest')
        if mib:
            if request != 'GetNextRequest':
                return mib
            oid,data = mib
            Mib = {}
            max = len(oids)
            #count = 0
            while 1:
                dat = self.get_snmpData(oid,'GetNextRequest')
                if dat is None:
                    break
                else:
                    oid,data = dat
                    if oid[:max] != oids or Mib.has_key(oid):
                        break
                    Mib[oid] = data
                    #print "next:" , oid #,data
            if Mib:
                return Mib
        return None

    def get_snmpData(self,oid,request):
        pdu_conf = snmp_pdu.get_pdu_data(request,oid,self.community,self.version)
        if pdu_conf is None:
            self.error = "get_snmpData() request Error.%s " % request
            print self.error
            return None

        data = self.socket.send_and_receive(pdu_conf.data)
        if not data:
            self.error = self.socket.get_error("last")
            print self.error
            return None

        if data:
            Mib = snmp_pdu.decode_mib_data(data)
            if Mib is None:
                print "snmp_pdu.decode_mib_data is None"
                return None

            if Mib.version != self.version:
                self.error = "Mib version is different."
                print self.error
                return None

            if Mib.community != self.community:
                self.error = "Mib community is different."
                print self.error
                return None

            if Mib.id != pdu_conf.id:
                self.error = "Mib ID is different."
                print self.error
                return None

            if Mib.error_info != 0x00 and Mib.error_info != 'noSuchName' and Mib.oid is None:
                    self.error = "Mib Error %s:%s." % (Mib.error_info,Mib.error_position)
                    print self.error
                    return None

            if Mib.error:
                self.error = "Mib data Error .",Mib.error
                print self.error
                return None

            return Mib.oid
        return None

   ## enterprises
    def check_enterprises_mib(self,vendorID):
        if vendorID is None:
            return None

        mib = self.get_snmp_data(vendorID )
        if mib == None:
            return None
        return mib

## Set mib data
    def mib_index_count(self,data,oid,max = 24):
        count = max
        while count > 1:
            if data.has_key(oid + str(count)):
               break
            count -= 1
        return count

    def get_index_data(self,data,oid,min,end,name):
        flag = 0
        mib = []
        while min <= end:
            keyname = oid + '.' + str(min) + '.' + name
            #print keyname
            if data.has_key(keyname):
                mib.append(data[keyname])
                flag = 1
            else:
                mib.append('')
            min += 1
        if flag == 0:
            return None
        return mib

    def get_index_mib2(self,data,oid,deviceindex,max_count,min,end):
        mibData = {}
        count =1
        while count <= max_count:
            tmp = self.get_index_data(data,oid,min,end,deviceindex + '.' + str(count))
            if tmp:
                mibData["%02d" % count] = tmp
            count += 1
        return  mibData

    def get_index_mib(self,data,oid,max_count,min,end):
        mibData = {}
        count =1
        while count <= max_count:
            tmp = self.get_index_data(data,oid,min,end,str(count))
            if tmp:
                mibData["%02d" % count] = tmp
            count += 1
        return  mibData

