#
#       etc_pjl.py
#
#       2003.11.20
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.pjl.pjl_class
import Lpy.pjl.pjl_printer
import Lpy.printer_model
import Lpy.pjl.pjl_title

class Etc_Model(Lpy.printer_model.Model_lang):
    # must be list
    model_lists = [Lpy.printer_model.Model_lang.Laser,Lpy.printer_model.Model_lang.CLaser] 

    def __init__(self):
        Lpy.printer_model.Model_lang.__init__(self)


class Vendor_PrinterType(Lpy.pjl.pjl_printer.PrinterType,Etc_Model):
    def __init__(self,ptype = None,model = None):
        Lpy.pjl.pjl_printer.PrinterType.__init__(self)
        Etc_Model.__init__(self)
        self.check_model(ptype,model)

class Vendor_model(Lpy.pjl.pjl_printer.PrinterModel,Etc_Model):
    def __init__(self,ptype,model= None):
        Lpy.pjl.pjl_printer.PrinterModel.__init__(self)
        Etc_Model.__init__(self)
        self.check_model(ptype,model)

class Vendor_lang(Lpy.pjl.pjl_printer.PrinterLang,Etc_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.PrinterLang.__init__(self)
        Etc_Model.__init__(self)
        self.check_model(ptype,model)
        self.value = self.value_list[0]

class Vendor_gs(Lpy.pjl.pjl_printer.GhostScript,Etc_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.GhostScript.__init__(self)
        Etc_Model.__init__(self)
        self.support = self.ON
        self.value = 'ljet4'

class Vendor_PrinterPJL(Lpy.pjl.pjl_printer.PrinterPJL,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.PrinterPJL.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.OFF

#####
class Vendor_SNMP(Lpy.pjl.pjl_printer.SNMP,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.SNMP.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.OFF

class Vendor_IPP(Lpy.pjl.pjl_printer.IPP,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.IPP.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.OFF

class Vendor_Duplex(Lpy.pjl.pjl_printer.Duplex,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.Duplex.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.OFF

#####
class Vendor_Copies(Lpy.pjl.pjl_class.Copies,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Copies.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_Orientation(Lpy.pjl.pjl_class.Orientation,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Orientation.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_resolv(Lpy.pjl.pjl_class.Resolution,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Resolution.__init__(self)
        Etc_Model.__init__(self)
        self.support = self.OFF
        self.set_vlist(['300','600','1200'],1)
    def check_model(self,ptype,model):
        self.support = self.OFF

class Vendor_smooth(Lpy.pjl.pjl_class.Smoothing,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Smoothing.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.OFF
            self.set_vlist(0,None)
            self.value = 0
        else:
            self.support = self.ON
            self.set_vlist(1,None)
            self.value = 2

class Vendor_TonerSave(Lpy.pjl.pjl_class.TonerSave,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.TonerSave.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_density(Lpy.pjl.pjl_class.Density,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Density.__init__(self)
        Etc_Model.__init__(self)
        self.max_val = 5
        self.value = 3
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.OFF
        else:
            self.support = self.ON

class Vendor_scaling(Lpy.pjl.pjl_class.Scaling,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Scaling.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.Never

class Vendor_mirror(Lpy.pjl.pjl_class.Mirror,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Mirror.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.Never

class Vendor_quality(Lpy.pjl.pjl_class.Quality,Etc_Model): # P_quality
    def __init__(self):
        Lpy.pjl.pjl_class.Quality.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.Never

class Vendor_margin(Lpy.pjl.pjl_class.Margin,Etc_Model): # P_marginLTop
    def __init__(self):
        Lpy.pjl.pjl_class.Margin.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.Never

class Vendor_intray(Lpy.pjl.pjl_class.InputTray,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.InputTray.__init__(self)
        Etc_Model.__init__(self)
        self.init_trayList()
        self.set_selectDict()

    def check_model(self,ptype,model):
        pass

class Vendor_paperSize(Lpy.pjl.pjl_class.PaperSize,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.PaperSize.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_mediatype(Lpy.pjl.pjl_class.MediaType,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.MediaType.__init__(self)
        Etc_Model.__init__(self)
        self.media_init(self.typeMedia,'etc')
        self.set_selectDict()

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.OFF
        else:
            self.support = self.ON

class Vendor_outtray(Lpy.pjl.pjl_class.OutTray,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.OutTray.__init__(self)
        Etc_Model.__init__(self)

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.OFF
            self.set_vlist(1,0) # outtray == 1,2,3
        else:
            self.set_vlist(2,0) # outtray == 1,2,3
            self.support = self.ON

class Vendor_mailbin(Lpy.pjl.pjl_class.MailBin,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.MailBin.__init__(self)
        Etc_Model.__init__(self)

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.OFF

class Vendor_faceup(Lpy.pjl.pjl_class.FaceUp,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.FaceUp.__init__(self)
        Etc_Model.__init__(self)

    def check_model(self,ptype,model):
        self.support = self.Never

class Vendor_staple(Lpy.pjl.pjl_class.Staple,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Staple.__init__(self)
        Etc_Model.__init__(self)

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.OFF

class Vendor_binding(Lpy.pjl.pjl_class.Binding,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Binding.__init__(self)
        Etc_Model.__init__(self)

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.OFF

class Vendor_punch(Lpy.pjl.pjl_class.Punch,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Punch.__init__(self)
        Etc_Model.__init__(self)

    def check_model(self,ptype,model):
        self.support = self.Never
  

## InsertPaper :Transparency OHP
class Vendor_insert(Lpy.pjl.pjl_class.InsertPaper,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.InsertPaper.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.OFF
  
class Vendor_insertMedia(Lpy.pjl.pjl_class.InsertMedia,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.InsertMedia.__init__(self)
        Etc_Model.__init__(self)
        self.media_init(self.typeInsert,'etc')
        self.set_selectDict()
    def check_model(self,ptype,model):
        self.support = self.OFF

## Front Cover
class Vendor_cover(Lpy.pjl.pjl_class.CoverPrint,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.CoverPrint.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.OFF

class Vendor_coverMedia(Lpy.pjl.pjl_class.CoverMedia,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.CoverMedia.__init__(self)
        Etc_Model.__init__(self)
        self.media_init(self.typeCover,'etc')
        self.set_selectDict()
    def check_model(self,ptype,model):
        self.support = self.OFF

## Security ##
class Vendor_security(Lpy.pjl.pjl_class.Security,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Security.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON
class Vendor_UserName(Lpy.pjl.pjl_class.UserName,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.UserName.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_password(Lpy.pjl.pjl_class.Password,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Password.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.max_val = 65535
            self.support = self.ON

## Panel Lock
class Vendor_PanelLock(Lpy.pjl.pjl_class.PanelLock,Etc_Model): #  P_panelLock
    def __init__(self):
        Lpy.pjl.pjl_class.PanelLock.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.OFF
        else:
            self.support = self.ON

class Vendor_PanelPassword(Lpy.pjl.pjl_class.PanelPassword,Etc_Model): # P_panelPass
    def __init__(self):
        Lpy.pjl.pjl_class.PanelPassword.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.OFF
        else:
            self.support = self.ON

## Color Printer
class Vendor_colorPrinter(Lpy.pjl.pjl_class.ColorPrinter,Etc_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.ColorPrinter.__init__(self)
        Etc_Model.__init__(self)
    def check_model(self,ptype,model):
        self.Never
