#include <windows.h>
#include <string>
#include <vector>
#include <map>
#include <cstdio>
#include <clocale>
#include <stdexcept>

#include "winsys.hpp"

FILETIME totime(const std::wstring &digits) {
  SYSTEMTIME st;
  FILETIME ft, lt;
  memset(&st, 0, sizeof st);
  size_t ll = digits.size();
  size_t si = digits.find_first_of(L'.');
  if (si != std::wstring::npos) {
    si++;
    // wprintf(L"DEBUG:%s(%d:%d)\n", digits.c_str(), si, digits.size());
    if (((digits.size() - si) != 2)
     || !isdigit(digits[si + 0]) || !isdigit(digits[si + 1])) {
      throw winsys::win_error<wchar_t>(digits + L":tw菑G[");
    }
    st.wSecond = (digits[si + 0] - L'0') * 10 + (digits[si + 1] - L'0');
    ll -= 3;
  } else {
    st.wSecond = 0;
  }
  for (size_t i = 0; i < ll; i++) {
    if (!isdigit(digits[i])) {
      throw winsys::win_error<wchar_t>(digits + L":tw菑G[");
    }
  }
  switch (ll) {
  case  8:
    st.wYear = ((SYSTEMTIME)winsys::ftime()).wYear;
    st.wMonth = _wtoi(digits.substr(0, 2).c_str());
    st.wDay = _wtoi(digits.substr(2, 2).c_str());
    st.wHour = _wtoi(digits.substr(4, 2).c_str());
    st.wMinute = _wtoi(digits.substr(6, 2).c_str());
    break;
  case 10:
    st.wYear = _wtoi(digits.substr(0, 2).c_str());
    st.wYear = ((st.wYear <= 70) ? st.wYear + 2000 : st.wYear + 1900);
    st.wMonth = _wtoi(digits.substr(2, 2).c_str());
    st.wDay = _wtoi(digits.substr(4, 2).c_str());
    st.wHour = _wtoi(digits.substr(6, 2).c_str());
    st.wMinute = _wtoi(digits.substr(8, 2).c_str());
    break;
  case 12:
    st.wYear = _wtoi(digits.substr(0, 4).c_str());
    st.wMonth = _wtoi(digits.substr(4, 2).c_str());
    st.wDay = _wtoi(digits.substr(6, 2).c_str());
    st.wHour = _wtoi(digits.substr(8, 2).c_str());
    st.wMinute = _wtoi(digits.substr(10, 2).c_str());
    break;
  default:
    throw winsys::win_error<wchar_t>(digits + L":tw菑G[");
    break;
  }
  if (!::SystemTimeToFileTime(&st, &ft)) {
    throw winsys::win_error<wchar_t>(digits + L":SystemTimeToFileTime");
  }
  if (!::LocalFileTimeToFileTime(&ft, &lt)) {
    throw winsys::win_error<wchar_t>(digits + L":LocalFileTimeToFileTime");
  }
  return lt;
}

int wmain(int argc, wchar_t *argv[]) {
  setlocale(LC_CTYPE, "");
  std::vector<std::wstring> ents;
  if (argc == 1) {
    printf("usage: touch [option] file ... \n"
     "t@C̃^CX^vύX\n"
     "ڂ̎w肪Ȃ\n"
     "ANZXƕύX̓ꏏɕύX\n"
     "ڂ̎w肪ȏ゠ꍇA\n"
     "̍ڂSĕς\n"
     "w肵ȂΎ͌ݎƂȂ\n"
     "options:\n"
     "-a ANZXύX\n"
     "-m ύXύX\n"
     "-C 쐬ύX(W)\n"
     "-c t@C̍쐬͂Ȃ\n"
     "-r t@C w肵t@CƎ킹\n"
     "-t [[CC]YY]MMDDhhmm[.ss] lŃ^CX^vw肷\n"
     "CCȗꍇAYY70ȏȂ+1900AȂ+2000\n"
     "CCYYȗꍇA݂̔N\n"
     "DIRR}h/TC܂/TW܂/TAt\n"
     "ꂼ쐬/XV/QƂ̎mFł\n");
    return +1;
  }
  try {
    bool chc = false, cha = false, chm = false, csw = true;
    winsys::ftime ta, tm, tc;
    ta = tm = tc;
    int os = 1;
    for (int i = 1; i < argc; i = os) {
      if (wcscmp(argv[i], L"--") == 0) {
        os++;
        break;
      }
      if (argv[i][0] == L'-') {
        os++;
        for (wchar_t *p = &(argv[i][1]); *p; p++) {
          // printf("DEBUG:%c\n", *p);
          switch (*p) {
          case L'c':
            csw = false;
            break;
          case L'C':
            chc = true;
            break;
          case L'a':
            cha = true;
            break;
          case L'm':
            chm = true;
            break;
          case L'r':
            if ((i + 1) < argc) {
              winsys::dirinf_w di(argv[os]);
              if (!di.first()) {
                throw winsys::win_error<wchar_t>(
                 (std::wstring)argv[os] + L":Qƃt@C");
              }
              tc = di.wfd.ftCreationTime;
              ta = di.wfd.ftLastAccessTime;
              tm = di.wfd.ftLastWriteTime;
              os++;
            } else {
              throw winsys::win_error<wchar_t>(
               L"-r IvV̎w肪\n");
            } 
            break;
          case L't':
            if ((i + 1) < argc) {
              tc = totime(argv[os]);
              ta = tc;
              tm = tc;
              os++;
            } else {
              throw winsys::win_error<wchar_t>(
               L"-c IvV̎w肪\n");
            } 
            break;
          default:
            throw winsys::win_error<wchar_t>(
             (std::wstring)argv[os] + L":IvVG[");
          }
        }
      } else break;
    }
    if (!chc && !chm && !cha) {
      chm = cha = true; /* default operation */
    }
    // printf("%s%s%s\n", chc ? "C" : "-", chm ? "M" : "-", cha ? "A" : "-");
    for (int i = os; i < argc; i++) {
      if (wcschr(argv[i], L'*') || wcschr(argv[i], L'?')) {
        winsys::dirinf_w di(argv[i]);
        while (di.step()) {
          if (wcscmp(di.wfd.cFileName, L".")
           && wcscmp(di.wfd.cFileName, L"..")) {
            wprintf(L"\"%s\"\n", di.wfd.cFileName);
            ents.push_back(di.wfd.cFileName);
          }
        }
      } else {
        ents.push_back(argv[i]);
      }
    }
    if (ents.size() < 1) {
      throw winsys::win_error<wchar_t>(L"Yt@C\n");
    }
    for (size_t i = 0; i < ents.size(); i++) {
      HANDLE fh = ::CreateFileW(ents[i].c_str(), GENERIC_WRITE, 0, NULL,
       csw ? OPEN_ALWAYS : OPEN_EXISTING, 0, NULL);
      if (fh == INVALID_HANDLE_VALUE) {
        wprintf(L"%s:%s\n", ents[i].c_str(), winsys::strsyserr_w());
      } else {
        if (!::SetFileTime(fh, 
         (chc ? (FILETIME *)tc : NULL), 
         (cha ? (FILETIME *)ta : NULL), 
         (chm ? (FILETIME *)tm : NULL))) {
          wprintf(L"%s:%s\n", ents[i].c_str(), winsys::strsyserr_w());
        }
        ::CloseHandle(fh);
      }
    }
#   if 0
    printf("ctime = %s\n", ((std::string)tc).c_str());
    printf("atime = %s\n", ((std::string)ta).c_str());
    printf("mtime = %s\n", ((std::string)tm).c_str());
#   endif
  } catch (winsys::win_error<char> &e) {
    printf("%s\n", e.what());
    return -1;
  } catch (winsys::win_error<wchar_t> &e) {
    wprintf(L"%s\n", e.what());
    return -1;
  } catch (std::exception &e) {
    printf("%s\n", e.what());
    return -1;
  } catch (...) {
    printf("unknown exception\n");
  }
  return 0;
}
