#ifndef WINSYS_H
#define WINSYS_H

/* ̃t@C̃CN[hO
   #define UNCODE/#define _UNICODEĂ͂Ȃ */

#include <windows.h>
#include <mbstring.h>
#include <wchar.h>
#include <string.h>

#include <vector>
#include <string>
#include <map>
#include <cstring>
#include <cstdlib>

#pragma comment(lib, "USER32.LIB")

class winsys {
public:
  template <class C> class win_error {
    std::basic_string<C> mss;
  public:
    win_error(const std::basic_string<C> &s): mss(s) {}
    virtual const C *what() { return mss.c_str(); }
  };
  static std::string strsyserr_a(int n = GetLastError()) {
    std::string mss;
    LPVOID buf;
    FormatMessageA(
     FORMAT_MESSAGE_ALLOCATE_BUFFER |
     FORMAT_MESSAGE_FROM_SYSTEM |
     FORMAT_MESSAGE_IGNORE_INSERTS,
     NULL, n,
     MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
     (LPSTR)&buf, 0, NULL);
    mss = (char *)buf;
    LocalFree(buf);
    if (mss.substr(mss.size() - 2) == "\r\n") {
      mss = mss.substr(0, mss.size() - 2);
    }
    char digit[10 + 1];
    sprintf(digit, "%d", n);
    return mss + "(" + digit + ")";
  }
  static std::wstring strsyserr_w(int n = GetLastError()) {
    std::wstring mss;
    LPVOID buf;
    FormatMessageW(
     FORMAT_MESSAGE_ALLOCATE_BUFFER |
     FORMAT_MESSAGE_FROM_SYSTEM |
     FORMAT_MESSAGE_IGNORE_INSERTS,
     NULL, n,
     MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
     (LPWSTR)&buf, 0, NULL);
    mss = (wchar_t *)buf;
    LocalFree(buf);
    if (mss.substr(mss.size() - 2) == L"\r\n") {
      mss = mss.substr(0, mss.size() - 2);
    }
    wchar_t digit[10 + 1];
    swprintf(digit, (sizeof digit) / sizeof (wchar_t), L"%d", n);
    return mss + L"(" + digit + L")";
  }
  static size_t mb_find_first_of(const char *s, int c) {
    const char *bp = (const char *)
     _mbschr((const unsigned char *)s, c & 0xffU);
    return bp ? (bp - s) : -1;
  }
  static size_t mb_find_last_of(const char *s, int c) {
    const char *bp = (const char *)
     _mbsrchr((const unsigned char *)s, c & 0xffU);
    return bp ? (bp - s) : -1;
  }
  static std::string basename_a(
   const std::string &s, 
   const std::string &e = "") {
    int bi = mb_find_last_of(s.c_str(), '\\');
    std::string d = ((bi >= 0) ? s.substr(bi + 1) : s);
    if (e.size() && (d.size() >= e.size())) {
      if (stricmp(d.substr(d.size() - e.size()).c_str(), e.c_str()) == 0) {
        d = d.substr(0, d.size() - e.size());
      }
    }
    return d;
  }
  static std::wstring basename_w(
   const std::wstring &s, 
   const std::wstring &e = L"") {
    size_t bi = s.find_last_of(L'\\');
    std::wstring d = ((bi != std::wstring::npos) ? s.substr(bi + 1) : s);
    if (e.size() && (d.size() >= e.size())) {
      if (_wcsicmp(d.substr(d.size() - e.size()).c_str(), e.c_str()) == 0) {
        d = d.substr(0, d.size() - e.size());
      }
    }
    return d;
  }
  static std::string file_extension_a(const std::string &path) {
    std::string s = basename_a(path);
    size_t bi = s.find_last_of('.');
    return ((bi != std::string::npos) ? s.substr(bi) : "");
  }
  static std::wstring file_extension_w(const std::wstring &path) {
    std::wstring s = basename_w(path);
    size_t bi = s.find_last_of(L'.');
    return ((bi != std::wstring::npos) ? s.substr(bi) : L"");
  }
  static std::string pathname_a(const std::string &s) {
    int bi = mb_find_last_of(s.c_str(), '\\');
    return (bi >= 0) ? s.substr(0, bi) : s;
  }
  static std::wstring pathname_w(const std::wstring &s) {
    size_t bi = s.find_last_of(L'\\');
    return (bi >= 0) ? s.substr(0, bi) : s;
  }
  static std::string getmpath_a() {
    char ename[MAX_PATH];
    if (!GetModuleFileNameA(NULL, ename, sizeof ename)) {
      throw win_error<char>
       (std::string("GetModuleFileNameA:") + strsyserr_a());
    }
    const char *bp = (const char *)
     _mbsrchr((const unsigned char *)ename, '\\' & 0xffU);
    size_t l = strlen(ename);
    if (bp && !stricmp(&(ename[l - 4]), ".EXE")) {
      return std::string(ename, bp);
    } else {
      throw win_error<char>
       (std::string("GetModuleFileNameA:") + ename + ":truncated");
    }
  }
  static std::wstring getmpath_w() {
    wchar_t ename[MAX_PATH];
    if (!GetModuleFileNameW(NULL, ename, sizeof ename)) {
      throw win_error<wchar_t>
       (std::wstring(L"GetModuleFileNameW:") + strsyserr_w());
    }
    const wchar_t *bp = wcsrchr(ename, L'\\');
    size_t l = wcslen(ename);
    if (bp && !_wcsicmp(&(ename[l - 4]), L".EXE")) {
      return std::wstring(ename, bp);
    } else {
      throw win_error<wchar_t>
       (std::wstring(L"GetModuleFileNameW:") + ename + L":truncated");
    }
  }
  static std::string getcwd_a() {
    DWORD e;
    std::vector<char> buff(MAX_PATH);
    for (;;) {
      e = GetCurrentDirectoryA((DWORD)buff.size(), &(buff[0]));
      if ((e != 0) && (e > (DWORD)buff.size())) {
        buff.resize((size_t)e);
      }
      break;
    }
    if (e) return std::string(&(buff[0]));
    throw win_error<char>
     (std::string("GetCurrentDirectoryA:") + strsyserr_a());
  }
  static std::wstring getcwd_w() {
    DWORD e;
    std::vector<wchar_t> buff(MAX_PATH);
    for (;;) {
      e = GetCurrentDirectoryW((DWORD)buff.size(), &(buff[0]));
      if ((e != 0) && (e > (DWORD)buff.size())) {
        buff.resize((size_t)e);
      }
      break;
    }
    if (e) return std::wstring(&(buff[0]));
    throw win_error<wchar_t>
     (std::wstring(L"GetCurrentDirectoryW:") + strsyserr_w());
  }
  static std::string getfullpath_a(const std::string &rname) {
    std::vector<char> fname(MAX_PATH);
    char *bp;
    DWORD n;
    for (;;) {
      n = GetFullPathNameA(rname.c_str(), fname.size(), &(fname[0]), &bp);
      if (n > fname.size()) {
        fname.resize(n);
        continue;
      }
      break;
    }
    if (n == 0) {
      throw win_error<char>
       (std::string("GetFullPathNameA:") + rname + ":" + strsyserr_a());
    }
    return std::string(&(fname[0]));
    
  }
  static std::wstring getfullpath_w(const std::wstring &rname) {
    std::vector<wchar_t> fname(MAX_PATH);
    wchar_t *bp;
    DWORD n;
    for (;;) {
      n = GetFullPathNameW(rname.c_str(), fname.size(), &(fname[0]), &bp);
      if (n > fname.size()) {
        fname.resize(n);
        continue;
      }
      break;
    }
    if (n == 0) {
      throw win_error<wchar_t>
       (std::wstring(L"GetFullPathNameW:") + rname + L":" + strsyserr_w());
    }
    return std::wstring(&(fname[0]));
    
  }
  static void chdir_a(const std::string &s) {
    if (SetCurrentDirectoryA(s.c_str()) == FALSE) {
      throw win_error<char>
       (std::string("SetCurrentDirectoryA:") + s + ":" + strsyserr_a());
    }
  }
  static void chdir_w(const std::wstring &s) {
    if (SetCurrentDirectoryW(s.c_str()) == FALSE) {
      throw win_error<wchar_t>
       (std::wstring(L"SetCurrentDirectoryW:") + s + L":" + strsyserr_w());
    }
  }
  static std::string getenv_a(const std::string &k) {
    std::vector<char> buff(512);
    for (;;) {
      size_t bs = GetEnvironmentVariableA(k.c_str(), &(buff[0]), buff.size());
      if (bs == 0) return "";
      if (bs > buff.size()) buff.resize(bs);
      else return std::string(&(buff[0]), bs);
    }
  }
  static std::wstring getenv_w(const std::wstring &k) {
    std::vector<wchar_t> buff(512);
    for (;;) {
      size_t bs = GetEnvironmentVariableW(k.c_str(), &(buff[0]), buff.size());
      if (bs == 0) return L"";
      if (bs > buff.size()) buff.resize(bs);
      else return std::wstring(&(buff[0]), bs);
    }
  }
  static bool setenv_a(const std::string &k, const std::string &v) {
    return SetEnvironmentVariableA(k.c_str(), v.size() ? v.c_str() : NULL);
  }
  static bool setenv_w(const std::wstring &k, const std::wstring &v) {
    return SetEnvironmentVariableW(k.c_str(), v.size() ? v.c_str() : NULL);
  }
  static std::string expandenvs_a(const std::string &s) {
    DWORD n;
    std::vector<char> buff(s.size());
    for (;;) {
      n = ExpandEnvironmentStringsA(
       s.c_str(), &(buff[0]), (DWORD)buff.size());
      if (n > buff.size()) {
        buff.resize(n);
        continue;
      }
      break;
    }
    if (n) return std::string(&(buff[0]));
    throw win_error<char>
     (std::string("ExpandEnvironmentStringsA:") + s + ":" + strsyserr_a());
  }  
  static std::wstring expandenvs_w(const std::wstring &s) {
    DWORD n;
    std::vector<wchar_t> buff(s.size());
    for (;;) {
      n = ExpandEnvironmentStringsW(
       s.c_str(), &(buff[0]), (DWORD)buff.size());
      if (n > buff.size()) {
        buff.resize(n);
        continue;
      }
      break;
    }
    if (n) return std::wstring(&(buff[0]));
    throw win_error<wchar_t>
     (std::wstring(L"ExpandEnvironmentStringsW:") + s + L":" + strsyserr_w());
  }  
  static std::map<std::string, std::string> getenvs_a() {
    class keeper {
      LPVOID value;
    public:
      operator const char *() { return (const char *)value; }
      keeper(LPVOID ep): value(ep) {} 
      ~keeper() { FreeEnvironmentStringsA((LPTSTR)value); }
    } kd(GetEnvironmentStringsA());
    std::map<std::string, std::string> es;
    for (const char *p = (const char *)kd; *p; p++) {
      size_t m;
      if ((m = mb_find_first_of(p, '=')) == 0) { // =NAME= = VALUE
        m = (m + 1) + mb_find_first_of(&(p[m + 1]), '=');
      }
      if (m > 0) {
        es[std::string(p, m)] = std::string(&(p[m + 1]));
      }
      p = &(p[strlen(p)]);
    }
    return es;
  }
  static std::map<std::wstring, std::wstring> getenvs_w() {
    class keeper {
      LPVOID value;
    public:
      operator const wchar_t *() { return (const wchar_t *)value; }
      keeper(LPVOID ep): value(ep) {} 
      ~keeper() { FreeEnvironmentStringsW((LPWSTR)value); }
    } kd(GetEnvironmentStringsW());
    std::map<std::wstring, std::wstring> es;
    for (const wchar_t *p = (const wchar_t *)kd; *p; p++) {
      std::wstring s = p;
      size_t m;
      if ((m = s.find_first_of(L'=')) == 0) {
        m = s.find_first_of('=', 1);
      }
      if (m > 0) {
        es[std::wstring(p, m)] = std::wstring(&(p[m + 1]));
      }
      p = &(p[s.size()]);
    }
    return es;
  }
  static std::string packenvs_a(std::map<std::string, std::string> &m) {
    std::string ev;
    for (std::map<std::string, std::string>::iterator it = m.begin();
     it != m.end(); it++) {
      ev += (it->first + "=" + it->second);
      ev += '\0';
    }
    return ev; 
  }
  static std::wstring packenvs_w(std::map<std::wstring, std::wstring> &m) {
    std::wstring ev;
    for (std::map<std::wstring, std::wstring>::iterator it = m.begin();
     it != m.end(); it++) {
      ev += (it->first + L"=" + it->second);
      ev += L'\0';
    }
    return ev;
  }
  class dirinf_a {
    HANDLE fh;
    std::string name;
  public:
    WIN32_FIND_DATA wfd;
    dirinf_a(const std::string &s = "*")
     : name(s), fh(INVALID_HANDLE_VALUE) {}
    virtual ~dirinf_a() { reset(); }
    void reset(const std::string &s = "") {
      if (fh != INVALID_HANDLE_VALUE) {
        FindClose(fh);
        fh = INVALID_HANDLE_VALUE;
      }
      name = s;
    }
    bool first() {
      fh = FindFirstFileA(name.c_str(), &wfd);
      return (fh != INVALID_HANDLE_VALUE);
    }
    bool next() {
      return (FindNextFileA(fh, &wfd) != FALSE);
    }
    bool step() { 
      return (fh == INVALID_HANDLE_VALUE) ? first() : next();
    }
  };
  class dirinf_w {
    HANDLE fh;
    std::wstring name;
  public:
    WIN32_FIND_DATAW wfd;
    dirinf_w(const std::wstring &s = L"*")
     : name(s), fh(INVALID_HANDLE_VALUE) {}
    virtual ~dirinf_w() { reset(); }
    void reset(const std::wstring s = L"") {
      if (fh != INVALID_HANDLE_VALUE) {
        FindClose(fh);
        fh = INVALID_HANDLE_VALUE;
      }
      name = s;
    }
    bool first() {
      fh = FindFirstFileW(name.c_str(), &wfd);
      return (fh != INVALID_HANDLE_VALUE);
    }
    bool next() {
      return (FindNextFileW(fh, &wfd) != FALSE);
    }
    bool step() { 
      return (fh == INVALID_HANDLE_VALUE) ? first() : next();
    }
  };
  static std::vector<std::string> dirlist_a(const std::string &path) {   
    std::vector<std::string> dirs;
    dirinf_a ds(path);
    for (bool b = ds.first(); b; b = ds.step()) {
      if (strcmp(ds.wfd.cFileName, ".") == 0) continue;
      if (strcmp(ds.wfd.cFileName, "..") == 0) continue;
      dirs.push_back(ds.wfd.cFileName);
    }
    return dirs;
  }
  static std::vector<std::wstring> dirlist_w(const std::wstring &path) {   
    std::vector<std::wstring> dirs;
    dirinf_w ds(path);
    for (bool b = ds.first(); b; b = ds.step()) {
      if (wcscmp(ds.wfd.cFileName, L".") == 0) continue;
      if (wcscmp(ds.wfd.cFileName, L"..") == 0) continue;
      dirs.push_back(ds.wfd.cFileName);
    }
    return dirs;
  }
  /* texttoclipgp邽߂ɂ͈ȉ̓̏Kv
     OpenClipboard(NULL); EmptyClipboard();
     n͕KvȂ */
  static void texttoclip_a(const std::string &s) {
    HANDLE handle = GlobalAlloc(
     GMEM_MOVEABLE | GMEM_DDESHARE, s.size() + 1);
    if (!handle) {
      throw win_error<char>
       (std::string("GlobalAlloc:") + strsyserr_a());
    }
    char *p = (char *)GlobalLock(handle);
    strcpy(p , s.c_str());
    GlobalUnlock(handle);
    if (!SetClipboardData(CF_OEMTEXT, handle)) {
      throw win_error<char>
       (std::string("SetClipboardData:") + strsyserr_a());
    }
  }
  static void texttoclip_w(const std::wstring &s) {
    HANDLE handle = GlobalAlloc(
     GMEM_MOVEABLE | GMEM_DDESHARE, (s.size() + 1) * sizeof (wchar_t));
    if (!handle) {
      throw win_error<wchar_t>
       (std::wstring(L"GlobalAlloc:") + strsyserr_w());
    }
    wchar_t *p = (wchar_t *)GlobalLock(handle);
    wcscpy(p , s.c_str());
    GlobalUnlock(handle);
    if (!SetClipboardData(CF_UNICODETEXT, handle)) {
      throw win_error<wchar_t>
       (std::wstring(L"SetClipboardData:") + strsyserr_w());
    }
  }
  static std::string cliptotext_a() {
    HANDLE handle = GetClipboardData(CF_OEMTEXT);
    if (!handle) {
      throw win_error<char>
       (std::string("GetClipboardData:") + strsyserr_a());
    }
    char *p = (char *)GlobalLock(handle);
    std::string s = p;
    GlobalUnlock(handle);
    return s;
  }
  static std::wstring cliptotext_w() {
    HANDLE handle = GetClipboardData(CF_UNICODETEXT);
    if (!handle) {
      throw win_error<wchar_t>
       (std::wstring(L"GetClipboardData:") + strsyserr_w());
    }
    wchar_t *p = (wchar_t *)GlobalLock(handle);
    std::wstring s = p;
    GlobalUnlock(handle);
    return s;
  }
  class ftime {
    FILETIME ft;
  public:
    operator FILETIME() {
      return ft;
    }
    operator FILETIME *() {
      return &ft;
    }
    operator SYSTEMTIME() {
      SYSTEMTIME st;
      ::FileTimeToSystemTime(&ft, &st);
      return st;
    }
    operator std::string() {
      SYSTEMTIME st;
      ::FileTimeToSystemTime(&ft, &st);
      char buff[17 + 1];
      sprintf(buff, "%04d%02d%02d%02d%02d%2d%03d",
       st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, 
       st.wSecond, st.wMilliseconds);
      return std::string(buff);
    }
    operator std::wstring() {
      SYSTEMTIME st;
      ::FileTimeToSystemTime(&ft, &st);
      wchar_t buff[17 + 1];
      swprintf(buff, L"%04d%02d%02d%02d%02d%2d%03d",
       st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute,
       st.wSecond, st.wMilliseconds);
      return std::wstring(buff);
    }
    ftime operator =(FILETIME t) {
      ft = t;
      return *this;
    }
    ftime operator =(SYSTEMTIME st) {
      ::SystemTimeToFileTime(&st, &ft);
      return *this;
    }
    ftime() {
      SYSTEMTIME st;
      ::GetSystemTime(&st);
      ::SystemTimeToFileTime(&st, &ft);
    }
    ftime(FILETIME t): ft(t) {}
    ftime(SYSTEMTIME st) {
      ::SystemTimeToFileTime(&st, &ft);
    }
    ftime(const std::string &s) {
      SYSTEMTIME st;
      memset(&st, 0, sizeof st);
      st.wYear = atoi(s.substr(0, 4).c_str());
      st.wMonth = atoi(s.substr(4, 2).c_str());
      st.wDay = atoi(s.substr(6, 2).c_str());
      if (s.size() >= 14) {
        st.wHour = atoi(s.substr(8, 2).c_str());
        st.wMinute = atoi(s.substr(10, 2).c_str());
        st.wSecond = atoi(s.substr(12, 2).c_str());
      }
      if (s.size() >= 17) {
        st.wMilliseconds = atoi(s.substr(14, 3).c_str());
      }
      ::SystemTimeToFileTime(&st, &ft);
    }
    ftime(const std::wstring &s) {
      SYSTEMTIME st;
      memset(&st, 0, sizeof st);
      st.wYear = _wtoi(s.substr(0, 4).c_str());
      st.wMonth = _wtoi(s.substr(4, 2).c_str());
      st.wDay = _wtoi(s.substr(6, 2).c_str());
      if (s.size() >= 14) {
        st.wHour = _wtoi(s.substr(8, 2).c_str());
        st.wMinute = _wtoi(s.substr(10, 2).c_str());
        st.wSecond = _wtoi(s.substr(12, 2).c_str());
      }
      if (s.size() >= 17) {
        st.wMilliseconds = _wtoi(s.substr(14, 3).c_str());
      }
      ::SystemTimeToFileTime(&st, &ft);
    }
  };
};

#endif
