module(..., package.seeall)
require "service.calc"

function index(request, response)
    return {forward = "./lp/calc/index.lp"}
end

function plus(request, response)
    return {forward = "./lp/calc/plus.lp"}
end
function plus_submit(request, response)
    local env = {
        a = request.QUERY.a or 0,
        b = request.QUERY.b or 0
    }
    require "validate"
    env.errors = validate.validate {
        ['A'] = {
            [validate.required] = env.a,
            [validate.num] = env.a,
        },
        ['B'] = {
            [validate.required] = env.b,
            [validate.num] = env.b,
        },
    }
    if #env.errors > 0 then
        return {
            forward = "./lp/calc/plus.lp",
            env = env
        }
    end
    env.answer = env.a + env.b
    return {
        forward = "./lp/calc/plus.lp",
        env = env
    }
end
-- vim: set ts=4 sw=4 sts=4 expandtab :
