local assert = assert
local require = require

module(..., package.seeall)

Context = {}
function Context.new(config)
    require("luasql." .. config.type)
    local env = assert(luasql[config.type]())
    local self = {
        env = env,
        con = assert(env:connect(config.dbname, config.user, config.passwd)),
    }
    return setmetatable(self, {__index = Context})
end

function Context:close()
    if self.con then assert(self.con:close()) end
    if self.env then assert(self.env:close()) end
end

function Context:begin()
    assert(self.con:execute("begin"))
end

function Context:commit()
    assert(self.con:execute("commit"))
end

function Context:rollback()
    assert(self.con:execute("rollback"))
end

local escape = function(s)
    s = s or ''
    s = string.gsub(s, "'", "''")
    s = string.gsub(s, "\\", "\\\\")
    s = string.gsub(s, "%%", "\\%")
    return s
end

function Context:execute(sql, ...)
    local params = {...}
    local compiled_sql = ''
    local index = 1
    for i = 1, #sql do
        local c = string.sub(sql, i, i)
        if c == "?" then
            local value = params[index]
            if type(value) == 'number' then
                compiled_sql = compiled_sql .. value
            else
                local stringvalue = escape(params[index])
                compiled_sql = compiled_sql .. string.format("'%s'", stringvalue)
            end
            index = index + 1
        else
            compiled_sql = compiled_sql .. c
        end
    end
    cgi.log:debug(compiled_sql)
    local cur_or_updates = assert(self.con:execute(compiled_sql))
    if type(cur_or_updates) ~= 'number' then
        local cur = cur_or_updates
        local results = {}
        local row = cur:fetch({}, "a")
        while row do
            table.insert(results, row)
            row = cur:fetch({}, "a")
        end
        cur:close()
        return results
    else
        return cur_or_updates
    end
end

function Context:lastid()
    local ret = assert(self:execute("select last_insert_rowid() as id"))
    cgi.log:debug(ret)
    return ret[1].id
end

---- vim: set ts=4 sw=4 sts=4 expandtab :
