module(..., package.seeall)

require "service.base"

Service = {} -- コネクションクラス
function Service.new()
    local config = assert(loadfile('db.workflow.config')())
    local self = {
        dbcontext = service.base.Context.new(config)
    }
    return setmetatable(self, {__index = Service})
end
function Service:close()
    if self.dbcontext then
        self.dbcontext:close()
    end
end

function Service:register_file(file)
    self.dbcontext:begin()
    local sql = [[
        insert into application_file(name, mimetype, size) values (?, ?, ?)
    ]]
    self.dbcontext:execute(sql, file.shortfilename, file.mimetype, file.filesize)
    local fileid = self.dbcontext:lastid()
    self.dbcontext:commit()
    return fileid
end

---- vim: set ts=4 sw=4 sts=4 expandtab fenc=utf-8:
