module(..., package.seeall)

function have(value)
    cgi.log:debug('validate have')
    return value and #value > 0, '%sを入力してください。'
end
function required(value)
    return value and value ~= '', '%sを入力してください。'
end
function num(value)
    return string.find(value, '^[+-]?[0-9]*$'), '%sは数字入力してください。'
end
function alpha(value)
    return string.find(value, '^[a-zA-Z]*$'), '%sは英字で入力してください。'
end
function alphanum(value)
    return string.find(value, '^[a-zA-Z0-9]*$'), '%sは英数字で入力してください。'
end
function ascii(value)
    return string.find(value, '^%w*$'), '%sは英数字記号で入力してください。'
end
function lengthmin(rule)
    local value, min = rule[1] or '', rule[2]
    return string.len(value) >= min, string.format('%%sは、%d文字以上で入力してください。', min)
end
function intrange(rule)
    local value, min, max = rule[1] or '', rule[2] or 0, rule[3] or 0
    if not num(value) then
        return false, string.format('%%sは、%dから%dの間の数値で入力してください。', min, max)
    end
    local num = tonumber(value)
    return num >= min and num <= max, string.format('%%sは、%dから%dの間の数値で入力してください。', min, max)
end


function validate(rules)
    local result = {}
    for field, check in pairs(rules) do
        for f, value in pairs(check) do
            local judge, message = f(value)
            if not judge then
                table.insert(result, string.format(message, field))
            end
        end
    end
    return result
end
-- vim: set ts=4 sw=4 sts=4 expandtab :
