/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

  $Id: mecab-test-gen.cpp,v 1.4 2006/07/09 11:26:27 taku-ku Exp $;

  Copyright (C) 2001-2006 Taku Kudo <taku@chasen.org>
  Copyright (C) 2004-2006 Nippon Telegraph and Telephone Corporation

*/

#include "mecab.h"
#include "common.h"
#include "utils.h"

using namespace MeCab;

int main (int argc, char **argv)
{
  char buf[BUF_SIZE];
  char *col[2];
  std::string str;
  while (std::cin.getline(buf, sizeof(buf))) {
    size_t n = tokenize(buf, "\t ", col, 2);
    CHECK_DIE(n <= 2) << "format error: " << buf;
    if (std::strcmp(col[0], "EOS") == 0 && ! str.empty()) {
      std::cout << str << std::endl;
      str.clear();
    } else {
      str += col[0];
    }
  }
  return 0;
}
