/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

  $Id: string_buffer.h,v 1.7 2006/07/09 11:26:27 taku-ku Exp $;

  Copyright (C) 2001-2006 Taku Kudo <taku@chasen.org>
  Copyright (C) 2004-2006 Nippon Telegraph and Telephone Corporation

*/
#ifndef MECAB_STRINGBUFFER_H
#define MECAB_STRINGBUFFER_H

#include <string>
#include "common.h"
#include "utils.h"

namespace MeCab {

#define _ITOA(_n)  char fbuf[64]; itoa  (_n, fbuf);  return this->write (fbuf);
#define _UITOA(_n) char fbuf[64]; uitoa (_n, fbuf);  return this->write (fbuf);
#define _DTOA(_n)  char fbuf[64]; dtoa  (_n, fbuf);  return this->write (fbuf);

  class StringBuffer
    {
    private:
      size_t size_;
      size_t alloc_size_;
      char *ptr_;
      bool is_delete_;
      bool error_;
      bool reserve (size_t);

    public:
      explicit StringBuffer (): size_(0), alloc_size_(0),
        ptr_(0), is_delete_ (true), error_ (false) {}
      explicit StringBuffer (char *_s, size_t _l):
        size_(0), alloc_size_(_l), ptr_ (_s), is_delete_(false), error_(false) {}

      virtual ~StringBuffer ();

      StringBuffer& write (char);
      StringBuffer& write (const char*, size_t);
      StringBuffer& write (const char*);

      StringBuffer& operator<< (double _n)             { _DTOA(_n); }
      StringBuffer& operator<< (short int _n)          { _ITOA(_n); }
      StringBuffer& operator<< (int _n)                { _ITOA(_n); }
      StringBuffer& operator<< (long int _n)           { _ITOA(_n); }
      StringBuffer& operator<< (unsigned short int _n) { _UITOA(_n); }
      StringBuffer& operator<< (unsigned int _n)       { _UITOA(_n); }
      StringBuffer& operator<< (unsigned long int _n)  { _UITOA(_n); }
      StringBuffer& operator<< (char _n)               { return this->write (_n); }
      StringBuffer& operator<< (unsigned char _n)      { return this->write (_n); }
      StringBuffer& operator<< (const char* _n)        { return this->write (_n); }
      StringBuffer& operator<< (const std::string& _n) { return this->write (_n.c_str()); }

      void clear () { size_ = 0; }
      const char *str () { return error_ ?  0 : const_cast<const char*>(ptr_); }
    };
}

#endif
