# spec file for lxcf

%define _topdir	 	/root/lxcf/lxcf/package
%define name		lxcf
%define release		3
%define version 	0.1
%define buildroot	%{_topdir}/%{name}-%{version}-root

BuildRoot:		%{buildroot}
Summary: 		LXCF is a lxc facility tool.
License: 		GPL v.2
Name: 			%{name}
Version: 		%{version}
Release: 		%{release}
Source: 		%{name}-%{version}.tar.gz
Prefix: 		/usr
Group: 			Applications/Emulators
Requires:		libvirt-daemon-lxc
Requires:		libvirt-daemon-driver-lxc
Requires:		python
Requires:		python-IPy
Requires:		virt-manager

%description
LXCF is a lxc facility tool.
LXCF efficiently makes the instance. One-instance making is a few minutes or less. 
The LXCF instance can dynamically change the resource of CPU, MEMORY, IO and NET. Even if the instance has stopped, the change in the resource can be changed. 
LXCF can be used by installing it on Linux on VM as well as bare metal. 
LXCF can be operated stabilizing the job like a past system at a long term. 
Moreover, a lot of LXCF instances are generable in a short time. If a lot of LXCF instances become unnecessary, it is possible to delete it collectively. Such stateless instance can be operated. 


%prep
%setup -q

%build
make clean
make 


%install
make install prefix=$RPM_BUILD_ROOT

%post
${RPM_BUILD_ROOT}/usr/lib/lxcf/lxcf-init
systemctl restart libvirtd

%postun
systemctl restart libvirtd

%files
%defattr(-,root,root)
/usr/sbin/lxcf
/usr/lib/lxcf/lxcf-setup
/usr/lib/lxcf/lxcf-config
/usr/lib/lxcf/lxcf-createfile
/usr/lib/lxcf/lxcf-resume
/usr/lib/lxcf/lxcf-update
/usr/lib/lxcf/lxcf-resource
/usr/lib/lxcf/lxcf-load
/usr/lib/lxcf/lxcf-check-json
/usr/lib/lxcf/lxcf-define
/usr/lib/lxcf/lxcf-keygen
/usr/lib/lxcf/lxcf-suspend
/usr/lib/lxcf/lxcf-erase-setup
/usr/lib/lxcf/lxcf-resource1
/usr/lib/lxcf/lxcf-list
/usr/lib/lxcf/lxcf-clone
/usr/lib/lxcf/lxcf-resource2
/usr/lib/lxcf/lxcf-sysgen
/usr/lib/lxcf/lxcf-stop
/usr/lib/lxcf/lxcf-clone-setup
/usr/lib/lxcf/lxcf-maintenance
/usr/lib/lxcf/lxcf-autostart
/usr/lib/lxcf/lxcf-start
/usr/lib/lxcf/lxcf-reboot
/usr/lib/lxcf/lxcf-run
/usr/lib/lxcf/lxcf-init
/usr/lib/lxcf/lxcf-parmchk-num
/usr/lib/lxcf/lxcf-parmchk-num-kmg
/usr/lib/lxcf/lxcf-parmchk-cname
/usr/lib/lxcf/lxcf-parmchk-float
/usr/lib/lxcf/lxcf-parmchk-float-kmg
/usr/lib/lxcf/lxcf-parmchk-hexdig
/usr/lib/lxcf/lxcf-parmchk-MJMI
/usr/lib/lxcf/lxcf-update1
/usr/lib/lxcf/lxcf-deploy
/usr/lib/lxcf/lxcf-rc
/usr/lib/lxcf/lxcf-update2
/usr/lib/lxcf/lxcf-erase
/usr/lib/lxcf/helpfile.txt
/usr/lib/lxcf/sbin/memlimit
/usr/lib/lxcf/sbin/sysgen
/usr/lib/lxcf/sbin/sysgen-n
/usr/lib/lxcf/sbin/blkiops_w
/usr/lib/lxcf/sbin/clone
/usr/lib/lxcf/sbin/clone-n
/usr/lib/lxcf/sbin/cpurate
/usr/lib/lxcf/sbin/blkio_r
/usr/lib/lxcf/sbin/deploy
/usr/lib/lxcf/sbin/update
/usr/lib/lxcf/sbin/update-alert
/usr/lib/lxcf/sbin/version
/usr/lib/lxcf/sbin/helpcmd
/usr/lib/lxcf/sbin/resume
/usr/lib/lxcf/sbin/resume-n
/usr/lib/lxcf/sbin/memswlimit
/usr/lib/lxcf/sbin/cpun
/usr/lib/lxcf/sbin/blkiops_r
/usr/lib/lxcf/sbin/stop
/usr/lib/lxcf/sbin/stop-n
/usr/lib/lxcf/sbin/erase
/usr/lib/lxcf/sbin/erase-n
/usr/lib/lxcf/sbin/set
/usr/lib/lxcf/sbin/show
/usr/lib/lxcf/sbin/blkio_w
/usr/lib/lxcf/sbin/reboot
/usr/lib/lxcf/sbin/run
/usr/lib/lxcf/sbin/autostart
/usr/lib/lxcf/sbin/start
/usr/lib/lxcf/sbin/start-n
/usr/lib/lxcf/sbin/numa
/usr/lib/lxcf/sbin/net_cls
/usr/lib/lxcf/sbin/suspend
/usr/lib/lxcf/sbin/suspend-n
/usr/lib/lxcf/sbin/list
/etc/lxcf/lxcf.conf
/etc/libvirt/hooks/lxc
/etc/libvirt/hooks/qemu
/etc/libvirt/qemu/networks/lxcfnet1.xml
/usr/lib/systemd/system/lxcf.service
/var/lib/libvirt/network/lxcfnet1.xml
/etc/libvirt/qemu/networks/autostart/lxcfnet1.xml
/etc/systemd/system/multi-user.target.wants/lxcf.service

%doc %attr(-,root,root) 
/usr/share/man/man1/lxcf.1.gz
/usr/share/doc/lxcf-%{version}/README
/usr/share/doc/lxcf-%{version}/COPYING
/usr/share/doc/lxcf-%{version}/ChangeLog
/usr/share/doc/lxcf-%{version}/AUTHORS
/usr/share/doc/lxcf-%{version}/example/README
/usr/share/doc/lxcf-%{version}/example/HA10
/usr/share/doc/lxcf-%{version}/example/ops-script
 


