AppName=Lynx for Win32
AppID=Lynx for Win32
AppPublisher=patakuti
AppPublisherURL=http://lynx-win32-pata.sourceforge.jp/
AppSupportURL=http://lynx-win32-pata.sourceforge.jp/
AppUpdatesURL=http://lynx-win32-pata.sourceforge.jp/
DefaultDirName={pf}\Lynx for Win32
DefaultGroupName=Lynx for Win32
SourceDir=D:\home\patakuti\etc\lynx\release
OutputDir=D:\home\patakuti\etc\lynx\output
Compression=lzma
SolidCompression=yes

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "COPYING";          DestDir: "{app}"; Flags: ignoreversion
Source: "COPYING.LIB";      DestDir: "{app}"; Flags: ignoreversion
Source: "LICENSE.zlib";     DestDir: "{app}"; Flags: ignoreversion
Source: "README";           DestDir: "{app}"; Flags: ignoreversion
Source: "RELEASENOTE";      DestDir: "{app}"; Flags: ignoreversion
Source: "google.html";      DestDir: "{app}"; Flags: ignoreversion
Source: "iconv.dll";        DestDir: "{app}"; Flags: ignoreversion
Source: "welcome-jp.html";  DestDir: "{app}"; Flags: ignoreversion
Source: "welcome.html";     DestDir: "{app}"; Flags: ignoreversion

Source: "docs\*";           DestDir: "{app}\docs";      Flags: ignoreversion recursesubdirs createallsubdirs
Source: "docs-jp\*";        DestDir: "{app}\docs-jp";   Flags: ignoreversion recursesubdirs createallsubdirs
Source: "for_developer\*";  DestDir: "{app}\for_developer";Flags: ignoreversion recursesubdirs createallsubdirs
Source: "locale\*";         DestDir: "{app}\locale";    Flags: ignoreversion recursesubdirs createallsubdirs
Source: "lynx_help\*";      DestDir: "{app}\lynx_help"; Flags: ignoreversion recursesubdirs createallsubdirs

Source: "lynx.exe"; DestDir: "{app}"; Flags: ignoreversion; AfterInstall: MyAfterInstall;
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\Lynx"; Filename: "{app}\lynx.exe"
Name: "{group}\{cm:UninstallProgram,Lynx for Win32}"; Filename: "{uninstallexe}"
Name: "{userdesktop}\Lynx"; Filename: "{app}\lynx.exe"; Tasks: desktopicon

[Run]
Filename: "{app}\lynx.exe"; Description: "{cm:LaunchProgram,Lynx for Win32}"; Flags: nowait postinstall skipifsilent

[Code]
var
  SelectDCSPage: TWizardPage;
  DCSComboBox: TComboBox;
  CfgDstName: String;
  CfgSrcName: String;

procedure CreateTheWizardPages;
var
  MyLabel: TLabel;
begin
  { TComboBox and others }

  SelectDCSPage := CreateCustomPage(wpSelectTasks, 'Custom Lynx', 'What is your display character set?');

  MyLabel := TLabel.Create(SelectDCSPage);
  with MyLabel do begin
    Parent := SelectDCSPage.Surface;
    AutoSize := True;
    WordWrap := True;
    Width := SelectDCSPage.SurfaceWidth;
    Caption := 'Please select your display character set.  You can also select it in Lynx''s option menu after installation.';
  end;

  DCSComboBox := TComboBox.Create(SelectDCSPage);
  with DCSComboBox do begin
    Top := MyLabel.Top + MyLabel.Height + ScaleY(8);
    Width := SelectDCSPage.SurfaceWidth;
    Parent := SelectDCSPage.Surface;
    Style := csDropDownList;
    with Items do begin
      Add('us-ascii');
      Add('iso-8859-1');
      Add('iso-8859-15');
      Add('cp850');
      Add('windows-1252');
      Add('cp437');
      Add('dec-mcs');
      Add('macintosh');
      Add('next');
      Add('hp-roman8');
      Add('euc-cn');
      Add('euc-jp');
      Add('shift_jis');
      Add('euc-kr');
      Add('big5');
      Add('viscii');
      Add('iso-8859-2');
      Add('cp852');
      Add('windows-1250');
      Add('iso-8859-3');
      Add('iso-8859-4');
      Add('iso-8859-13');
      Add('cp775');
      Add('windows-1257');
      Add('iso-8859-14');
      Add('iso-8859-5');
      Add('cp866');
      Add('windows-1251');
      Add('koi8-r');
      Add('iso-8859-6');
      Add('cp864');
      Add('windows-1256');
      Add('iso-8859-7');
      Add('cp737');
      Add('cp869');
      Add('windows-1253');
      Add('iso-8859-8');
      Add('cp862');
      Add('windows-1255');
      Add('iso-8859-9');
      Add('iso-8859-10');
      Add('cp866u');
      Add('koi8-u');
      Add('utf-8');
      Add('mnemonic+ascii+0');
      Add('mnemonic');
      Add('x-transparent');
    end;
    ItemIndex := 0;
  end;
end;

procedure InitializeWizard();
begin
  { Custom wizard pages }

  CreateTheWizardPages;
  
  { Other custom controls }

end;
