/*
 *  m2m_nav.c:
 *     Infomation handling for DVD navigation.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */
#ifndef _LARGEFILE64_SOURCE
#define _LARGEFILE64_SOURCE
#endif
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 199506L
#endif
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE  500
#endif
#ifndef _BSD_SOURCE
#define _BSD_SOURCE
#endif

#include <features.h>
#include <stdio.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/mman.h>
#include <netinet/in.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <pthread.h>
#include <string.h>
#include <ifo.h>

#include "config.h"
#include <mpeg2dec/video_out.h>
#include <mpeg2dec/mpeg2.h>
#include <mpeg2dec/mm_accel.h>
#include <dvd_udf.h>
#include "m2m.h"

#define FILE_IFO "/VIDEO_TS/VIDEO_TS.IFO"
#define PREAD64

static int nchapter=0;
static struct chapter_rec_t {
    __off64_t lba_st;
    __off64_t lba_ed;
    __off64_t title_start;
    int n_pgci_cells;
    int title;
    int chapter;
    int pgci_cell_index;
    ifo_cell_addr_t *cells;
    ifo_cell_addr_t *last_cell;
    ifo_pgci_cell_addr_t *pgci_cells;
    u_char chain_info_low;
    char name[32];
} *chapter_rec;

int m2m_init_info(int fd)
{
    __off64_t lba;
    unsigned long int partition_offset,pos=0;
    struct AD file_entry;
    int i,j,k,l,tno,cno,ntitle,n;
    ifo_ptt_t *ptt;
    ifo_t * ifo_s =NULL;
    struct chapter_rec_t wkchap[250];

#if 0
    if (!UDFFindFileEntry(0,FILE_IFO,&partition_offset,&file_entry) )
        return -1;
    lba=partition_offset+file_entry.Location;
    if (!(ifo_s = ifoOpen(fd, lba * DVD_VIDEO_LB_LEN)))
        return -2;

    {
        u_char *ptr=NULL;
        u_int offset;
        ifoGetVMGPTT ((ifo_hdr_t *)ifo_s->data[ID_PTT], (char **) &ptr);
        offset  = ptr[ 8] << 24;
        offset |= ptr[ 9] << 16;
        offset |= ptr[10] << 8;
        offset |= ptr[11];
        lba += offset;
    }
    ntitle=ifoGetNumberOfTitles (ifo_s);
    ifoClose (ifo_s);
#endif

    nchapter=0;
    for( tno=1;;tno++ )
    {
        ifo_cell_addr_t *cells=NULL;
        char titlename[32];
        sprintf(titlename,"/VIDEO_TS/VTS_%02d_0.IFO",tno );
        if (!UDFFindFileEntry(0,titlename,&partition_offset,&file_entry) )
            break;
        lba=partition_offset+file_entry.Location;

        if (!(ifo_s = ifoOpen (fd, lba * DVD_VIDEO_LB_LEN)) )
            return -3;
        lba += ifoGetVOBStart(ifo_s);
        ifoGetCellAddr( (char *) ifo_s->data[ID_TITLE_CELL_ADDR],
                        (char **) &cells );

        // scan program chain
        if ( !(ptt = ifo_get_ptt(ifo_s)) )
            return -4;

        cno=1;
        for ( i=0 ; i<ptt->num ; i++ ) /* earch title ? */
        {
            for ( j=0 ; j<ptt->title[i].num ; j++ ) /* earch chapter */
            {
                int num_cells;
                char *pgci;
                ifo_pgc_cell_pos_t *cell_pos=NULL;
                ifo_pgci_cell_addr_t *pgci_cells=NULL;

                ifoGetPGCI( (ifo_hdr_t *)ifo_s->data[ID_TITLE_PGCI],
                            ptt->title[i].data[j].pgc-1,&pgci);
                num_cells = ifoGetCellPos (pgci, (u_char **) &cell_pos);
                num_cells = ifoGetCellAddrNum(
                                  (char *)ifo_s->data[ID_TITLE_CELL_ADDR]);
                n = ifoGetCellPlayInfo( pgci, (u_char **) &pgci_cells );
                for ( k=0 ; k<n ; k++ )
                {
                    wkchap[nchapter].lba_st=htonl(pgci_cells[k].vobu_start   )+lba;
                    wkchap[nchapter].lba_ed=htonl(pgci_cells[k].vobu_last_end)+lba;
                    //wkchap[nchapter].title=tno;
                    wkchap[nchapter].title=ptt->title[i].data[j].pgc-1;
                    wkchap[nchapter].chapter=cno;
                    wkchap[nchapter].title_start=lba;
                    wkchap[nchapter].cells=cells;
                    wkchap[nchapter].last_cell=cells+num_cells;
                    wkchap[nchapter].n_pgci_cells=n;
                    wkchap[nchapter].pgci_cells=pgci_cells;
                    wkchap[nchapter].pgci_cell_index=k;
                    wkchap[nchapter].chain_info_low=
                               pgci_cells[k].chain_info & 0x0ff;
                    sprintf( wkchap[nchapter].name,"dvd %d-%d-%d-%d",tno,i+1,j+1,k+1);
                    for ( l=0 ; l<nchapter ; l++ )
                        if ( wkchap[nchapter].lba_st == wkchap[l].lba_st )
                            break;
                    if( l >= nchapter )
                    {
//fprintf(stderr,"cell:%d:%d:%ld %ld \n",tno,cno,(long)wkchap[nchapter].lba_st,(long)wkchap[nchapter].lba_ed);
                        nchapter++;
                        cno++;
                    }
                }
            }
        }
        //ifoClose (ifo_s);
    }
    if( nchapter <= 0 )
        return -1;

    chapter_rec=(struct chapter_rec_t *)malloc( sizeof(struct chapter_rec_t)*nchapter );
    memcpy( chapter_rec,wkchap,sizeof(struct chapter_rec_t)*nchapter );
fprintf(stderr,"nchapter=%ld \n",nchapter );
    return nchapter;
}

static int m2m_last_chapter=-1;
static inline int lba2chapter_index( __off64_t lba )
{
    int i=m2m_last_chapter;
    if ( i >= 0 && i < nchapter
     && lba >= chapter_rec[i].lba_st
     && lba <= chapter_rec[i].lba_ed )
        return i;
    while ( ++i < nchapter )
	if ( lba >= chapter_rec[i].lba_st
	  && lba <= chapter_rec[i].lba_ed )
            return m2m_last_chapter=i;
    i=m2m_last_chapter;
    while ( --i >= 0 )
	if ( lba >= chapter_rec[i].lba_st
	  && lba <= chapter_rec[i].lba_ed )
            return m2m_last_chapter=i;
    return m2m_last_chapter=i;
}

int lba2chapter( __off64_t lba )
{
    int i=lba2chapter_index(lba);
    return (i<0)?-1:chapter_rec[i].title*256+chapter_rec[i].chapter ;
}

__off64_t chapter_lba( __off64_t lba ,int offset_chapter )
{
    int i=lba2chapter_index(lba);
    if( i < 0 || i >= nchapter ) return -1;
    return chapter_rec[i].lba_st;
}

int get_menu_vob( vob_file_t **menus )
{
    __off64_t j;
    int i,nmenu,div_flg=0;
    struct AD file_entry;
    unsigned long int partition_offset=0,pos=0;
    vob_file_t wkvob[100];
    char titlename[32];
    nmenu=0;
    for( i=0;;i++ )
    {
        sprintf(titlename,"/VIDEO_TS/VTS_%02d_0.VOB",i+1 );
        if (!UDFFindFileEntry(0,titlename,&partition_offset,&file_entry) )
            break;
        if ( file_entry.Length < 2048 ) continue;
        wkvob[nmenu].lbnum = partition_offset+file_entry.Location;
        wkvob[nmenu].st = pos ;
        wkvob[nmenu].ed = (pos+=file_entry.Length/2048) ;
        wkvob[nmenu].name = "menu";
#if 0
fprintf( stderr,"menu %d:ln=%ld st=%ld ed=%ld \n",nmenu,(long)wkvob[nmenu].lbnum,(long)wkvob[nmenu].st,(long)wkvob[nmenu].ed );
        for ( j=0 ; j<file_entry.Length/2048 ; j++ )
        {
            unsigned char local_buf[2048];
            unsigned char *pes;
            if ( UDFReadLB( wkvob[nmenu].lbnum +j, 1,local_buf) != 2048 )
                break;
            pes = local_buf + 14 + (local_buf[13] & 7) ;
            if ( pes[0] != 0x00 || pes[1] != 0x00 || pes[2] != 0x01 )
                continue;

            if ( pes[3] == 0x0bb )
            {
                pes += ( pes[4] << 8 ) + pes[5] + 6 ;
                if ( pes[0] != 0x00 || pes[1] != 0x00 || pes[2] != 0x01 )
                        continue;
            }
        }
#endif
        if ( wkvob[nmenu].st  != wkvob[nmenu].ed ) nmenu++;
//fprintf( stderr,"menu %d:ln=%ld st=%ld ed=%ld \n",nmenu,(long)wkvob[nmenu].lbnum,(long)wkvob[nmenu].st,(long)wkvob[nmenu].ed );
    }

    *menus=(vob_file_t *)malloc( sizeof(vob_file_t)*nmenu );
    memcpy( *menus , wkvob , sizeof(vob_file_t)*nmenu );
    return nmenu;
}

void chapter2voblist( vob_file_t ** vobfiles ,int * in_nchapter , int * nmenus )
{
    int i;
    __off64_t pos=0;
    vob_file_t *menus=NULL;
    vob_file_t *ret=NULL;

    *in_nchapter=nchapter;
    if ( nchapter < 1 ) return;
    if ( nmenus )
    {
        *nmenus= get_menu_vob( &menus );
        ret=(vob_file_t *)malloc( sizeof(vob_file_t)*(nchapter+*nmenus) );
        memset ( ret,0x0, sizeof(vob_file_t)*(nchapter+*nmenus) );
    }
    else
    {
        ret=(vob_file_t *)malloc( sizeof(vob_file_t)*nchapter );
        memset( ret,0x0 , sizeof(vob_file_t)*nchapter );
    }

    for( i=0 ; i<nchapter ; i++ )
    {
        ret[i].lbnum = chapter_rec[i].lba_st ;
        ret[i].st = pos ;
        pos += chapter_rec[i].lba_ed - chapter_rec[i].lba_st + 1;
        ret[i].ed = pos ;
        ret[i].name = (char *)malloc( strlen(chapter_rec[i].name)+1 ); ;
        strcpy( ret[i].name , chapter_rec[i].name ); ;
    }

    for( ; nmenus && i<nchapter+*nmenus ; i++ )
    {
        ret[i].lbnum = menus[i-nchapter].lbnum ;
        ret[i].st = pos ;
        pos += menus[i-nchapter].ed - menus[i-nchapter].st + 1;
        ret[i].ed = pos ;
    }
    if ( menus ) free( menus );
    *vobfiles = ret;
    return ;
}

void check_cell_step( __off64_t *seekpos,int step,__off64_t lba_idx )
{
    static struct chapter_rec_t *chap_bak=NULL;
    static ifo_cell_addr_t *cell_bak=NULL;
    struct chapter_rec_t *chap=NULL;
    ifo_cell_addr_t *cell=NULL;
    int i;
    uint32_t st,ed,off;

    i=lba2chapter_index( lba_idx );
    if( i < 0 || i >= nchapter )
        return ;
    chap=chapter_rec+i;
    if ( ! chap->chain_info_low ) return;
    if ( chap == chap_bak )
    {
        cell=cell_bak;
        st= htonl(cell->start);
        ed= htonl(cell->end);
    }

    off = lba_idx - chap->title_start;
    if ( chap != chap_bak || off < st || off > ed )
    {
        cell=chap->cells;
        do {
            st= htonl(cell->start);
            ed= htonl(cell->end);
            if ( off <= ed && off >= st ) break;
            if ( cell == chap->last_cell ) cell=chap->cells;
            else cell++;
        } while ( cell != chap->cells );
        if ( cell == chap->cells )
            return;
        chap_bak=chap,cell_bak=cell;
    }

    if ( off == ed )
    {
        // check multi-angle !!
        switch ( chap->chain_info_low ) 
        {
            case 0x0c:
printf( "chain %02x skip  .cell[%08lx,%08lx]llast[%08lx,%08lx] %08lx\n",chap->chain_info_low,(long)htonl(cell->start),htonl(cell->end),(long)htonl(chap->last_cell->start),htonl(chap->last_cell->end),(long)htonl(chap->pgci_cells[i].vobu_last_end) );
            {
                if ( ++cell != chap->last_cell && off > (st=htonl(cell->start)) )
                if ( ++cell != chap->last_cell && off > (st=htonl(cell->start)) )
                if ( ++cell != chap->last_cell && off > (st=htonl(cell->start)) )
                if ( ++cell != chap->last_cell && off > (st=htonl(cell->start)) )
                    return;
                cell--;
printf( "chain %02x skiped.cell[%08lx,%08lx]llast[%08lx,%08lx] %08lx\n",chap->pgci_cells[i].chain_info,(long)htonl(cell->start),htonl(cell->end),(long)htonl(chap->last_cell->start),htonl(chap->last_cell->end),(long)htonl(chap->pgci_cells[i].vobu_last_end) );
                *seekpos += ( st +chap->title_start -lba_idx )*2048-step;
                break;
            }
            case 0x0e: // non equivalent interleave
printf( "chain %02x\n",chap->chain_info_low );
            {
                ifo_cell_addr_t *c=cell;
                i=chap->pgci_cell_index+1;
                for ( ; i < chap->n_pgci_cells ; i++ )
                {
printf( "chain %02x check..cell[%08lx,%08lx]c[%08lx,%08lx] %08lx\n",chap->pgci_cells[i].chain_info,(long)htonl(cell->start),htonl(cell->end),(long)htonl(c->start),htonl(c->end),(long)htonl(chap->pgci_cells[i].vobu_last_end) );
                    if ( chap->pgci_cells[i].chain_info < 0x0c ) break;
                    if ( htonl(chap->pgci_cells[i].vobu_last_end) > htonl(c->end) )
                    {
                        cell++;
                        c++;
                    }
                    c++;
                }
printf( "chain %02x checked\n",chap->pgci_cells[i].chain_info );
                *seekpos += (htonl(cell->start) +chap->title_start -lba_idx)
                             *2048 -step;
                break;
            }
            case 0x5f: // multi angle
printf( "chain %02x\n",chap->chain_info_low );
            {
                i = (chap->title_start + htonl(cell[1].start) - lba_idx)
                                            *2048-step;
                if ( i >= 0 ) *seekpos += i;
                else
                    *seekpos += ( chap->title_start
                                   + htonl(
                                      chap->pgci_cells[chap->pgci_cell_index]
                                                      .vobu_last_end )
                                   + 1 - lba_idx )*2048-step;
                break;
            }
            default:
printf( "chain %02x\n",chap->chain_info_low );
                // check next cell
                if ( (st= htonl(cell[1].start)) == htonl(cell->start) )
                    step = (htonl(cell[2].start)+chap->title_start)-lba_idx;
                else
                    step = (st+chap->title_start)-lba_idx;
                break;
        }
        chap_bak=chap,cell_bak=cell;
    }
    return;
}
