/*
 *  m2m_thread.c:
 *     pthread(POSIX thread) routines.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */
#ifndef _LARGEFILE64_SOURCE
#define _LARGEFILE64_SOURCE
#endif
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 199506L
#endif
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE  500
#endif

#include <features.h>
#include <stdio.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/mman.h>
#include <netinet/in.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <pthread.h>
#include <string.h>

#include "video_out/video_out.h"
#include <mpeg2dec/mpeg2.h>
#include <mpeg2dec/mm_accel.h>
#include "m2m.h"
#include <sys/types.h>
#include <dvd_udf.h>


/* current time stamp */
uint32_t volatile ts_v; /* video frame   DTS/PTS */
uint32_t volatile ts_a; /* audio(master) PTS  */
static struct timeval tv_a;


static void *audio_thread( void *arg )
{
    extern void ao_play_pcm( void * ,void * , int );
    extern void  * audio_out_a52_init( void );
    extern void a52_decode_data (void * ,uint8_t * , uint8_t * );
    FILE *fp=NULL;
    m2m_buf_t * buf=NULL;
    // lpcm
    void  * ao= audio_out_a52_init();

    for(;;){
        if ( buf ) m2m_free_buffer( buf );
        buf= m2m_next_buffer( 0 );
if ( buf == NULL ) {
 sched_yield();
 //usleep( 100 );
 continue;
}
        if ( buf->ts ){
          ts_a=buf->ts;
          gettimeofday( &tv_a,NULL);
        }
//fprintf(stderr," TS(%lx) MPEG AUDIO\n",ts_a );
        if( play_status == STATUS_STOP ) 
        {
            pthread_mutex_lock( &play_stat_mutex );
            while( play_status == STATUS_STOP ) 
                pthread_cond_wait(&play_stat_cond,&play_stat_mutex);
            pthread_mutex_unlock( &play_stat_mutex );
            pthread_cond_signal( &play_stat_cond );
        }
        if ( buf->ch +1 != audio_no ) continue;
        switch ( buf->type ){
          case 0x080: // a52
            a52_decode_data(ao,buf->pos,buf->pos+buf->len);
            break;
          case 0x0a0: // pcm
            ao_play_pcm( ao,buf->pos , buf->len/4);
            break;
          case 0x0c0: // mpeg
            if( fp==NULL ) fp=popen("mpg123 - ","w");
            fwrite(buf->pos,1,buf->len,fp);
            break;
        }
    }
}

static uint8_t do_thread_flag=0;
static void *(*m2m_thread_functions[8])(void *)={
        video_thread,
        audio_thread,
        NULL
};

inline void m2m_thread_control( int type,int isCreate )
{
    if( type >= 8 ) return;
    if ( isCreate )
    {
        pthread_attr_t attr;
        pthread_t      thr;
        uint8_t        mask=1<<type;
        if ( mask&do_thread_flag )
            return;
        do_thread_flag |= mask;
        pthread_attr_init( &attr );
        pthread_attr_setscope( &attr , PTHREAD_SCOPE_SYSTEM );
        pthread_create( &thr , &attr  , m2m_thread_functions[type] , NULL );
    }
    else
    {
        uint8_t        mask=1<<type;
        do_thread_flag &= ~mask;
    }
}

uint64_t to_seek_pos=0l;
long change_program_by_lba( long seek_pos )
{
    play_status_t bak_play_status;
    long adjust_value;
    pthread_mutex_lock( &play_stat_mutex );
    if ( play_status == STATUS_TO_SEEK )
    {
        pthread_mutex_unlock( &play_stat_mutex );
        pthread_cond_signal( &play_stat_cond  );
        return get_current_value();
    }
    bak_play_status=play_status;
    to_seek_pos=seek_pos;
    play_status = STATUS_TO_SEEK;
    pthread_mutex_unlock( &play_stat_mutex );
    pthread_cond_broadcast( &play_stat_cond  );
    sched_yield();
    pthread_mutex_lock( &play_stat_mutex );
    while( play_status == STATUS_TO_SEEK )
        pthread_cond_wait( &play_stat_cond,&play_stat_mutex );
    play_status=STATUS_PLAY;
    play_status=bak_play_status;

    pthread_mutex_unlock( &play_stat_mutex );
    pthread_cond_signal( &play_stat_cond  );
    return to_seek_pos;
}

void *video_thread( void *arg )
{
    extern mpeg2dec_t mpeg2dec;
    extern int m2m_ad_sync;
    extern int m2m_ad_late;
    extern int m2m_ad_skip;
    int is_initialized;
    int i,n;
    int vcnt=0;
    double ts_v_bak;
    double ts_a_bak;
    double ts_v_pre;
    double ts_a_pre;
    double fps;
    double ts_v_per;
    double ts_a_per;
    double usec_pre;
    double ts_a_cur;
    double ts_v_cur;
    double usec;
    static struct timeval tv_sec;
    struct timeval tv;
    struct timeval tv_v;
    m2m_buf_t * buf=NULL;

    is_initialized=0;
    for ( ;; )
    {
        pthread_mutex_lock( &play_stat_mutex );
        if( play_status == STATUS_TO_SEEK )
        {
            pthread_mutex_unlock( &play_stat_mutex );
            is_initialized=0;
            pthread_mutex_lock( &play_stat_mutex );
            while( play_status == STATUS_TO_SEEK )
                pthread_cond_wait( &play_stat_cond,&play_stat_mutex );
            pthread_mutex_unlock( &play_stat_mutex );
            pthread_cond_signal( &play_stat_cond );
        }
        if( play_status == STATUS_STOP )
        {
            while( play_status == STATUS_STOP )
                pthread_cond_wait( &play_stat_cond,&play_stat_mutex );
        }
        pthread_mutex_unlock( &play_stat_mutex );
        pthread_cond_signal( &play_stat_cond );

        if ( buf ) m2m_free_buffer( buf );
        buf= m2m_next_buffer( 1 );
if ( buf == NULL ){
 if ( m2m_inc_index() == 0 && ! IS_LOOP ) {
  pthread_mutex_lock( &play_stat_mutex );
  play_status = STATUS_STOP ;
  while( play_status == STATUS_STOP )
   pthread_cond_wait( &play_stat_cond,&play_stat_mutex );
   pthread_mutex_unlock( &play_stat_mutex );
   pthread_cond_signal( &play_stat_cond );
  }
  continue;
}
        if ( buf->ts ){
          ts_v=buf->ts;
          gettimeofday( &tv_v,NULL );
          vcnt=0;
        }
        n=mpeg2_decode_data(&mpeg2dec,buf->pos,buf->pos+buf->len );

        while( n--){
            static double w=0;
           int retry=m2m_ad_sync;
while(--retry >=0 ){
            gettimeofday( &tv,NULL );
            usec=(tv.tv_sec-tv_a.tv_sec)*1000000.0+tv.tv_usec-tv_a.tv_usec;
            if( usec > 1000000.0/15.0 ) break;
            fps =ts_v +vcnt*1000000.0/120.0 -ts_a;

//fprintf( stderr,"%8.0lf ", ts_v*1.0 );
//fprintf( stderr,"%8.0lf ", ts_a*1.0 );
//fprintf( stderr,"%8.0lf ", ts_v+vcnt*10300.0 -ts_a );
//fprintf( stderr,"%8.0lf ", (tv.tv_sec -tv_a_wk.tv_sec )*1000000.0 +(tv.tv_usec-tv_a_wk.tv_usec) );
//fprintf( stderr,"%8.0lf ", fps );
//fprintf( stderr,"%8.0lf ", ts_v_per*1.0 );
//fprintf( stderr,"%8.0lf ", ts_a_per*1.0 );
//fprintf( stderr,"%8.0lf ", ts_v_cur );
//fprintf( stderr,"%8.0lf ",ts_a_cur );
//fprintf( stderr,"%8.0lf ",usec-usec_pre );
//fprintf( stderr,"%8.0lf ",ts_v_cur+fps-ts_a_cur );
//fprintf( stderr,"\r" );
          if ( fps < m2m_ad_late*-100.0 ){
          if ( w > 1.0 ) usleep( w );
fprintf( stderr,"sync:video %8.0lf %8.0lf      \r",w,fps/m2m_ad_late);
            if (  fps < m2m_ad_late*-500.0 ) w *=.4; else
            if (  fps < m2m_ad_late*-400.0 ) w *= .6; else
            if (  fps < m2m_ad_late*-360.0 ) w *= .8; else
            if (  fps < m2m_ad_late*-340.0 ) w *= .9; else
            if (  fps < m2m_ad_late*-330.0 ) w *= .94; else
            if (  fps < m2m_ad_late*-320.0 ) w *= .96; else
            if (  fps < m2m_ad_late*-310.0 ) w *= .97; else
            if (  fps < m2m_ad_late*-300.0 ) w *= .975; else
            if (  fps < m2m_ad_late*-290.0 ) w *= .98; else
            if (  fps < m2m_ad_late*-280.0 ) w *= .985; else
            if (  fps < m2m_ad_late*-270.0 ) w *= .99; else
            if (  fps < m2m_ad_late*-260.0 ) w *= .995; else
            if (  fps < m2m_ad_late*-200.0 ) w *= .999;
            usec_pre=usec;
            break;
          }else{
          if ( w > 1.0 ) usleep( w );
fprintf( stderr,"sync:video %8.0lf %8.0lf wait. %d \r",w,fps/m2m_ad_late,m2m_ad_sync-retry );
           w *= .95;
           w += (fps-(m2m_ad_late*-100.0))/7200.0;
           if ( w > m2m_ad_skip ) w=m2m_ad_skip;
           sched_yield();
           if ( fps > 10000.0 ) retry++;
          }
}
            vcnt++;
        }
    }
    return NULL;
}


