/*
 *  m2m_caster.c:
 *     pthread(POSIX thread) routines.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */

typedef struct m2m_playlist_entry_s {
  struct m2m_playlist_entry_s * next;
  char *name;
  char *path;
  int isES;
  off64_t st; // as byte on playlist
  off64_t ed; // as byte on playlist
  m2m_descripter_t *descripter;
} m2m_playlist_entry_t;

extern m2m_playlist_entry_t * m2m_get_playlist_entry_by_chapter(char *,char *);
extern m2m_playlist_entry_t * m2m_add_playlist_from_properties(void);
extern off64_t m2m_get_playlist_length(void);

