/*
 *  m2m_div.c:
 *     PS stream dvide utility
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */
#ifndef _LARGEFILE64_SOURCE
#define _LARGEFILE64_SOURCE
#endif
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 199506L
#endif
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE  500
#endif
#ifndef _BSD_SOURCE
#define _BSD_SOURCE
#endif

#define W_OPEN(FN) (( (FN)[0] == '-' && (FN)[1] == '\0' )?stdout:((FN)[0] == '|')?popen( (FN)+1,"w" ):fopen(FN,"w"))

#include <features.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <netinet/in.h>

#include "wav.h"

static int is_wave=0;
static int audio_no=1;
static int fd=0;
static char *out_fn[4]={NULL,NULL,NULL,NULL};
static FILE *out_fp[4]={NULL,NULL,NULL,NULL};
static struct {
 char id[4];
 uint32_t data_len;
 char wave_id[4];
 char format_chunk_id[4];
 uint32_t format_chunk_size;
 uint16_t format_tag;
 uint16_t n_channels;
 uint32_t rate;//=sample per sec
 uint32_t byte_per_sec;
 uint16_t block_size;
 uint16_t bit_per_sampletime;
 char data_chunk_id[4];
 uint32_t data_chunk_size;
} wave_hed={
 {'R','I','F','F'},
 0,
 {'W','A','V','E'},
 {'f','m','t',' '},
 0,
 1, // tag=PCM
 1, // channels = 2
 4800, // rate = 4800
 1200, // bps = 1200
 4, // block = 2byte*2ch
 16, // bpsmp = 16
 {'d','a','t','a'},
 0
};

static void usage( char *name )
{
	fprintf( stderr,"Usage:\n" );
	fprintf( stderr,"  %s mpeg2PS [-v video] [-m mpeg1audio] [-a ac3audio] [-l LPCM] [-wave]\n" ,name );
	fprintf( stderr,"Arguments:\n" );
	fprintf( stderr,"  mpeg2PS      : input file.'-' is stdin\n" );
	fprintf( stderr,"  -v vodeo     : output video stream\n" );
	fprintf( stderr,"  -m mpeg1audio: output mpeg audio stream\n" );
	fprintf( stderr,"  -a ac3audio  : output Dolby-AC3 stream\n" );
	fprintf( stderr,"  -l LPCM      : output LinerPCM stream\n" );
	fprintf( stderr,"  -wave        : add wave header for LPCM\n" );
}

static int init( int argc,char *argv[] )
{
	int arg;
	for ( arg=1 ; arg<argc ; arg++ )
	{
		int idx;
		if ( strcmp( argv[arg],"-wave" ) == 0 )
		{
			is_wave=1;
			continue;
		}
		if ( argv[arg][0] != '-' )
		{
			if ( fd > 1 ) return -1;
			if ( (fd=open( argv[arg], O_RDONLY )) == -1 )
				return -1;
			continue;
		}
		if ( argv[arg][1] == 'v' ) idx=0;
		else
		if ( argv[arg][1] == 'm' ) idx=1;
		else
		if ( argv[arg][1] == 'a' ) idx=2;
		else
		if ( argv[arg][1] == 'l' ) idx=3;
		else
		if ( argv[arg][1] == '\0' )
                        continue;
		else
			idx=-1;
		if ( arg+1 >= argc || idx < 0 )
			break;
		else
			out_fn[idx]=argv[++arg];
	}
	if ( arg<argc )
		fprintf( stderr,"bad option:%s\n",argv[arg] );
	return ( arg<argc ) ? -1 : 0;
}

int divide( void )
{
	int idx,hdrlen,peslen ;
	unsigned char buf[2048];
	while ( read( fd,buf,2048 ) > 0 )
	{
                unsigned char *pes;
                if ( buf[0x00] != 0x00
                  || buf[0x01] != 0x00
                  || buf[0x02] != 0x01
                  || buf[0x03] != 0xba )
                {
                        fprintf( stderr,"not mpeg2 packet.\n" );
                        continue;
                }
                pes = buf + 14 + (buf[13] & 7) ;
                if ( pes[0] != 0x00 || pes[1] != 0x00 || pes[2] != 0x01 )
                {
                        fprintf( stderr,"not PES \n" );
                        continue;
                }
                if ( pes[3] == 0x0bb )
                {
                        pes += ( pes[4] << 8 ) + pes[5] + 6 ;
                        if ( pes[0] != 0x00 || pes[1] != 0x00 || pes[2] != 0x01 )
                        {
                                fprintf( stderr,"not PES (2)\n" );
                                continue;
                        }
                }
		peslen = ( pes[4] << 8 ) + pes[5] +6 ;
		hdrlen = pes[8] + 6 + 3 ;
		if ( (pes[3]&0x0f0) == 0x0e0 ) //video
		{
			if ( out_fp[0] == NULL && out_fn[0] != NULL )
				out_fp[0]=W_OPEN(out_fn[0]);
			if ( out_fp[0] == NULL )
				continue;
			fwrite( pes+hdrlen , peslen-hdrlen , 1 , out_fp[0] );
		}
		else
		if ( pes[3] == (0xc0|(audio_no-1)) )    /* mpeg Audio */
		{
			if ( out_fp[1] == NULL && out_fn[1] != NULL )
				out_fp[1]=W_OPEN(out_fn[1]);
			if ( out_fp[1] == NULL )
				continue;
			fwrite( pes+hdrlen , peslen-hdrlen , 1 , out_fp[1] );
		}
		else
		if ( (pes[3] == 0xbd || pes[3] == 0xbf)    /* External */
		  && pes[hdrlen] == (0x080|(audio_no-1)) ) /* AC3 Track */
		{
			if ( out_fp[2] == NULL && out_fn[2] != NULL )
				out_fp[2]=W_OPEN(out_fn[2]);
			if ( out_fp[2] == NULL )
				continue;
			hdrlen += 4;
			fwrite( pes+hdrlen , peslen-hdrlen , 1 , out_fp[2]  );
		}
		else
		if ( (pes[3] == 0xbd || pes[3] == 0xbf)    /* External */
		  && pes[hdrlen] == (0x0a0|(audio_no-1)) ) /* LPCM Track */
		{
			if ( out_fp[3] == NULL && out_fn[3] != NULL )
			{
				out_fp[3]=W_OPEN(out_fn[3]);
				if ( out_fp[3] && is_wave )
					fwrite( &wave_hed,sizeof(wave_hed),1,out_fp[3] ); 
			}
			if ( out_fp[3] == NULL )
				continue;
			while( ++hdrlen < peslen-1 ){
				if( pes[hdrlen] == 0x01 && pes[hdrlen+1] == 0x80 ){
					hdrlen+=2;
					break;
				}
			}
			for( idx=hdrlen; idx+1<peslen ; idx+=2 ){
			    //unsigned char bak=pes[hdrlen+idx];
			    //pes[hdrlen+idx]=pes[hdrlen+idx+1];
			    //pes[hdrlen+idx+1]=bak;
			    fwrite( pes+idx+1,1,1,out_fp[3] );
			    fwrite( pes+idx  ,1,1,out_fp[3] );
                        }
			//fwrite( pes+hdrlen,(peslen-hdrlen)&(~3),1,out_fp[3] );
		}
	}
	if( out_fp[3] && is_wave) {
		static struct wave_header wave;
		off_t offset;

		offset = ftell(out_fp[3] );

		rewind( out_fp[3] ) ;
		offset -= 8;

		strcpy(wave.riff.id, "RIFF");
		wave.riff.len = offset + 24;
		strcpy(wave.riff.wave_id, "WAVE");
		offset -= 4;

		offset -= 8;
		strcpy(wave.format.id, "fmt ");
		wave.format.len = sizeof(struct common_struct);
		wave.common.wChannels = 2;
		wave.common.wBitsPerSample = 16;
		wave.common.dwSamplesPerSec = 48000;
		wave.common.wFormatTag = WAVE_FORMAT_PCM;
		wave.common.dwAvgBytesPerSec =
		wave.common.wChannels * wave.common.dwSamplesPerSec *
		(wave.common.wBitsPerSample >> 4);

		wave.common.wBlockAlign = wave.common.wChannels *
		(wave.common.wBitsPerSample >> 4);

		strcpy(wave.data.id, "data");

		offset -= sizeof(struct common_struct);
		wave.data.len = offset;

		offset -= 8;
		strcpy(wave.riffdata.id, "RIFF");
		wave.riffdata.len = offset;
		strcpy(wave.riffdata.wave_id, "WAVE");
		offset -= 4;

		offset -= 8;
		strcpy(wave.dataformat.id, "DATA");
		wave.dataformat.len = offset;
		fwrite( &wave, sizeof(wave),1 ,out_fp[3]);
	}
	for ( idx=0 ; idx<4 ; idx++ )
		if ( out_fp[idx] != NULL )
			fclose( out_fp[idx] ); 
	return 0;
}

int main( int argc,char *argv[] )
{
	int status=1;
	if ( init(argc,argv) )
		usage(argv[0]);
	else
		status = divide( );
	return status;
}
