/*
 *  m2m_thread.c:
 *     pthread(POSIX thread) routines.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */
#ifndef _LARGEFILE64_SOURCE
#define _LARGEFILE64_SOURCE
#endif
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 199506L
#endif
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE  500
#endif

#define PREAD64
#define VOB_FILE_NAME "VIDEO_TS/VTS_01_1.VOB"

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>
#include <signal.h>
#include <stdint.h>
#include <unistd.h>
#include <dvd_udf.h>

#include "m2m.h"


/* file handling
uint64_t menu_lba=0l;
vob_file_t *vobfiles=NULL;
vob_file_t *menufiles=NULL;
int nvobfiles=-1;
int nmenufiles=-1;
int in_file_index=0;
int dvdfd=-1;
int end_of_file=0;
*/

#ifdef USE_css_auth
static unsigned char title_key[5];
#endif
#if defined(PREAD64)
off64_t seekpos=0;
#elif defined(PREAD)
off_t seekpos=0;
#else
unsigned int seekpos=0;
#endif

void DE_CSS( uint8_t buf[] )
{
#ifdef USE_css_auth
    if ( buf[20] & 0x30)
    {
        extern void css_descramble(unsigned char *,unsigned char *);
        css_descramble( buf, title_key);
        //buf[20] &= 0x8f;
    }
#endif
}

/*
long get_total_vob_length( void )
{
    return vobfiles[nvobfiles-1].ed ;
}

int get_number_of_chapter( void )
{
    return nvobfiles ;
}

long change_program_by_index(int index )
{
    if ( index < 0 )
        return get_current_value();
    return change_program_by_lba( vobfiles[index%nvobfiles].st );
}

long change_program_by_offset(int offset)
{
    return change_program_by_index( in_file_index+offset );
}

long change_to_menu_program( void )
{
    long ret;
    if ( nmenufiles < 1 || in_file_index >= nvobfiles-nmenufiles )
        return get_current_value();
    ret=change_program_by_lba( vobfiles[nvobfiles-nmenufiles].st );
    pthread_mutex_lock( &play_stat_mutex );
    if ( play_status != STATUS_PLAY )
    {
        play_status = STATUS_PLAY;
    }
    pthread_mutex_unlock( &play_stat_mutex );
    pthread_cond_signal( &play_stat_cond );
    return ret;
}


long get_current_value(void)
{
#if defined(PREAD) || defined(PREAD64)
    return vobfiles[in_file_index].st + (seekpos >> 11) ;
#else
    return (lseek( vobfiles[in_file_index].fd,0,SEEK_CUR ) >> 11)
          + vobfiles[in_file_index].st;
#endif
}

int m2m_read_vobfile( m2m_descripter_t *_desc , uint8_t _local_buf[])
{
  m2m_filedesc_t *desc=_desc;
  int bytes_read;

  if ( _desc->st > desc->pos  || desc->pos > _desc->ed )
    return 0;
  bytes_read=pread64(desc->fd,_local_buf,READ_BLOCK_SIZE,desc->pos );
  desc->pos += bytes_read;
  if( bytes_read != READ_BLOCK_SIZE )
  {
    end_of_file=1;
    return bytes_read;
  }
  if( _local_buf[0x00] != 0x00
   || _local_buf[0x01] != 0x00
   || _local_buf[0x02] != 0x01
   || _local_buf[0x03] != 0xba )
  {
        PACK_DUMP(_local_buf,"not PES:");
        return -1;
  }
  return bytes_read;
}

int read_sector( m2m_descripter_t *instance , uint8_t _local_buf[])
{
    int bytes_read;

    if( device_name )
    {
        __off64_t sect_offset=seekpos>>11;
        if(vobfiles[in_file_index].st+sect_offset>=vobfiles[in_file_index].ed)
            return 0;
        sect_offset += vobfiles[in_file_index].lbnum;
        bytes_read = UDFReadLB( sect_offset, 1,_local_buf);
        check_cell_step( &seekpos,bytes_read,sect_offset );
    }
    else
        bytes_read=pread64(vobfiles[in_file_index].fd,_local_buf,READ_BLOCK_SIZE,seekpos);
    seekpos+=bytes_read;
    if( bytes_read != READ_BLOCK_SIZE )
    {
        end_of_file=1;
        //perror("read_sector()");
        return bytes_read;
    }
    if( _local_buf[0x00] != 0x00
     || _local_buf[0x01] != 0x00
     || _local_buf[0x02] != 0x01
     || _local_buf[0x03] != 0xba )
    {
        PACK_DUMP(_local_buf,"not PES:");
        return -1;
    }
    return bytes_read;
}

void open_file( void )
{
    int idx;
    int nfile=0;
    long pos=0;
    struct stat file_stat;
    struct AD File;
    int Partition=0;  // this is the standard location for DVD Video
    unsigned long int partition_offset;
#ifdef USE_css_auth
    static int isInit_css=1;
#endif

    nvobfiles=-1;
    vobfiles=NULL;
    if( device_name )
    {
        if( (dvdfd=UDFOpenDisc( device_name )) == -1 )
        {
            perror("");
            exit(1);
        }
        m2m_init_info(dvdfd);
#ifdef USE_css_auth
        if( isInit_css )
        {
            extern int init_css_by_lba( char [],int,unsigned char [] );
            if ( !UDFFindFileEntry(0,VOB_FILE_NAME,&partition_offset,&File))
            {
                exit(2);
            }
            isInit_css= init_css_by_lba( device_name,
                          (int)(partition_offset+File.Location),title_key );
            // if( isInit_css ) exit( 2-isInit_css );
            isInit_css= 0;
        }
#endif
        if ( DISABLE_MENU )
            chapter2voblist( &vobfiles,&nvobfiles,NULL ) ;
        else
            chapter2voblist( &vobfiles,&nvobfiles,&nmenufiles ) ;
        if ( nmenufiles > 0 )
            nvobfiles+=nmenufiles;
        return;
    }
    else
    {
        for( idx=0 ; file_name[idx] ; idx++)
            if( file_name[idx][0] != '-') nfile++;
    }
    if( nfile <= 0 )
    {
        fprintf( stderr,"file or title not found.\n" );
        exit(2);
    }
    vobfiles=(vob_file_t *)malloc( sizeof(vob_file_t)*nfile );

    for( nfile=idx=0 ; vobfiles ; idx++)
    {
        if( file_name[idx] == NULL ) break;
        if( file_name[idx][0] == '-')
            continue;
        if( stat( file_name[idx],&file_stat ) != 0 )
        {
            fprintf( stderr,"%s",file_name[idx] );
            perror(" - file stat:");
            continue;
        }
        vobfiles[nfile].fd=open(file_name[idx],O_RDONLY);
        if( vobfiles[nfile].fd < 0 )
        {
            fprintf( stderr,"%s",file_name[idx] );
            perror(" - file open:");
            continue;
        }
        vobfiles[nfile].st=pos;
        pos+=file_stat.st_size>>11;
        vobfiles[nfile].ed=pos;
        vobfiles[nfile].name=file_name[idx];
        nfile++ ;
    }
    in_file_index=(title_no<=nfile && title_no>0)?title_no:1;
    if( in_file_index > 0 ) in_file_index--;
    nvobfiles=nfile ;
}

int do_seek( uint8_t pack_type,uint8_t ext_type,off64_t to_seek,int flg )
{
    int skip_flag=0;
    if ( pack_type == 0x0e0 )
             skip_flag=1;
    for(in_file_index=0;in_file_index<nvobfiles;in_file_index++ )
        if( to_seek < vobfiles[in_file_index].ed ) break;
    seekpos=to_seek - vobfiles[in_file_index].st;
    seekpos *= READ_BLOCK_SIZE;
    chapter_echo( in_file_index+1 , nvobfiles );
    ts_v=ts_a=0;
    m2m_flush_buffer(flg);
    //imdct_init();
    play_status = STATUS_PLAY;
    return  skip_flag ;
}

int m2m_inc_index(){
    if ( nmenufiles < 1 || in_file_index < nvobfiles-nmenufiles )
    if ( ++in_file_index >= nvobfiles )
        in_file_index=0;
    chapter_echo( in_file_index+1 , nvobfiles );
    seekpos=0l;
     return in_file_index;
}
*/

