import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

import tsp.Controller;
import tsp.Node;
import tsp.TspPanel;

public class Main {
	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}
		JFrame frame = new JFrame("greedy (multiple fragment)");
		frame.setLayout(new BorderLayout());
		final TspPanel panel = new TspPanel();
		Controller controller = new Controller(panel);
		panel.addMouseListener(controller);
		frame.add(panel, BorderLayout.CENTER);
		JPanel subPanel = new JPanel();
		JButton startButton = new JButton("計算開始");
		subPanel.add(startButton);
		startButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.clearRoute();
				Set<Node> nodes = new HashSet<Node>(panel.getNodes());
				LinkedList<Node> route = new LinkedList<Node>();
				Set<Node> vp = new HashSet<Node>();
				
				Iterator<Node> itr = nodes.iterator();
				if (!itr.hasNext()) {
					return;
				}
				Node start = itr.next();
				Node node = start;
				while (!nodes.isEmpty()) {
					route.add(node);
					vp.add(node);
					nodes.remove(node);
					Node tmp = null;
					double min = Double.POSITIVE_INFINITY;
					for (Node terminal : nodes) {
						if (!node.equals(terminal) && !vp.contains(terminal)) {
							double distance = node.getDistance(terminal);
							if (min > distance) {
								min = distance;
								tmp = terminal;
							}
						}
					}
					node = tmp;
				}
				route.add(start);
				panel.add(route);
			}
		});
		JButton clearButton = new JButton("やり直し");
		subPanel.add(clearButton);
		clearButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.clear();
			}
		});

		frame.add(subPanel, BorderLayout.SOUTH);
		frame.setSize(600, 400);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}
}
