# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1811
## - Date: 2019-01-04
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3.1811) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

settings.mrconfig = {}

MR_CONF = settings.mrconfig

MR_CONF.setdefault('APP_NAME','machikane')
MR_CONF.setdefault('DB_NAME','w2%s' % MR_CONF['APP_NAME'])
MR_CONF.setdefault('IMAGE_NAME',MR_CONF['APP_NAME'])
MR_CONF.setdefault('APP_TITLE','Machikane-Red')
MR_CONF.setdefault('DEBUG',False)
MR_CONF.setdefault('RELOAD',True)

# ========
# ご利用に合わせて変更ください．
MR_CONF.setdefault('TITLE','Machikane')
MR_CONF.setdefault('OWNER','You')
MR_CONF.setdefault('OWNER_EN','You')
# ========

# /path/to/ 箇所を環境に合わせて設定ください.この記載のままでは動作しません．
MR_CONF.setdefault('WEB2PY_PATH','/path/to/web2py/applications/'+MR_CONF['APP_NAME']+'/')
MR_CONF.setdefault('BASE_PATH','/path/to/data_dir/'+MR_CONF['APP_NAME']+'/')
MR_CONF.setdefault('IMAGEBASE_PATH','/path/to/image_dir/'+MR_CONF['IMAGE_NAME']+'/')
MR_CONF.setdefault('RESOURCEBASE_PATH','/path/to/image_dir/'+MR_CONF['IMAGE_NAME']+'/')
MR_CONF.setdefault('FILEBASE_PATH','/path/to/file_dir/'+MR_CONF['IMAGE_NAME']+'/')

MR_CONF.setdefault('IMAGE_PATH',MR_CONF['IMAGEBASE_PATH']+'')  #image
MR_CONF.setdefault('DB_PATH',MR_CONF['WEB2PY_PATH']+'databases/')  #static　データベースのパス
MR_CONF.setdefault('DBBACKUP_PATH',MR_CONF['BASE_PATH']+'backups/')  #static　データベースのバックアップ位置
MR_CONF.setdefault('EXPORT_PATH',MR_CONF['BASE_PATH']+'exports/')  #テーブル・エクスポートの位置
MR_CONF.setdefault('RESTORE_PATH',MR_CONF['BASE_PATH']+'restores/')  #リストア・パス

# /host.domain/ 箇所を環境に合わせて設定ください. この記載のままでは動作しません．
MR_CONF.setdefault('SERVER_URL','https://host.domain/'+MR_CONF['APP_NAME'])
# IIPImage Server を利用しない場合は記載の変更は不要です.
MR_CONF.setdefault('IIIF_PORT','')
MR_CONF.setdefault('IIIF_SERVER_URL','https://host.domain/fcgi-bin/iipsrv.fcgi?IIIF=/'+MR_CONF['IMAGE_NAME']+'%2Fresources%2F')  #IIIF Server

MR_CONF.setdefault('GROUP_DEVELOPER',1)    # ルート管理者（開発者）
MR_CONF.setdefault('GROUP_ADMINISTRATOR',2)    # 管理者（データベース管理者）
MR_CONF.setdefault('GROUP_EDITOR',3)   # 編集者
MR_CONF.setdefault('GROUP_USER',4)     # 閲覧者 (RESERVED)
MR_CONF.setdefault('GROUP_GUEST',5)   # ゲスト (RESERVED)

# 画像サイズ（初期構成時のみ変更可。ただし、別サイズにする場合、レイアウト編集が必要）
MR_CONF.setdefault('IMG_SNAP_SIZE',640)   # 掲示用
MR_CONF.setdefault('IMG_THUMBNAIL_SIZE',160)   # サムネイル画像用

# 分割タイルサイズ（256:デフォルト値,[128,512]の整数範囲の制限）
MR_CONF.setdefault('IMG_TILE_SIZE',256)

# ライセンス（必要に応じて編集可。ただし、static/mr_js/staff/uploader.jsとの連携が必要）
MR_CONF.setdefault('LICENSES',[
    'Private'       #0
    ,'CC0'          #1
    ,'CC-BY 4.0'    #2
    ,'CC-BY-SA 4.0' #3
    ,'Other'        #4
    ])

MR_CONF.setdefault('TARGET',['undefined','resource','page'])
MR_CONF.setdefault('EXPORT_PATTERN',[])
