// Machikane-Red
// Version:3.1811
// Copyright (c) 2018-2019 Mitsuhiro Tsuda.

$(function(){

	var categorylist = [];
	var contributorlist = [];
	var DEBUG = true;

	var template = '<div class="m-upload-item">\
	<div class="dz-preview dz-file-preview">\
		<div class="dz-details">\
			<div class="dz-filename"><span data-dz-name></span></div>\
			<div class="dz-size" data-dz-size></div>\
			<img data-dz-thumbnail>\
		</div>\
		<!--div class="dz-progress"><span class="dz-upload" data-dz-uploadprogress></span></div-->\
		<div class="dz-success-mark"><span>✔</span></div>\
		<div class="dz-error-mark"><span>✘</span></div>\
		<div class="dz-error-message"><span data-dz-errormessage></span></div>\
	</div>\
	<table class="m-upload-item-info">\
		<tr><td class="m-label">Member:</td><td><input name="member" type="checkbox" class="member"></td></tr>\
		<tr><td class="m-label">Filename:</td><td><textarea name="name" class="fname"></textarea></td></tr>\
		<!--tr><td class="m-label">Collection:</td><td><select name="collection" value="0" class="collection"></select></td></tr-->\
		<tr><td class="m-label">ID:</td><td><input name="ident" type="text" value=""></td></tr>\
		<tr><td class="m-label">Title:</td><td><input name="title" type="text" value=""></td></tr>\
		<!--tr><td class="m-label">Category:</td><td><select name="category" value="0" class="category"></select></td></tr-->\
		<!--tr><td class="m-label">Contributor:</td><td><select name="contributor" value="0" class="contributor"></select></td></tr-->\
		<tr><td class="m-label">Rotate:</td><td><select name="rotate" value="0" class="rotate">\
			<option value="0" selected="selected">0</option>\
			<option value="1">Cw(90)</option>\
			<option value="2">Ud(180)</option>\
			<option value="3">Ccw(270)</option>\
		</select></td></tr>\
		<tr><td class="m-label">Format:</td><td><select name="format" value="1" class="format">\
			<option value="0" selected="selected">JPEG(.jpg)</option>\
			<option value="1">PDF(.pdf)</option>\
			<option value="2">Pyramid Tiled TIFF(.tif)</option>\
			<!--option value="3">JPEG 2000(.jp2)</option--><!-- Experimental -->\
		</select></td></tr>\
		<tr><td class="m-label">License:</td><td><select name="license" value="0" class="license">\
			<option value="0" selected="selected">Private</option>\
			<option value="1">CC0</option>\
			<option value="2">CC-BY 4.0</option>\
			<option value="3">CC-BY-SA 4.0</option>\
			<option value="4">Other</option>\
		</select></td></tr>\
	</table>\
<div>';

	// DropzoneJs
	// https://www.dropzonejs.com
	var m_dropzone = new Dropzone("#m-drop-box", {

		url: "/"+APPLICATION+"/staff/upload_callback.json",
		paramName: "file",
		maxFilesize: 20,  //default: 20
		maxThumbnailFilesize: 20,  //default: 20Mbyte
		thumbnailWidth: 160,
		thumbnailHeight: 160,
		thumbnailMethod: 'contain',
		createImageThumbnails: true,  //default: true
		clickable: true,  //default: true
		parallelUpload: 2,  //default: 2
		autoQueue: false,  //default: true, Manual Upload
		previewTemplate: template,  //default: HTML template

		init:function(){
			this.on("sending", function(file, xhr, formData){
				$elem = file.previewElement;
				formData.append("name", $("[name='name']", $elem).text());
				formData.append("ident", $("[name='ident']", $elem).val());
				formData.append("title", $("[name='title']", $elem).val());
				formData.append("rotate", $("[name='rotate']", $elem).val());
				formData.append("format", $("[name='format']", $elem).val());
				formData.append("license", $("[name='license']", $elem).val());
			});
			this.on("success", function(file, mes){
				if (DEBUG) alert(JSON.stringify(mes)); // 暫定
				this.removeFile(file);
			});
			this.on("error", function(file, mes){
				if (DEBUG) alert(JSON.stringify(mes)); // 暫定
			});
			this.on("queuecomplete", function(file, mes){
				location.reload();
			});
		},

		addedfile: function(file) {
			file.previewElement = Dropzone.createElement(this.options.previewTemplate);
			this.previewsContainer.appendChild(file.previewElement);
			file.previewElement.querySelector(".dz-filename span").textContent = file.name;
			//file.previewElement.querySelector(".dz-filename").setAttribute("value",file.name);
			file.previewElement.querySelector(".fname").textContent = file.name;
			var srcname = file.name;
			var srcext = srcname.substring(srcname.lastIndexOf(".")+ 1).toLowerCase();
			if (srcext == "pdf"){
				file.previewElement.querySelector(".format").value = 1; //PDF
			}
			file.previewElement.querySelector("input[name='title']").setAttribute("value",file.name);
			return file.previewElement.querySelector(".dz-size").appendChild(Dropzone.createElement("<span>" + this.filesize(file.size) + "</span>"));
		},

		thumbnail: function(file, dataUrl) {
			//file.previewElement.classList.remove("dz-file-preview");
			//file.previewElement.classList.add("dz-image-preview");
			file.previewElement.querySelector("img").remove();
			return file.previewElement.querySelector(".dz-details").appendChild(Dropzone.createElement("<img alt=\"" + file.name + "\" src=\"" + dataUrl + "\" data-dz-thumbnail>"));
		}
	});

	// 編集ツール
	var m_tool = false;

	function openTool(a_name, a_data){
		if (a_name == "upload") {
			$("#m-drop-box").addClass("dropzone").focus();
			m_tool = true;
		}
	}

	// チェックボックスを使った選択
	$("#m-tool-uploader-checkbox").change(function(){
		if (this.checked){
			$(".member").prop("checked",true);
		}
		else{
			$(".member").prop("checked",false);
		}
		return false;
	});

	// チェックボックスを使った実行（削除）
	$("#m-tool-uploader-action").on('click',function(evt){
		var act = $("#m-tool-uploader-fn").val();
		if (act == "remove"){
			var childs = m_dropzone.previewsContainer.childNodes;
			for (var i = childs.length - 1; i > 0; i--){
				var temp = childs[i];
				if ($('input[name="member"]',temp).prop("checked")==true){
					var file = m_dropzone.files[i-1];
					m_dropzone.removeFile(file);
				}
			}
		}
		return false;
	});

	// ファイル・アップロードの実行
	$("#m-tool-uploader-upload").on('click',function(evt){
		for (var i = 0; i < m_dropzone.files.length; i++) {
			var file = m_dropzone.files[i];
			m_dropzone.enqueueFile(file);
		}
		m_dropzone.processQueue();
		return false;
	});

	m_tool = false;

	openTool('upload', null);

});
