// Shimakuma-Green Image Viewer
// Version：3.1811
// Date: 2019-01-04
// Copyright (c) 2015-2019 Mitsuhiro Tsuda.
// License: Machikane-Red (version 3.1811) is released
//          under the GNU General Public License (GPL).
//          See the copyright notice LICENSE.

"use strict";

(function(window){

	var IPALLETORG = {};
	IPALLETORG.id = "g1811.shimakuma.ipallet.org";

	if (typeof window.IPALLETORG !== "undefined") { IPALLETORG = window.IPALLETORG; }
	else { window.IPALLETORG = IPALLETORG; }

	if (typeof IPALLETORG.Util === "undefined") {
		IPALLETORG.Util = {

			TYPE_NOTSUPPORT: 0,
			TYPE_PC: 1,
			TYPE_LEGACY: 2,
			TYPE_WINTOUCH: 3,
			TYPE_ANDROID: 4,
			TYPE_IPAD: 5,
			TYPE_IPHONE: 6,
			TYPE_OTHER: 7,

			support_: false,
			support_pc: false,
			support_windows: false,
			support_legacy: false,
			support_touch: false,
			support_wintouch: false,

			checkdevice : function () {
				// デバイス判定
				var _type = -1;	// not-support: 0, pc:1, pc(legacy):2, windows-touch:3, android:4, ipad:5, iphone:6, other: 7

				var _user_agent = navigator.userAgent.toLowerCase();

				//  ブラウザの種類とバージョン情報を得る
				var getBrowserVersion = function (a_agent, a_name, a_num, a_len) {
					if (a_agent.indexOf(a_name)<0){
						return -1;
					} else {
						var _idx = a_agent.indexOf(a_name);
						var _agent_temp = a_agent.substring(_idx+a_num, _idx+a_num+a_len);
						return parseFloat(_agent_temp);
					}
				};

				if (_user_agent.indexOf("windows")>0) {
					if (getBrowserVersion(_user_agent, "msie", 5, 3)>0) {
						if (getBrowserVersion(_user_agent, "msie", 5, 3)<=6) { _type = 0; }	// IE6以下
						else if (getBrowserVersion(_user_agent, "msie", 5, 3)<9 || parseInt(document.documentMode)<9) { _type = 2; }	// IE7, IE8
						else if (getBrowserVersion(_user_agent, "msie", 5, 3)>=9 && parseInt(document.documentMode)>=9) { _type = 2; }	// IE9, IE10
						this.support_windows = true;
					}
					if (getBrowserVersion(_user_agent, "rv:", 3, 3)>=11 && parseInt(document.documentMode)>=11) { _type = 1; this.support_windows = true; }	// IE11
					if (getBrowserVersion(_user_agent, "edge/", 5, 3)>=12) { _type = 1; this.support_windows = true; }		// Edge12+ (default)
				}
				if (_user_agent.indexOf("firefox")>0) {
					if (getBrowserVersion(_user_agent, "firefox/", 8, 3)>=15) { _type = 1; }		// Firefox15+ (default)
				}
				if (_user_agent.indexOf("webkit")>0) {
					if (getBrowserVersion(_user_agent, "edge/", 5, 3)>=12) { _type = 1; }		// Edge12+ (default)
					else if (getBrowserVersion(_user_agent, "opr/", 4, 3)>=30) { _type = 1; }		// Opela30+ (default)
					else if (getBrowserVersion(_user_agent, "chrome/", 7, 3)>=22) { _type = 1; }		// Chrome22+ (default)
					else if (getBrowserVersion(_user_agent, "safari/", 7, 4)>=600) { _type = 1; }		// Safari8+ (default)
					else if (getBrowserVersion(_user_agent, "version", 8, 3)>=5) { _type = 1; }		// Safari5+ (default)
					if (getBrowserVersion(_user_agent, "applewebkit/", 12, 4)>500) { _type = 1; }		// Apple Webkit
				}

				// タブレット
				if (_user_agent.indexOf("iphone")>0) { _type = 6; }
				if (_user_agent.indexOf("ipad")>0) {
					//if (_user_agent.match(/iPad;.*CPU.*OS 8_/i)) { var_ipad_os_version = 8; }
					if (_user_agent.indexOf("webkit")>0) { _type = 5; }		// iOS Version 5+ (only iPad Safari/Chrome)
				}
				if (_user_agent.indexOf("android")>0) {
					if (_user_agent.indexOf("webkit")>0 && getBrowserVersion(_user_agent, "android", 8, 3)>=4) { _type = 4; }		// Android Version 4+ (only Chrome)
				}
				if (_user_agent.indexOf("windows")>0) {
					if (navigator.maxTouchPoints>0 || navigator.msMaxTouchPoints>0 || _user_agent.indexOf("touch")>0) { _type = 3; }	// IE10+, タッチデバイス
				}

				return _type;
			},

			availablecanvas : function () {
				// Canvas(HTML5)の利用可否を確認, IE8不可
				var _canvas = false;
				try {
					var cvs = document.createElement('canvas');
					if (cvs.getContext('2d')) _canvas = true;
				}
				catch (e) {}
				return _canvas;
			},

			_pageX: function(event) { return 'touches' in event.originalEvent ? event.originalEvent.touches[0].pageX : event.pageX; },
			_pageY: function(event) { return 'touches' in event.originalEvent ? event.originalEvent.touches[0].pageY : event.pageY; },
			_elemX: function(event, e_offset) { return this._pageX(event) - e_offset; },
			_elemY: function(event, e_offset) { return this._pageY(event) - e_offset; },

			// 補助関数
			removePx: function(s) {
				if (s && typeof s !== "undefined" && (s == "" || s == "0")) { return 0; }
				if (s && s.indexOf("px") > 0) { return parseFloat(s.substring(0, s.length - 2)); } else { return 0; }
			},
			addPx: function(v){ if (v && typeof v !== "undefined" && v == "") { return "0"; } else { return v + "px"; } },

			// 配列中の一致を探す、IE8対策
			indexOf: function(ls, val, num) {
				if (!Array.indexOf || num>-1) {	// IE8 の場合、もしくは階層
					for (var i in ls){
						if (typeof ls[i] === "array"){ if (ls[i][num].indexOf(val) >=0) return i; }
						else { if (ls[i].indexOf(val) >=0) return i; }
				 	}
				 }
				else { return ls.indexOf(val); }
			},

			// オブジェクトの数をカウント
			countObj: function(obj) {
				if (Object.keys){ return Object.keys(obj).length; }
				else { var c = 0; for (var v in obj) c++; return c; }	// IE8対応
			},

			// 関数の存在確認
			existFunc: function(x){
				return (typeof x === "function") || (typeof x === "object" && x != null);
			},

			extend: function (obj, objs) { for (var key in objs) { obj[key] = objs[key]; } },	// 追加

			SINGLETAP: true,	// 画像・原資料のタッチ操作補正（シングルクリック/タッチ:true）
			DEBUG: false	// デバッグ用
		};
	}

	if (typeof window.Shimakuma !== "undefined") { IPALLETORG.Shimakuma = window.Shimakuma; }
	else if (typeof IPALLETORG.Shimakuma === "undefined") { IPALLETORG.Shimakuma = {}; window.Shimakuma = IPALLETORG.Shimakuma; }
	if (typeof IPALLETORG.Shimakuma.Viewer === "undefined") { IPALLETORG.Util.extend(IPALLETORG.Shimakuma, { Viewer: {} }); }
	if (typeof IPALLETORG.Shimakuma.Viewers === "undefined") { IPALLETORG.Util.extend(IPALLETORG.Shimakuma, { Viewers: {} }); }
	if (typeof IPALLETORG.Shimakuma.Indexer === "undefined") { IPALLETORG.Util.extend(IPALLETORG.Shimakuma, { Indexer: {} }); }
	if (typeof IPALLETORG.Shimakuma.Index === "undefined") { IPALLETORG.Util.extend(IPALLETORG.Shimakuma, { Index: {} }); }

	$(function(){

		var devicetype = IPALLETORG.Util.checkdevice();
		switch (devicetype) {
			case IPALLETORG.Util.TYPE_PC:
				IPALLETORG.Util.support_ = true;
				IPALLETORG.Util.support_pc = true;
				break;
			case IPALLETORG.Util.TYPE_IPAD:
			case IPALLETORG.Util.TYPE_ANDROID:
				IPALLETORG.Util.support_ = true;
				IPALLETORG.Util.support_touch = true;
				break;
			case IPALLETORG.Util.TYPE_LEGACY:
				IPALLETORG.Util.support_ = true;
				IPALLETORG.Util.support_pc = true;
				IPALLETORG.Util.support_legacy = true;
				break;
			case IPALLETORG.Util.TYPE_WINTOUCH:
				IPALLETORG.Util.support_ = true;
				IPALLETORG.Util.support_pc = true;
				IPALLETORG.Util.support_wintouch = true;
				break;
		}

		try {
			if (IPALLETORG.Util.DEBUG) console.log(navigator.userAgent+" || "+document.documentMode+" || "+devicetype+"|"+IPALLETORG.Util.support_pc+"|"+IPALLETORG.Util.support_legacy+"|"+IPALLETORG.Util.support_touch+"|"+IPALLETORG.Util.support_wintouch+" > "+IPALLETORG.Util.support_);
		} catch (e){}

		if (IPALLETORG.Util.support_windows) document.onselectstart = function(){ return false; };
		document.ondragstart = function(){ return false; };
	});

}(window));


(function(window, $, Indexer, Util){

	// アノテーション索引
	function AnnoteFl(parent_obj) {

		this.parent = parent_obj;

		this.x = this.y = 0;
		this.width = this.height = 0;
		this.offx = this.offy = 0;

		this.itemlist = [];

		this.id = "preview";
		this.indexpath = "xmls/";
		this.resourcepath = "resources/";
		this.startitem = 1;
		this.active = true;

		this.param = parent_obj.UIParam.UI_Preview;

		if (typeof this.param.id === "string") this.id = this.param.id;
		if (typeof this.param.indexpath === "string") this.indexpath = this.param.indexpath;
		if (typeof this.param.resourcepath === "string") {
			this.resourcepath = this.param.resourcepath;
			this.parent.VIEWParam.ResourcePath = this.resourcepath;
		}
		if (typeof this.param.startitem === "number") this.startitem = this.param.startitem;
		if (typeof this.param.active === "boolean") this.active = this.param.active;

		this.preview_div = null;
		this.preview_container = null;
		this.annote_fl_div = null;
		this.fl = null;

		return this;
	}
	AnnoteFl.prototype.init = function() {

		this.offx = this.parent.parent_dom["offsetx"];
		this.offy = this.parent.parent_dom["offsety"];

		this.preview_div = document.getElementById(this.param.id);
		if (this.preview_div == null){
			this.preview_div = document.createElement("div");
			this.preview_div.id = this.param.id;
			this.parent.parent_dom_node.appendChild(this.preview_div);
		}
		var elements = this.preview_div.getElementsByTagName("ul");
		if (elements.length == 0){
			this.preview_container = document.createElement("ul");
			this.preview_div.appendChild(this.preview_container);
		}
		else{
			this.preview_container = elements[0];
		}

		this.annote_fl_div = document.getElementById("annotefl");
		if (this.annote_fl_div != null) this.annote_fl_div.remove();
		this.annote_fl_div = document.createElement("div");
		this.annote_fl_div.id = "annotefl";
		this.preview_div.appendChild(this.annote_fl_div);

		this.fl = null;
		try {
			this.fl = new Fl(this, this.annote_fl_div);
		} catch (e) {}

		var that = this;
		$(window).on("keyup", function(event) {
			var evt = event || window.event;
			var keycode = evt.charCode || evt.keyCode;
			if (keycode == 33){ event.preventDefault(); that.movePage(-1); }
			else if (keycode == 34){ event.preventDefault(); that.movePage(1); }
		});

	};
	AnnoteFl.prototype.movePage = function(d) {

		var $current = $("li.current",$(this.preview_div));
		var param = $current[0];

		if (d>0){
			var $next = $current.next();
			if ($next.length > 0){ param = $next[0]; }
			else {
				$next = $("li:first-child",$current.parent().parent().next());
				if ($next.length > 0){ param = $next[0]; }
			}
		}
		else if (d<0){
			var $prev = $current.prev();
			if ($prev.length>0){ param = $prev[0]; }
			else {
				$prev = $("li:last-child",$current.parent().parent().prev());
				if ($prev.length>0){ param = $prev[0]; }
			}
		}
		if (param){
			var __id = parseInt($(param).attr("id").substring(1));
			this.fl.changePage(__id);
			this.parent.forcedPage([__id, this.itemlist.length-1]);
			var resource = $(param).attr("data-resource");
			var type = $(param).attr("data-ext");
			var _src_obj = this.itemlist[__id];
			if (_src_obj == null || typeof _src_obj["name"] === "undefined"){
				this.parent.setForcedResource(resource, type);
			}
			else {
				this.parent.image_viewer.setForcedResource(_src_obj);
			}
		}
	};
	AnnoteFl.prototype.updateSize = function(w, h) {
		this.height = h;
		if (this.preview_div) this.preview_div.style.height = h + "px";
		if (this.fl) this.fl.updateSize(w, h);
	};
	AnnoteFl.prototype.setAnnotePreview = function() {

		var items = this.preview_container.children;

		if (this.fl == null) {
		}
		else if (items.length > 0){
			// HTML内の内容を移設
			$(this.preview_container).appendTo($(this.fl.fl_base.fl_base_div));
			this.itemlist.push({});	// 整合ダミー
			for (var i = 0; i < items.length; i++) {
				var _id = items[i].getAttribute("id");
				this.itemlist.push({"id":_id});	// 整合ダミー
				this.fl.fl_base.setItemData(_id, i, true);	// 読み込み済み
				var that = this;
				$("span",items[i]).click(function(){
					var $li = $(this).parent();
					var __id = parseInt($li.attr("id").substring(1));
					var sv = $li.attr("data-rect").split(",");
					var v = [parseInt(sv[0]),parseInt(sv[1]),parseInt(sv[2]),parseInt(sv[3])];
					var w = $(window).width(); var h = $(window).height();
					that.parent.forcedView( v[0]+v[2]/2, v[1]+v[3]/2, (w/v[2]+h/v[3])/8 );
				}).css("cursor","pointer");
				var data_rect = items[i].getAttribute("data-rect");
				var _data = data_rect.split(",");
				this.parent.annotes.push({
					"locate":_data[0]+","+_data[1]
					,"label":$("span",items[i]).text()
					,"rect":data_rect
					,"type":"rect"
					,"vis":3
					,"vislevel":5
				});
			}
			this.fl.loaded = true;	// 読み込み済み
			this.fl.init();

			var $li = $(items[this.startitem-1]);
			var __id = parseInt($li.attr("id").substring(1));

			this.fl.fl_div.style.display = "block";
			$("#preview").css("left","-180px");
		}
	};
	AnnoteFl.prototype.setPreview = function(a_resource, a_resource_type, a_params) {

		var items = this.preview_container.children;

		if (this.fl == null) {
		}
		else if (items.length > 0){
			// HTML内の内容を移設
			$(this.preview_container).appendTo($(this.fl.fl_base.fl_base_div));
			this.itemlist.push({});	// 整合ダミー
			for (var i = 0; i < items.length; i++) {
				var _id = items[i].getAttribute("id");
				this.itemlist.push({"id":_id});	// 整合ダミー
				this.fl.fl_base.setItemData(_id, i, true);	// 読み込み済み
				var that = this;
				$("img",items[i]).click(function(){
					var $li = $(this).parent();
					var __id = parseInt($li.attr("id").substring(1));
					that.fl.changePage(__id);
					that.parent.forcedPage([__id, items.length]);
					that.parent.setForcedResource($li.attr("data-resource"), $li.attr("data-ext"), a_params);
				}).css("cursor","pointer");
			}
			this.fl.loaded = true;	// 読み込み済み
			this.fl.init();

			var $li = $(items[this.startitem-1]);
			var __id = parseInt($li.attr("id").substring(1));
			that.fl.changePage(__id);
			this.parent.forcedPage([this.startitem, items.length]);
			this.parent.setForcedResource($li.attr("data-resource"), $li.attr("data-ext"), a_params);

			this.fl.fl_div.style.display = "block";
		}
		else {
			// 新規
			loadIndex(this, a_resource, a_resource_type);

			function setWorks (that) {
				var $ul = $('<ul></ul>');
				$(that.fl.fl_base.fl_base_div).append($ul);

				var ld = null;
				if (typeof that.itemlist[0]["ldata"] === "object") ld = that.itemlist[0]["ldata"];

				for (var i = 1; i < that.itemlist.length; i++) {
					var item = that.itemlist[i];
					var _id = item["id"];
					if (typeof item["path"] === "undefined") item["path"] = that.parent.VIEWParam.ResourcePath;
					var tresource = item["resource"];
					if (tresource.lastIndexOf("/")>0){
						var tresource_index = tresource.lastIndexOf("/");
						item['field'] = tresource.substring(0,tresource_index);
						item['name'] = tresource.substring(tresource_index+1);
					}
					else {
						item['field'] = "";
						item['name'] = tresource;
					}
					if (ld && typeof item["ldata"] === "undefined") item["ldata"] = ld;

					var $img = $('<img src="'+window.lime3depth['s_dir']+'limescripts3/lime3lib_option/preview.png" width="'+item["ldata"][0]+'" height="'+item["ldata"][1]+'" data-resource="'+item["path"]+item["resource"]+'/_'+item["name"]+'">');

					var $li = $('<li id="n'+_id+'" data-resource="'+item["resource"]+'" data-ext="'+item["type"]+'"><span>'+item["label"]+'</span></li>');
					$li.prepend($img);
					$("img",$li).click(function(){
						var $li = $(this).parent();
						var __id = parseInt($li.attr("id").substring(1));
						that.fl.changePage(__id);
						that.parent.forcedPage([__id,that.itemlist.length-1]);
						that.parent.image_viewer.setForcedResource(that.itemlist[__id]);
						//that.parent.setForcedResource($li.attr("data-resource"), $li.attr("data-ext"), a_params);
					}).css("cursor","pointer");
					$ul.append($li);
					that.fl.fl_base.setItemData("n"+_id, i-1, false);
				}
				that.fl.loaded = false;
				that.fl.init();

				var li = that.itemlist[that.startitem];

				that.parent.forcedPage([that.startitem,that.itemlist.length-1]);
				that.parent.image_viewer.setForcedResource(li);

				if (that.startitem > 1){
					setTimeout(function(){
						that.fl.changePage(that.startitem);
					},500);
				}
				else {
					that.fl.changePage(that.startitem);
				}
				that.fl.fl_div.style.display = "block";
			}
			// 解析用関数
			function loadIndex(that, index_file, index_format) {
				$.ajax({
					type: "GET",
					url: that.indexpath + index_file + "." + index_format,
					dataType: index_format,
					success: function(obj){
						if (index_format == "xml") { readXmlIndex(that, obj); }
						else if (index_format == "json") { readJsonIndex(that, obj); }
						setWorks(that);
					},
					error: function(){}
				});
			}
			function readJsonIndex(that, json) {
				that.itemlist = json["body"];
				that.itemlist.unshift(json["header"]);

				for (var i = 1; i < that.itemlist.length; i++){
					var _obj = that.itemlist[i];
					if (_obj != null && typeof _obj["ext"] === "string" && typeof _obj["type"] === "undefined"){
						_obj["type"] = _obj["ext"].toLowerCase();
					}
				}
			}
			function readXmlIndex(that, xml) {
				if ($("items", xml).length == 1) {
					var group = $("items", xml);
					readFirst(that, group[0]);
					if ($("item", xml).length > 0) {
						var i = 0;
						var pages = $("item", xml);
						while (i < pages.length){
							readPage(that, i + 1, pages[i]);
							i = i + 1;
						}
					}
				}
				else if ($("item", xml).length > 0) {
					var pages = $("item", xml);
					readFirst(that, pages[0]);
					var i = 1;
					while (i < pages.length){
						readPage(that, i, pages[i]);
						i = i + 1;
					}
				}
			}
			function readFirst(that, page) {
				var node = {title: "", description: "", total: 0, direction: "LR", ldata: [128,128]};
				page.getAttribute("title") != null ? node['title'] = page.getAttribute("title") : node['title'] = "";
				page.getAttribute("description") != null ? node['description'] = page.getAttribute("description") : node['description'] = "";
				page.getAttribute("total") != null ? node['total'] = page.getAttribute("total") : node['total'] = "";
				if (page.getAttribute("direction") != null){
					if (page.getAttribute("direction").indexOf("LR") >= 0){
						// 横書き、from L to R
						//that.PAGERL = false;
						//that.INDEXFIRST = true;
					} else if (page.getAttribute("direction").indexOf("RL") >= 0){
						//that.PAGERL = true;
						//that.INDEXFIRST = true;
					}
					if (page.getAttribute("direction").indexOf("-") == 0){
						//that.INDEXFIRST = false;
					}
				}
				else {
					// 指定が無い場合は設定が優先（横書きLR、from L to R）
				}
				// サムネイルサイズ
				var ldata = [128,100];
				if (page.getAttribute("ldata") != null){
					var ld = page.getAttribute("ldata");
					node['ldata'] = ld.split(/[\s,]+/).map(function(x){ return parseInt(x); });
				}
				that.itemlist.push(node);
			}
			function readPage(that, index, page) {

				if (page == null) return;

				var node = {role:"resource", path:"", field:"", name:"", type:"", altertype:"", metadata:{}};

				page.getAttribute("path") != null ? node['path'] = page.getAttribute("path") : node['path'] = that.parent.VIEWParam.ResourcePath;
				if (page.getAttribute("resource") != null){
					var tresource = page.getAttribute("resource");
					if (tresource.lastIndexOf("/")>0){
						var tresource_index = tresource.lastIndexOf("/");
						node['field'] = tresource.substring(0,tresource_index);
						node['name'] = tresource.substring(tresource_index+1);
					}
					else {
						node['field'] = "";
						node['name'] = tresource;
						node['resource'] = tresource;
					}
				}
				else if (page.getAttribute("name") != null){
					var tresource = page.getAttribute("name");
					if (tresource.lastIndexOf("/")>0){
						var tresource_index = tresource.lastIndexOf("/");
						node['field'] = tresource.substring(0,tresource_index);
						node['name'] = tresource.substring(tresource_index+1);
					}
					else {
						node['field'] = "";
						node['name'] = tresource;
						node['resource'] = tresource;
					}
				}
				if (page.getAttribute("field") != null){
					var tfield = page.getAttribute("field");
					node['field'] = tfield;
				}
				if (node["field"] != ""){
					node['resource'] = node["field"] + "/" + node["name"];
				} else {
					node['resource'] = node["name"];
				}
				// 拡張子
				if (typeof page.getAttribute("ext") === "string") {
					var _type = page.getAttribute("ext");
					if (_type.indexOf("|") > 0){
						var _typeindex = _type.indexOf("/");
						node['type'] = _type.substring(0,_typeindex);
						if (_type.substring(_typeindex+1).indexOf("|") < 0){
							node['altertype'] = _type.substring(_typeindex+1);
						} // これ以上は対応しない
					}
					else {
						node['type'] = _type;
					}
				}
				// 優先書き換え
				if (typeof page.getAttribute("type") === "string") {
					var _type = page.getAttribute("type");
					if (_type.indexOf("|") > 0){
						var _typeindex = _type.indexOf("/");
						node['type'] = _type.substring(0,_typeindex);
						if (_type.substring(_typeindex+1).indexOf("|") < 0){
							node['altertype'] = _type.substring(_typeindex+1);
						} // これ以上は対応しない
					}
					else {
						node['type'] = _type;
					}
				}
				// 表示形式
				if (typeof page.getAttribute("view") === "string") node['view'] = page.getAttribute("view");

				page.getAttribute("label") != null ? node['label'] = page.getAttribute("label") : node['label'] = "";	//  優先
				page.getAttribute("id") != null ? node['id'] = page.getAttribute("id") : node['id'] = "" + index;
				page.getAttribute("page") != null ? node['page'] = parseInt(page.getAttribute("page")) : node['id'] = index;

				// サムネイルサイズ
				if (typeof page.getAttribute("ldata") === "string"){
					var ld = page.getAttribute("ldata");
					node["ldata"] = ld.split(/[\s,]+/).map(function(x){ return parseInt(x); });
				}
				else {
					node["ldata"] = that.itemlist[0]["ldata"];
				}

				Indexer.setExpandAttrs(node, page);

				that.itemlist.push(node);
			}

		}

	};


	function Fl(parent_obj, parent_elem) {

		this.parent = parent_obj;
		this.parent_elem = parent_elem;

		this.x = this.y = 0;
		this.width = parent_obj.width;
		this.height = parent_obj.height;

		this.offx = parent_obj.offx;
		this.offy = parent_obj.offy;

		this.fl_div = document.createElement("div");
		this.fl_div.id = "s14fl";

		this.fls_div = document.createElement("div");
		this.fls_div.id = "s14fls";
		this.fl_div.appendChild(this.fls_div);

		this.parent_elem.appendChild(this.fl_div);

		this.fl_base = new FlBase(this);
		this.fl_bar = new FlBar(this);

		// スクロール用変数
		this.controller_height = 0;
		this.fl_height = this.height - this.controller_height;
		this.fl_base_position = this.height - this.controller_height;
		this.fl_base_offset = 0;
		this.fl_base_offset_past = 0;
		this.fl_base_height = this.fl_base_position + this.fl_base_offset;
		this.fl_scrolled = false;

		// ハンドル用変数
		this.fl_button_height = 38;
		this.fl_bar_height = this.fl_height - 2 * this.fl_button_height;
		this.fl_bar_offset = this.fl_button_height;
		this.fl_hangle_height = Math.floor(this.fl_bar_height * this.fl_height / this.fl_base_height);
		this.fl_handle_top = Math.floor(this.fl_base_offset * this.fl_bar_height / this.fl_base_height) + this.fl_bar_offset;

		// マウスホイール
		var that = this;
		$(this.fl_div).on("mousewheel", function(evt){
			evt.stopPropagation(); evt.preventDefault();
			that.stepScroll(-evt.originalEvent.wheelDelta / 60);
		}).on("DOMMouseScroll", function(evt){
			evt.stopPropagation(); evt.preventDefault();
			that.stepScroll(evt.originalEvent.detail / 3);
		});

		// 初期状態
		this.fl_div.style.display = "none";
		this.loaded = false;

		this.updateSize();
		this.setScroll();
	}
	// オブジェクトの数をカウント
	Fl.prototype.countObj = function(obj) {
		if (Object.keys){ return Object.keys(obj).length; }
		else { var c = 0; for (var v in obj) c++; return c; }	// IE8対応
	};
	// 初期化
	Fl.prototype.init = function()
	{
	  if (this.countObj(this.fl_base.imgs) > 0){
			// 逐次ロード
			var that = this;

			$("#preview").css("left","0px");
			$("#preview").fadeIn(function(){

				var ymax = 0;
				$("#s14fl_base li").each(function(){
					if ($(this).parent().css("display")=="block"){
						var _y = $(this).offset().top;
						var _id = $(this).attr("id");
						if (typeof _id !== "undefined"){
							that.fl_base.imgs[_id]["y"] = _y;
							if (_y > ymax) ymax = _y;
						}
					}
				});

				that.fl_base_position = $("#s14fl_base>ul").height() * 1.012;	// 後日検証
				that.fl_base_height = that.fl_base_position;

				var timer = setInterval(function(){
					if (that.loaded){
						clearInterval(timer);
						that.updateSize();
						that.setScroll();
					}
					else { that.updateLoad();
					}
				}, 100);

				that.updateSize();
				that.setScroll();

			});

		}
		else {
			$("#preview").css("left","-180px");
		}

		this.updateSize();
		this.setScroll();
	};
	Fl.prototype.reinit = function()
	{
	  if (this.countObj(this.fl_base.imgs) > 1){
			// 逐次ロード
			this.loaded = false;
			var that = this;

			setTimeout(function(){

				var ymax = 0;
				$("#s14fl_base li").each(function(){
					if ($(this).parent().css("display")=="block"){
						var _y = $(this).offset().top;
						var _id = $(this).attr("id");
						if (typeof _id !== "undefined"){
							that.fl_base.imgs[_id]["y"] = _y;
							if (_y > ymax) ymax = _y;
						}
					}
				});

				that.fl_base_position = $("#s14fl_base>ul").height() * 1.012;	// 後日検証
				that.fl_base_height = that.fl_base_position;

				var timer = setInterval(function(){
					if (that.loaded){
						clearInterval(timer);
						that.updateSize();
						that.setScroll();
					}
					else { that.updateLoad();
					}
				}, 100);

				that.updateSize();
				that.setScroll();

			}, 500);

		}
	};
	Fl.prototype.stepScroll = function(d)
	{
		this.fl_base_offset += Math.floor(d*(this.fl_handle_height / 32) * this.fl_base_height / this.fl_bar_height);
		this.setScroll();

		var that = this;
		setTimeout(function(){
			if (that.fl_base_offset == that.fl_base_offset_past){
				that.updateLoad();
			}
		},1000);
		this.fl_base_offset_past = this.fl_base_offset;
	};
	Fl.prototype.moveScroll = function(ty)
	{
		if (ty <= -9999) {
			this.fl_base_offset = this.fl_base_height - this.fl_height;
		}
		else if (ty <= 0) {
			if (this.fl_base_height > this.fl_height){
				this.fl_base_offset = 0;
			} else {
				this.fl_base_offset = this.fl_base_height - this.fl_height;
			}
		} else {
			if (this.fl_handle_height < 36){
				this.fl_base_offset = Math.floor((ty - 18 - this.fl_bar_offset) * this.fl_base_height / (this.fl_bar_height - 36 + this.fl_handle_height));
			}
			else {
				this.fl_base_offset = Math.floor((ty - this.fl_handle_height / 2 - this.fl_bar_offset) * this.fl_base_height / this.fl_bar_height);
			}
		}
		this.setScroll();
	};
	Fl.prototype.relativeScroll = function(ty)
	{
		if (ty < this.fl_handle_top + this.fl_handle_height / 2){
			this.fl_base_offset -= (this.fl_bar_height - this.offy - this.fl_bar_offset);
			if (this.fl_base_offset <= 0) this.fl_base_offset = 0;
		}
		else {
			this.fl_base_offset += (this.fl_bar_height - this.offy - this.fl_bar_offset);
			if (this.fl_base_offset >= this.fl_base_height - this.fl_height) this.fl_base_offset = this.fl_base_height - this.fl_height;
		}
		this.updateLoad();
		this.setScroll();
	};
	Fl.prototype.setScroll = function()
	{
		if (this.fl_base_offset < 0) { this.fl_base_offset = 0; }
		if (this.fl_base_offset + this.fl_height > this.fl_base_height) { this.fl_base_offset = this.fl_base_height - this.fl_height; }

		if (this.fl_handle_height >= this.fl_height - 80){ this.fl_base_offset = 0; } // 2016-03-04ボタン補正,数量の少ない場合に、Bottom配置となる対応

		this.fl_base.fl_base_div.style.top = -this.fl_base_offset + "px";

		this.updateHandle();
	};
	Fl.prototype.updateLoad = function()
	{
		if (!this.loaded) {
			var that = this;
			var no_load = 0;
			$("#s14fl_base li").each(function(){
				var img = that.fl_base.imgs[$(this).attr("id")];
				if (typeof img !== "undefined" && !img["loaded"]){
					no_load++;

					if (img["y"] > that.fl_base_offset - that.fl_height && img["y"] < that.fl_base_offset + 2 * that.fl_height){
						$("img",this).on("load",function(event){
							img["loaded"] = true;
							var wid = 128;
			      	var hei = 128;
			      	var _wid = $(this).width();
			      	var _hei = $(this).height();
							if (typeof event.currentTarget.naturalWidth !== "undefined") { _wid = event.currentTarget.naturalWidth; _hei = event.currentTarget.naturalHeight; }
				      else { _wid = event.target.width; _hei = event.target.height; }
				      if (_wid > _hei){ hei = parseInt(_hei * wid / _wid); }
				      else{ wid = parseInt(_wid * hei / _hei); }
				      $(this).attr({"width":wid,"height":hei});
						});
						var src = $("img",this).attr("data-resource");
						$("img", this).attr("src",src + ".jpg").on("error",function(){
						  var that = this;
						  setTimeout(function(){
						    $(that).attr("src",window.lime3depth['s_dir']+"limescripts3/lime3lib_option/preview.png");
						  },0);
						});
					}
				}
			});
			if (no_load == 0) this.loaded = true;
		}
	};
	Fl.prototype.play = function(items)
	{
		this.fl_base.play(items);
		this.init();
	};
	Fl.prototype.setItem = function(item)
	{
		this.init();
	};
	Fl.prototype.changePage = function(tnum)
	{
		jimeHighlight(tnum);

		if (tnum > 1 && this.fl_bar.accessible) {
			this.fl_base_offset = Math.floor(((tnum - 2) / (this.parent.itemlist.length + 1)) * this.fl_base_height);
			if (this.fl_base_offset <= 0) { this.fl_base_offset = 0; }
			else if (this.fl_base_offset >= this.fl_base_height - this.fl_height) { this.fl_base_offset = this.fl_base_height - this.fl_height; }

			this.updateLoad();
			this.setScroll();
		}
	};
	Fl.prototype.updateHandle = function()
	{
		if (this.fl_handle_height < 36){
			this.fl_handle_top = Math.floor(this.fl_base_offset * (this.fl_bar_height - 36 + this.fl_handle_height) / this.fl_base_height) + this.fl_bar_offset;
			this.fl_bar.fl_handle.fl_handle_div.style.height = "36px";
			this.fl_bar.fl_handle.fl_handle_div.style.top = this.fl_handle_top + "px";
		}
		else {
			this.fl_handle_top = Math.floor(this.fl_base_offset * this.fl_bar_height / this.fl_base_height) + this.fl_bar_offset;
			this.fl_bar.fl_handle.fl_handle_div.style.height = this.fl_handle_height + "px";
			this.fl_bar.fl_handle.fl_handle_div.style.top = this.fl_handle_top + "px";
		}
	}
	Fl.prototype.updateSize = function(tw, th)
	{
		if (arguments.length == 2){
			if (th <= 0 && tw <= 0){
				this.height = this.parent.height;
			}
			else {
				this.width = tw;
				this.height = th;
			}
		}
		else {
			this.height = $(this.parent_elem).height() - this.controller_height * 1;
		}
		this.fl_div.style.height = (this.height - this.controller_height * 0) + "px";
		this.fl_base.fl_base_div.style.height = (this.height - this.controller_height * 0) + "px";
		this.fl_bar.fl_bar_div.style.height = (this.height - this.controller_height * 0) + "px";

		this.fl_height = this.height;
		this.fl_base_height = this.fl_base_position;
		this.fl_bar_height = this.fl_height - 2 * this.fl_button_height;
		this.fl_handle_height = Math.floor(this.fl_bar_height * this.fl_height / this.fl_base_height);

		this.updateHandle();

		if (this.fl_handle_height > 0 && this.fl_handle_height >= this.fl_height){
			this.fl_handle_height = this.fl_height;
			this.fl_bar.fl_handle.fl_handle_div.style.display = "none";
			this.fl_bar.accessible = false;
			this.fl_bar.fl_bar_div.style.cursor = "default";
		} else {
			this.fl_bar.fl_handle.fl_handle_div.style.display = "block";
			this.fl_bar.accessible = true;
			this.fl_bar.fl_bar_div.style.cursor = "move";
		}

		this.fl_base.fl_base_div.style.height = this.fl_base_height + "px";
	};


	function FlBase(parent_obj)
	{
		this.parent = parent_obj;

		this.x = 0;
		this.y = 0;
		this.width = parent_obj.width;
		this.height = parent_obj.height;

		// 要素
		this.fl_base_div = document.createElement("div");
		this.fl_base_div.id = "s14fl_base";

		// 配置
		this.parent.fls_div.appendChild(this.fl_base_div);

		// 画像逐次読み込み用スタック
		this.imgs = [];

		var that = this;

		$(this.fl_base_div).on("touchstart touchend mouseup", function(evt) {
			that.parent.fl_base_offset = -$(this).position().top;
			that.parent.updateHandle();
		});

		function LfScroll(){
			that.parent.fl_base_offset = -$(this).position().top;
			that.parent.updateHandle();
		}
	}
	FlBase.prototype.play = function(ul)
	{
	};
	FlBase.prototype.setItem = function(item, _loop)
	{
		this.imgs['n'+_loop] = ({"page":_loop+1,"y":0,"load":false});
	};
	FlBase.prototype.setItemData = function(_id,_loop,loaded)
	{
		this.imgs[_id] = ({"page":_loop+1,"y":0,"load":loaded});
	};
	function jimeLinkWork(tnum, tref){
		if (window.jimeref!=null){
			window.jimeref.forcedPage(tnum);
			jimeHighlight(tnum);
		}
	}
	function jimeHighlight(tnum){
		$("#s14fl li").removeClass("current");
		$("#s14fl li#n"+tnum).addClass("current");
		if (Util.existFunc(window.jime3SetItemLabel)) window.jime3SetItemLabel();
	}


	function FlBar(parent_obj)
	{
		this.parent = parent_obj;

		this.x = 0;
		this.y = 0;
		this.width = parent_obj.width;
		this.height = parent_obj.height;

		this.fl_bar_div = document.createElement("div");
		this.fl_bar_div.id = "s14fl_bar";

		this.parent.fl_div.appendChild(this.fl_bar_div);

		this.fl_handle = new FlHandle(this);
		this.fl_first = new FlButton(this, "top");
		this.fl_last = new FlButton(this, "bottom");

		this.accessible = false;

		var click = false;
		var intouch = false;
		var touchy = 0;

		var that = this;

		$(this.fl_bar_div).on("mousedown",function(evt){
			evt.stopPropagation(); evt.preventDefault();
			intouch = false;
			that.fl_handle.intouch = false;
			if (that.accessible) { click = true; }
		}).on("mousemove",function(evt){
			evt.stopPropagation(); evt.preventDefault();
			if (that.fl_handle.drag){
				that.parent.moveScroll(evt.clientY - that.parent.offy);
			}
		}).on("mouseup",function(evt){
			evt.stopPropagation(); evt.preventDefault();
			if (click){
				that.parent.relativeScroll(evt.clientY - that.parent.offy);
			}
			click = false;
			that.fl_handle.drag = false;
			$("#s14fl_handle").css({"opacity": "0.7"});
		}).on("mouseleave",function(evt){
			click = false;
			that.fl_handle.drag = false;
			$("#s14fl_handle").css({"opacity": "0.7"});
		});
		$(this.fl_bar_div).on("touchstart", function(evt){
			evt.stopPropagation(); evt.preventDefault();
			click = false;
			that.fl_handle.drag = false;
			touchy = evt.originalEvent.touches[0].clientY - that.parent.offy;
			if (that.accessible){ intouch = true; }
		}).on("touchend", function(evt){
			evt.stopPropagation(); evt.preventDefault();
			if (intouch){ that.parent.relativeScroll(touchy); }
			intouch = false;
			that.fl_handle.intouch = false;
			$("#s14fl_handle").css({"opacity": "0.7"});
		});
	}

	function FlHandle(parent_obj)
	{
		this.parent = parent_obj;

		this.x = 0;
		this.y = 0;
		this.width = this.parent.width;
		this.height = this.parent.height;

		this.fl_handle_div = document.createElement("div");
		this.fl_handle_div.id = "s14fl_handle";

		this.parent.fl_bar_div.appendChild(this.fl_handle_div);

		this.drag = false;
		this.intouch = false;

		var that = this;

		$(this.fl_handle_div).on("mouseover", function(evt){
			$(this).css({"opacity": "1"});
		}).on("mousedown",function(evt){
			evt.stopPropagation(); evt.preventDefault();
			that.intouch = false;
			if (that.parent.accessible) {
				that.drag = true;
				$(this).css({"opacity": "1"});
			}
		}).on("mousemove",function(evt){
			evt.stopPropagation(); evt.preventDefault();
			if (that.drag){
				$(this).css("top", evt.clientY + "px");
				that.parent.parent.moveScroll(evt.clientY - that.parent.parent.offy);
			}
		}).on("mouseup",function(evt){
			evt.stopPropagation(); evt.preventDefault();
			that.drag = false;
			that.parent.parent.updateLoad();
			$(this).css({"opacity": "0.7"});
		});
		$(this.fl_handle_div).on("touchstart", function(evt){
			evt.stopPropagation(); evt.preventDefault();
			that.drag = false;
			if (that.parent.accessible){
				that.intouch = true;
				$(this).css({"opacity": "1"});
			}
		}).on("touchmove", function(evt){
			evt.stopPropagation(); evt.preventDefault();
			if (that.intouch){
				$(this).css("top", evt.originalEvent.touches[0].clientY + "px");
				that.parent.parent.moveScroll(evt.originalEvent.touches[0].clientY - that.parent.parent.offy);
			}
		}).on("touchend", function(evt){
			evt.stopPropagation(); evt.preventDefault();
			that.intouch = false;
			that.parent.parent.updateLoad();
			$(this).css({"opacity": "0.7"});
		});
	}

	function FlButton(parent_obj, position)
	{
		this.parent = parent_obj;

		this.x = 0;
		this.y = 0;
		if (position == "top") this.y = this.parent.parent.height - 36;
		this.width = this.parent.width;
		this.height = 36;

		this.position = position;	// 配置位置（移動方向）

		this.fl_button_div = document.createElement("div");
		this.fl_button_div.className = "s14c_bt";
		if (position == "top") { this.fl_button_div.id = "s14fl_first"; }
		else { this.fl_button_div.id = "s14fl_last"; }

		this.parent.fl_bar_div.appendChild(this.fl_button_div);

		var that = this;

		$(this.fl_button_div).on("mouseover", function(evt){
			$(this).css({"opacity": "1"});
		}).on("mouseout", function(evt){
			$(this).css({"opacity": "0.7"});
		}).on("mousedown touchstart",function(evt){
			evt.stopPropagation(); evt.preventDefault();
			if (that.parent.accessible) {
				$(this).css({"opacity": "1"});
			}
		}).on("mouseup touchend",function(evt){
			evt.stopPropagation(); evt.preventDefault();
			if (that.parent.accessible) {
				if (that.position == "top") { that.parent.parent.moveScroll(0); }
				else { that.parent.parent.moveScroll(-9999); }
				that.parent.parent.updateLoad();
			}
			$(this).css({"opacity": "0.7"});
		});
	}


	Util.extend(Indexer, {

		mr_previewSupport: true,

		create: function (parent_obj) {
			return new AnnoteFl(parent_obj);
		},

		setExpandAttrs: function (node, attrs){}

	});

}(window, window.jQuery, IPALLETORG.Shimakuma.Indexer, IPALLETORG.Util));


(function(window, $, Stack, ShimakumaViewer, Indexer, Util){

// 基本位置座標クラス（Minimum）
function LmPoint (tx, ty) { this.x = tx; this.y = ty; }
function LmRectangle (tx, ty, tw, th) { this.x = tx; this.y = ty; this.width = tw; this.height = th; }
// 2-D回転クラス（Minimum）
function LmMatrix () {
	this.mat = [[1,0],[0,1]];
	this.inv_mat = [[1,0],[0,1]];
}
LmMatrix.prototype.setRotate = function(rot) {
	var sin = Math.sin(rot * Math.PI / 180.0); var cos = Math.cos(rot * Math.PI / 180.0);
	if (Math.abs(sin) < 0.0000001) sin = 0; if (Math.abs(cos) < 0.0000001) cos = 0;
	this.mat[0][0] = cos; this.mat[0][1] = sin; this.mat[1][0] = -sin; this.mat[1][1] = cos;
	this.inv_mat[0][0] = cos; this.inv_mat[0][1] = -sin; this.inv_mat[1][0] = sin; this.inv_mat[1][1] = cos;
};
LmMatrix.prototype.setDefaultMatrix = function() {
	this.setRotate(0);
};

// 座標系クラス（Minimum）
function Coordinate () {
	this.bw = 256; this.bh = 256;				// ベース・サイズ W=256, H=256
	this.tilw = 512; this.tilh = 512;		// タイル・サイズ W=512, H=512

	this.W = 2 * this.bw; this.H = 2 * this.bh;		// コンポーネント・サイズ（初期値）
	this.w = this.W; this.h = this.H;						// コンポーネント・サイズ

	this.PX = this.bw; this.PY = this.bh;			// 表示系センター座標（初期値）
	this.px = this.PX; this.py = this.PY;					// 表示系センター座標

	this.WID = this.tilw; this.HEI = this.tilh;		// 画像サイズ（初期値）
	this.wid = this.WID; this.hei = this.HEI;						// 画像サイズ

	this.VPX = this.bw; this.VPY = this.bh;			// 仮想系センター座標（初期値）
	this.vpx = this.VPX; this.vpy = this.VPY;				// 仮想系センター座標

	this.RD = 1.0;										// 仮想系単位幅（仮想系／表示系、初期値）
	this.rd = 1.0;										// 仮想系単位幅（仮想系／表示系）定比

	this.vc1x = 0; this.vc1y = 0;							// 仮想系フレーム値（左上、コンポーネント左上原点対応）
	this.vc2x = 0; this.vc2y = 0;							// 仮想系フレーム値（右下、コンポーネント右下対応）

	this.Xo = 0; this.Yo = 0;								// 絶対基準座標系に対するシフト

	this.ROTATE = 0;									// 仮想系回転初期値
	this.rotate = this.ROTATE;
	this.m = new LmMatrix();
}
Coordinate.prototype.setDefaultInit = function() {
	this.setInit(this.W, this.H, this.WID, this.HEI, this.RD, this.RD, this.VPX, this.VPY, this.ROTATE);
};
Coordinate.prototype.setInit = function(tw, th, im_wid, im_hei, r, r_, center_vx, center_vy, rot) {
	this.W = tw; this.H = th;							// 表示サイズ保存値
	this.w = this.W; this.h = this.H;
	this.px = this.W / 2; this.py = this.H / 2;			// 表示サイズ中心

	this.WID = im_wid; this.HEI = im_hei;			// 画像サイズ（仮想系）保存値
	this.wid = this.WID; this.hei = this.HEI;			// 画像サイズ（仮想系）実用値

	this.RD = r;										// 仮想系/参照系の比率、保存値
	this.rd = this.RD;								// 仮想系/参照系の比率、実用値

	this.VPX = center_vx; this.VPY = center_vy;					// 参照系の中心と対応する仮想系座標値、保存値
	this.vpx = this.VPX + this.Xo; this.vpy = this.VPY + this.Yo;		// 参照系の中心と対応する仮想系座標値、実行値

	this.m.setDefaultMatrix(); this.updateRotate(rot); this.ROTATE = this.rotate;
	this.updateCorners();
};
Coordinate.prototype.updateComponentSize = function(tw, th) {
	this.W = tw; this.H = th; this.w = this.W; this.h = this.H;
	this.px = Math.floor(this.W / 2); this.py = Math.floor(this.H / 2);
};
Coordinate.prototype.updateImageSize = function(tw, th) {
	this.WID = tw; this.HEI = th; this.wid = this.WID; this.hei = this.HEI;
	this.VPX = Math.floor(this.wid / 2); this.VPY = Math.floor(this.hei / 2); this.vpx = this.VPX; this.vpy = this.VPY;
};
Coordinate.prototype.getCorner = function(c) {
	// コーナーの仮想系座標を得る．コーナー指定コードは電卓配列．'7'、'3'、'5'(デフォルト、中央）のみ．
	var mul = 1; if (typeof arguments[1] !== "undefined") mul = arguments[1];
	var value1 = this.vpx; var value2 = this.vpy;
	switch (c){
		case '7':
		value1 = this.vpx - mul * (this.rd * this.m.mat[0][0] * this.px + this.rd * this.m.mat[0][1] * this.py);
		value2 = this.vpy - mul * (this.rd * this.m.mat[1][0] * this.px + this.rd * this.m.mat[1][1] * this.py);
		break;
		case '9':
		value1 = this.vpx + mul * (this.rd * this.m.mat[0][0] * this.px - this.rd * this.m.mat[0][1] * this.py);
		value2 = this.vpy + mul * (this.rd * this.m.mat[1][0] * this.px - this.rd * this.m.mat[1][1] * this.py);
		break;
		case '3':
		value1 = this.vpx + mul * (this.rd * this.m.mat[0][0] * this.px + this.rd * this.m.mat[0][1] * this.py);
		value2 = this.vpy + mul * (this.rd * this.m.mat[1][0] * this.px + this.rd * this.m.mat[1][1] * this.py);
		break;
		case '1':
		value1 = this.vpx - mul * (this.rd * this.m.mat[0][0] * this.px - this.rd * this.m.mat[0][1] * this.py);
		value2 = this.vpy - mul * (this.rd * this.m.mat[1][0] * this.px - this.rd * this.m.mat[1][1] * this.py);
		break;
		default:
		break;
	}
	return new LmPoint(value1, value2);
};
Coordinate.prototype.getCorners = function() {
	// コーナーの仮想系範囲を得る.
	var mul = 1; if (typeof arguments[0] !== "undefined") mul = arguments[0];
	var p1 = this.getCorner('7', mul); var p2 = this.getCorner('9', mul); var p3 = this.getCorner('3', mul); var p4 = this.getCorner('1', mul);
	var rect = new LmRectangle(p1.x, p2.y, p3.x - p1.x, p4.y - p2.y);
	if (this.rotate < 90){ }
	else if (this.rotate < 180){ rect = new LmRectangle(p2.x, p3.y, p4.x - p2.x, p1.y - p3.y); }
	else if (this.rotate < 270){ rect = new LmRectangle(p3.x, p4.y, p1.x - p3.x, p2.y - p4.y); }
	else if (this.rotate < 360){ rect = new LmRectangle(p4.x, p1.y, p2.x - p4.x, p3.y - p1.y); }
	return rect;
};
Coordinate.prototype.getCornerX = function(c) {
	// コーナーのX座標（仮想系）、Y座標（仮想系）を得る．
	var value = this.vpx;
	switch (c){
		case '7':
		value = this.vpx - (this.rd * this.m.mat[0][0] * this.px + this.rd * this.m.mat[0][1] * this.py);
		break;
		case '9':
		value = this.vpx + (this.rd * this.m.mat[0][0] * this.px - this.rd * this.m.mat[0][1] * this.py);
		break;
		case '3':
		value = this.vpx + (this.rd * this.m.mat[0][0] * this.px + this.rd * this.m.mat[0][1] * this.py);
		break;
		case '1':
		value = this.vpx - (this.rd * this.m.mat[0][0] * this.px - this.rd * this.m.mat[0][1] * this.py);
		break;
		default:
		break;
	}
	return value;
};
Coordinate.prototype.getCornerY = function(c) {
	var value = this.vpy;
	switch (c){
		case '7':
		value = this.vpy - (this.rd * this.m.mat[1][0] * this.px + this.rd * this.m.mat[1][1] * this.py);
		break;
		case '9':
		value = this.vpy + (this.rd * this.m.mat[1][0] * this.px - this.rd * this.m.mat[1][1] * this.py);
		break;
		case '3':
		value = this.vpy + (this.rd * this.m.mat[1][0] * this.px + this.rd * this.m.mat[1][1] * this.py);
		break;
		case '1':
		value = this.vpy - (this.rd * this.m.mat[1][0] * this.px - this.rd * this.m.mat[1][1] * this.py);
		break;
		default:
		break;
	}
	return value;
};
// 参照座標に対応する仮想座標を得る．
Coordinate.prototype.getD2V = function(tx, ty) {
	var vx = this.rd * this.m.mat[0][0] * (tx - this.px) + this.rd * this.m.mat[0][1] * (ty - this.py) + this.vpx;
	var vy = this.rd * this.m.mat[1][0] * (tx - this.px) + this.rd * this.m.mat[1][1] * (ty - this.py) + this.vpy;
	return new LmPoint(vx, vy);
};
// 参照座標範囲に対応する仮想座標範囲を得る．
Coordinate.prototype.getD2VR = function(tx, ty, tw, th) {
	var vx = this.rd * this.m.mat[0][0] * (tx - this.px) + this.rd * this.m.mat[0][1] * (ty - this.py) + this.vpx;
	var vy = this.rd * this.m.mat[1][0] * (tx - this.px) + this.rd * this.m.mat[1][1] * (ty - this.py) + this.vpy;
	var vw = this.m.mat[0][0] * this.rd * tw  + this.m.mat[0][1] * this.rd * th;
	var vh = this.m.mat[1][0] * this.rd * tw  + this.m.mat[1][1] * this.rd * th;
	return new LmRectangle(vx, vy, vw, vh);
};
// 仮想座標から参照座標を得る．
Coordinate.prototype.getV2D = function(vx, vy) {
	var x = (this.m.inv_mat[0][0] * (vx - this.vpx) + this.m.inv_mat[0][1] * (vy - this.vpy))/this.rd + this.px;
	var y = (this.m.inv_mat[1][0] * (vx - this.vpx) + this.m.inv_mat[1][1] * (vy - this.vpy))/this.rd + this.py;
	return new LmPoint(x, y);
};
// 仮想座標範囲から参照座標範囲を得る．
Coordinate.prototype.getV2DR = function(vx, vy, vw, vh) {
	var x = (this.m.inv_mat[0][0] * (vx - this.vpx) + this.m.inv_mat[0][1] * (vy - this.vpy))/this.rd + this.px;
	var y = (this.m.inv_mat[1][0] * (vx - this.vpx) + this.m.inv_mat[1][1] * (vy - this.vpy))/this.rd + this.py;
	var w = (this.m.inv_mat[0][0] * vw + this.m.inv_mat[0][1] * vh)/this.rd;
	var h = (this.m.inv_mat[1][0] * vw + this.m.inv_mat[1][1] * vh)/this.rd;
	return new LmRectangle(x, y, w, h);
};
// コーナー座標（仮想系）更新．
Coordinate.prototype.updateCorners = function() { this.vc1x = this.getCornerX('7'); this.vc1y = this.getCornerY('7'); this.vc2x = this.getCornerX('3'); this.vc2y = this.getCornerY('3'); };
// ズームレイヤ更新．
Coordinate.prototype.updateAbsR = function(r) { var rd_old = this.rd; this.rd = r; this.wid = this.wid * rd_old / this.rd; this.hei = this.hei * rd_old / this.rd; };
// 仮想系センター座標の更新．
Coordinate.prototype.updateVCenter = function(vx, vy) { this.vpx = vx; this.vpy = vy; };
// 回転値更新
Coordinate.prototype.updateRotate = function(degree) { this.rotate = degree % 360; this.m.setRotate(degree); };


// マルチポインタ
function M () {
	if (typeof arguments[0] !== "undefined"){
		this.parent = arguments[0];
		this.relative = true;
	}
	else {
		this.parent = null;
		this.relative = false;
	}
	if (typeof arguments[1] === "boolean") this.relative = arguments[1];

	this.o;
	this.p;
	this.count = -1;
	this.startset;	// タッチ時
	this.set;		// 移動時
	this.d = 0;

	this.init();

	this.drg = false; this.indrg = false;
	this.dbl = false; this.indbl = false; this.near;
}
M.prototype.isMoved = function(){ return this.indrg; };
M.prototype.isDoubleTap = function(){ return this.indbl; };
M.prototype.init = function(evt){
	for (var k in this.o) { this.o[k] = null; delete this.o[k]; } this.o = null; this.o = new Object();
	for (var k in this.p) { this.p[k] = null; delete this.p[k]; } this.p = null; this.p = new Object();
	this.startset = {x: 0, y: 0, dx: 0, dy: 0};
	this.set = {x: 0, y: 0, dx: 0, dy: 0};
	this.count = 0;
	this.d = 0;
};
M.prototype.add = function(evt){
	switch (evt.type) {
		case "pointerdown":
		case "MSPointerDown":
			if (evt.originalEvent.pointerId){
				if (typeof this.o[evt.originalEvent.pointerId] === "undefined") {
					this.p[evt.originalEvent.pointerId] = [evt.originalEvent.pageX, evt.originalEvent.pageY];
					this.o[evt.originalEvent.pointerId] = [evt.originalEvent.pageX, evt.originalEvent.pageY];
					this.count = Object.keys(this.o).length;
					if (this.count <= 2) this.setStart();
					if (this.count < 2) {
						if (this.dbl && this.isNear()) { this.indbl = true; }
						else { var that = this; window.setTimeout(function(){ that.dbl = false; }, 500); this.dbl = true; this.setNear(); }
					}
				}
			}
			break;
		case "touchstart":
			if ("touches" in evt.originalEvent) {
				this.count = evt.originalEvent.touches.length;
				for (var i=0; i<this.count; i++) {
					this.p["p"+i] = [evt.originalEvent.touches[i].pageX, evt.originalEvent.touches[i].pageY];
					if (typeof this.o["p"+i] === "undefined") this.o["p"+i] = [evt.originalEvent.touches[i].pageX, evt.originalEvent.touches[i].pageY];
				}

				if (this.count <= 2) this.setStart();
				if (this.count < 2) {
					if (this.dbl && this.isNear()) { this.indbl = true; }
					else { var that = this; window.setTimeout(function(){ that.dbl = false; }, 500); this.dbl = true; this.setNear(); }
				}
			}
			break;
		case "mousedown":
			this.count = 0;
			this.p["p0"] = [evt.pageX, evt.pageY];
			if (typeof this.o["p0"] === "undefined") this.o["p0"] = [evt.pageX, evt.pageY];
			if (evt.ctrlKey) { this.count = 2; }
			if (this.count <= 2) this.setStart();
			if (this.count < 2) {
				if (this.dbl && this.isNear()) { this.indbl = true; }
				else { var that = this; window.setTimeout(function(){ that.dbl = false; }, 500); this.dbl = true; this.setNear(); }
			}
			break;
	}
	this.drg = true;
};
M.prototype.update = function(evt){
	switch (evt.type) {
		case "pointermove":
		case "MSPointerMove":
			if (evt.originalEvent.pointerId){
				this.p[evt.originalEvent.pointerId] = [evt.originalEvent.pageX, evt.originalEvent.pageY];
			}
			break;
		case "touchmove":
			if ("touches" in evt.originalEvent) {
				for (var i=0; i<this.count; i++) {
					this.p["p"+i] = [evt.originalEvent.touches[i].pageX, evt.originalEvent.touches[i].pageY];
				}
			}
			break;
		case "mousemove":
			this.p["p0"] = [evt.pageX, evt.pageY];
			break;
	}
	this.setCurrent();
};
M.prototype.remove = function(evt){
	if (this.indrg && Math.abs(this.set.x - this.startset.x)+Math.abs(this.set.y - this.startset.y) > 8){
		var that = this; window.setTimeout(function(){ that.indrg = false; }, 50);
	}
	else { this.indrg = false; }
	this.drg = false;

	switch (evt.type) {
		case "pointerup":
		case "MSPointerUp":
			if (this.count < 2) {
				if (this.indbl) { var that = this; window.setTimeout(function(){ that.indbl = false; }, 200); }
			}
			if (evt.originalEvent.pointerId){
				this.o[evt.originalEvent.pointerId] = null; delete this.o[evt.originalEvent.pointerId];
				this.p[evt.originalEvent.pointerId] = null; delete this.p[evt.originalEvent.pointerId];
			}
			this.count = Util.countObj(this.o);
			if (this.count < 1) this.init();
			else if (this.count < 2) this.setStartInit();
			break;
		case "touchend":
			if (this.count < 2) {
				if (this.indbl) { var that = this; window.setTimeout(function(){ that.indbl = false; }, 200); }
			}
			this.init();
			break;
		case "mouseup":
			if (this.indbl) { var that = this; window.setTimeout(function(){ that.indbl = false; }, 200); }
			this.init();
			break;
	}
};
M.prototype.garbage = function(){
	if (this.indrg && Math.abs(this.set.x - this.startset.x)+Math.abs(this.set.y - this.startset.y) > 8){
		var that = this; window.setTimeout(function(){ that.indrg = false; }, 50);
		this.init();
	}
	else { this.indrg = false; }
	this.drg = false;
};
M.prototype.setStartInit = function() {
	var _x = 0; var _y = 0;
	var _off = [0, 0]; if (this.relative) { var off = $(this.parent).offset(); _off = [off.left, off.top]; }
	for (var ky in this.o){ _x = this.o[ky][0]; _y = this.o[ky][1]; }
	this.startset = {x: _x-_off[0], y: _y-_off[1], dx: 0, dy: 0};
};
M.prototype.setNear = function() {
	this.near = [];
	this.near.push([this.startset.x, this.startset.y]);
};
M.prototype.isNear = function() {
	var v = this.near.pop();
	this.near.push([this.startset.x, this.startset.y]);
	return (Math.abs(v[0] - this.startset.x)+Math.abs(v[1] - this.startset.y) < 16);
};
M.prototype.changeTemp = function() {
	this.temp = [this.startset.x, this.startset.y];
};
M.prototype.setStart = function() {
	var _x = 0; var _y = 0; var _dx = 0; var _dy = 0; var _c = 1;
	var _off = [0, 0]; if (this.relative) { var off = $(this.parent).offset(); _off = [off.left, off.top]; }
	if (Util.countObj(this.o)>1){
		for (var ky in this.o){
			_x = _x + this.o[ky][0]; _y = _y + this.o[ky][1];
			if (_c<2) {_dx = this.o[ky][0]; _dy = this.o[ky][1]; } else { _dx -= this.o[ky][0]; _dy -= this.o[ky][1]; }
			_c++; if (_c>2) break;
		}
		this.startset = {x: Math.round(_x/2-_off[0]), y: Math.round(_y/2-_off[1]), dx: Math.abs(_dx), dy: Math.abs(_dy)};
	}
	else {
		for (var ky in this.o){
			this.startset = {x: Math.round(this.o[ky][0]-_off[0]), y: Math.round(this.o[ky][1]-_off[1]), dx: 0, dy: 0};
		}
	}
	this.d = 0;
};
M.prototype.setCurrent = function() {
	var _x = 0; var _y = 0; var _dx = 0; var _dy = 0; var _c = 1;
	var _off = [0, 0]; if (this.relative) { var off = $(this.parent).offset(); _off = [off.left, off.top]; }
	if (Util.countObj(this.p)>1){
		for (var ky in this.p){
			_x = _x + this.p[ky][0]; _y = _y + this.p[ky][1];
			if (_c<2) {_dx = this.p[ky][0]; _dy = this.p[ky][1]; } else { _dx -= this.p[ky][0]; _dy -= this.p[ky][1]; }
			_c++; if (_c>2) break;
		}
		this.set = {x: Math.round(_x/2-_off[0]), y: Math.round(_y/2-_off[1]), dx: Math.abs(_dx), dy: Math.abs(_dy)};
		this.indrg = false;
	}
	else {
		if (this.count==2){	// ctrl+mouse
			for (var ky in this.p){
				_dx = this.p[ky][0] - this.o[ky][0]; _dy = this.p[ky][1] - this.o[ky][1];
				this.set = {x: Math.round(this.o[ky][0]-_off[0]), y: Math.round(this.o[ky][1]-_off[1]), dx: _dx , dy: _dy};
			}
			this.indrg = false;
		}
		else {
			for (var ky in this.p){
				this.set = {x: Math.round(this.p[ky][0]-_off[0]), y: Math.round(this.p[ky][1]-_off[1]), dx: 0, dy: 0};
			}
			this.indrg = true;
		}
	}
	this.d = (this.set.dx - this.startset.dx);
};


// 簡易版画像配列の管理クラス
function Tile (image_width, image_height, tile_size_width, tile_size_height, target_layer, work_numx, work_numy, tid, tpattern, tsuffix, toverlap, tedge) {
	this.id = tid;						// ID
	this.layer = target_layer; this.scl = Math.floor(Math.pow(2, target_layer));		// レイヤー解像度（整数化（切捨て適用））
	this.xi = work_numx; this.yi = work_numy;									// 画像インデックス
	this.wtilew = tile_size_width; this.wtileh = tile_size_height;						// 表示系 タイルサイズ
	(work_numx == 0) ? this.wx = 0 : this.wx = work_numx * tile_size_width - toverlap;	//  表示系（ワーク）座標
	(work_numy == 0) ? this.wy = 0 : this.wy = work_numy * tile_size_height - toverlap;
	(work_numx == 0 || tedge) ? this.ww = tile_size_width + toverlap : this.ww = tile_size_width + 2 * toverlap;
	(work_numy == 0 || tedge) ? this.wh = tile_size_height + toverlap : this.wh = tile_size_height + 2 * toverlap;

	this.otilew = tile_size_width * this.scl; this.otileh = tile_size_height * this.scl;	// 仮想系タイルサイズ
	(work_numx == 0) ? this.ox = this.otilew * work_numx : this.ox = this.otilew * work_numx - toverlap;	// 仮想座標系
	(work_numy == 0) ? this.oy = this.otileh * work_numy : this.oy = this.otileh * work_numy - toverlap;
	(work_numx == 0 || tedge) ? this.ow = tile_size_width * this.scl + toverlap : this.ow = tile_size_width * this.scl + 2 * toverlap;
	(work_numy == 0 || tedge) ? this.oh = tile_size_height * this.scl + toverlap : this.oh = tile_size_height * this.scl + 2 * toverlap;
	this.pattern = tpattern; this.suffix = tsuffix;										// 分割画像拡張
	// 境界処理
	this.nwx = (work_numx + 1) * tile_size_width + toverlap;	// 隣接座標
	this.nwy = (work_numy + 1) * tile_size_height + toverlap;
	if (image_width - this.ox - this.ow < 0){
		this.ow = image_width - this.ox;
		this.ww = Math.ceil(this.ow / this.scl);
		this.nwx = this.wx + this.ww;
	}
	if (image_height - this.oy - this.oh < 0){
		this.oh = image_height - this.oy;
		this.wh = Math.ceil(this.oh / this.scl);
		this.nwy = this.wy + this.wh;
	}

	this.xwork = function(tscale){ if (tscale == null){ return this.wx; } else { return this.wx * tscale; } };
	this.ywork = function(tscale){ if (tscale == null){ return this.wy; } else { return this.wy * tscale; } };
	this.wwork = function(tscale){ if (tscale == null){ return this.ww; } else { return this.ww * tscale; } };
	this.hwork = function(tscale){ if (tscale == null){ return this.wh; } else { return this.wh * tscale; } };
	this.nxwork = function(tscale){ if (tscale == null){ return this.nwx; } else { return this.nwx * tscale; } };
	this.nywork = function(tscale){ if (tscale == null){ return this.nwy; } else { return this.nwy * tscale; } };
	this.xindex = function(){ return this.xi; };
	this.yindex = function(){ return this.yi; };
}
// FzP 1.0〜1.2,1.3
Tile.prototype.getPlainCode = function(c, nstr) { var s = nstr + c.toString(); return s.substr(s.length - nstr.length, nstr.length); };
Tile.prototype.getCode = function(c, nstr) { var s = nstr + c.toString(10); return s.substr(s.length - nstr.length, nstr.length); };
Tile.prototype.getImageName = function(nstr) { return this.getCode(this.ox, nstr) + this.getCode(this.oy, nstr) + this.getCode(this.ow, nstr) + this.getCode(this.oh, nstr); };
Tile.prototype.getTileName = function(lstr, nstr) { return this.getPlainCode(this.layer, lstr) + "_" + this.getDefaultImageName(); };
Tile.prototype.getImageUrl = function(tbase, lstr, nstr) { return tbase + this.getPlainCode(this.layer, lstr) + "/" + this.getImageName(nstr) + this.suffix; };
// FzP 0.9
Tile.prototype.getDefaultCode = function(c) { var s = this.pattern + c.toString(10); return s.substring(s.length - 5); };
Tile.prototype.getDefaultImageName = function() { return this.getDefaultCode(this.ox) + this.getDefaultCode(this.oy) + this.getDefaultCode(this.ow) + this.getDefaultCode(this.oh); };
Tile.prototype.getDefaultTileName = function() { return this.layer + "_" + this.getDefaultImageName(); };
Tile.prototype.getDefaultImageUrl = function(tbase) { return tbase + this.layer + "/" + this.getDefaultImageName() + this.suffix; };
// FzP 3.0+, Zoomify, DeepZoom
Tile.prototype.getExtendImageUrl = function(tbase){ return tbase + this.pattern[0] + "/" + this.pattern[1] + this.suffix; };
// IIIF
Tile.prototype.getImageRange = function() { return  this.ox + "," + this.oy + "," + this.ow + "," + this.oh + "/" + this.ww + "," + this.wh; };
Tile.prototype.getImageRangeList = function() { return  [this.ox,this.oy,this.ow,this.oh,this.ww,this.wh]; };
Tile.prototype.getImageRangeUrl = function(tbase){ return tbase + this.getImageRange() + "/0/default" + this.suffix; };

// タイル管理クラス
function TileManager (tw, th, ttw, tth, tresmin, tresmax, tservice, tpattern, tsuffix, toverlap) {
	this.image_w = tw; this.image_h = th;		// 画像サイズ
	this.tile_w = ttw; this.tile_h = tth;		// タイルサイズ
	this.view = [];
	this.service = tservice;
	this.pattern = tpattern;
	this.suffix = tsuffix; this.overlap = toverlap;
	this.patterns = null;
	if (tservice == "FZP3") this.patterns = new TileFzp3Pattern(tw,th,ttw,tth);
	else if (tservice == "ZOOMIFY") this.patterns = new TileZoomifyPattern(tw,th,ttw,tth);
	else if (tservice == "DZ") this.patterns = new TileDZPattern(tw,th,ttw,tth);
}
TileManager.prototype.getIndexRect = function(tres, trect) {
	var pow = Math.pow(2, tres);
	var tempw = Math.floor(pow * this.tile_w); var temph = Math.floor(pow * this.tile_h);
	var tilex; var tiley;
	var tilexmx; var tileymx;
	if (trect.x < 0){ tilex = 0; } else { tilex = Math.floor(trect.x / tempw); }
	if (trect.y < 0){ tiley = 0; } else { tiley = Math.floor(trect.y / temph); }
	if ((trect.x + trect.width) >= this.image_w){ tilexmx = Math.ceil(this.image_w / tempw); } else { tilexmx = Math.ceil((trect.x + trect.width) / tempw); }
	if ((trect.y + trect.height) >= this.image_h){ tileymx = Math.ceil(this.image_h / temph); } else { tileymx = Math.ceil((trect.y + trect.height) / temph); }
	return [tilex, tiley, tilexmx, tileymx, Math.floor((tilex + tilexmx) / 2), Math.floor((tiley + tileymx) / 2), pow];
};
TileManager.prototype.getTiles = function(tres, trect) {
	this.view = this.getIndexRect(tres, trect);
	var tiles = [];
	for (var iy = this.view[1]; iy < this.view[3]; iy++){ for (var ix = this.view[0]; ix < this.view[2]; ix++){
		var tileid = Math.abs((ix - this.view[4]) * (iy - this.view[5]));
		if (tileid > -1){
			if (this.service == "DZ" || this.service == "FZP3"){
				var name_pattern = this.patterns.getTilePath(tres,ix,iy);
				if (this.overlap == 0) { tiles.push([tileid, new Tile(this.image_w, this.image_h, this.tile_w, this.tile_h, tres, ix, iy, tileid, name_pattern, this.suffix, 0, false)]); }
				else { tiles.push([tileid, new Tile(this.image_w, this.image_h, this.tile_w, this.tile_h, tres, ix, iy, tileid, name_pattern, this.suffix, this.overlap, (this.view[2] - ix > 1 && this.view[2] - ix >= 1))]); }
			}
			else if (this.service == "ZOOMIFY" ){
				var name_pattern = this.patterns.getTilePath(tres,ix,iy);
				tiles.push([tileid, new Tile(this.image_w, this.image_h, this.tile_w, this.tile_h, tres, ix, iy, tileid, name_pattern, this.suffix, 0, false)]);
			}
			else {
				// Other FzP, IIIF
				tiles.push([tileid, new Tile(this.image_w, this.image_h, this.tile_w, this.tile_h, tres, ix, iy, tileid, this.pattern, this.suffix, 0, false)]);
			}
		}
	}}
	tiles.sort(function(a, b){ return a[0] - b[0];});
	return tiles;
};
TileManager.prototype.viewrect = function() {
	return this.view;
};
TileManager.prototype.getTileInfo = function(tres, ix, iy) {
	var temp = new Tile(this.image_w, this.image_h, this.tile_w, this.tile_h, tres, ix, iy, '0', this.pattern, this.suffix, 0, false);
	return temp.getImageRange();
};
TileManager.prototype.getTileInfoList = function(tres, ix, iy) {
	var temp = new Tile(this.image_w, this.image_h, this.tile_w, this.tile_h, tres, ix, iy, '0', this.pattern, this.suffix, 0, false);
	return temp.getImageRangeList();
};

// タイルパターン
function TileZoomifyPattern (tw, th, ttw, tth) {
	// Image size
	this.image_w = tw;
	this.image_h = th;
	this.tile_w = ttw;
	this.tile_h = tth;
	this.group_size = 256;
	this.res_min = 0;
	this.res_max = Math.ceil(Math.log(Math.max(tw,th)/ttw)*Math.LOG2E);

	this.res_array = new Array(this.res_max);
	var count = 0;
	for (var i = this.res_min; i <= this.res_max; i++){
		var obj = {};
		var mul = Math.pow(2, this.res_max - i);
		obj["ix"] = Math.ceil(this.image_w / (this.tile_w * mul));
		obj["iy"] = Math.ceil(this.image_h / (this.tile_h * mul));
		obj["qw"] = Math.ceil(this.image_w / mul) % this.tile_w;
		obj["qh"] = Math.ceil(this.image_h / mul) % this.tile_h;
		count+=obj["ix"]*obj["iy"];
		obj["num"] = count;
		this.res_array[i] = obj;
	}
}
TileZoomifyPattern.prototype.getTilePath = function(tres, ix, iy)
{
	var res = this.res_max - tres;
	var obj = this.res_array[res];
	if (res<1){
		return ["TileGroup0","0-0-0"];
	} else {
		var groupnum = Math.floor((this.res_array[res-1]["num"]+iy*obj["ix"]+ix)/this.group_size);
		return ["TileGroup"+groupnum, res+"-"+ix+ "-"+iy];
	}
};
function TileDZPattern(tw, th, ttw, tth) {
	// Image size
	this.image_w = tw;
	this.image_h = th;
	this.tile_w = ttw;
	this.tile_h = tth;

	var res_offset = 0;
	if (ttw == 128) res_offset = 7;
	else if (ttw >= 512) res_offset = 9;
	else res_offset = 8;

	this.res_min = res_offset;
	this.res_max = res_offset + Math.ceil(Math.log(Math.max(tw,th)/ttw)*Math.LOG2E);

	this.res_array = new Array(this.res_max);
	var count = 0;
	for (var i = this.res_min; i <= this.res_max; i++){
		var obj = {};
		var mul = Math.pow(2, this.res_max - i);
		obj["ix"] = Math.ceil(this.image_w / (this.tile_w * mul));
		obj["iy"] = Math.ceil(this.image_h / (this.tile_h * mul));
		obj["qw"] = Math.ceil(this.image_w / mul) % this.tile_w;
		obj["qh"] = Math.ceil(this.image_h / mul) % this.tile_h;
		this.res_array[i] = obj;
	}
}
TileDZPattern.prototype.getTilePath = function(tres, ix, iy)
{
	var res = this.res_max - tres;
	var obj = this.res_array[res];
	if (res<this.res_min){
		return [this.res_min, "0_0"];
	} else {
		return [res, ix+"_"+iy];
	}
};
// FreezoomPack 3.0
function TileFzp3Pattern (tw, th, ttw, tth) {
	// Image size
	this.image_w = tw;
	this.image_h = th;
	this.tile_w = ttw;
	this.tile_h = tth;

	this.res_min = 0;
	this.res_max = Math.ceil(Math.log(Math.max(tw,th)/ttw)*Math.LOG2E);

	this.res_array = new Array(this.res_max);
	var count = 0;
	for (var i = this.res_min; i <= this.res_max; i++){
		var obj = {};
		var mul = Math.pow(2, i);
		obj["ix"] = Math.ceil(this.image_w / (this.tile_w * mul));
		obj["iy"] = Math.ceil(this.image_h / (this.tile_h * mul));
		obj["qw"] = Math.ceil(this.image_w / mul) % this.tile_w;
		obj["qh"] = Math.ceil(this.image_h / mul) % this.tile_h;
		this.res_array[i] = obj;
	}
}
TileFzp3Pattern.prototype.getTilePath = function(tres, ix, iy)
{
	var res = tres;
	var obj = this.res_array[res];
	if (res>=this.res_max){
		return [res,"0_0"];
	} else {
		return [res, ix+"_"+iy];
	}
};

// FzP, FzP3, IIIF, Zoomify, DeepZoom
function FreezoomPack ()
{
	this.image_src = null;
	this.image_x = 0; this.image_y = 0;
	this.image_w = 0; this.image_h = 0;
	this.image_res_min = 0; this.image_res_max = 0;
	this.image_tile_w = 0; this.image_tile_h = 0;
	this.image_div_base = 2;
	this.image_dpi = -1;
	this.image_code_pattern = "0/00000"; this.image_code_layer = "0"; this.image_code_name = "00000";
	this.image_service = "FZP"; this.image_suffix = ".jpg";
	this.image_overlap = 0;	// DeepZoom, FzP 3.0
	this.image_num = 0;	// Zoomify
	this.image_res_offset = 0;	// DeepZoom

	this.tiles_class = null;
}
FreezoomPack.prototype.prepare = function(obj) {	//IIIF
	var trtype = obj.resource_type.toLowerCase();
	if (trtype == "iiif"){
		this.image_x = 0; this.image_y = 0;
		this.image_w = obj.global_w; this.image_h = obj.global_h;
		this.image_tile_h = this.image_tile_w = obj.resource_tilesize;
		this.image_overlap = 0;
		this.image_res_min = 0;
		this.image_res_max = Math.ceil(Math.log(Math.max(this.image_w,this.image_h)/this.image_tile_w) * Math.LOG2E);
		if (obj.access_limiter < 0) this.image_res_min = this.image_res_max + obj.access_limiter;
		else if (obj.access_limiter > 0) this.image_res_min = obj.access_limiter;
		this.image_suffix = ".jpg";
		this.image_service = "IIIF";
		this.image_code_name = "0,0";
		this.tiles_class = new TileManager(this.image_w, this.image_h, this.image_tile_w, this.image_tile_h, this.image_res_min, this.image_res_max, this.image_service, this.image_code_name, this.image_suffix, this.image_overlap);
	}
	else if (trtype == "iiif-opossum"){
		this.image_x = 0; this.image_y = 0;
		this.image_w = obj.global_w; this.image_h = obj.global_h;
		this.image_tile_h = this.image_tile_w = obj.resource_tilesize;
		this.image_overlap = 0;
		this.image_res_min = 0;
		this.image_res_max = Math.ceil(Math.log(Math.max(this.image_w,this.image_h)/this.image_tile_w) * Math.LOG2E);
		if (obj.access_limiter < 0) this.image_res_min = this.image_res_max + obj.access_limiter;
		else if (obj.access_limiter > 0) this.image_res_min = obj.access_limiter;
		this.image_suffix = ".jpg";
		this.image_service = "IIIF-OPOSSUM";
		this.image_code_name = "0,0";
		this.tiles_class = new TileManager(this.image_w, this.image_h, this.image_tile_w, this.image_tile_h, this.image_res_min, this.image_res_max, this.image_service, this.image_code_name, this.image_suffix, this.image_overlap);
	}
};
FreezoomPack.prototype.load = function(request, resource_path, resource_name, resource_type) {
	var trtype = resource_type.toLowerCase();
	if (request == null || (trtype.indexOf("fzp") < 0 && trtype != "zoomify" && trtype != "dzi")){
		this.image_src = resource_path + resource_name;
		this.image_service = "PLAIN";
	}
	else {
		if (trtype == "zoomify"){
			if (this.readZoomifyXml(request)) {
				this.image_code_name = "0-0-0";
				this.tiles_class = new TileManager(this.image_w, this.image_h, this.image_tile_w, this.image_tile_h, this.image_res_min, this.image_res_max, this.image_service, this.image_code_name, this.image_suffix, this.image_overlap);
			} else {
				// 対応外
			}
		}
		else if (trtype == "dzi"){
			if (this.readDZXml(request, trtype)) {
				//this.checkDzDepth(resource_path + resource_name + "/" + resource_name + "_files/0/0_0");	// get depth
				this.image_code_name = "0_0";
				this.tiles_class = new TileManager(this.image_w, this.image_h, this.image_tile_w, this.image_tile_h, this.image_res_min, this.image_res_max, this.image_service, this.image_code_name, this.image_suffix, this.image_overlap);
			} else {
				// 対応外
			}
		} else {
			if (this.readFreezoomPackXml(request)) {
				this.tiles_class = new TileManager(this.image_w, this.image_h, this.image_tile_w, this.image_tile_h, this.image_res_min, this.image_res_max, this.image_service, this.image_code_name, this.image_suffix, this.image_overlap);
			} else {
				// 対応外
			}
		}
	}
};
FreezoomPack.prototype.getAttr = function(req, elem, attr, outv, otype){
	var _doms = req.getElementsByTagName(elem);
	if (_doms && typeof _doms[0] !== "undefined") {
		if (_doms[0].getAttribute(attr) && _doms[0].getAttribute(attr) != "") {
			if (otype == "int") { return parseInt(_doms[0].getAttribute(attr)); }
			else if (otype == "string") { return _doms[0].getAttribute(attr); }
		}
	}
	return outv;
};
FreezoomPack.prototype.readFreezoomPackXml = function(request){
	var version = this.getVersion(request);
	if (version >= 30) {
		this.image_overlap = this.getAttr(request, "resource", "overlap", this.image_overlap, "int");
	}
	if (version >= 11) {
		this.image_dpi = this.getAttr(request, "resource", "src", "dpi", this.image_dpi, "int");
		this.image_code_pattern = this.getAttr(request, "resource", "pattern", this.image_code_pattern, "string");
		this.setPattern(this.image_code_pattern);
		this.image_mime = this.getAttr(request, "resource", "mime", this.image_mime, "string");
		this.setImageSuffix(this.image_mime);
	}
	if (version >= 10) {
		this.image_src = this.getAttr(request, "resource", "src", this.image_src, "string");
		this.image_x = this.getAttr(request, "resource", "x", this.image_x, "int");
		this.image_y = this.getAttr(request, "resource", "y", this.image_y, "int");
		this.image_w = this.getAttr(request, "resource", "width", this.image_w, "int");
		this.image_h = this.getAttr(request, "resource", "height", this.image_h, "int");
		this.image_tile_w = this.getAttr(request, "resource", "tilewidth", this.image_tile_w, "int");
		this.image_tile_h = this.getAttr(request, "resource", "tileheight", this.image_tile_h, "int");
		this.image_res_min = this.getAttr(request, "resource", "min", this.image_res_min, "int");
		this.image_res_max = this.getAttr(request, "resource", "max", this.image_res_max, "int");
		this.image_service = this.getAttr(request, "resource", "service", this.image_service, "string");

		if (version >= 30) {
			if (this.image_service == "FZP") this.image_service = "FZP3"
		}
		return true;
	}
	else if (version >= 9){
		this.image_src = this.getAttr(request, "image", "src", this.image_src, "string");
		this.image_x = this.getAttr(request, "image", "x", this.image_x, "int");
		this.image_y = this.getAttr(request, "image", "y", this.image_y, "int");
		this.image_w = this.getAttr(request, "image", "width", this.image_w, "int");
		this.image_h = this.getAttr(request, "image", "height", this.image_h, "int");
		this.image_tile_w = this.getAttr(request, "image", "tilewidth", this.image_tile_w, "int");
		this.image_tile_h = this.getAttr(request, "image", "tileheight", this.image_tile_h, "int");
		this.image_res_min = this.getAttr(request, "image", "min", this.image_res_min, "int");
		this.image_res_max = this.getAttr(request, "image", "max", this.image__res_max, "int");
		this.image_service = this.image_service = "FZP0";		// Only

		return true;
	}
	else {
		// version 1.0 未満は非対応
		return false;
	}
};
FreezoomPack.prototype.getVersion = function(request) {
	// Version 判定
	var pal_elem = request.documentElement;
	var version = "0.9";
	if (pal_elem.getAttribute("version") && typeof pal_elem.getAttribute("version") !== "undefined") version = pal_elem.getAttribute("version").toString();
	else if (pal_elem.getAttribute("ver") && typeof pal_elem.getAttribute("ver") !== "undefined") version = pal_elem.getAttribute("ver").toString();
	var num_version = 9;
	try{ num_version = Math.floor(parseFloat(version) * 10); } catch (e) { num_version = -1; }
	return num_version;
};
FreezoomPack.prototype.setPattern = function(_pattern) {
	if (typeof _pattern === "string") {
		var _code = _pattern.split("/");
		if (_code.length == 2) { this.image_code_layer = _code[0]; this.image_code_name = _code[1]; }
	}
};
FreezoomPack.prototype.setImageSuffix = function(_mime) {
	if (typeof _mime === "string") {
		switch (_mime){
			case "image/png": this.image_suffix = ".png"; break;
			case "image/gif": this.image_suffix = ".gif";
		}
	}
};
FreezoomPack.prototype.readZoomifyXml = function(request) {
	// Version判定
	var xml_elem = request.documentElement;
	var version = "1.8";
	if (xml_elem.getAttribute("VERSION") && typeof xml_elem.getAttribute("version") !== "undefined") version = xml_elem.getAttribute("VERSION").toString();
	var num_version = 18;
	try{ num_version = Math.floor(parseFloat(version) * 10); } catch (e) { num_version = -1; }

	if (num_version == 18) {
		// Version 1.8 only
		if (xml_elem.getAttribute("WIDTH") && typeof xml_elem.getAttribute("WIDTH") !== "undefined") this.image_w = parseInt(xml_elem.getAttribute("WIDTH"));
		if (xml_elem.getAttribute("HEIGHT") && typeof xml_elem.getAttribute("HEIGHT") !== "undefined") this.image_h = parseInt(xml_elem.getAttribute("HEIGHT"));
		if (xml_elem.getAttribute("TILESIZE") && typeof xml_elem.getAttribute("TILESIZE") !== "undefined") this.image_tile_h = this.image_tile_w = parseInt(xml_elem.getAttribute("TILESIZE"));
		if (xml_elem.getAttribute("NUMTILES") && typeof xml_elem.getAttribute("NUMTILES") !== "undefined") this.image_num = parseInt(xml_elem.getAttribute("NUMTILES"));

		this.image_x = 0; this.image_y = 0;
		this.image_res_min = 0;
		this.image_res_max = Math.ceil(Math.log(Math.max(this.image_w,this.image_h)/this.image_tile_w) * Math.LOG2E);
		this.image_suffix = ".jpg";
		this.image_service = "ZOOMIFY";
		return true;
	}
	else {
		// Version 1.8以外は非対応
		return false;
	}
};
FreezoomPack.prototype.readDZXml = function(request, ttype) {
	// Version判定
	var xml_elem = request.documentElement;
	var size_elem = request.getElementsByTagName("Size")[0];
	try {
		if (size_elem.getAttribute("Width") && typeof size_elem.getAttribute("Width") !== "undefined") this.image_w = parseInt(size_elem.getAttribute("Width"));
		if (size_elem.getAttribute("Height") && typeof size_elem.getAttribute("Height") !== "undefined") this.image_h = parseInt(size_elem.getAttribute("Height"));

		if (xml_elem.getAttribute("TileSize") && typeof xml_elem.getAttribute("TileSize") !== "undefined") this.image_tile_h = this.image_tile_w = parseInt(xml_elem.getAttribute("TileSize"));
		if (xml_elem.getAttribute("Overlap") && typeof xml_elem.getAttribute("Overlap") !== "undefined") this.image_overlap = parseInt(xml_elem.getAttribute("Overlap"));
		if (xml_elem.getAttribute("Format") && typeof xml_elem.getAttribute("Format") !== "undefined") this.image_suffix = "." + xml_elem.getAttribute("Format");

		this.image_x = 0; this.image_y = 0;
		this.image_res_min = 0;
		this.image_res_max = Math.ceil(Math.log(Math.max(this.image_w,this.image_h)/this.image_tile_w) * Math.LOG2E);

		this.image_service = "DZ";
		if (this.image_tile_w <= 128) this.image_res_offset = 7;
		else if (this.image_tile_w > 256) this.image_res_offset = 9;
		else this.image_res_offset = 8;

		return true;
	}
	catch (e) {
		return false;
	}
};


// controller
function Controller (parent_obj) {
	this.parent = parent_obj;
	this.controller_div = $('<div class="s14c"></div>');
	this.base = new ControllerUnit(this);
	this.unitsw = new ButtonLogo(this);	// logo, unit visible switch
	$(this.parent.image_viewer_div).append(this.controller_div);
}
Controller.prototype.zoomClip = function () { this.init(); };
Controller.prototype.init = function () { this.base.init(); };
Controller.prototype.updateSize = function (wid, hei) {
	this.base.updateSize(wid, hei);
};
Controller.prototype.updateGUI = function () { };
Controller.prototype.toggleUnit = function () {
	var that = this;
	$(this.base.controller_base_div).toggle();
	$(this.parent.control_l.base.controller_base_div).toggle();
	if (this.parent.locator.enable){
		$(this.parent.locator.locator_div).toggle(0, function(){
			that.parent.locator.updateSize();
		});
	}
	var b = ($(this.parent.control_l.base.controller_base_div).css("display") == "block")
	if (typeof window.s14vToggleUnit !== "undefined") window.s14vToggleUnit(b);

	this.parent.parent.updateStage();
};

// logo (tool hide/show)
function ButtonLogo (parent_obj) {
	this.parent = parent_obj;
	this.active = true; this.click = false;
	this.controller_bt_logo = $('<div class="s14c_logo s14c_logo_bt"></div>');
	$(this.controller_bt_logo).css({"bottom": "0"});
	var sy = "0"; // or "-60";
	var that = this;
	$(this.controller_bt_logo).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) { that.parent.toggleUnit(); } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-60px "+sy+"px"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"0 "+sy+"px"}); if (that.active && that.click) { that.parent.toggleUnit(); } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-60px "+sy+"px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"0 "+sy+"px"}); } return false;
	}).css({"cursor":"pointer","backgroundPosition":"0 "+sy+"px"});
	$(this.parent.controller_div).append(this.controller_bt_logo);
	this.indicator = new Indicator(this);
}
// Indicator
function Indicator (parent_obj) {
	this.parent = parent_obj;
	this.controller_indicator = $('<div class="s14c_indicator"><div class="s14c_indicator_value"></div></div>');
	this.total = 100;
	//$(this.parent.controller_unitc_div).append(this.controller_indicator);
	$(this.parent.controller_bt_logo).append(this.controller_indicator);
}
Indicator.prototype.init = function (_total) {
	this.total = _total;
	$(".s14c_indicator_value").css("width","0");
};
Indicator.prototype.set = function (n) {
	var _v = 100 * (this.total - n) / this.total;
	if (_v > 99) { $(".s14c_indicator").css({"visibility":"hidden"}); }
	else { $(".s14c_indicator").css({"visibility":"visible"});$(".s14c_indicator_value").css({"width":_v+"%"}); }
};

// controller unit
function ControllerUnit (parent_obj) {
	this.parent = parent_obj;
	this.BTYOFF = 70;
	this.BTSPACE = 60;
	this.BTSPACEX = 70;
	this.layout = this.parent.parent.parent.VIEWParam.ControllerLayout; // true:vertical, false:horizontal

	this.controller_base_div = $('<div class="s14c_base"><div class="s14c_back"></div></div>');
	this.controller_unitc_div = $('<div class="s14c_unitc"></div>');

	this.bt_init = new ButtonInit(this);
	this.bt_zoomout = new ButtonZoomOut(this);
	this.bt_zoomin = new ButtonZoomIn(this);
	if (this.parent.parent.parent.VIEWParam.UseRotation) this.bt_rotateccw = new ButtonRotateCCW(this);
	if (this.parent.parent.parent.VIEWParam.UseRotation) this.bt_rotatecw = new ButtonRotateCW(this);
	//this.bt_index = new ButtonIndex(this);
	$(this.controller_base_div).append(this.controller_unitc_div);
	//this.bt_pageleft = new ButtonPageRight(this);
	if (Util.support_pc && !Util.support_legacy && this.layout && this.parent.parent.parent.VIEWParam.UseFull) this.bt_fullsize = new ButtonFullSize(this);
	if (this.parent.parent.parent.VIEWParam.UseClose) this.bt_close = new ButtonClose(this);
	$(this.parent.controller_div).append(this.controller_base_div);
	return this;
}
ControllerUnit.prototype.init = function () {
	if (this.parent.parent.plate_scale <= this.parent.parent.plate_scale_min / (100 / this.parent.parent.LIMITSCALE_LOW)) {
		if (this.parent.parent.plate_scale >= this.parent.parent.limit_plate_scale) { this.bt_zoomin.setEnable(false); this.bt_zoomout.setEnable(false); }
		else { this.bt_zoomin.setEnable(true); this.bt_zoomout.setEnable(false); }
	}
	else if (this.parent.parent.plate_scale >= this.parent.parent.limit_plate_scale) { this.bt_zoomin.setEnable(false); this.bt_zoomout.setEnable(true); }
	else { this.bt_zoomin.setEnable(true); this.bt_zoomout.setEnable(true); }

	if (!this.layout){
		$("div.s14c").css({"width":"100%","height":"60px"});
		$("div.s14c_base").css({"width":"100%","height":"60px"});
		$("div.s14c_unitc").css({"width":"100%","height":"60px"});
		//$("div.s14loc").css({"right":"4px"});
	}
};
ControllerUnit.prototype.updateSize = function (wid, hei) {

	if (!this.layout){
		// horizontal
		if (this.parent.parent.parent.rotate_enable){
			if (wid <= 360) {
				this.BTSPACEX = 50;
				$(".s14c_unitc").css({"width":"250px","marginLeft":"-70px"});
				$(this.bt_rotateccw.controller_bt_rotate).css({"left":(3 * this.BTSPACEX)+"px"}).hide();
				$(this.bt_rotatecw.controller_bt_rotate).css({"left":(4 * this.BTSPACEX)+"px"}).hide();
			}
			else if (wid <= 480){
				this.BTSPACEX = 56;
				$(".s14c_unitc").css({"width":"280px","marginLeft":"-105px"});
				$(this.bt_rotateccw.controller_bt_rotate).css({"left":(3 * this.BTSPACEX)+"px"}).show();
				$(this.bt_rotatecw.controller_bt_rotate).css({"left":(4 * this.BTSPACEX)+"px"}).hide();
			}
			else {
				this.BTSPACEX = 70; $(".s14c_unitc").css({"width":"350px","marginLeft":"-160px"});
				$(this.bt_rotateccw.controller_bt_rotate).css({"left":(3 * this.BTSPACEX)+"px"}).show();
				$(this.bt_rotatecw.controller_bt_rotate).css({"left":(4 * this.BTSPACEX)+"px"}).show();
			}
		}
		else {
			//$(this.bt_rotateccw.controller_bt_rotate).hide();
			//$(this.bt_rotatecw.controller_bt_rotate).hide();
			$(".s14c_unitc").css({"width":"210px","marginLeft":"-90px"});
		}
		//$(this.bt_index.controller_bt_index).css({"left":(0 * this.BTSPACEX)+"px"});
		$(this.bt_init.controller_bt_init).css({"left":(0 * this.BTSPACEX)+"px"});
		$(this.bt_zoomout.controller_bt_zoomout).css({"left":(1 * this.BTSPACEX)+"px"});
		$(this.bt_zoomin.controller_bt_zoomin).css({"left":(2 * this.BTSPACEX)+"px"});

		$(this.bt_close.controller_bt_close).css({"left":"10px"});
	}
	else {
		if (hei <= 360) {
			$(this.bt_rotateccw.controller_bt_rotate).hide();
			$(this.bt_rotatecw.controller_bt_rotate).hide();
		}
		else if (hei < 440){
			$(this.bt_rotateccw.controller_bt_rotate).show();
			$(this.bt_rotatecw.controller_bt_rotate).hide();
		}
		else {
			$(this.bt_rotateccw.controller_bt_rotate).show();
			$(this.bt_rotatecw.controller_bt_rotate).show();
		}

	}
};


// Controller of left side
function ControllerL (parent_obj) {
	this.parent = parent_obj;
	this.controller_div = $('<div class="s14cl"></div>');
	this.base = new ControllerLUnit(this);
	$(this.parent.image_viewer_div).append(this.controller_div);
	if (this.parent.parent.VIEWParam.UseLeftControl) $(".s14cl").show();
}
ControllerL.prototype.zoomClip = function () { this.init(); };
ControllerL.prototype.init = function () { this.base.init(); };
ControllerL.prototype.setPage = function (pageset) { }; // this.base.setPage(pageset);
ControllerL.prototype.updateSize = function (wid, hei) {
	this.base.updateSize(wid, hei);
};
ControllerL.prototype.updateGUI = function () { };

// controller unit of left side
function ControllerLUnit (parent_obj) {
	this.parent = parent_obj;
	this.BTYOFF = 70;
	this.BTXOFF = 10;
	this.BTSPACE = 60;
	this.BTSPACEX = 70;
	this.layout = true; // true:vertical, false:horizontal
	this.controller_base_div = $('<div class="s14cl_base"><div class="s14cl_back"></div></div>');
	this.controller_unitc_div = $('<div class="s14cl_unitc"></div>');

	this.pageset = [0, 1];

	this.bt_edit = new ButtonEdit(this);
	this.bt_annote = new ButtonAnnote(this);
	this.bt_index = new ButtonIndex(this);
	this.bt_pageleft = new ButtonPageLeft(this);
	this.bt_pageright = new ButtonPageRight(this);

	$(this.controller_base_div).append(this.controller_unitc_div);
	$(this.parent.controller_div).append(this.controller_base_div);

	this.init();
	return this;
}
ControllerLUnit.prototype.init = function () {
	try{ this.bt_index.setEnable(false); } catch (e) {}
	try{ this.bt_pageleft.setEnable(false); this.bt_pageright.setEnable(false); } catch (e) {}
};
ControllerLUnit.prototype.pageWork = function (n) {
	try {
		if (typeof n === "number") {
			if (this.parent.parent.parent.VIEWParam.PageDirection){ window.movePage(n); }
			else { window.movePage(-n); }
		}
	} catch (e) {}
};
ControllerLUnit.prototype.setPage = function (pageset) {
	try{
		if (this.parent.parent.parent.VIEWParam.PageDirection){
			if (pageset[1] <= 1) { this.bt_pageleft.setEnable(false); this.bt_pageright.setEnable(false); }
			else if (pageset[0] <= 1) { this.bt_pageleft.setEnable(false); this.bt_pageright.setEnable(true); }
			else if (pageset[0] >= pageset[1]) { this.bt_pageleft.setEnable(true); this.bt_pageright.setEnable(false); }
			else { this.bt_pageleft.setEnable(true); this.bt_pageright.setEnable(true); }
		}
		else {
			if (pageset[1] <= 1) { this.bt_pageleft.setEnable(false); this.bt_pageright.setEnable(false); }
			else if (pageset[0] <= 1) { this.bt_pageleft.setEnable(true); this.bt_pageright.setEnable(false); }
			else if (pageset[0] >= pageset[1]) { this.bt_pageleft.setEnable(false); this.bt_pageright.setEnable(true); }
			else { this.bt_pageleft.setEnable(true); this.bt_pageright.setEnable(true); }
		}
	} catch (e) {}
};
ControllerLUnit.prototype.updateSize = function (wid, hei) {
	if (!this.layout){
		if (this.parent.parent.parent.rotate_enable){
			if (wid <= 360) { this.BTSPACEX = 50; $(".s14cl_unitc").css({"width":"250px","marginLeft":"-145px"}); }
			else if (wid <= 480){ this.BTSPACEX = 56; $(".s14cl_unitc").css({"width":"280px","marginLeft":"-155px"}); }
			else { this.BTSPACEX = 70; $(".s14cl_unitc").css({"width":"350px","marginLeft":"-165px"}); }
		}
		else {
			$(".s14cl_unitc").css({"width":"210px","marginLeft":"-90px"});
		}
		$(this.bt_index.controller_bt_index).css({"left":(0 * this.BTSPACEX)+"px"});
		//$(this.bt_init.controller_bt_init).css({"left":(0 * this.BTSPACEX)+"px"});
		//$(this.bt_zoomout.controller_bt_zoomout).css({"left":(1 * this.BTSPACEX)+"px"});
		//$(this.bt_zoomin.controller_bt_zoomin).css({"left":(2 * this.BTSPACEX)+"px"});
	}
	else {
		//$(this.bt_index.controller_bt_index).css({"left":(0 * this.BTSPACEX + this.BTXOFF)+"px"});
	}
};

// zoom and view initialize
function ButtonInit (parent_obj) {
	this.parent = parent_obj;
	this.active = true; this.click = false;
	this.controller_bt_init = $('<div class="s14c_init s14c_bt"></div>');
	if (this.parent.layout) $(this.controller_bt_init).css({"bottom":(0 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	else $(this.controller_bt_init).css({"left":(0 * this.parent.BTSPACEX)+"px"});
	var that = this;
	$(this.controller_bt_init).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) { that.parent.parent.parent.viewInit(); } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-40px -80px"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"0 -80px"}); if (that.active && that.click) { that.parent.parent.parent.viewInit(); } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-40px -80px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"0 -80px"}); } return false;
	});
	$(this.parent.controller_unitc_div).append(this.controller_bt_init);
}
// zoom-out button
function ButtonZoomOut (parent_obj) {
	this.parent = parent_obj;
	this.active = false; this.click = false;
	this.controller_bt_zoomout = $('<div class="s14c_zoomout s14c_bt"></div>');
	if (this.parent.layout) $(this.controller_bt_zoomout).css({"bottom":(1 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	else $(this.controller_bt_zoomout).css({"left":(1 * this.parent.BTSPACEX)+"px"});
	var that = this;
	$(this.controller_bt_zoomout).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) { that.parent.parent.parent.viewZoomOut(-1); } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-40px -40px"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"0 -40px"}); if (that.active && that.click) { that.parent.parent.parent.viewZoomOut(-1); } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-40px -40px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"0 -40px"}); } return false;
	});
	$(this.parent.controller_unitc_div).append(this.controller_bt_zoomout);
}
ButtonZoomOut.prototype.setEnable = function (b) {
	if (b) { $(this.controller_bt_zoomout).css({"cursor":"pointer","backgroundPosition":"0 -40px"}); }
	else { $(this.controller_bt_zoomout).css({"cursor":"deafult","backgroundPosition":"-80px -40px"}); }
	this.active = b;
};
// zoom-in button
function ButtonZoomIn (parent_obj) {
	this.parent = parent_obj;
	this.active = false; this.click = false;
	this.controller_bt_zoomin = $('<div class="s14c_zoomin s14c_bt"></div>');
	if (this.parent.layout) $(this.controller_bt_zoomin).css({"bottom":(2 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	else $(this.controller_bt_zoomin).css({"left":(2 * this.parent.BTSPACEX)+"px"});
	var that = this;
	$(this.controller_bt_zoomin).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) { that.parent.parent.parent.viewZoomIn(1); } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-40px 0"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"0 0"}); if (that.active && that.click) { that.parent.parent.parent.viewZoomIn(1); } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-40px 0"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"0 0"}); } return false;
	});
	$(this.parent.controller_unitc_div).append(this.controller_bt_zoomin);
}
ButtonZoomIn.prototype.setEnable = function (b) {
	if (b) { $(this.controller_bt_zoomin).css({"cursor":"pointer","backgroundPosition":"0 0"}); }
	else { $(this.controller_bt_zoomin).css({"cursor":"default","backgroundPosition":"-80px 0"}); }
	this.active = b;
};
// ccw rotation
function ButtonRotateCCW (parent_obj) {
	this.parent = parent_obj;
	this.active = true; this.click = false;
	this.controller_bt_rotate = $('<div class="s14c_rotate s14c_bt"></div>');
	if (this.parent.layout) $(this.controller_bt_rotate).css({"bottom":(3 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	else $(this.controller_bt_rotate).css({"left":(3 * this.parent.BTSPACEX)+"px"});
	var that = this;
	$(this.controller_bt_rotate).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) { that.parent.parent.parent.viewStepRotate(-1); } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-40px -120px"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"0 -120px"}); if (that.active && that.click) { that.parent.parent.parent.viewStepRotate(-1); } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-40px -120px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"0 -120px"}); } return false;
	}).css({"cursor":"pointer","backgroundPosition":"0 -120px"});
	$(this.parent.controller_unitc_div).append(this.controller_bt_rotate);
}
// cc rotation
function ButtonRotateCW (parent_obj) {
	this.parent = parent_obj;
	this.active = true; this.click = false;
	this.controller_bt_rotate = $('<div class="s14c_rotate s14c_bt"></div>');
	if (this.parent.layout) $(this.controller_bt_rotate).css({"bottom":(4 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	else $(this.controller_bt_rotate).css({"left":(4 * this.parent.BTSPACEX)+"px"});
	var that = this;
	$(this.controller_bt_rotate).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) { that.parent.parent.parent.viewStepRotate(1); } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-120px -120px"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"-80px -120px"}); if (that.active && that.click) { that.parent.parent.parent.viewStepRotate(1); } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-120px -120px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"-80px -120px"}); } return false;
	}).css({"cursor":"pointer","backgroundPosition":"-120px -120px"});
	$(this.parent.controller_unitc_div).append(this.controller_bt_rotate);
}
/*
// locator (option)
function ButtonLocator (parent_obj) {
	this.parent = parent_obj;
	this.active = false; this.click = false;
	this.controller_bt_locator = $('<div class="s14c_locator" s14c_bt"></div>');
	$(this.controller_bt_locator).css({"top":(-0 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	var that = this;
	$(this.controller_bt_locator).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) {  } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-40px -240px"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"0 -240px"}); if (that.active && that.click) {  } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-40px -240px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"0 -240px"}); } return false;
	});
	$(this.parent.controller_base_div).append(this.controller_bt_locator);
}
ButtonLocator.prototype.setEnable = function (b) {
	if (b) { $(this.controller_bt_locator).css({"cursor":"pointer","backgroundPosition":"0 -240px"}); }
	else { $(this.controller_bt_locator).css({"cursor":"deafult","backgroundPosition":"-80px -240px"}); }
	this.active = b;
};
*/
// viewer full size
function ButtonFullSize (parent_obj) {
	this.parent = parent_obj;
	this.active = true; this.click = false;
	this.controller_bt_fullsize = $('<div class="s14c_fullsize s14c_bt"></div>');
	$(this.controller_bt_fullsize).css({"top":(0 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	var that = this;
	$(this.controller_bt_fullsize).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) { that.parent.parent.parent.viewFullSize(); } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-40px -360px"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"0 -360px"}); if (that.active && that.click) { that.parent.parent.parent.viewFullSize(); } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-40px -360px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"0 -360px"}); } return false;
	}).css({"cursor":"pointer","backgroundPosition":"0 -360px"});
	$(this.parent.controller_base_div).append(this.controller_bt_fullsize);
}

// viewer close
function ButtonClose (parent_obj) {
	this.parent = parent_obj;
	this.active = true; this.click = false;
	this.controller_bt_close = $('<div class="s14c_close s14c_bt"></div>');
	$(this.controller_bt_close).css({"top":(-1 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	var that = this;
	$(this.controller_bt_close).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) { that.parent.parent.parent.viewClose(); } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-40px -480px"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"0 -480px"}); if (that.active && that.click) { that.parent.parent.parent.viewClose(); } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-40px -480px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"0 -480px"}); } return false;
	}).css({"cursor":"pointer","backgroundPosition":"0 -480px"});
	$(this.parent.controller_base_div).append(this.controller_bt_close);
}

// annotation editor toggle
function ButtonEdit (parent_obj) {
	this.parent = parent_obj;
	this.active = true; this.click = false;
	this.controller_bt_editor = $('<div class="s14c_editor s14c_bt"></div>');
	$(this.controller_bt_editor).css({"left":(1 * this.parent.BTSPACEX)+"px","top":(-1 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	var that = this;
	$(this.controller_bt_editor).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) { that.parent.parent.parent.toggleEditor(); } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-120px -560px"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"-80px -560px"}); if (that.active && that.click) { that.parent.parent.parent.toggleEditor(); } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) {
  $(this).css({"cursor":"pointer","backgroundPosition":"-120px -560px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"-80px -560px"}); } return false;
	}).css({"cursor":"pointer","backgroundPosition":"-80px -560px"});
	$(this.parent.controller_unitc_div).append(this.controller_bt_editor);
}
function ButtonAnnote (parent_obj) {
	this.parent = parent_obj;
	this.active = false; this.click = false;
	this.controller_bt_editor = $('<div class="s14c_annote s14c_bt"></div>');
	if (this.parent.layout) $(this.controller_bt_editor).css({"left":(0 * this.parent.BTSPACEX+this.parent.BTXOFF)+"px","top":(-1 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	else $(this.controller_bt_editor).css({"left":(1 * this.parent.BTSPACEX)+"px"});
	var that = this;
	$(this.controller_bt_editor).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){
		if (that.click) { that.active = !that.active; }
		that.parent.parent.parent.image_field.image_plate.changeAnnoteview(that.active);
		that.click = false;
		return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-40px -560px"}); that.click = true; return false;
	}).on("touchend", function(event){
		$(this).css({"cursor":"default","backgroundPosition":"0 -560px"});
		if (that.click) { that.active = !that.active; }
		that.parent.parent.parent.image_field.image_plate.changeAnnoteview(that.active);
		that.click = false;
		return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-40px -560px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"0 -560px"}); } return false;
	}).css({"cursor":"pointer","backgroundPosition":"0 -560px"});
	$(this.parent.controller_unitc_div).append(this.controller_bt_editor);
}
// index
function ButtonIndex (parent_obj) {
	this.parent = parent_obj;
	this.active = false; this.click = false;
	this.controller_bt_index = $('<div class="s14c_index s14c_bt"></div>');
	if (this.parent.layout) $(this.controller_bt_index).css({"left":(0 * this.parent.BTSPACEX+this.parent.BTXOFF)+"px","bottom":(-1 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	else $(this.controller_bt_index).css({"left":(0 * this.parent.BTSPACEX)+"px"});
	var that = this;
	$(this.controller_bt_index).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) {  } that.click = false; return false;
  }).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-120px -520px"}); that.click = true; return false;
  }).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"-80px -520px"}); if (that.active && that.click) {  } that.click = false; return false;
  }).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-120px -520px"}); } return false;
  }).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"-80px -520px"}); } return false;
	});
	$(this.parent.controller_unitc_div).append(this.controller_bt_index);
}
ButtonIndex.prototype.setEnable = function (b) {
	if (b) { $(this.controller_bt_index).css({"cursor":"pointer","backgroundPosition":"-80px -520px"}); }
	else { $(this.controller_bt_index).css({"cursor":"default","backgroundPosition":"-120px -520px","opacity":"0.3"});  }
	this.active = b;
};
// page button
function ButtonPageLeft (parent_obj) {
	this.parent = parent_obj;
	this.active = false; this.click = false;
	this.controller_bt_pageleft = $('<div class="s14c_pageleft s14c_bt"></div>');

	//var nn = 2; if (!this.parent.parent.parent.parent.VIEWParam.PageDirection) nn = 0;
	//if (this.parent.layout) $(this.controller_bt_pageleft).css({"bottom":(nn * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});*/
	var nn = 1;
	if (this.parent.layout) $(this.controller_bt_pageleft).css({"right":(nn * this.parent.BTSPACEX)+"px","bottom":(-1 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});

	//else $(this.controller_bt_pageleft).css({"left":(0 * this.parent.BTSPACEX)+"px"});
	var that = this;
	$(this.controller_bt_pageleft).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) { that.parent.pageWork(-1); } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-40px -400px"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"0 -400px"}); if (that.active && that.click) { that.parent.pageWork(-1); } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-40px -400px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"0 -400px"}); } return false;
	});
	$(this.parent.controller_unitc_div).append(this.controller_bt_pageleft);
}
ButtonPageLeft.prototype.setEnable = function (b) {
	if (b) { $(this.controller_bt_pageleft).css({"cursor":"pointer","backgroundPosition":"0 -400px"}); }
	else { $(this.controller_bt_pageleft).css({"cursor":"deafult","backgroundPosition":"-80px -400px"}); }
	this.active = b;
};
function ButtonPageRight (parent_obj) {
	this.parent = parent_obj;
	this.active = false; this.click = false;
	this.controller_bt_pageright = $('<div class="s14c_pageright s14c_bt"></div>');

	//var nn = 0; if (!this.parent.parent.parent.parent.VIEWParam.PageDirection) nn = 2;
	//if (this.parent.layout) $(this.controller_bt_pageright).css({"bottom":(nn * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});
	var nn = 0;
	if (this.parent.layout) $(this.controller_bt_pageright).css({"right":(nn * this.parent.BTSPACEX + this.parent.BTXOFF)+"px","bottom":(-1 * this.parent.BTSPACE + this.parent.BTYOFF)+"px"});

	//else $(this.controller_bt_pageright).css({"left":(2 * this.parent.BTSPACEX)+"px"});
	var that = this;
	$(this.controller_bt_pageright).on("mousedown", function(event){ that.click = true; return false;
	}).on("mouseup", function(event){ if (that.active && that.click) { that.parent.pageWork(1); } that.click = false; return false;
	}).on("touchstart", function(event){ $(this).css({"cursor":"pointer","backgroundPosition":"-40px -440px"}); that.click = true; return false;
	}).on("touchend", function(event){ $(this).css({"cursor":"default","backgroundPosition":"0 -440px"}); if (that.active && that.click) { that.parent.pageWork(1); } that.click = false; return false;
	}).on("mouseover", function(event){ if (that.active) { $(this).css({"cursor":"pointer","backgroundPosition":"-40px -440px"}); } return false;
	}).on("mouseout", function(event){ if (that.active) { $(this).css({"cursor":"default","backgroundPosition":"0 -440px"}); } return false;
	});
	$(this.parent.controller_unitc_div).append(this.controller_bt_pageright);
}
ButtonPageRight.prototype.setEnable = function (b) {
	if (b) { $(this.controller_bt_pageright).css({"cursor":"pointer","backgroundPosition":"0 -440px"}); }
	else { $(this.controller_bt_pageright).css({"cursor":"default","backgroundPosition":"-80px -440px"}); }
	this.active = b;
};


// locator
function Locator (parent_obj) {

	this.parent = parent_obj;

	this.x = this.y = 0;
	this.width = this.height = 128;

	this.enable = false;
	this.locator_size = this.LOCATORSIZE = 128;
	this.locator_w = this.locator_h = this.LOCATORSIZE;
	this.locator_vw = this.locator_vh = this.LOCATORSIZE;
	this.scale = 1;
	this.image_scale = 1;
	this.rotate = 0;
	this.draw_color = "#f00";

	this.coordinate = null;

	this.locator_div = document.createElement("div");
	this.locator_div.className = "s14loc";

	this.locator_base_div = document.createElement("div");
	this.locator_base_div.className = "s14loc_base";
	this.locator_div.appendChild(this.locator_base_div);

	this.locator_image = new LocatorImage(this);
	this.locator_area_div = document.createElement("div");
	this.locator_area_div.className = "s14loc_area";
	this.locator_base_div.appendChild(this.locator_area_div);

	this.parent.image_viewer_div.appendChild(this.locator_div);

	// ui variable
	var endval;
	var drag = false;

	var that = this;

	var _ua = (function(){
		return {
			Touch: typeof document.ontouchstart !== "undefined",
			Pointer: window.navigator.pointerEnabled,
			MSPoniter: window.navigator.msPointerEnabled
		}
	})();
	var _start = _ua.Pointer ? 'pointerdown' : _ua.MSPointer ? 'MSPointerDown' : _ua.Touch ? 'touchstart mousedown' : 'mousedown';
	var _move = _ua.Pointer ? 'pointermove' : _ua.MSPointer ? 'MSPointerMove' : _ua.Touch ? 'touchmove mousemove' : 'mousemove';
	var _leave = _ua.Pointer ? 'pointerleave' : _ua.MSPointer ? 'MSPointerLeave' : _ua.Touch ? 'mouseleave' : 'mouseleave'; // iOS, Androidは未定義？
	var _end = _ua.Pointer ? 'pointerup' : _ua.MSPointer ? 'MSPointerUp' : _ua.Touch ? 'touchend mouseup' : 'mouseup';

	if (_start.toLowerCase().indexOf("pointer")>=0) {
		$(this.locator_base_div).css({"touch-action": "none", "-ms-touch-action": "none"}); /* IE10,IE11 タッチデフォルト挙動の停止 */
	}

	var getPoint = function(event){
		var localX = Util._elemX(event, that.x + that.locator_vw / 2);
		var localY = Util._elemY(event, that.y + that.locator_vh / 2);
		var tx = Math.floor(localX + that.locator_vw / 2);
		var ty = Math.floor(localY + that.locator_vh / 2);
		return that.coordinate.getD2V(tx, ty);
	};

	$(this.locator_base_div).on("mousedown touchstart", function(event){
		event.stopPropagation(); event.preventDefault();
		endval = getPoint(event);
		that.parent.moving(endval.x, endval.y);
		that.parent.coordinate.updateVCenter(endval.x, endval.y);
		drag = true;
	}).on("mousemove touchmove", function(event){
		if (drag){
			endval = getPoint(event);
			if (endval.x < 0) endval.x = 0;
			if (endval.y < 0) endval.y = 0;
			if (endval.x > that.parent.image_w) endval.x = that.parent.image_w;
			if (endval.y > that.parent.image_h) endval.y = that.parent.image_h;
			that.parent.moving(endval.x, endval.y);
			that.parent.coordinate.updateVCenter(endval.x, endval.y);
		}
	}).on("mouseup touchend mouseleave", function(event){
		if (drag){
			that.parent.coordinate.updateVCenter(endval.x, endval.y);
			that.parent.pan(endval.x, endval.y, true);
		}
		drag = false;
	});
}
Locator.prototype.init = function() {
	this.enable = this.parent.parent.VIEWParam.LocatorEnable;
	this.active = this.enable;// && this.parent.parent.VIEWParam.LocatorActive;
	var _size = this.parent.parent.VIEWParam.LocatorImageSize;
	if (_size > 100) this.locator_size = this.LOCATORSIZE = _size;
	else this.image_scale = _size;
	this.locator_w = this.locator_h = this.LOCATORSIZE;
	this.locator_vw = this.locator_vh = this.LOCATORSIZE;
};
Locator.prototype.setResource = function(src_path) {
	this.locator_image.loadImage(src_path);
};
Locator.prototype.setInit = function(image_w, image_h, center_x, center_y, rotate) {
	var drag = false;
	if (image_w > image_h){
		//this.locator_size = this.locator_image.width * this.locator_scale;
		this.scale = image_w / this.locator_size;
		this.locator_w = Math.floor(this.locator_size);
		this.locator_h = Math.floor(image_h / this.scale);
		//this.locator_h = Math.floor(this.locator_size);
	}
	else {
		//this.locator_size = this.locator_image.height * this.locator_scale;
		this.scale = image_h / this.locator_size;
		this.locator_h = Math.floor(this.locator_size);
		this.locator_w = Math.floor(image_w / this.scale);
		//this.locator_w = Math.floor(this.locator_size);
	}
	this.coordinate = new Coordinate();
	this.coordinate.setInit(this.locator_w, this.locator_h, image_w, image_h, this.scale, this.scale, center_x, center_y, rotate);

	this.updateRotate(this.parent.ROTATE);
	(this.enable && this.active) ? this.locator_div.style.display = "block": this.locator_div.style.display = "none";

	this.parent.updateStage();
};
Locator.prototype.setBoxPosition = function(p1, p2, p3, p4) {
	if (this.coordinate != null){
		var q1 = this.coordinate.getV2D(p1.x, p1.y);
		var q2 = this.coordinate.getV2D(p2.x, p2.y);
		var q3 = this.coordinate.getV2D(p3.x, p3.y);
		var q4 = this.coordinate.getV2D(p4.x, p4.y);
		this.locator_area_div.style.borderColor = this.draw_color;
		this.locator_area_div.style.left = (q1.x - 1) + "px";
		this.locator_area_div.style.top = (q1.y - 1) + "px";
		this.locator_area_div.style.width = (q2.x - q1.x - 2) + "px";
		this.locator_area_div.style.height = (q3.y - q2.y - 2) + "px";
	}
};
Locator.prototype.updateRotate = function(trot) {
	this.locator_image.locator_img.style["-webkit-transform"] = "rotate("+trot+"deg)";
	this.locator_image.locator_img.style.MozTransform = "rotate("+trot+"deg)"; //this.locator_image.locator_img.style["-moz-transform"] = "rotate("+trot+"deg)";
	this.locator_image.locator_img.style["-o-transform"] = "rotate("+trot+"deg)";
	this.locator_image.locator_img.style["-ms-transform"] = "rotate("+trot+"deg)";
	this.locator_image.locator_img.style["transform"] = "rotate("+trot+"deg)";

	this.rotate = trot;
	if (this.rotate % 180 == 0) {
		this.locator_vw = this.locator_w;
		this.locator_vh = this.locator_h;
	}
	else if (this.rotate % 90 == 0) {
		this.locator_vw = this.locator_h;
		this.locator_vh = this.locator_w;
	}
	else {
		this.locator_vw = this.locator_vh = this.locator_size;
	}
	this.parent.updateStage();
};
Locator.prototype.updateSize = function() {
	this.locator_div.style.width = (this.locator_vw + 16) + "px";
	this.locator_div.style.height = (this.locator_vh + 16) + "px";
	//this.locator_div.style.left = $loc.left + "px";
	//this.locator_div.style.top = $loc.top + "px";

	this.locator_base_div.style.width = (this.locator_vw + 16) + "px";
	this.locator_base_div.style.height = (this.locator_vh + 16) + "px";
	if (this.rotate % 90 == 0) {
		this.locator_base_div.style.left = Math.floor((this.locator_vw - this.locator_w) / 2 + 8) + "px";
		this.locator_base_div.style.top = Math.floor((this.locator_vh - this.locator_h) / 2 + 8) + "px";
	}
	else {
	}
	var $loc = $(this.locator_div).offset();
	this.x = $loc.left + Math.floor((this.locator_vw - this.locator_w) / 2 + 8);
	this.y = $loc.top + Math.floor((this.locator_vh - this.locator_h) / 2 + 8);
};
// ロケータ画像
function LocatorImage (parent_obj) {
	this.x = this.y = 0;
	this.width = this.height = 128;

	this.parent = parent_obj;

	this.locator_img = document.createElement("img");
	this.locator_img.className = "s14loc_image";
	this.parent.locator_base_div.appendChild(this.locator_img);

	this.comp = 1;
}
LocatorImage.prototype.loadImage = function(file_path) {
	var that = this;
	$(this.locator_img).on("load", function(event){ that.compLoad(event); });
	$(this.locator_img).on("error", function(){ that.errorLoad(); });
	this.locator_img.setAttribute("src", file_path);
};
LocatorImage.prototype.compLoad = function(event) {
	$(this.locator_img).off();
	if (typeof event.currentTarget.naturalWidth !== "undefined") { this.width = event.currentTarget.naturalWidth; this.height = event.currentTarget.naturalHeight; }
	else { this.width = event.target.width; this.height = event.target.height; }
	/*if (false){//that.parent.image_scale <= 1) {
		this.locator_img.style.width = Math.floor(this.parent.image_scale * this.width) + "px";
		this.locator_img.style.height = Math.floor(this.parent.image_scale * this.height) + "px";
		this.width >= that.height ? this.parent.locator_size = this.locator_img.style.width : this.parent.locator_size = this.locator_img.style.height;
	}
	else {*/
		if (this.width > this.height){
			//this.locator_size = this.locator_image.width * this.locator_scale;
			var _image_scale = this.width / this.parent.locator_size;
			if (_image_scale > 0){
				this.locator_img.style.width = Math.floor(this.parent.locator_size) + "px";
				this.locator_img.style.height = Math.floor(this.height / _image_scale) + "px";
			}
			//this.locator_h = Math.floor(this.locator_size);
		}
		else {
			//this.locator_size = this.locator_image.height * this.locator_scale;
			var _image_scale = this.height / this.parent.locator_size;
			if (_image_scale > 0){
				this.locator_img.style.height = Math.floor(this.parent.locator_size) + "px";
				this.locator_img.style.width = Math.floor(this.width / _image_scale) + "px";
			}
			//this.locator_w = Math.floor(this.locator_size);
		}
	//}
	this.comp = 0;
	this.parent.parent.actionSuccessLocator();
};
LocatorImage.prototype.errorLoad = function() {
	$(this.locator_img).off();
	this.parent.enable = false;
	this.parent.parent.actionErrorLocator();
};


// 2018-10-07, add Rokka
function AnnoteObject (parent_obj) {
	// 親を参照
	this.parent = parent_obj;

	this.oid = 2;
	this.x = 0;
	this.y = 0;
	this.width;
	this.height;
	this.scale = 1;

	this.resource_obj = this.parent.parent.field_property;
	this.global_w = this.resource_obj["image_w"] || 0;
	this.global_h = this.resource_obj["image_h"] || 0;

	// 要素
	this.image_object_div = document.createElement("div");
	this.image_object_div.className = "s14ao";

	// 配置
	this.parent.image_plate_div.appendChild(this.image_object_div);

	this.image_canvas = document.createElement("canvas");
	this.image_canvas.className = "s14ac";

	this.ctx = this.image_canvas.getContext("2d");

	// コンテナ
	this.items;
	this.comp = 1;	// 読み込み未完了

	this.enable = false;
	this.active = false;
	this.visible = true;

	this.canvas_x = 0;
	this.canvas_y = 0;
	this.canvas_SIZE_OFFSET = 0;
	this.canvas_SIZE_MAGNIFY_HALF = 1;
	this.canvas_SIZE_MAGNIFY = 4 * this.canvas_SIZE_MAGNIFY_HALF;
	this.past = [0,0];

	/*this.imgs = {};
	this.loaded = false;
	this.IMWID = 64;*/
}
AnnoteObject.prototype.init = function (annote_items) {
	this.items = annote_items;
	this.updateAnnotes();

	// 配置
	this.image_object_div.appendChild(this.image_canvas);

	// image_fieldに更新抑制用の参照渡し
	this.parent.parent.annote_overlay = this;
};
AnnoteObject.prototype.updateSize = function () {
	this.scale = this.parent.parent.parent.plate_scale;
	//this.width = this.global_w * this.scale;
	//this.height = this.global_h * this.scale;
	this.width = this.canvas_SIZE_MAGNIFY * (this.parent.parent.parent.half_view_w - this.canvas_SIZE_OFFSET);
	this.height = this.canvas_SIZE_MAGNIFY * (this.parent.parent.parent.half_view_h - this.canvas_SIZE_OFFSET);

	var pnt = this.parent.parent.parent.coordinate.getCorner("5");
	this.canvas_x = pnt.x - this.canvas_SIZE_MAGNIFY_HALF * this.parent.parent.parent.half_view_w / this.scale;
	this.canvas_y = pnt.y - this.canvas_SIZE_MAGNIFY_HALF * this.parent.parent.parent.half_view_h / this.scale;

	$(".s14ac").attr({
		"width": this.width,
		"height": this.height
	}).css({
		"left": (this.canvas_x * this.scale + this.canvas_SIZE_OFFSET) + "px",
		"top": (this.canvas_y * this.scale + this.canvas_SIZE_OFFSET) + "px",
	});
};
AnnoteObject.prototype.updateAnnotes = function () {
	this.updateSize();
	if (!(this.active && this.visible)) return;
	this.ctx.clearRect(-this.width,-this.height,this.width*2,this.height*2);
	for (var i=0; i < this.items.length; i++){
		var item = this.items[i];
		if (item["type"]=="label" && item["vis"]>0 && this.parent.parent.parent.layer <= item["vislevel"]){
			var label = item["label"];
			var loc = item["locate"];
			var locs = loc.split(",");

			this.ctx.font = "normal 14px 'メイリオ','ヒラギノ角ゴ ProN W3','MS UI Gothic','ＭＳ Ｐゴシック',sans-serif";
			this.ctx.shadowColor = "#000";
			this.ctx.textAlign = "center";
			this.ctx.fillStyle = "#000";
			this.ctx.strokeStyle = "#fff";
			this.ctx.lineWidth = 3;
			var c_x = (parseFloat(locs[0]) - this.canvas_x) * this.scale;
			var c_y = (parseFloat(locs[1]) - this.canvas_y) * this.scale;
			this.ctx.strokeText(label, c_x, c_y);
			this.ctx.fillText(label, c_x, c_y);
		}
		else if (item["type"]=="rect" && item["vis"]>0 && this.parent.parent.parent.layer <= item["vislevel"]){
			var label = item["label"];
			var loc = item["locate"];
			var locs = loc.split(",");

			var vrect = item["rect"];
			var vrects = vrect.split(",");
			var rects = this.parent.parent.parent.coordinate.getV2DR(vrects[0],vrects[1],vrects[2],vrects[3]);

			var rx = rects.x; var ry = rects.y;
			var rw = rects.width; var rh = rects.height;

			this.ctx.strokeStyle = "#fc0";
			this.ctx.shadowColor = "#000";
			this.ctx.shadowBlur = 4;
			this.ctx.shadowOffsetX = 2;
			this.ctx.shadowOffsetY = 2;
			this.ctx.lineWidth = 4;

			var r_x = rx;
			var r_y = ry;
			var r_w = rw;
			var r_h = rh;
			this.ctx.strokeRect(r_x, r_y, r_w, r_h);

			this.ctx.font = "normal 14px 'メイリオ','ヒラギノ角ゴ ProN W3','MS UI Gothic','ＭＳ Ｐゴシック',sans-serif";
			this.ctx.shadowColor = "#000";
			this.ctx.textAlign = "left";
			this.ctx.fillStyle = "#000";
			this.ctx.strokeStyle = "#fff";
			this.ctx.shadowBlur = 0;
			this.ctx.shadowOffsetX = 0;
			this.ctx.shadowOffsetY = 0;
			this.ctx.lineWidth = 3;
			var c_x = rx + 5;	//(rx - this.canvas_x + 5) * this.scale;
			var c_y = ry - 5; //(ry - this.canvas_y - 20) * this.scale;
			this.ctx.strokeText(label, c_x, c_y);
			this.ctx.fillText(label, c_x, c_y);
		}
	}
	this.image_object_div.style.visibility = "visible";
};
AnnoteObject.prototype.loadImage = function (tlevel) {
};
AnnoteObject.prototype.loadFzpImage = function (trect, tlevel) {
};
AnnoteObject.prototype.setViewScale = function (tscale, tlevel) {
	if (this.active && this.visible){ this.updateAnnotes(); }
	else{ this.image_object_div.style.visibility = "hidden"; }
};
AnnoteObject.prototype.updateRotate = function(trot) {
	this.parent.updatePosition();
	this.updateAnnotes();
};
AnnoteObject.prototype.jump = function (vpx, vpy) {
	var x = vpx * this.parent.parent.parent.int_scale * this.scale;
	var y = vpy * this.parent.parent.parent.int_scale * this.scale;
	this.image_object_div.style.left = x + "px";
	this.image_object_div.style.top = y + "px";
	this.updateAnnotes();
	this.past = [x, y];
};
AnnoteObject.prototype.smooth = function (vpx, vpy) {
};


// ビューア
function Viewer (UI_param, VIEW_param){

	this.UIParam = UI_param; this.VIEWParam = VIEW_param;			// パラメータ保持
	this.parent_dom_node = this.UIParam.UI_Element;					// 配置先

	// コンストラクタ
	this.viewer_div = document.createElement("div");
	this.viewer_div.className = "s14viewer";
	this.parent_dom_node.appendChild(this.viewer_div);

	// 下層構造
	this.annote_fl = null;
	try {
		if (Indexer && typeof Indexer.mr_previewSupport === "boolean" && Indexer.mr_previewSupport){
			if (this.UIParam.UI_Preview) this.annote_fl = Indexer.create(this);
		}
	} catch (e){}
	this.VIEWParam.UsePreview = (this.annote_fl != null);

	// 下層構造
	this.image_viewer = new ImageViewer(this);

	// パラメータ
	this.DBLZOOM = true;												// ダブルクリック、ダブルタップでズーム(デフォルト有効)
	this.MOVESTEP = 32;													// キー移動基準値
	this.ROTATESTEP = 90;												// 回転ステップ
	this.rotate_enable = false;									// 回転の有効・無効(デフォルト無効)
	this.localrun = (typeof this.VIEWParam.Lrun !== "undefined");			// Safari上でのローカル起動
	// IIIF 表示遅延
	this.LOAD_DELAY_TIME = 1000;								// 本読み込みの遅延（IIIF,IIIF-OPOSSUM）
	if (typeof this.VIEWParam.Ldt !== "undefined") {
		try { this.LOAD_DELAY_TIME = parseInt(this.VIEWParam.Ldt); } catch(e) {}
	}

	// アノテーションレイヤの初期作成
	this.ANNOTEATFIRST = true;

	// コンテンツ配列
	//this.list = [];


	// アノテーション配列
	// 018-10-07, add Rokka
	this.annotes = [];


	// 初期値
	this.rotate = 0;
	this.x = 0; this.y = 0;
	this.width = 640; this.height = 480;
	this.parent_dom = {	// 配置元の位置とサイズ
		"offsetx": $(this.parent_dom_node).offset().left,
		"offsety": $(this.parent_dom_node).offset().top,
		"width": $(this.parent_dom_node).width(),
		"height": $(this.parent_dom_node).height()
	};
	this.full = false;

	// 初期設定
	this.setConfig();
	this.expandableEvents();
	this.updateStage();
}
Viewer.prototype.setConfig = function() {
	if (typeof this.VIEWParam.Rot !== "undefined") this._setParamsRotate(this.VIEWParam.Rot); // rotation
	if (typeof this.VIEWParam.Lmt !== "undefined") this._setParamsLimit(this.VIEWParam.Lmt); // zoom restrict
	if (typeof this.VIEWParam.LocatorImageSize !== "undefined") this._setParamsLocator(this.VIEWParam.LocatorImageSize); // locator's size
	if (typeof this.VIEWParam.LocatorImageColor !== "undefined") this._setParamsLocColor(this.VIEWParam.LocatorImageColor); // locator's area frame color

	if (typeof this.image_viewer.locator !== "undefined") this.image_viewer.locator.init();	// update of parameter
};
Viewer.prototype.expandableEvents = function() {

	var that = this;

	// キーボード
	$(window).on("keydown", function(event) {
		if (that.MOVESTEP != 0) {
			var evt = event || window.event;
			var keycode = evt.charCode || evt.keyCode;
			if (keycode == 37) { that.image_viewer.viewMove(-that.MOVESTEP, 0); }
			else if (keycode == 38) { that.image_viewer.viewMove(0, -that.MOVESTEP); }
			else if (keycode == 39) { that.image_viewer.viewMove(that.MOVESTEP, 0); }
			else if (keycode == 40) { that.image_viewer.viewMove(0, that.MOVESTEP); }
		}
	});

	// コンテクストメニューの抑止
	$(this.viewer_div).on("contextmenu", function(event){ event.preventDefault(); });

	// マウスホイール・イベント
	$(this.viewer_div).off("mousewheel").on("mousewheel", function(event) {
		that.image_viewer.viewZoomRel(event.originalEvent.wheelDelta); // for IE, webkit
		return false;
	}).off("DOMMouseScroll").on("DOMMouseScroll", function(event) {
		that.image_viewer.viewZoomRel(-event.originalEvent.detail * 20); // FF
		return false;
	});

};
Viewer.prototype.setParams = function(params) {
	// over write parameters
	if (typeof params.rot === "string") this.VIEWParam.Rot = params.rot;
	if (typeof params.lmt === "string") this.VIEWParam.Lmt = params.lmt;
	if (typeof params.loc === "string") this.VIEWParam.LocatorImageSize = params.loc;
	if (typeof params.clr === "string") this.VIEWParam.LocatorImageColor = params.clr;
	// reset by parameters
	this.setConfig();
};
Viewer.prototype._setParamsRotate = function(_rot) {
	this.rotate_enable = false; this.rotate = this.image_viewer.ROTATE = 0;
	if (Util.support_legacy) { this.VIEWParam.UseRotation = false; return; }
	var rot = 0;
	if (typeof _rot === "string" && /\d/.test(_rot)) { this.rotate_enable = true; rot = parseInt(_rot); }
	else if (typeof _rot === "number") { this.rotate_enable = true; rot = _rot; }
	if (rot % 90 == 0) this.rotate = this.image_viewer.ROTATE = rot % 360;
	this.rotate_enable = this.rotate_enable && !!this.VIEWParam.LocatorEnable;
};
Viewer.prototype._setParamsLimit = function(_lmt) {
	if (/^[0-9]{2,3},[1-8][0-9][0-9]/.test(_lmt)){
		var _lmts = _lmt.split(",");
		if (!isNaN(Number(_lmts[0])) && !isNaN(Number(_lmts[1]))) {
			if (parseInt(_lmts[0]) >= 50 && parseInt(_lmts[0]) <= 100){ this.image_viewer.LIMITSCALE_LOW = parseInt(_lmts[0]); }
			if (parseInt(_lmts[1]) >= 100 && parseInt(_lmts[1]) <= 400){ this.image_viewer.LIMITSCALE = parseInt(_lmts[1]); }
		}
	}
};
Viewer.prototype._setParamsLocator = function(_loc) {
	if (Util.support_legacy) { this.VIEWParam.LocatorEnable = false; this.VIEWParam.LocatorImageSize = 128; return; }
	else if (!this.VIEWParam.LocatorEnable) { this.VIEWParam.LocatorImageSize = 128; return; }
	else {
		this.VIEWParam.LocatorEnable = false; //this.VIEWParam.LocatorImageSize = 128;
		var loc = 0;
		if (typeof _loc === "string" && /N/.test(_loc)) { loc = 128; this.VIEWParam.LocatorEnable = true; } // Deprecated
		else if (typeof _loc === "string" && /^[0-9]{2,3}$/.test(_loc)) { loc = parseInt(_loc); this.VIEWParam.LocatorEnable = true; } // Deprecated
		else if (typeof _loc === "number" && /\d/.test(_loc)){ loc = _loc; this.VIEWParam.LocatorEnable = true; }
		if (Math.abs(loc) > 100 && Math.abs(loc) <= 512) this.VIEWParam.LocatorImageSize = Math.abs(loc);
	}
};
Viewer.prototype._setParamsLocColor = function(_clr) {
	if (this.image_viewer.locator){
		if (/^#[0-9a-fA-F]{3}|^#[0-9a-fA-F]{6}/.test(_clr)) this.image_viewer.locator.draw_color = _clr;
	}
};


Viewer.prototype.setIndex = function(a_resource, a_resource_type) {
	// 索引インデックス（オプション）,2017-09-03
	var a_params = {}
	if (typeof arguments[2] !== "undefined") {
		a_params = arguments[2];
		this.setParams(a_params);	// 一般パラメータの解析
	}

	if (this.annote_fl) {
		this.annote_fl.init();
		this.annote_fl.setPreview(a_resource, a_resource_type, a_params);
	}
	else if (a_resource_type == "xml" || a_resource_type == "json"){
		this.image_viewer.doAction();
		console.log("(This message was from the viewer.) No support preview index. Mistake configuration.");
	}
};


Viewer.prototype.setForcedMultiResources = function(params) {
	var nodes = [];
	for (var i = 0; i < params.length; i++){
		nodes.push(this.getForcedResource(params[i]));
	}
	this.image_viewer.setForcedResource(nodes);
};
Viewer.prototype.getForcedResource = function(a_params) {

	var node = {role:"resource", indexpath:"", path:"", field:"", name:"", type:"jpg", x:0, y:0};

	var a_resource = a_params["name"];
	var a_resource_type = a_params["type"];

	this.setParams(a_params);	// 一般パラメータの解析

	//this.image_viewer.locator.init();	// update of parameter

	if (typeof this.VIEWParam.ResourcePath === "string" && this.VIEWParam.ResourcePath != ""){ node.path = this.VIEWParam.ResourcePath; }
	if (typeof a_params !== "undefined" && typeof a_params.path === "string") { node.path = a_params.path; }

	if (a_resource != null && a_resource != ""){

		var idx = a_resource.lastIndexOf("/");
		if (idx > 0){
			node.field = a_resource.substring(0, idx);
			node.name = a_resource.substring(idx + 1);
		}
		else {
			node.name = a_resource;
		}

		node.type = "jpg"; node.altertype = "jpg";	// 画像名のみある場合は暗黙にJPEGとする
		// 予約設定
		if (typeof this.VIEWParam.ResourceType === "string" && this.VIEWParam.ResourceType != ""){
			if (this.VIEWParam.ResourceType.indexOf("|")>0){
				var _types = this.VIEWParam.ResourceType.toLowerCase().split("|");
				if (_types[0] != "") { node.type = _types[0]; if (_types[1] != "") node.altertype = _types[1]; }
			}
			else if (this.VIEWParam.ResourceType.indexOf("/")>0){
				var _types = this.VIEWParam.ResourceType.toLowerCase().split("/");
				if (_types[0] != "") { node.type = _types[0]; if (_types[1] != "") node.altertype = _types[1]; }
			}
			else {
				node.type = this.VIEWParam.ResourceType.toLowerCase();
				if (node.type == "iiif") node.altertype = "";
			}
		}
		// この関数の引数を優先
		if (typeof a_resource_type !== "undefined" && a_resource_type != ""){
			if (a_resource_type.indexOf("|")>0){
				var _types = a_resource_type.toLowerCase().split("|");
				if (_types[0] != "") { node.type = _types[0]; if (_types[1] != "") node.altertype = _types[1]; }
			}
			else if (a_resource_type.indexOf("/")>0){
				var _types = a_resource_type.toLowerCase().split("/");
				if (_types[0] != "") { node.type = _types[0]; if (_types[1] != "") node.altertype = _types[1]; }
			}
			else {
				node.type = a_resource_type.toLowerCase();
				if (node.type == "iiif") node.altertype = "";
			}
		}

		if (typeof a_params.x !== "undefined") { try { node.x = parseInt(a_params.x); } catch (e) {} }
		if (typeof a_params.y !== "undefined") { try { node.y = parseInt(a_params.y); } catch (e) {} }

		if (typeof a_params.width !== "undefined") { try { node.width = parseInt(a_params.width); } catch (e) {} }
		if (typeof a_params.height !== "undefined") { try { node.height = parseInt(a_params.height); } catch (e) {} }

		// ローカル拡張
		var locpath = window.location.href;
		if (typeof a_params !== "undefined"){
			if (typeof a_params.profile === "string"){
				if (locpath.indexOf("http")==0){}
				else { node.profile = a_params.profile; }
			}
		}
	}
	return node;
};
Viewer.prototype.setForcedResource = function(a_resource, a_resource_type) {

	var node = {role:"resource", indexpath:"", path:"", field:"", name:"", type:"jpg"};

	var a_resource;
	var a_resource_type;

	if (arguments.length > 0) a_resource = arguments[0];
	if (arguments.length > 1) a_resource_type = arguments[1];

	var a_params = {}
	if (typeof arguments[2] !== "undefined") {
		a_params = arguments[2];
		this.setParams(a_params);	// 一般パラメータの解析
	}
	this.image_viewer.locator.init();	// update of parameter

	if (typeof this.VIEWParam.ResourcePath === "string" && this.VIEWParam.ResourcePath != ""){ node.path = this.VIEWParam.ResourcePath; }
	if (typeof a_params !== "undefined" && typeof a_params.path === "string") { node.path = a_params.path; }

	if (a_resource != null && a_resource != ""){

		var idx = a_resource.lastIndexOf("/");
		if (idx > 0){
			node.field = a_resource.substring(0, idx);
			node.name = a_resource.substring(idx + 1);
		}
		else {
			node.name = a_resource;
		}

		node.type = "jpg"; node.altertype = "jpg";	// 画像名のみある場合は暗黙にJPEGとする
		// 予約設定
		if (typeof this.VIEWParam.ResourceType === "string" && this.VIEWParam.ResourceType != ""){
			if (this.VIEWParam.ResourceType.indexOf("|")>0){
				var _types = this.VIEWParam.ResourceType.toLowerCase().split("|");
				if (_types[0] != "") { node.type = _types[0]; if (_types[1] != "") node.altertype = _types[1]; }
			}
			else if (this.VIEWParam.ResourceType.indexOf("/")>0){
				var _types = this.VIEWParam.ResourceType.toLowerCase().split("/");
				if (_types[0] != "") { node.type = _types[0]; if (_types[1] != "") node.altertype = _types[1]; }
			}
			else {
				node.type = this.VIEWParam.ResourceType.toLowerCase();
				if (node.type == "iiif") node.altertype = "";
			}
		}
		// この関数の引数を優先
		if (typeof a_resource_type !== "undefined" && a_resource_type != ""){
			if (a_resource_type.indexOf("|")>0){
				var _types = a_resource_type.toLowerCase().split("|");
				if (_types[0] != "") { node.type = _types[0]; if (_types[1] != "") node.altertype = _types[1]; }
			}
			else if (a_resource_type.indexOf("/")>0){
				var _types = a_resource_type.toLowerCase().split("/");
				if (_types[0] != "") { node.type = _types[0]; if (_types[1] != "") node.altertype = _types[1]; }
			}
			else {
				node.type = a_resource_type.toLowerCase();
				if (node.type == "iiif") node.altertype = "";
			}
		}

		// IIIF
		if (typeof a_params !== "undefined"){
			if (typeof a_params.width !== "undefined") { try { node.width = parseInt(a_params.width); } catch (e) {} }
			if (typeof a_params.height !== "undefined") { try { node.height = parseInt(a_params.height); } catch (e) {} }
			if (typeof a_params["tilesize"] !== "undefined") { try { node.tilesize = parseInt(a_params["tilesize"]); } catch (e) { node.tilesize = 256; } }
			//if (typeof a_params.format !== "undefined") { try { node.format = a_params.format; } catch (e) {} }	//要改修
		}

		// ローカル拡張
		var locpath = window.location.href;
		if (typeof a_params !== "undefined"){
			if (typeof a_params.profile === "string"){
				if (locpath.indexOf("http")==0){}
				else { node.profile = a_params.profile; }
			}
		}
	}

	if (node["name"] != "") {
		this.image_viewer.setForcedResource([node]);
	}
};
Viewer.prototype.forcedView = function(vx,vy,vscale) {
	// 強制位置・拡大移動,20160523
	this.image_viewer.forcedviewdata = [vx, vy, vscale];
	if (this.image_viewer.forcedviewdata){
		this.image_viewer.forcedView(this.image_viewer.forcedviewdata);
	}
};
Viewer.prototype.forcedPage = function(pageset) {
	this.image_viewer.forcedPage(pageset);
};
Viewer.prototype.updateStage = function() {
	if (this.full || !this.VIEWParam.SizeFixed){
		this.width = $(window).width() - (this.VIEWParam.Margin[0]-this.VIEWParam.Margin[2]);
		this.height = $(window).height() - (this.VIEWParam.Margin[1]-this.VIEWParam.Margin[3]);
	}
	this.viewer_div.style.width = this.width + "px";
	this.viewer_div.style.height = this.height +"px";
	this.image_viewer.updateSize(this.width, this.height);
};


function ImageViewer(parent_obj) {

	this.parent = parent_obj;

	this.x = 0; this.y = 0;
	this.width = parent_obj.width - 0; this.height = parent_obj.height - 0;

	this.image_viewer_div = document.createElement("div");
	this.image_viewer_div.className = "s14v";
	this.parent.viewer_div.appendChild(this.image_viewer_div);

	this.image_x = 0; this.image_y = 0;						// 画像
	this.image_w = this.width; this.image_h = this.height;

	this.view_w = this.width; this.view_h = this.height;			// 表示座標系
	this.half_view_w = Math.floor(this.view_w / 2); this.half_view_h = Math.floor(this.view_h / 2);

	this.ocvx = this.width / 2; this.ocvy = (this.height - 0) /2;	//仮想座標系
	this.coordinate = new Coordinate();
	this.coordinate.setInit(this.width, this.height, this.width, this.height, 1.0, 1.0, this.ocvx, this.ocvy, 0);

	// スケール
	this.layer = 0;										// レイヤー値 (0:原寸)
	this.max_layer = 0;
	this.image_res_min = 0; this.image_res_max = 0;		// FzPのレイヤー範囲
	this.image_size = 0;
	this.image_type = "jpg";
	this.plate_scale = 1;									// ImagePlateオブジェクトのスケール
	this.rel_plate_scale = 1;								// レイヤーを考慮したスケール
	this.idx_scale = 1 / this.plate_scale;					// ImagePlateオブジェクトのスケール逆数
	this.int_scale = Math.pow(2, this.layer);				// レイヤ－のスケール（元の画像にするための掛け率）
	this.plate_scale_min = 1 / 16;						// = 0.0625, 最小表示倍率
	this.plate_scale_fit = 1;
	this.LIMITSCALE_LOW = 100;						// 表示拡大率%
	this.LIMITSCALE = 100;								// 基底(0)レイヤの表示解像度％
	this.limit_plate_scale = this.LIMITSCALE / 100;
	this.limit_scale = 1 / this.limit_plate_scale;
	this.ROTATE = 0;
	this.rotate = this.ROTATE;

	this.forcedviewdata = null;
	this.actionwork = true;

	this.image_field = new ImageField(this);
	this.locator = new Locator(this);
	this.control_l = new ControllerL(this);
	this.control = new Controller(this);
}
ImageViewer.prototype.doAction = function() {
	this.updateStage();
	this.viewMove(0, 0);

	var imgo = this.image_field.image_plate.imgus[0];
	if (!this.parent.VIEWParam.LocatorEnable){
		//this.control.base.bt_locator.setEnable(false);
		this.locator.locator_div.style.display = "none";
		if (this.actionwork) {
			this.viewInit();
			this.actionwork = false;
		}
		if (this.forcedviewdata){
			this.forcedView(this.forcedviewdata);
			//this.forcedviewdata = null;
		}
	}
	else if (this.locator != null && this.locator.enable && this.locator.coordinate == null){
		//this.control.base.bt_locator.setEnable(false);
		if (this.parent.VIEWParam.LocatorImagePath) {
			if (/^(.+?:\/([^?#]*))?\/$/.test(this.parent.VIEWParam.LocatorImagePath) && /^\.(jpg|png)$/.test(this.parent.VIEWParam.LocatorImageType.toLowerCase())){
				this.locator.setResource(this.parent.VIEWParam.LocatorImagePath + imgo.resource_field + imgo.resource_name + "/" + imgo.resource_name + this.parent.VIEWParam.LocatorImageType);
			}
			else if (/^(?:\/([^\.?#]*))?\/$/.test(this.parent.VIEWParam.LocatorImagePath) && /^\.(jpg|png)$/.test(this.parent.VIEWParam.LocatorImageType.toLowerCase())){
				this.locator.setResource(this.parent.VIEWParam.LocatorImagePath + imgo.resource_field + imgo.resource_name + "/" + imgo.resource_name + this.parent.VIEWParam.LocatorImageType);
			}
		}
		else {
			switch (imgo.resource_type) {
				case "iiif":
				if (imgo.resource_altertype == ""){
					this.locator.setResource(imgo.resource_path + imgo.resource_field + imgo.resource_name + "/full/,256/0/default" + imgo.image_suffix);
				}
				else {
					this.locator.setResource(imgo.resource_path + imgo.resource_field + imgo.resource_name + "." + imgo.resource_altertype + "/full/,256/0/default" + imgo.image_suffix);
				}
				break;
				case "iiif-opossum":
				this.locator.setResource(imgo.resource_path + imgo.resource_field.replace("/","%2F") + imgo.resource_name + "." + imgo.resource_altertype + "/full/full/0/default" + imgo.image_suffix);
				break;
				case "zoomify":
				this.locator.setResource(imgo.resource_path + imgo.resource_field + imgo.resource_name + "/TileGroup0/0-0-0" + imgo.image_suffix);
				break;
				case "dzi":
				this.locator.setResource(imgo.resource_path + imgo.resource_field + imgo.resource_name + "/" + imgo.resource_name + "_files/"+imgo.fzp.image_res_offset+"/0_0" + imgo.image_suffix);
				break;
				case "fzp":
				case "fzp3":
				default:
				if (this.locator.locator_size <= 1 || this.locator.locator_size > 160) this.locator.setResource(imgo.resource_path + imgo.resource_field + imgo.resource_name + "/" + imgo.resource_name + imgo.image_suffix);
				else this.locator.setResource(imgo.resource_path + imgo.resource_field + imgo.resource_name + "/_" + imgo.resource_name + imgo.image_suffix);
			}
		}
	}

	if (this.parent.ANNOTEATFIRST){
		if (this.parent.annote_fl) {
			this.parent.annote_fl.init();
			this.parent.annote_fl.setAnnotePreview();
		}
		this.parent.ANNOTEATFIRST = false;

		this.image_field.setAnnoteviewResource();
		this.image_field.image_plate.changeAnnoteview(false);	// 初期値
	}

};
ImageViewer.prototype.actionSuccessLocator = function() {
	//this.control.base.bt_locator.setEnable(true);
	this.locator.locator_div.style.display = "block";
	this.locator.setInit(this.image_w, this.image_h, this.ocvx, this.ocvy, 0);
	this.locator.updateSize();
	this.viewInit();

	if (this.forcedviewdata){
		this.forcedView(this.forcedviewdata);
		//this.forcedviewdata = null;
	}
	//this.control.base.controller_unitc_div.style.display = "block";
};
ImageViewer.prototype.actionErrorLocator = function() {
	//this.control.base.bt_locator.setEnable(false);
	this.locator.locator_div.style.display = "none";
	this.viewMove(0, 0);
	this.viewInit();

	if (this.forcedviewdata){
		this.forcedView(this.forcedviewdata);
		//this.forcedviewdata = null;
	}
	//this.control.base.controller_unitc_div.style.display = "block";
};
ImageViewer.prototype.init = function() {
	this.field_property = this.image_field.field_property;
	this.image_x = this.field_property["x"]; this.image_y = this.field_property["y"];
	this.image_w = this.field_property["w"]; this.image_h = this.field_property["h"];
	this.image_res_min = this.field_property["res_min"]; this.image_res_max = this.field_property["res_max"];
	this.image_size = this.field_property["size"];
	this.image_type = this.field_property["type"];

	this.view_w = Math.floor(2 * this.half_view_w); this.view_h = Math.floor(2 * this.half_view_h);
	this.plate_scale_min = this.view_h / this.image_h; this.plate_scale_fit = this.view_w / this.image_w;
	this.setInitialPlateScales();
	this.CURRENT_SCALE = 1;

	// 画像中心の設定
	this.ocvx = Math.floor(this.image_x + this.image_w / 2); this.ocvy = Math.floor(this.image_y + this.image_h / 2);
	this.OCVX = this.ocvx; this.OCVY = this.ocvy;
	this.ROTATESTEP = this.parent.ROTATESTEP;
	this.rotate = this.ROTATE;

	// ロケータ初期化
	this.locator.locator_div.style.display = "none";
	//this.control.base.bt_locator.setEnable(false);

	// 座標系の初期化
	this.coordinate.setInit(this.view_w, this.view_h, this.image_w, this.image_h, this.idx_scale, this.idx_scale, this.ocvx, this.ocvy, 0);

	// 初期化
	this.control.zoomClip();
	this.viewInit();
};
ImageViewer.prototype.setForcedResource = function(ary_src_objs) {
	this.actionwork = true;
	this.src_obj = ary_src_objs[0];	// based
	this.locator.coordinate = null;

	this.image_field.removeResource();
	this.image_field.setResource(ary_src_objs);
};
ImageViewer.prototype.setPlateScale = function(t_plate_scale) {
	this.image_field.setViewScale(t_plate_scale, this.layer);
};
ImageViewer.prototype.setRelativePlateScale = function(t_plate_scale) {
	this.setPlateScale(this.getRelativePlateScale(t_plate_scale));
};
ImageViewer.prototype.getRelativePlateScale = function(t_plate_scale) {
	this.plate_scale = t_plate_scale;
	this.idx_scale = 1.0 / this.plate_scale;
	this.layer = Math.floor(Math.log(this.idx_scale) / Math.LN2);
	if (this.layer > this.image_res_max) this.layer = this.image_res_max;
	if (this.layer < this.image_res_min) this.layer = this.image_res_min;
	this.int_scale = Math.floor(Math.pow(2, this.layer));
	this.rel_plate_scale = this.int_scale * this.plate_scale;
	return this.rel_plate_scale;
};
ImageViewer.prototype.setInitialPlateScales = function() {
	if (this.image_w >= this.image_h){
		if (this.view_w >= this.view_h){
			if (this.image_w / this.image_h >= this.view_w / this.view_h){
				this.plate_scale_min = this.view_w / this.image_w;
				this.plate_scale_fit = this.view_h / this.image_h;
			} else {
				this.plate_scale_min = this.view_h / this.image_h;
				this.plate_scale_fit = this.view_w / this.image_w;
			}
		} else {
			this.plate_scale_min = this.view_w / this.image_w;
			this.plate_scale_fit = this.view_h / this.image_h;
		}
	} else {
		if (this.view_h >= this.view_w){
			if (this.image_h / this.image_w >= this.view_h / this.view_w){
				this.plate_scale_min = this.view_h / this.image_h;
				this.plate_scale_fit = this.view_w / this.image_w;
			} else {
				this.plate_scale_min = this.view_w / this.image_w;
				this.plate_scale_fit = this.view_h / this.image_h;
			}
		} else {
			this.plate_scale_min = this.view_h / this.image_h;
			this.plate_scale_fit = this.view_w / this.image_w;
		}
	}
	this.LIMITSCALE_LOW = 100;
	//this.plate_scale_min = this.plate_scale_fit;
	//this.plate_scale_min *= 1.0;

	this.limit_scale = Math.floor(Math.pow(2, this.image_res_min));
	this.limit_plate_scale = (this.LIMITSCALE / 100)/ this.limit_scale;

	this.max_layer = Math.floor(Math.log(1.0 / this.plate_scale_min) / Math.LN2 - 1.0);
	if (this.max_layer > this.image_res_max) this.max_layer = this.image_res_max;

	if (this.plate_scale_min > this.limit_plate_scale) this.plate_scale_min = this.limit_plate_scale;
	this.setRelativePlateScale(this.plate_scale_min);
};
ImageViewer.prototype.fitView = function(){
	var past_layer = this.layer;
	this.view_w = Math.floor(2 * this.half_view_w); this.view_h = Math.floor(2 * this.half_view_h);

	this.plate_scale_min = this.view_h / this.image_h;
	this.plate_scale_fit = this.view_w / this.image_w;
	this.setInitialPlateScales();

	this.ocvx = Math.floor(this.image_x + this.image_w / 2); this.ocvy = Math.floor(this.image_y + this.image_h / 2);
	this.OCVX = this.ocvx; this.OCVY = this.ocvy;
	this.rotate  = this.ROTATE;

	this.coordinate.setInit(this.view_w, this.view_h, this.image_w, this.image_h, this.idx_scale, this.idx_scale, this.ocvx, this.ocvy, 0);

	this.control.zoomClip();
	this.viewInit();
};
ImageViewer.prototype.enforcedUpdate = function() {
	this.setRelativePlateScale(this.plate_scale);
};
ImageViewer.prototype.viewInit = function () {
	this.ocvx = this.OCVX; this.ocvy = this.OCVY;
	this.rotate = this.ROTATE;
	this.setInitialPlateScales();
	this.coordinate.setInit(this.view_w, this.view_h, this.image_w, this.image_h, this.idx_scale, this.idx_scale, this.ocvx, this.ocvy, 0);
	this.locator.updateRotate(0);
	this.control.zoomClip();
	this.viewRotate(0);

	this.coordinate.updateVCenter(this.ocvx, this.ocvy);
	this.coordinate.updateCorners();
	var pnt = this.coordinate.getCorner('5');
	this.viewRotate(0);
	this.pan(pnt.x, pnt.y, true);
};
ImageViewer.prototype.forcedView = function(fvdata){
	// 強制位置・拡大移動,20160523
	// [vpx, vpy, vscale]
	this.setRelativePlateScale(fvdata[2]);
	this.coordinate.updateAbsR(this.idx_scale);
	this.control.zoomClip();
	this.viewRotate(0);
	this.coordinate.updateVCenter(fvdata[0], fvdata[1]);
	this.coordinate.updateCorners();
	var pnt = this.coordinate.getCorner('5');
	this.pan(pnt.x, pnt.y, true);
};
ImageViewer.prototype.forcedPage = function(pageset) {
	if (this.control_l) this.control_l.setPage(pageset);
};
ImageViewer.prototype.pan = function(vpx, vpy, enforce) {
	this.image_field.pann(Math.round(vpx / this.int_scale), Math.round(vpy / this.int_scale), enforce);
};
ImageViewer.prototype.moving = function(vpx, vpy) {
	this.panning();
};
ImageViewer.prototype.panning = function() {
	var p1 = this.coordinate.getCorner("7"); var p2 = this.coordinate.getCorner("9");
	var p4 = this.coordinate.getCorner("1"); var p3 = this.coordinate.getCorner("3");
	if (this.locator != null) this.locator.setBoxPosition(p1, p2, p3, p4);
	var arot = this.rotate;
	if (arot < 0) arot += 360;
	if (typeof window.s14vUpdateRect !== "undefined") {
		var vrect = this.coordinate.getD2VR(this.image_field.holdpos[0],this.image_field.holdpos[1],this.image_field.holdpos[2],this.image_field.holdpos[3]);
		var rx = vrect.x; var ry = vrect.y;
		var rw = vrect.width; var rh = vrect.height;
		switch (arot){
			case 90:
			ry = ry - (-rh);
			rh = - rh;
			break;
			case 180:
			rx = rx - (-rw);
			ry = ry - (-rh);
			rw = - rw;
			rh = - rh;
			break;
			case 270:
			rx = rx - (-rw);
			rw = - rw;
		}
		window.s14vUpdateRect(Math.floor(p1.x), Math.floor(p1.y), Math.ceil(p3.x - p1.x), Math.ceil(p3.y - p1.y), Math.floor(rx), Math.floor(ry), Math.ceil(rw), Math.ceil(rh), Math.floor(arot));
	}
	//if (typeof window.s14vUpdateRect !== "undefined") window.s14vUpdateRect(Math.floor(p1.x), Math.floor(p1.y), Math.ceil(p3.x - p1.x), Math.ceil(p3.y - p1.y));
};
ImageViewer.prototype.viewReload = function() {
	var pnt = coordinate.getCorner('5');
	this.pan(pnt.x, pnt.y, true);
};
ImageViewer.prototype.viewStepRotate = function(direction) {
	this.viewRotate(this.ROTATESTEP * direction);
};
ImageViewer.prototype.viewRotate = function(degree) {
	// Get value (0 =< -- < 360)
	if (degree == null) this.rotate = 0;
	else this.rotate = (this.rotate += degree) % 360;

	if (this.control.base.compass) this.control.base.compass.updateRotate(this.rotate);
	if (this.locator.coordinate) {
		this.locator.coordinate.updateRotate(this.rotate);
		this.locator.updateRotate(this.rotate);
	}
	//this.image_field.image_plate.updateRotate(this.rotate);
	this.coordinate.updateRotate(this.rotate);
	this.coordinate.updateCorners();
	var pnt = this.coordinate.getCorner('5');
	this.image_field.image_plate.updateRotate(this.rotate);
	this.pan(pnt.x, pnt.y, true);
};
ImageViewer.prototype.viewZoomIn = function(zoom) {
	if (this.plate_scale >= 2){ this.plate_scale = 4; }
	else if (this.plate_scale >= 1.5){ this.plate_scale = 2; }
	else if (this.plate_scale >= 1){ this.plate_scale = 1.5; }
	else if (this.plate_scale >= 0.5){ this.plate_scale = 1; }
	else if (this.plate_scale >= 0.25){ this.plate_scale = 0.5; }
	else if (this.plate_scale >= 0.125){ this.plate_scale = 0.25; }
	else if (this.plate_scale >= 0.0625){ this.plate_scale = 0.125; }
	else if (this.plate_scale >= 0.03125){ this.plate_scale = 0.0625; }
	else { this.plate_scale = 0.03125; }
	if (this.plate_scale > this.limit_plate_scale) this.plate_scale = this.limit_plate_scale;
	this.setRelativePlateScale(this.plate_scale);
	this.coordinate.updateAbsR(this.idx_scale);
	this.coordinate.updateCorners();
	this.control.zoomClip();
	var pnt = this.coordinate.getCorner('5');
	if (zoom > 0){ this.pan(pnt.x, pnt.y, true); }
};
ImageViewer.prototype.viewZoomOut = function(zoom) {
	if (this.plate_scale > 2){ this.plate_scale = 2; }
	else if (this.plate_scale > 1.5){ this.plate_scale = 1.5; }
	else if (this.plate_scale > 1){ this.plate_scale = 1; }
	else if (this.plate_scale > 0.5){ this.plate_scale = 0.5; }
	else if (this.plate_scale > 0.25){ this.plate_scale = 0.25; }
	else if (this.plate_scale > 0.125){ this.plate_scale = 0.125; }
	else if (this.plate_scale > 0.0625){ this.plate_scale = 0.0625; }
	else if (this.plate_scale > 0.03125){ this.plate_scale = 0.03125; }
	else if (this.plate_scale > 0.015625){ this.plate_scale = 0.015625; }
	else { this.plate_scale = 0.015625; }
	if (this.plate_scale <= this.plate_scale_min / (100 / this.LIMITSCALE_LOW)){
		this.plate_scale = this.plate_scale_min / (100 / this.LIMITSCALE_LOW);
		this.fitView();
	}
	else {
		this.setRelativePlateScale(this.plate_scale);
		this.coordinate.updateAbsR(this.idx_scale);
		this.coordinate.updateCorners();
		this.control.zoomClip();
		var pnt = this.coordinate.getCorner('5');
		if (zoom < 0){ this.pan(pnt.x, pnt.y, true); }
	}
};
ImageViewer.prototype.viewZoom = function(tscale) {
	this.plate_scale = tscale;
	if (this.plate_scale < this.plate_scale_min / (100 / this.LIMITSCALE_LOW)){
		this.plate_scale = this.plate_scale_min / (100 / this.LIMITSCALE_LOW);
	}
	this.setRelativePlateScale(this.plate_scale);
	this.coordinate.updateAbsR(this.idx_scale);
	this.coordinate.updateCorners();
	this.control.zoomClip();
	var pnt = this.coordinate.getCorner('5');
	this.pan(pnt.x, pnt.y, true);
};
ImageViewer.prototype.viewZoomRel = function(dscale) {
	var tscale = this.plate_scale;

	if (dscale != 0){
		if (dscale >= 0){ tscale += Math.sqrt(0.003 * dscale / 100); }
		else { tscale -= Math.sqrt(-0.003 * dscale / 100); }
		if (tscale > this.limit_plate_scale) { tscale = this.limit_plate_scale; }
		else if (tscale < this.plate_scale_min / (100 / this.LIMITSCALE_LOW)) { tscale = this.plate_scale_min / (100 / this.LIMITSCALE_LOW) }
	}

	this.plate_scale = tscale;
	this.setRelativePlateScale(this.plate_scale);
	this.coordinate.updateAbsR(this.idx_scale);
	this.coordinate.updateCorners();
	var pnt = this.coordinate.getCorner('5');
	this.control.zoomClip();
	this.pan(pnt.x, pnt.y, true);

};
ImageViewer.prototype.viewZoomGesture = function(dscale, update) {
	var tscale;
	if (dscale<0){}
	else if (dscale > 1){ tscale = this.CURRENT_SCALE * Math.sqrt(dscale); }
	else { tscale = this.CURRENT_SCALE / Math.sqrt(1/dscale); }
	if (tscale > this.limit_plate_scale) { tscale = this.limit_plate_scale; }

	if (tscale <= this.plate_scale_min / (100 / this.LIMITSCALE_LOW)){
		this.plate_scale = this.plate_scale_min / (100 / this.LIMITSCALE_LOW);
		this.fitView();
	}
	else {
		this.plate_scale = tscale;
		this.setRelativePlateScale(this.plate_scale);
		this.coordinate.updateAbsR(this.idx_scale);
		this.coordinate.updateCorners();
		this.control.zoomClip();
		var pnt = this.coordinate.getCorner('5');
		this.image_field.jump(-Math.round(pnt.x / this.int_scale), -Math.round(pnt.y / this.int_scale));
		this.image_field.updateImage(this.plate_scale);
	}
	if (update){ this.workAfter(this); }
};
ImageViewer.prototype.viewZoomGesture2 = function(d, update) {
	var t = (function(_d){ return _d >= 0 ? 1+_d/60: 1+_d/240; })(d);
	var tscale = 0;
	if (t>0) tscale = this.CURRENT_SCALE * t;	// 簡易
	if (tscale > this.limit_plate_scale) { tscale = this.limit_plate_scale; }

	if (tscale == 0) {
	} else if (tscale <= this.plate_scale_min / (100 / this.LIMITSCALE_LOW)){
		this.plate_scale = this.plate_scale_min / (100 / this.LIMITSCALE_LOW);
		this.fitView();
	}
	else {
		this.plate_scale = tscale;
		this.setRelativePlateScale(this.plate_scale);
		this.coordinate.updateAbsR(this.idx_scale);
		this.coordinate.updateCorners();
		this.control.zoomClip();
		var pnt = this.coordinate.getCorner('5');
		this.image_field.jump(-Math.round(pnt.x / this.int_scale), -Math.round(pnt.y / this.int_scale));
		this.image_field.updateImage(this.plate_scale);
	}
	if (update){ this.workAfter(this); }
	this.panning();
};
ImageViewer.prototype.setCurrentScale = function() {
	this.CURRENT_SCALE = this.plate_scale;
};
ImageViewer.prototype.workAfter = function(that) {
	that.setRelativePlateScale(that.plate_scale);
	that.viewMove(0, 0);
};
ImageViewer.prototype.viewClose = function() {
	window.close();
  return false;
};
ImageViewer.prototype.viewMove = function(tmx, tmy) {
	var value = this.coordinate.getD2V(tmx + this.half_view_w, tmy + this.half_view_h);
	if (value.x < 0 || value.y < 0 || value.y > this.image_h || value.x > this.image_w){
	}
	else {
		this.image_field.image_plate.x -= tmx; this.image_field.image_plate.y -= tmy;
		this.image_field.image_plate.updatePosition();
		var cx = tmx + this.half_view_w; var cy = tmy + this.half_view_h;
		var value = this.coordinate.getD2V(cx, cy);
		this.coordinate.updateVCenter(Math.round(value.x), Math.round(value.y));
		var pnt = this.coordinate.getCorner('5');
		this.pan(pnt.x, pnt.y, true);
	}
};
ImageViewer.prototype.viewUpdate = function() {
	var pnt = this.coordinate.getCorner('5');
	this.image_field.jump(-Math.round(pnt.x / this.int_scale), -Math.round(pnt.y / this.int_scale));
};
ImageViewer.prototype.isEnable = function() {
	return true;
};
ImageViewer.prototype.viewFullSize = function() {
	var elem = this.parent.parent_dom_node;
	if (elem.webkitRequestFullscreen) { //Chrome15+, Safari5.1+, Opera15+
		if (document.webkitFullscreenElement) { this.parent.full = false; document.webkitCancelFullScreen(); }
		else { this.parent.full = true; elem.webkitRequestFullscreen(); }
	}
	else if (elem.mozRequestFullScreen) { //FF10+
		if (document.mozFullScreenElement) { this.parent.full = false; document.mozCancelFullScreen(); }
		else { this.parent.full = true; elem.mozRequestFullScreen(); }
	}
	else if (elem.msRequestFullscreen) { //IE11+
		if (document.msFullscreenElement) { this.parent.full = false; document.msExitFullscreen(); }
		else { this.parent.full = true; elem.msRequestFullscreen(); }
	}
	else if (elem.requestFullscreen) { // HTML5 Fullscreen API
		if (document.fullScreenElement) { this.parent.full = false; document.cancelFullScreen(); }
		else { this.parent.full = true; elem.requestFullscreen(); }
	}
	else { this.parent.full = false; this.parent.updateStage(); }
};
ImageViewer.prototype.updateStage = function() {
	this.parent.updateStage();
};
ImageViewer.prototype.updateSize = function(wid, hei) {
	//this.x = 0; this.y = 0;
	this.width = wid; this.height = hei;
	this.image_viewer_div.style.width = wid + "px"; this.image_viewer_div.style.height = hei + "px";
	this.viewerResize(this.width, this.height);
	this.locator.updateSize();

	if (this.parent.annote_fl) this.parent.annote_fl.updateSize(this.width, this.height - 2 * $(this.control.controller_div).height() - 2);
};
ImageViewer.prototype.viewerResize = function(wid, hei) {
	this.view_w = wid;
	this.view_h = hei;
	this.half_view_w = Math.floor(this.view_w / 2); this.half_view_h = Math.floor(this.view_h / 2);

	this.image_field.image_field_div.style.left = "0"; this.image_field.image_field_div.style.top = "0";
	this.image_field.image_field_div.style.width = this.view_w + "px"; this.image_field.image_field_div.style.height = this.view_h + "px";

	this.control.updateSize(wid, hei);
	this.control_l.updateSize(wid, hei);

	this.image_field.image_plate.x = this.half_view_w; this.image_field.image_plate.y = this.half_view_h;
	this.image_field.image_plate.width = this.view_w; this.image_field.image_plate.height = this.view_h;
	this.image_field.image_plate.updatePosition();

	if (this.coordinate != null){
		var pnt = this.coordinate.getCorner('5');
		this.coordinate.updateComponentSize(this.view_w, this.view_h);
		this.coordinate.updateVCenter(pnt.x, pnt.y);
		this.coordinate.updateCorners();
		this.viewMove(0, 0);
	}
	else{
		this.coordinate = new Coordinate();
		this.coordinate.setInit(this.view_w, this.view_h, this.image_w, this.image_h, this.idx_scale, this.idx_scale, this.ocvx, this.ocvy, 0);
	}
};
// 範囲登録
ImageViewer.prototype.toggleEditor = function() {
	window.s14vToggleEditor();
};


function ImageField (parent_obj) {

	this.parent = parent_obj;

	this.x = 0; this.y = 0;
	this.width = 0; this.height = 0;

	this.field_property = {};
	this.resource_list = [];

	this.image_field_div = document.createElement("div");
	this.image_field_div.className = "s14f";
	this.parent.image_viewer_div.appendChild(this.image_field_div);

	this.image_plate = new ImagePlate(this);

	this.annote_overlay = null;
	if (typeof this.image_plate.imgus[1] === "object"){
		this.annote_overlay = this.image_plate.imgus[1];
		this.annote_overlay.visible = true;
	}


	this.expandEvents();
}
ImageField.prototype.setEditArea = function(array) {
};
ImageField.prototype.expandEvents = function() {

	var that = this;

  this.image_overlay_div = document.createElement("div");
  this.image_overlay_div.className = "s14ae";

	this.image_overlay_handler_div = document.createElement("div");
  this.image_overlay_handler_div.className = "s14ah";
	this.image_overlay_div.appendChild(this.image_overlay_handler_div);

	this.image_overlay_type = 1; // 1:Free, 2:Fixed
  this.image_overlay_enabled = true;

  var that_ov_enb = this.image_overlay_enabled;
  var a_hold = false;	// オブジェクト・ハンドル
  var a_handle = false;	// 大きさのハンドル
  var xi, yi, xo, yo;
  var wi, hi;

	this.holdpos = [];

  $(this.image_overlay_div).on("mousedown touchstart",function(event){
    a_hold = true;
    xi = $(this).position().left;
    yi = $(this).position().top;
    wi = $(this).width();
    hi = $(this).height();
		that.holdpos[0] = xi; that.holdpos[1] = yi;
		that.holdpos[2] = wi; that.holdpos[3] = hi;
		that.parent.panning();
		xo = Util._elemX(event, $(that.parent.parent.viewer_div).offset().left);
		yo = Util._elemY(event, $(that.parent.parent.viewer_div).offset().top);

    if (xo - xi > $(this).width()-58 && xo - xi < $(this).width()-4 && yo - yi > $(this).height()-58 && yo - yi < $(this).height()-4){
      a_handle = true;
      $(this).css("borderColor","rgba(0,255,0,0.9)");
    }
    return false;
	}).on("mouseover",function(event){
		$(this).css("backgroundColor","rgba(0,255,0,0.2)");
		return false;
	}).on("mouseout",function(event){
		$(this).css("backgroundColor","rgba(0,255,0,0.0)");
		return false;
  }).on("mousemove touchmove",function(event){
		if (a_hold) {
			if (a_handle){
				var w = wi + Util._elemX(event, $(that.parent.parent.viewer_div).offset().left) - xo;
				var h = hi + Util._elemY(event, $(that.parent.parent.viewer_div).offset().top) - yo;
				$(this).css({"width": w + "px", "height": h + "px"});
				that.holdpos[2] = w; that.holdpos[3] = h;
				that.parent.panning();
			}
			else {
				var x = xi + (Util._elemX(event, $(that.parent.parent.viewer_div).offset().left) - xo);
				var y = yi + (Util._elemY(event, $(that.parent.parent.viewer_div).offset().top) - yo);
				$(this).css({"left": x + "px", "top": y + "px"});
				that.holdpos[0] = x; that.holdpos[1] = y;
				that.parent.panning();
			}
			return false;
		}
		else {
			var tx = Util._elemX(event, $(that.parent.parent.viewer_div).offset().left) - $(this).width();
			var ty = Util._elemY(event, $(that.parent.parent.viewer_div).offset().top) - $(this).height();
			if (tx > -58 && tx < -4 && ty > -58 && ty < -4) { $(this).css("borderColor","rgba(0,255,0,0.9)"); }
			else { $(this).css("borderColor","rgba(0,255,0,0.6)"); }
			return false;
		}
  }).on("mouseup mouseleave touchend mouseout",function(event){
    a_hold = false;
    a_handle = false;
    $(this).css("borderColor","rgba(0,255,0,0.6)");
    // 現在の座標
    that.parent.panning();
    return false;
  });
  this.parent.image_viewer_div.appendChild(this.image_overlay_div);

	// ユーザーインタフェース操作用変数
	this.rootx = 0; this.rooty = 0;
	this.startx = 0; this.starty = 0;
	this.endx = 0; this.endy = 0;

	var _ua = (function(){
		return {
			Touch: typeof document.ontouchstart !== "undefined",
			Pointer: window.navigator.pointerEnabled,
			MSPoniter: window.navigator.msPointerEnabled
		}
	})();
	var _start = _ua.Pointer ? 'pointerdown' : _ua.MSPointer ? 'MSPointerDown' : _ua.Touch ? 'touchstart mousedown' : 'mousedown';
	var _move = _ua.Pointer ? 'pointermove' : _ua.MSPointer ? 'MSPointerMove' : _ua.Touch ? 'touchmove mousemove' : 'mousemove';
	var _leave = _ua.Pointer ? 'pointerleave' : _ua.MSPointer ? 'MSPointerLeave' : _ua.Touch ? 'mouseleave' : 'mouseleave'; // iOS, Androidは未定義？
	var _end = _ua.Pointer ? 'pointerup' : _ua.MSPointer ? 'MSPointerUp' : _ua.Touch ? 'touchend mouseup' : 'mouseup';

	if (_start.toLowerCase().indexOf("pointer")>=0) {
		$(this.image_plate.image_plate_div).css({"touch-action": "none", "-ms-touch-action": "none"}); /* IE10,IE11 タッチデフォルト挙動の停止 */
	}

	var m = new M(this.parent.parent.parent_dom_node, true); // #s14viewerはrelative!

	$(this.image_plate.image_plate_div).on(_start, function(event){
		event.preventDefault(); event.stopPropagation();
		$(that.parent.parent.viewer_div).off("mousewheel DOMMouseScroll");
		m.add(event);
		that.startx = Math.floor(m.startset.x);
		that.starty = Math.floor(m.startset.y);
		that.rootx = Util.removePx(event.currentTarget.style.left);
		that.rooty = Util.removePx(event.currentTarget.style.top);
		if (m.count==2) that.parent.setCurrentScale();
	}).on(_move, function(event){
		event.stopPropagation(); event.preventDefault();
		if (m.drg){
			m.update(event);
			if (m.count>2){}
			else if (m.count>1){
				if (Math.abs(m.d)>2) {
					if (that.annote_overlay != null) that.annote_overlay.visible = false;
					that.parent.viewZoomGesture2(m.d, false);
				}
			}
			else {
				that.endx = Math.floor(m.set.x);
				that.endy = Math.floor(m.set.y);
				that.image_plate.x = that.rootx + (that.endx - that.startx);
				that.image_plate.y = that.rooty + (that.endy - that.starty);
				that.image_plate.updatePosition();
			}
		}
	}).on(_leave, function(event){	// iOS, Androidは未定義？
		event.preventDefault(); event.stopPropagation();
		if (m.drg && m.isMoved()){
			m.garbage();
			var cx = that.startx - that.endx + that.parent.half_view_w;
			var cy = that.starty - that.endy + that.parent.half_view_h;
			var val = that.parent.coordinate.getD2V(cx, cy);
			that.parent.coordinate.updateVCenter(val.x, val.y);
			var pnt = that.parent.coordinate.getCorner('5');
			that.parent.pan(pnt.x, pnt.y, true);
		}
		else {
			var pnt = that.parent.coordinate.getCorner('5');
			that.parent.pan(pnt.x, pnt.y, true);
		}
	}).on(_end, function(event){
		event.preventDefault(); event.stopPropagation();
		m.remove(event);
		if (m.isDoubleTap()) {
			that.image_plate.x = that.rootx;
			that.image_plate.y = that.rooty;
			that.image_plate.updatePosition();
			var cx = that.startx;
			var cy = that.starty;
			var val = that.parent.coordinate.getD2V(cx, cy);
			that.parent.coordinate.updateVCenter(val.x, val.y);
			var pnt = that.parent.coordinate.getCorner('5');
			if (that.parent.parent.DBLZOOM){ that.parent.viewZoomIn(1); }
			else { that.parent.pan(pnt.x, pnt.y, true); }
		}
		else if (m.isMoved()){
			var cx = that.startx - that.endx + that.parent.half_view_w;
			var cy = that.starty - that.endy + that.parent.half_view_h;
			var val = that.parent.coordinate.getD2V(cx, cy);
			that.parent.coordinate.updateVCenter(val.x, val.y);
			var pnt = that.parent.coordinate.getCorner('5');
			that.parent.pan(pnt.x, pnt.y, true);
		}
		else {
			var pnt = that.parent.coordinate.getCorner('5');
			that.parent.pan(pnt.x, pnt.y, true);
		}
		if (that.annote_overlay != null) that.annote_overlay.visible = true;
		setTimeout(function(){
			// マウスホイール・イベント
			$(that.parent.parent.viewer_div).on("mousewheel", function(event) {
				that.parent.viewZoomRel(event.originalEvent.wheelDelta); // for IE, webkit
				return false;
			}).on("DOMMouseScroll", function(event) {
				that.parent.viewZoomRel(-event.originalEvent.detail * 20); // FF
				return false;
			});
		}, 200);
	});
	// タッチ抑制
	$(this.image_field_div).on("touchstart", function(event){
		event.stopPropagation(); event.preventDefault();
	});
};
ImageField.prototype.removeResource = function() {
	this.image_plate.removeResources();
};
ImageField.prototype.setResource = function(src_objs) {;
	this.image_plate.createResource(src_objs);
};
ImageField.prototype.setAnnoteviewResource = function() {
	this.image_plate.createAnnoteviewResource();
};
ImageField.prototype.pann = function(vpx, vpy, enforce) {
	if (enforce){
		this.image_plate.x = this.parent.half_view_w; this.image_plate.y = this.parent.half_view_h;
		this.image_plate.updatePosition();
		this.jump(-vpx, -vpy);
		this.afterPann(vpx, vpy, enforce);
	} else {
		this.image_plate.x = this.parent.half_view_w; this.image_plate.y = this.parent.half_view_h;
		this.image_plate.updatePosition();
		this.smooth(-vpx, -vpy);
	}
};
ImageField.prototype.afterPann = function(vpx, vpy, enforce) {
	this.loadImage(this.parent.coordinate.getCorners(), this.parent.layer);
	if (enforce){
		this.image_plate.x = this.parent.half_view_w; this.image_plate.y = this.parent.half_view_h;
		this.image_plate.updatePosition();
		this.parent.panning();
		this.jump(-vpx, -vpy);
	} else {
		this.image_plate.x = this.parent.half_view_w; this.image_plate.y = this.parent.half_view_h;
		this.image_plate.updatePosition();
		this.parent.panning();
	}
};
ImageField.prototype.init = function() {
	this.parent.init();
};
ImageField.prototype.setViewScale = function(tscale, tlevel) {
	this.image_plate.setViewScale(tscale, tlevel);
};
ImageField.prototype.updateImage = function(tscale) {
	this.image_plate.updateImage(tscale);
};
ImageField.prototype.jump = function(vpx, vpy) {
	this.image_plate.jump(vpx, vpy);
};
ImageField.prototype.smooth = function(vpx, vpy) {
	this.image_plate.smooth(vpx, vpy);
};
ImageField.prototype.loadImage = function(trect, tlevel) {
	this.image_plate.loadImage(trect, tlevel);
};


function ImagePlate (parent_obj) {

	this.parent = parent_obj;

	this.x = 0; this.y = 0;
	this.width = parent_obj.width; this.height = parent_obj.height;

	this.image_plate_div = document.createElement("div");
	this.image_plate_div.className = "s14p";
	this.parent.image_field_div.appendChild(this.image_plate_div);

	this.imgus = [];

	// 遅延工程
	this.delay = 0;
	this.cancel = false;
}
ImagePlate.prototype.removeResources = function() {
	if (this.imgus.length > 0){
		for (var i = this.imgus.length - 1; i >= 0; i--){
			if (this.imgus[i] && this.imgus[i].image_object_div){
				try{
					this.image_plate_div.removeChild(this.imgus[i].image_object_div);
					this.imgus[i] = null;
					delete this.imgus[i];
				}
				catch (e){}
			}
		}
	}
	this.imgus = [];
};
ImagePlate.prototype.createResource = function(src_objs) {

	this.cancel = true;

	for (var i=0; i<src_objs.length; i++){
		var imgu = new ImageObject(this, src_objs[i]);

		this.imgus.push(imgu);
		this.image_plate_div.appendChild(imgu.image_object_div);

		imgu.init();
	}
};
ImagePlate.prototype.createAnnoteviewResource = function () {
	// 2018-10-07, add Rokka
	if (this.imgus[1] != null) return;
	var obj = this.parent.parent.parent.annotes;
	if (obj != null) this.imgus[1] = new AnnoteObject(this);
	if (this.imgus.length > 1 && typeof this.imgus[1] !== "undefined"){
		this.imgus[1].init(obj);
	}
};
ImagePlate.prototype.changeAnnoteview = function (b_show) {
	if (this.imgus.length<2 || typeof this.imgus[1] == "undefined") return;
	this.imgus[1].active = b_show;
	if (b_show){
		$("div.s14cl").css("width","180px");
		$("#preview").css("left","0px");
		this.imgus[1].image_object_div.style.display = "block";
		this.imgus[1].updateAnnotes();
		this.updatePosition();
	}
	else if (this.imgus.length > 1){
		$("div.s14cl").css("width","60px");
		$("#preview").css("left","-180px");
		this.imgus[1].image_object_div.style.display = "none";
	}
};
ImagePlate.prototype.checkFzPComp = function() {
	var wait = 0;
	for (var i = 0; i < this.imgus.length; i++) {
		if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
			wait += this.imgus[i].fzp_comp;
		}
	}
	if (wait == 0 && this.imgus.length>0 && typeof this.imgus[0] !== "undefined"){
		var _image_w = 0;
		var _image_h = 0;
		var imgu = this.imgus[0];
		if (imgu.fzp.image_w > 0){ _image_w = imgu.fzp.image_w; }
		else { _image_w = imgu.global_w; }
		if (imgu.fzp.image_h > 0){ _image_h = imgu.fzp.image_h; }
		else { _image_h = imgu.global_h; }
		imgu.image_suffix = imgu.fzp.image_suffix;

		var _image_res_min = imgu.fzp.image_res_min;
		var _image_res_max = imgu.fzp.image_res_max;

		for (var i = 1; i < this.imgus.length; i++) {
			if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
				if (this.imgus[i].fzp.image_w > 0){
					if (_image_w < this.imgus[i].fzp.image_w + this.imgus[i].global_x) _image_w = this.imgus[i].fzp.image_w + this.imgus[i].global_x;
				} else {
					if (_image_w < this.imgus[i].global_w + this.imgus[i].global_x) _image_w = this.imgus[i].global_w + this.imgus[i].global_x;
				}
				if (this.imgus[i].fzp.image_h > 0){
					if (_image_h < this.imgus[i].fzp.image_h + this.imgus[i].global_y) _image_h = this.imgus[i].fzp.image_h + this.imgus[i].global_y;
				} else {
					if (_image_h < this.imgus[i].global_h + this.imgus[i].global_y) _image_h = this.imgus[i].global_h + this.imgus[i].global_y;
				}
				if (_image_res_min > this.imgus[i].fzp.image_res_min) _image_res_min = this.imgus[i].fzp.image_res_min;
				if (_image_res_max < this.imgus[i].fzp.image_res_max) _image_res_max = this.imgus[i].fzp.image_res_max;
				this.imgus[i].image_suffix = this.imgus[i].fzp.image_suffix;
			}
		}
		this.parent.field_property["x"] = 0;
		this.parent.field_property["y"] = 0;
		this.parent.field_property["w"] = _image_w;
		this.parent.field_property["h"] = _image_h;
		this.parent.field_property["res_min"] = _image_res_min;
		this.parent.field_property["res_max"] = _image_res_max;
		this.parent.field_property["size"] = this.imgus.length;
		this.parent.field_property["type"] = imgu.resource_type;

		if (imgu.fzp.image_service == "IIIF" && (_image_w > 0 && _image_h > 0)) {
			if (false && this.parent.parent.forcedviewdata){ this.parent.init(); }
			else { this.delay = this.parent.parent.parent.LOAD_DELAY_TIME; this.cancel = false; imgu.baseview = 0; this.parent.init(); imgu.loadPreImage(); }
		}	// IIIF
		else if (imgu.fzp.image_service == "IIIF-OPOSSUM" && (_image_w > 0 && _image_h > 0)) {
			if (false && this.parent.parent.forcedviewdata){ this.parent.init(); }
			else { this.delay = this.parent.parent.parent.LOAD_DELAY_TIME; this.cancel = false; imgu.baseview = 0; this.parent.init(); imgu.loadPreImage(); }
		}	// IIIF(Opossum)
		else if (imgu.fzp.image_service == "FZP3" && (_image_w > 0 && _image_h > 0)) { this.parent.init(); }	// FzP 3.0
		else if (imgu.fzp.image_service == "FZP" && (_image_w > 0 && _image_h > 0)) { this.parent.init(); }	// FzP 1.0〜1.3
		else if (imgu.fzp.image_service == "FZP0" && (_image_w > 0 && _image_h > 0)) { this.parent.init(); }	// FzP 0.9
		else if (imgu.fzp.image_service == "ZOOMIFY" && (_image_w > 0 && _image_h > 0)) { this.parent.init(); }
		else if (imgu.fzp.image_service == "DZ" && (_image_w > 0 && _image_h > 0)) { this.parent.init(); }
		else if (imgu != null && typeof imgu !== "undefined"){ this.parent.init(); imgu.loadImage(); }
	}
};
ImagePlate.prototype.setViewScale = function(tscale, tlevel) {
	for (var i = 0; i < this.imgus.length; i++) {
		if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
			this.imgus[i].setViewScale(tscale, tlevel);
		}
	}
};
ImagePlate.prototype.updateImage = function(tscale) {
	for (var i = 0; i < this.imgus.length; i++) {
		if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
			this.imgus[i].updateImage(tscale);
		}
	}
};
ImagePlate.prototype.updateRotate = function(trot) {
	for (var i = 0; i < this.imgus.length; i++) {
		if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
			this.imgus[i].updateRotate(trot);
		}
	}
};
ImagePlate.prototype.jump = function(vpx, vpy) {
	for (var i = 0; i < this.imgus.length; i++) {
		if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
			this.imgus[i].jump(vpx, vpy);
		}
	}
};
ImagePlate.prototype.smooth = function(vpx, vpy) {
	for (var i = 0; i < this.imgus.length; i++){
		if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
			this.imgus[i].smooth(vpx, vpy);
		}
	}
};
ImagePlate.prototype.loadImage = function(trect, tlevel) {
	for (var i = 0; i < this.imgus.length; i++){
		if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
			var imgu = this.imgus[i];
			switch (imgu.resource_type){
				case "iiif":
				case "iiif-opossum":
				if (this.delay > 0) {
					var that = this;
					setTimeout(function(){
						if (!that.cancel) imgu.loadFzpImage(trect, tlevel);
						that.delay = 0;
					}, this.delay);
				}
				else {
					if (!this.cancel) imgu.loadFzpImage(trect, tlevel);
				}
				break;

				case "fzp":
				case "fzp3":
				case "zoomify":
				case "dzi":
				imgu.loadFzpImage(trect, tlevel);
				break;

				case "jpg":
				case "png":
				case "gif":
				imgu.loadImage();
				this.parent.parent.viewUpdate();
				break;
			}
		}
	}
};
ImagePlate.prototype.errorLoaded = function() {
	for (var i = 1; i < this.imgus.length; i++){
		if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
			this.imgus[i] = null;
		}
	}
	try{
		var obj = this.imgus[0].layers["layer_0"].tiles["tile_0"];
		if (obj != null && typeof obj.width !== "undefined") {
			this.parent.field_property["image_x"] = 0;
			this.parent.field_property["image_y"] = 0;
			this.parent.field_property["image_w"] = obj.width;
			this.parent.field_property["image_h"] = obj.height;

			this.parent.init();
			this.parent.parent.doAction();
		}
	} catch (e){}
};
ImagePlate.prototype.checkLoaded = function() {
	var wait = 0;
	for (var i = 0; i < this.imgus.length; i++){
		if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
			wait += this.imgus[i].comp;
		}
		else { wait++; }
	}
	if (wait == 0) this.parent.parent.doAction();
};
ImagePlate.prototype.checkNotFzpLoaded = function(tx, ty, tw, th) {
	var wait = 0;
	for (var i = 0; i < this.imgus.length; i++){
		if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
			wait += this.imgus[i].comp;
		}
		else { wait++; }
	}
	if (wait == 0 && tw > 0 && th > 0) {
		this.parent.field_property["x"] = tx;
		this.parent.field_property["y"] = ty;
		this.parent.field_property["w"] = tw;
		this.parent.field_property["h"] = th;
		this.parent.init();
		this.parent.parent.doAction();
	}
};
ImagePlate.prototype.updatePosition = function() {
	this.image_plate_div.style.left = this.x + "px"; this.image_plate_div.style.top = this.y + "px";
	for (var i = 0; i < this.imgus.length; i++){
		if (typeof this.imgus[i] !== "undefined" && this.imgus[i] != null) {
			var imgu = this.imgus[i];
			var scale = this.parent.parent.plate_scale;
			imgu.image_object_div.style.left = scale * imgu.global_x + "px"; imgu.image_object_div.style.top = scale * imgu.global_y + "px";
		}
	}
};


function ImageObject (parent_obj, resource_item) {

	this.parent = parent_obj;

	this.oid = 0;
	this.x = 0; this.y = 0;
	this.width = parent_obj.width; this.height = parent_obj.height;

	this.image_object_div = document.createElement("div");
	this.image_object_div.className = "s14o";
	this.parent.image_plate_div.appendChild(this.image_object_div);

	// 例外対応
	if (resource_item == null || typeof resource_item === "undefined"){ this.parent.parent.parent.image_viewer_div.style.display = "none"; return; }
	this.resource_path = resource_item["path"];

	if (typeof resource_item["field"] !== "undefined" && resource_item["field"] != ""){ this.resource_field = resource_item["field"] + "/"; }
	else { this.resource_field = ""; }
	this.resource_name = resource_item["name"];
	this.resource_type = resource_item["type"].toLowerCase();
	this.resource_altertype = resource_item["altertype"].toLowerCase();
	this.resource_tilesize = 256;
	if (typeof resource_item["tilesize"] === "number" && resource_item["tilesize"] >= 128 && resource_item["tilesize"] <= 512) { this.resource_tilesize = resource_item["tilesize"]; }
	this.image_suffix = ".jpg";
	this.access_limiter = this.parent.parent.parent.parent.VIEWParam.AccessLimiter;

	this.local_profile;
	if (typeof resource_item["profile"] === "string"){
		this.local_profile = resource_item["profile"];
	}

	this.global_x = resource_item["x"] || 0;
	this.global_y = resource_item["y"] || 0;
	this.global_w = resource_item["width"] || 0;
	this.global_h = resource_item["height"] || 0;

	this.layd = {};
	this.current_level = -1; this.past_level = -1;
	this.tiles = null;
	this.fzp = new FreezoomPack();
	this.fzp_comp = null;
	this.comp = 1;

	// 予呼び出し
	this.basesize = 512;
	this.basemag　= -1;
	this.baseview = 0;
}
ImageObject.prototype.init = function() {
	function loadFzpAjax(that, property_file) {
		if (that.local_profile){
			loadFzpFile(that, that.local_profile);
		}
		else {
			$.ajax({
				type: "GET",
				url: that.resource_path + that.resource_field + that.resource_name + "/" + property_file,
				dataType: 'xml',
				success: function(obj){ afterWork(obj, that); },
				error: function(){ that.resource_type = that.resource_altertype; afterWork(null, that); }
			});
		}
	}
	function loadFzpFile(that, property_file_text) {
		var file = new File([property_file_text], "temp.txt", {
			type: "text/xml",
			lastModified: 0
		});
		var reader = new FileReader();
		reader.onloadend = function(e){
			var xml = e.target.result;
			var parser = new DOMParser();
      var dom = parser.parseFromString(xml,'text/xml');
			afterWork(dom, that);
		};
		reader.readAsText(file);
	}
	function afterWork(req, that) {
		that.fzp.load(req, that.resource_path + that.resource_field, that.resource_name, that.resource_type);
		if (that.resource_type.indexOf("fzp") == 0 && that.fzp.image_service == "PLAIN") { that.resource_type = that.resource_altertype; that.fzp.tiles_class = null; }
		that.loadedFzpHandler();
	}
	function prepareFzp(that) {
		// IIIF 2015-08-09
		that.fzp.prepare(that);
		that.loadedFzpHandler();
	}
	function loadIIIFInfoAjax(that, property_file) {
		// IIIF 2018-07-22
		var altertype = "";
		if (that.resource_altertype != "") altertype = "." + that.resource_altertype;
		$.ajax({
			type: "GET",
			url: that.resource_path + that.resource_field + that.resource_name + altertype + "/" + property_file,
			dataType: 'json',
			success: function(json){
				if (typeof json["tiles"] !== "undefined" && typeof json["tiles"][0] !== "undefined" && typeof json["tiles"][0]["width"] !== "undefined"){
					that.resource_tilesize = json["tiles"][0]["width"];
				}
				if (typeof json["width"] !== "undefined" && typeof json["height"] !== "undefined"){
					that.global_w = json["width"];
					that.global_h = json["height"];
					prepareFzp(that);
				}
				else if (that.global_w <= 0 || that.global_h <= 0){
					that.resource_type = that.resource_altertype;
					afterWork(null, that);
				}
			},
			error: function(){
				prepareFzp(that);
			}
		});
	}

	if (this.resource_type == "fzp"){ loadFzpAjax(this, "root.xml"); }
	else if (this.resource_type == "fzp3"){ loadFzpAjax(this, "root.xml"); }
	else if (this.resource_type == "iiif"){ loadIIIFInfoAjax(this, "info.json"); }	// IIIF
	else if (this.resource_type == "iiif-opossum"){ loadIIIFInfoAjax(this, "info.json"); }	// IIIF(Opossum)
	else if (this.resource_type == "zoomify"){ loadFzpAjax(this, "ImageProperties.xml"); }
	else if (this.resource_type == "dzi"){ loadFzpAjax(this, this.resource_name + ".dzi"); }
	else { afterWork(null, this); }
};
ImageObject.prototype.loadedFzpHandler = function() {
	this.removeImageLevels();
	this.createImageLevels(this.fzp.image_res_min, this.fzp.image_res_max);
	this.fzp_comp = 0;
	this.parent.checkFzPComp();
};
ImageObject.prototype.removeImageLevels = function() {
	for (var layer in this.layd){
		if (this.layd[layer] != null && typeof this.layd[layer].image_layer_div !== "undefined"){
			this.image_object_div.removeChild(this.layd[layer].image_layer_div);
			this.layd[layer] = null;
			delete this.layd[layer];
		}
	}
};
ImageObject.prototype.createImageLevels = function(min_level, max_level) {
	for (var i = max_level; i >= min_level; i--){ this.layd["n" + i] = new ImageLayer(this, i); }
};
ImageObject.prototype.clearImageTiles = function() {
	for (var level = this.fzp.image_res_min; level <= this.fzp.image_res_max; level++){
		if ((level < this.current_level || level > this.current_level + 1) && level < this.parent.parent.parent.max_layer){
			if (this.layd["n" + level].tiles_array.length > 0){ this.layd["n" + level].clearTiles(); }
		}
	}
};
ImageObject.prototype.postLoaded = function(success) {
	if (success){
		if (typeof this.layd["n" + this.current_level] !== "undefined"){
			if (this.layd["n" + this.current_level].image_layer_div.style.visibility == "visible"){ this.clearImageTiles(); }
			else { this.layd["n" + this.current_level].image_layer_div.style.visibility = "visible"; }
		}

		this.comp = 0;

		switch (this.resource_type){
			case "fzp":
			case "fzp3":
			case "iiif":
			case "iiif-opossum":
			case "zoomify":
			case "dzi":
				if (this.past_level >= 0 && this.current_level - this.past_level > 0){
					if (typeof this.layd["n" + this.past_level] !== "undefined") this.layd["n" + this.past_level].image_layer_div.style.visibility = "hidden";
				}
				this.setViewScale(this.parent.parent.parent.rel_plate_scale, this.current_level);
				this.parent.checkLoaded();
				break;
			case "jpg":
			case "png":
			case "gif":
				if (this.fzp.image_w > 0 && this.fzp.image_h > 0){
					var obj = this.layd["n0"].tiled["t0"];
					if (typeof obj.width !== "undefined" && typeof obj.height !== "undefined" && obj.width > 0 && obj.height > 0){
						obj.reScale(0, 0, this.fzp.image_w / obj.width, this.fzp.image_h / obj.height);
						obj.rotation = this.global_rotation;
						obj.alpha = 1.0;
						this.parent.checkLoaded();
					}
				} else {
					var obj = this.layd["n0"].tiled["t0"];
					if (typeof obj.width !== "undefined" && typeof obj.height !== "undefined" && obj.width > 0 && obj.height > 0){
						if (this.global_w > 0 || this.global_h > 0){
							obj.reScale(0, 0, this.global_w / obj.width, this.global_h / obj.height);
							obj.rotation = this.global_rotation;
							obj.alpha = 1.0;
							this.parent.checkNotFzpLoaded(this.global_x, this.global_y, this.global_w, this.global_h);
						} else {
							this.parent.checkNotFzpLoaded(this.global_x, this.global_y, obj.width, obj.height);
						}
					}
				}
				break;
		}
	}
	else {
		this.comp = 1;

		switch (this.resource_type){
			case "fzp":
			case "fzp3":
			case "iiif":
			case "iiif-opossum":
			case "zoomify":
			case "dzi":
				this.setViewScale(this.parent.parent.parent.rel_plate_scale, this.current_level);
		}
	}
};
ImageObject.prototype.loadPreImage = function() {
	var toppath = this.parent.parent.parent.parent;
	var sizecode = "512,";
	if (this.fzp.image_h > this.fzp.image_w) sizecode = ",512";
	var altertype = '';
	if (this.resource_altertype != ''){
		altertype = "." + this.resource_altertype;
	}
	var loadpath = this.resource_path + this.resource_field + this.resource_name + altertype + "/full/" + sizecode + "/0/default" + this.image_suffix;

	if (toppath.VIEWParam.LocatorImagePath) {
		if (/^(.+?:\/([^?#]*))?\/$/.test(toppath.VIEWParam.LocatorImagePath) && /^\.(jpg|png)$/.test(toppath.VIEWParam.LocatorImageType.toLowerCase())){
			loadpath = toppath.VIEWParam.LocatorImagePath + this.resource_field + this.resource_name + toppath.VIEWParam.LocatorImageType;
		}
		else if (/^(?:\/([^\.?#]*))?\/$/.test(toppath.VIEWParam.LocatorImagePath) && /^\.(jpg|png)$/.test(toppath.VIEWParam.LocatorImageType.toLowerCase())){
			loadpath = toppath.VIEWParam.LocatorImagePath + this.resource_field + this.resource_name + toppath.VIEWParam.LocatorImageType;
		}
	}

	switch (this.resource_type){
		case "iiif":
			if (this.layd["n"+this.fzp.image_res_max] != null && typeof this.layd["n"+this.fzp.image_res_max].tiled["t0"] === "undefined"){
				this.current_level = this.fzp.image_res_max;
				this.layd["n"+this.fzp.image_res_max].loadJpeg(loadpath);
			}
			break;
		case "iiif-opossum":
			if (this.layd["n"+this.fzp.image_res_max] != null && typeof this.layd["n"+this.fzp.image_res_max].tiled["t0"] === "undefined"){
				this.current_level = this.fzp.image_res_max;
				loadpath = this.resource_path + this.resource_field.replace("/","%2F") + this.resource_name + "." + this.resource_altertype + "/full/full/0/default" + this.image_suffix;
				this.layd["n"+this.fzp.image_res_max].loadJpeg(loadpath);
			}
			break;
	}
};
ImageObject.prototype.loadImage = function() {
	switch (this.resource_type){
		case "jpg":
		case "png":
		case "gif":
			if (this.layd["n0"] != null && typeof this.layd["n0"].tiled["t0"] === "undefined"){
				this.current_level = 0;
				this.layd["n0"].loadJpeg(this.resource_path + this.resource_field + this.resource_name + "." + this.resource_type);
			}
			break;
	}
	this.setViewScale(this.parent.parent.parent.rel_plate_scale, 0);
};
ImageObject.prototype.loadFzpImage = function(trect, tlevel) {
	var rect = new LmRectangle(trect.x - this.global_x, trect.y - this.global_y, trect.width, trect.height);
	if (this.fzp.tiles_class != null){
		this.tiles = this.fzp.tiles_class.getTiles(tlevel, rect);

		if (this.layd["n" + tlevel] == null) {
				if (this.current_level >= this.fzp.image_res_min){
					var reducelevel = Math.pow(2, this.current_level - tlevel);
					var rect = new LmRectangle((trect.x - trect.width / reducelevel - this.global_x), (trect.y - trect.height / reducelevel - this.global_y) / reducelevel, trect.width * reducelevel, trect.height * reducelevel);
					this.tiles = this.fzp.tiles_class.getTiles(this.current_level, rect);
				}
				if (this.fzp.image_service == "IIIF-OPOSSUM"){
					this.layd["n" + this.current_level].loadTiles(this.resource_path + this.resource_field.replace("/","%2F") + this.resource_name + "." + this.resource_altertype + "/", this.fzp.tiles_class.viewrect, this.current_level, this.tiles);
				}
				else if (this.fzp.image_service == "IIIF"){
					if (this.resource_altertype == ""){
						this.layd["n" + this.current_level].loadTiles(this.resource_path + this.resource_field + this.resource_name + "/", this.fzp.tiles_class.viewrect, this.current_level, this.tiles);
					}
					else {
						this.layd["n" + this.current_level].loadTiles(this.resource_path + this.resource_field + this.resource_name + "." + this.resource_altertype + "/", this.fzp.tiles_class.viewrect, this.current_level, this.tiles);
					}
				}
				else if (this.fzp.image_service == "DZ"){
					this.layd["n" + this.current_level].loadTiles(this.resource_path + this.resource_field + this.resource_name + "/" + this.resource_name + "_files/", this.fzp.tiles_class.viewrect, this.current_level, this.tiles);
				}
				else {
					this.layd["n" + this.current_level].loadTiles(this.resource_path + this.resource_field + this.resource_name + "/", this.fzp.tiles_class.viewrect, this.current_level, this.tiles);
				}
		}
		else if (this.layd["n" + tlevel].busy) {
		}
		else {
			if (this.current_level != tlevel){
				this.setViewScale(Math.pow(2, this.current_level - tlevel) * this.parent.parent.parent.plate_scale * this.parent.parent.parent.int_scale, this.current_level);
			}
			if (this.fzp.image_service == "IIIF-OPOSSUM"){
				this.layd["n" + tlevel].loadTiles(this.resource_path + this.resource_field.replace("/","%2F") + this.resource_name + "." + this.resource_altertype + "/", this.fzp.tiles_class.viewrect, tlevel, this.tiles);
			}
			else if (this.fzp.image_service == "IIIF"){
				if (this.resource_altertype == ""){
					this.layd["n" + tlevel].loadTiles(this.resource_path + this.resource_field + this.resource_name + "/", this.fzp.tiles_class.viewrect, tlevel, this.tiles);
				}
				else {
					this.layd["n" + tlevel].loadTiles(this.resource_path + this.resource_field + this.resource_name + "." + this.resource_altertype + "/", this.fzp.tiles_class.viewrect, tlevel, this.tiles);
				}
			}
			else if (this.fzp.image_service == "DZ"){
				this.layd["n" + tlevel].loadTiles(this.resource_path + this.resource_field + this.resource_name + "/" + this.resource_name + "_files/", this.fzp.tiles_class.viewrect, tlevel, this.tiles);
			}
			else {
				this.layd["n" + tlevel].loadTiles(this.resource_path + this.resource_field + this.resource_name + "/", this.fzp.tiles_class.viewrect, tlevel, this.tiles);
			}
		}
	}
	this.setViewScale(this.parent.parent.parent.rel_plate_scale, tlevel);

	try{
		if (typeof this.layd["n" + this.current_level] !== "undefined") this.layd["n" + tlevel].image_layer_div.style.visibility = "visible";

		if (Math.abs(this.current_level - tlevel) > 0){
			if (typeof this.layd["n" + tlevel] !== "undefined"){
				if (typeof this.layd["n" + this.current_level] !== "undefined") this.layd["n" + this.current_level].image_layer_div.style.visibility = "hidden";
				this.past_level = this.current_level;
				this.current_level = tlevel;
			}
		}
	} catch (e){}
};
ImageObject.prototype.setViewScale = function(tscale, tlevel) {
	switch (this.resource_type){
		case "iiif":
		case "iiif-opossum":
			for (var level = this.fzp.image_res_min; level <= this.fzp.image_res_max; level++){
				if (typeof this.layd["n" + level] !== "undefined"){
					var mag = Math.pow(2, level - tlevel);
					if (level==this.fzp.image_res_max) {
						var tile_size_info = this.fzp.tiles_class.getTileInfoList(this.fzp.image_res_max,0,0);
						var thumbnail_base = this.layd["n" + this.fzp.image_res_max].tiled['t0'];
						if (thumbnail_base && typeof thumbnail_base.width !== "undefined") {
							this.basesize = Math.max(thumbnail_base.width,thumbnail_base.height);
						}
						this.basemag = mag * Math.max(tile_size_info[4],tile_size_info[5]) / this.basesize;
						this.layd["n" + level].reScale(tscale, tscale, this.basemag);
					}
					else {
						this.layd["n" + level].reScale(tscale, tscale, mag);
					}
				}
			}
			break;
		case "fzp":
		case "fzp3":
		case "zoomify":
		case "dzi":
			for (var level = this.fzp.image_res_min; level <= this.fzp.image_res_max; level++){
				if (typeof this.layd["n" + level] !== "undefined"){
					var mag = Math.pow(2, level - tlevel);
					this.layd["n" + level].reScale(tscale, tscale, mag);
				}
			}
			break;
		case "jpg":
		case "png":
		case "gif":
			if (this.layd["n" + this.current_level] != null && typeof this.layd["n" + this.current_level] !== "undefined"){
				var _scale = tscale / this.parent.parent.parent.int_scale;
				this.layd["n0"].reScale(_scale, _scale, 1.0);
			}
			break;
	}
};
ImageObject.prototype.updateRotate = function(trot) {
	this.image_object_div.style["-webkit-transform"] = "rotate("+trot+"deg)";
	//this.image_object_div.style["-moz-transform"] = "rotate("+trot+"deg)";
	this.image_object_div.style.MozTransform = "rotate("+trot+"deg)";
	this.image_object_div.style["-o-transform"] = "rotate("+trot+"deg)";
	this.image_object_div.style["-ms-transform"] = "rotate("+trot+"deg)";
	this.image_object_div.style["transform"] = "rotate("+trot+"deg)";
};
ImageObject.prototype.updateImage = function(tscale) {
	switch (this.resource_type){
		case "fzp":
		case "fzp3":
		case "iiif":
		case "iiif-opossum":
		case "zoomify":
		case "dzi":
			var tlevel = this.parent.parent.parent.layer;
			this.setViewScale(this.parent.parent.parent.plate_scale * this.parent.parent.parent.int_scale, tlevel);
			break;
		case "jpg":
		case "png":
		case "gif":
			var tlevel = this.parent.parent.parent.layer;
			this.setViewScale(this.parent.parent.parent.plate_scale * this.parent.parent.parent.int_scale, tlevel);
			break;
	}
};
ImageObject.prototype.jump = function(vpx, vpy) {
	switch (this.resource_type){
		case "fzp":
		case "fzp3":
		case "iiif":
		case "iiif-opossum":
		case "zoomify":
		case "dzi":
			for (var level = this.fzp.image_res_min; level <= this.fzp.image_res_max; level++){
				if (typeof this.layd["n" + level] !== "undefined") { var _mag = this.layd["n" + level].mag; this.layd["n" + level].jump(vpx / _mag, vpy / _mag); }
			}
			break;
		case "jpg":
		case "png":
		case "gif":
			this.layd["n0"].jump(vpx * this.parent.parent.parent.int_scale, vpy * this.parent.parent.parent.int_scale);
			break;
	}
};
ImageObject.prototype.smooth = function(vpx, vpy) {
	switch (this.resource_type){
		case "fzp":
		case "fzp3":
		case "iiif":
		case "iiif-opossum":
		case "zoomify":
		case "dzi":
			for (var level = this.fzp.image_res_min; level <= this.fzp.image_res_max; level++){
				if (typeof this.layd["n" + level] !== "undefined") { var _mag = this.layd["n" + level].mag; this.layd["n" + level].smooth(vpx / _mag, vpy / _mag); }
			}
			break;
		case "jpg":
		case "png":
		case "gif":
			this.layd["n0"].smooth(vpx * this.parent.parent.parent.int_scale, vpy * this.parent.parent.parent.int_scale);
			break;
	}
};


function ImageLayer (parent_obj, level) {

	this.parent = parent_obj;

	this.x = 0; this.y = 0;
	this.width = parent_obj.width; this.height = parent_obj.height;
	this.scaleX = 1; this.scaleY = 1;
	this.scaleXX = 1; this.scaleYY = 1;
	this.mag = 1;

	this.image_layer_div = document.createElement("div");
	this.image_layer_div.className = "s14y";
	this.parent.image_object_div.appendChild(this.image_layer_div);

	this.orbit_index = 0; this.orbit_pattern = [1,3,5,8,10,12];
	this.xmove = [0,0,0,0,0,0]; this.ymove = [0,0,0,0,0,0];
	this.tvpx = 0; this.tvpy = 0;
	this.busy = false;

	this.tiles_array = [];
	this.tiled = {};
}
ImageLayer.prototype.loadTiles = function(resource_path, trect, tlevel, ttiles) {
	this.busy = true;
	for (var i = this.tiles_array.length - 1; i >= 0; i--){
		if (trect.length==3 && (this.tiles_array[i][1] < trect[0] || this.tiles_array[i][2] < trect[1] || this.tiles_array[i][1] > trect[2] || this.tiles_array[i][2] > trect[3])) {
			try {
				if (this.tiled["t" + this.tiles_array[i][0]] != null && typeof this.tiled["t" + this.tiles_array[i][0]] !== "undefined"){
					this.image_layer_div.removeChild(this.tiled["t" + this.tiles_array[i][0]].image_tile_img);
					this.tiled["t" + this.tiles_array[i][0]] = null;
				}
			} catch (error){ }
		}
	}

	if (ttiles.length>0) this.parent.parent.parent.parent.control.unitsw.indicator.init(ttiles.length);

	var index = 0;
	for (i = 0; i < ttiles.length; i++){
		var tile = ttiles[i][1];
		var tilename = tile.getDefaultTileName();
		if (typeof this.tiled["t" + tilename] === "undefined" || this.tiled["t" + tilename] == null){
			this.tiled["t" + tilename] = new ImageTile(this, i);
			this.tiled["t" + tilename].x = tile.xwork(1);
			this.tiled["t" + tilename].y = tile.ywork(1);
			var k = this.tiles_array.length;
			while (k > 0){ var _tilename = this.tiles_array[--k][0]; if (_tilename == tilename){ k = -1; } }
			if (k == 0){ this.tiles_array.push([tilename, tile.xindex, tile.yindex, tile.xwork(1), tile.ywork(1), tile.wwork(1), tile.hwork(1), tile.nxwork(1), tile.nywork(1)]); }
			this.image_layer_div.appendChild(this.tiled["t" + tilename].image_tile_img);
			if (this.parent.fzp.image_service == "IIIF"){ this.tiled["t" + tilename].loadImage(tile.getImageRangeUrl(resource_path)); }
			else if (this.parent.fzp.image_service == "IIIF-OPOSSUM"){ this.tiled["t" + tilename].loadImage(tile.getImageRangeUrl(resource_path)); }
			else if (this.parent.fzp.image_service == "FZP"){ this.tiled["t" + tilename].loadImage(tile.getImageUrl(resource_path, this.parent.fzp.image_code_layer, this.parent.fzp.image_code_name)); }
			else if (this.parent.fzp.image_service == "FZP3"){ this.tiled["t" + tilename].loadImage(tile.getExtendImageUrl(resource_path)); }
			else if (this.parent.fzp.image_service == "ZOOMIFY"){ this.tiled["t" + tilename].loadImage(tile.getExtendImageUrl(resource_path)); }
			else if (this.parent.fzp.image_service == "DZ"){ this.tiled["t" + tilename].loadImage(tile.getExtendImageUrl(resource_path)); }
			else { this.tiled["t" + tilename].loadImage(tile.getDefaultImageUrl(resource_path)); } // FZP0, Other FzP, Ver. 0.9
			index++;
		}
	}
	this.busy = false;
};
ImageLayer.prototype.loadJpeg = function(resource_path) {
	this.tiles_array.push(["0", 0, 0, 0, 0, -1, -1, -1, -1]);
	this.tiled["t0"] = new ImageTile(this);
	this.tiled["t0"].x = 0; this.tiled["t0"].y = 0;
	this.tiled["t0"].loadImage(resource_path);
};
ImageLayer.prototype.clearTiles = function() {
	this.busy = true;
	while (this.tiles_array.length > 0){
		var tile_array = this.tiles_array.pop();
		try {
			if (this.tiled["t" + tile_array[0]] != null && typeof this.tiled["t" + tile_array[0]] !== "undefined"){
				this.image_layer_div.removeChild(this.tiled["t" + tile_array[0]].image_tile_img);
				this.tiled["t" + tile_array[0]] = null;
			}
		} catch (error){ }
	}
	this.busy = false;
};
ImageLayer.prototype.checkLoaded = function() {
	var wait = 0;
	for (var i = 0; i < this.tiles_array.length; i++){
		if (this.tiled["t" + this.tiles_array[i][0]] != null && typeof this.tiled["t" + this.tiles_array[i][0]] !== "undefined"){
			wait += this.tiled["t" + this.tiles_array[i][0]].comp;
		}
	}

	this.parent.parent.parent.parent.control.unitsw.indicator.set(wait);

	if (wait == 0) { this.parent.postLoaded(true); }
	else { this.parent.postLoaded(false); }
};
ImageLayer.prototype.reScale = function(scalex, scaley, mag) {
	this.mag = mag;
	this.scaleX = scalex * mag; this.scaleY = scaley * mag;
	for (var i = 0; i < this.tiles_array.length; i++){
		if (this.tiled["t" + this.tiles_array[i][0]] != null && typeof this.tiled["t" + this.tiles_array[i][0]] !== "undefined"){
			this.tiled["t" + this.tiles_array[i][0]].reScale(this.tiles_array[i][3], this.tiles_array[i][4], this.tiles_array[i][7], this.tiles_array[i][8], this.scaleX, this.scaleY, this.scaleXX, this.scaleYY);
		}
	}
};
ImageLayer.prototype.jump = function(vpx, vpy) {
	this.x = vpx * this.scaleX / 1.00; this.y = vpy * this.scaleY / 1.00;
	this.image_layer_div.style.left = this.x + "px"; this.image_layer_div.style.top = this.y + "px";
};
ImageLayer.prototype.smooth = function(vpx, vpy) {
	this.tvpx = vpx; this.tvpy = vpy;
	this.makeOrbit(vpx * this.scaleX / 1.00, vpy * this.scaleY / 1.00);
	this.orbit_index = 0;
	var that = this;
	this.smooth_id = setInterval(function(){ that.onOrbitTick(); }, 40);
};
ImageLayer.prototype.makeOrbit = function(tx, ty) {
	var dx = (tx - this.x) / 12; var dy = (ty - this.y) / 12;
	var i = 0;
	while (i < 6){
		this.xmove[i] = Math.floor(dx * this.orbit_pattern[i]) + this.x;
		this.ymove[i] = Math.floor(dy * this.orbit_pattern[i]) + this.y;
		i++;
	}
};
ImageLayer.prototype.onOrbitTick = function() {
	this.x = this.xmove[this.orbit_index];
	this.y = this.ymove[this.orbit_index];
	this.image_layer_div.style.left = this.x + "px";
	this.image_layer_div.style.top = this.y + "px";
	this.orbit_index++;
	if (this.orbit_index > 5) this.onOrbitCompTick();
};
ImageLayer.prototype.onOrbitCompTick = function() {
	clearInterval(this.smooth_id);
	this.parent.parent.parent.afterPann(this.tvpx, this.tvpy, false);
};


function ImageTile (parent_obj, id) {

	this.parent = parent_obj;

	this.loaded = 1;
	this.comp = 1;

	this.x = 0; this.y = 0;
	this.width; this.height; // = undefined

	this.id = id;

	this.alphanum = 1.0;

	this.imageviewer;

	this.image_tile_img = document.createElement("img");
	this.image_tile_img.className = "s14t";
	this.image_tile_img.setAttribute("unselectable","on");
	this.parent.image_layer_div.appendChild(this.image_tile_img);

	this.timer_id;
	this.var_alpha = -0.2;
}
ImageTile.prototype.loadImage = function(file_path) {
	if (this.loaded) { this.loaded = 0; }
	var that = this;
	if (this.parent.tiles_array[this.id] != null){
		this.reScale(this.parent.tiles_array[this.id][3], this.parent.tiles_array[this.id][4], this.parent.tiles_array[this.id][7], this.parent.tiles_array[this.id][8], this.parent.scaleX, this.parent.scaleY, this.parent.scaleXX, this.parent.scaleYY);
	}
	this.image_tile_img.addEventListener("load", function(event){ that.compLoadImage(event); }, false);
	this.image_tile_img.addEventListener("error", function(event){ that.errorImage(event); }, false);
	this.image_tile_img.setAttribute("src", file_path);
};
ImageTile.prototype.compLoadImage = function(event) {
	if (typeof event.currentTarget.naturalWidth !== "undefined") { this.width = event.currentTarget.naturalWidth; this.height = event.currentTarget.naturalHeight; }
	else { this.width = event.target.width; this.height = event.target.height; }
	if (this.parent.tiles_array[this.id] != null){
		this.reScale(this.parent.tiles_array[this.id][3], this.parent.tiles_array[this.id][4], this.parent.tiles_array[this.id][7], this.parent.tiles_array[this.id][8], this.parent.scaleX, this.parent.scaleY, this.parent.scaleXX, this.parent.scaleYY);
	}
	this.image_tile_img.style.opacity = "0.0";
	this.image_tile_img.style.visibility = "visible";
	var that = this;
	this.image_tile_img.removeEventListener("load", that.compLoadImage, false);
	this.image_tile_img.removeEventListener("error", that.errorImage, false);
	this.timer_id = setInterval(function(){
		that.var_alpha = that.var_alpha + 0.3;
		if (that.var_alpha>0) that.image_tile_img.style.opacity = String(that.var_alpha);
		if (that.var_alpha>=0.8){
			clearInterval(that.timer_id);
			that.image_tile_img.style.opacity = "1.0";
		}
	},50);
	this.comp = 0;
	this.parent.checkLoaded();
};
ImageTile.prototype.errorImage = function(event) {
	this.width = 0; this.height = 0;
	this.image_tile_img.style.opacity = "0.0";
	this.image_tile_img.style.visibility = "hidden";
	var that = this;
	this.image_tile_img.removeEventListener("load", that.compLoadImage, false);
	this.image_tile_img.removeEventListener("error", that.errorImage, false);
	this.comp = 1; //読み込み未完了
	this.parent.checkLoaded();
};
ImageTile.prototype.reScale = function(x, y, nx, ny, xscale, yscale, xxscale, yyscale) {
	try{
		this.x = x * xscale;
		this.y = y * yscale;
		this.image_tile_img.style.left = Math.floor(this.x) + "px";
		this.image_tile_img.style.top = Math.floor(this.y) + "px";
		if (typeof this.width !== "undefined"){
			if (nx<0 || ny<0){
				this.image_tile_img.style.width = Math.round(this.width * xscale * xxscale) + "px";
				this.image_tile_img.style.height = Math.round(this.height * yscale * yyscale) + "px";
			} else {
				this.image_tile_img.style.width = (Math.floor(nx * xscale ) - Math.floor(this.x)) + "px";
				this.image_tile_img.style.height = (Math.floor(ny * yscale) - Math.floor(this.y)) + "px";
			}
		}
	} catch(e){}
};


// ======================================================


$(function(){

	Util.extend(Stack, {
		member: {}, // ビューア・オブジェクト・フォルダ
		order: [], // ビューア・オブジェクト・数値ID配列
		cross: function(i){
			return i ? 0 : 1;
		}
	});

	Util.extend(ShimakumaViewer, {
		version: function () {
			return "Shimakuma-Green(3.1811)";  // バージョン
		},
		init: function (target_element_id, params) {

			var _ui = {};
			_ui.nid = 0;					// ビューアの数値ID
			_ui.UI_Element = null;				// 配置先DOMオブジェクト

			var _vars = {};
			_vars.ResourcePath = "resources/";		// 画像フォルダ位置（HTML相対）
			_vars.ResourceName = null;			//
			_vars.ResourceType = "fzp|jpg";		// 画像形式、優先順
			_vars.LocatorImagePath = null;			//
			_vars.LocatorImageType = ".jpg";		// ロケータの画像拡張子
			_vars.LocatorImageSize = 128;			// ロケータのサイズ（128: default, 101〜512)
			_vars.LocatorImageColor = "#f00";		// ロケータカラー
			_vars.LocatorEnable = true;			// ロケータの表示
			_vars.Rot = 0;					// 回転（初期値）
			_vars.Lmt = "50,100";				// 表示拡大率制限範囲（表示フィット,拡大値上限）パラメータ変更可能
			_vars.Lrun = "";				// Safari用アプリ製作時にLocalでの利用を有効化
			_vars.ControllerLayout = true;			// コントローラのレイアウト true(default):vertical, false:Horizontal

			// Options
			_vars.AccessLimiter = 0;			// 表示解像度の強制制限
			_vars.UseLeftControl = false;			// 左サイドのコントローラの表示（ページ対応時の移動ボタン）
			_vars.UseClose = true;				// Closeボタンの表示
			_vars.UseFull = true;				// Fullボタンの表示
			_vars.UseRotation = true;			// Rotationボタンの表示
			_vars.SizeFixed = false;			// ビューアサイズの固定（デフォルト：ウィンドウにフィット）
			_vars.Margin = [0,0,0,0];			// ビューアのマージン
			_vars.PageDirection = true;			// ページ遷移方向（RL:false, other: true）

			_vars.UsePreview = false;			// プレビュー（外部オプション）
			_vars.UseAnnotes = false;			// アノテーション（外部オプション）
			_vars.UseAnnoteEditor = false;			// アノテーション編集（外部オプション）

			_ui.UI_Element = window.document.getElementById(target_element_id);
			if (params != null){
				if (typeof params.path === "string") _vars.ResourcePath = params.path;
				if (typeof params.name === "string") _vars.ResourceName = params.name;
				if (typeof params.type === "string") _vars.ResourceType = params.type;
				if (typeof params.rotation === "number") _vars.Rot = params.rotation;
				if (params.locator && typeof params.locator === "object") {
					if (typeof params.locator.path === "string") _vars.LocatorImagePath = params.locator.path;
					if (typeof params.locator.image === "string") _vars.LocatorImageType = params.locator.image;
					if (typeof params.locator.size === "number") _vars.LocatorImageSize = params.locator.size;
					if (typeof params.locator.color === "string") _vars.LocatorImageColor = params.locator.color;
					if (typeof params.locator.enable === "boolean") _vars.LocatorEnable = !!params.locator.enable;
				}
				if (typeof params.limit === "number") _vars.Lmt = "100," + params.limit;
				if (typeof params.accesslimiter === "number") _vars.AccessLimiter = params.accesslimiter;
				if (typeof params.useleftcontrol === "boolean") _vars.UseLeftControl = !!params.useleftcontrol;
				if (typeof params.useclose === "boolean") _vars.UseClose = !!params.useclose;
				if (typeof params.usefull === "boolean") _vars.UseFull = !!params.usefull;
				if (typeof params.userotation === "boolean") _vars.UseRotation = !!params.userotation;
				if (typeof params.sizefixed === "boolean") _vars.SizeFixed = !!params.sizefixed;
				if (typeof params.margin === "object") _vars.Margin = params.margin;
				if (typeof params.pagedirection === "string") _vars.PageDirection = !(params.pagedirection.indexOf("RL")==0);

				if (typeof params.preview === "object") _ui.UI_Preview = params.preview;
				if (typeof params.edittool === "boolean") _vars.UseAnnoteEditor = params.edittool;

				if (typeof params.horizontallayout === "boolean") _vars.ControllerLayout = !params.horizontallayout;
			}
			_ui.nid = Stack.order.length;
			var s14viewer = new Viewer(_ui, _vars);
			Stack.member[target_element_id] = s14viewer;
			if (typeof params.interlock === "boolean" && params.interlock == true){
				Stack.order.push(target_element_id);
			}
			ShimakumaViewer.updateFrame();
		},
		loadIn: function(target_element_id, params) {
			var s14viewer = Stack.member[target_element_id];
			if (s14viewer == null) return;
			if (Array.isArray(params)){
				s14viewer.setForcedMultiResources(params);
			}
			else {
				if (typeof params.type === "string" && (params.type == "xml" || params.type == "json" || params.type == "html")){
					s14viewer.setIndex(params.name, params.type, params);
				}
				else if (typeof params.name === "string"){ s14viewer.setForcedResource(params.name, params.type, params); }
			}
		},
		forcedIn: function(target_element_id, params) {
			if (Util.countObj(Stack.member) == 0) { ShimakumaViewer.loadIn(target_element_id, params); }
			else {
				var s14viewer = Stack.member[target_element_id];

				s14viewer.image_viewer.forcedviewdata = null;
				s14viewer.setForcedResource(params.name, params.type, params);
				if ($(window).width()<768){
					setTimeout(function(){
						s14viewer.image_viewer.control.beyond.forcedPreview(false);
					},200);
				}
			}
		},
		forcedView: function (target_element_id, string_view_rect) {
			// 強制移動
			var s14viewer = Stack.member[target_element_id];
			try {
				var sv = string_view_rect.split(",");
				if (sv.length == 4 && !isNaN(sv[0]) && !isNaN(sv[1]) && !isNaN(sv[2])&& !isNaN(sv[3])){
					v = [parseInt(sv[0]),parseInt(sv[1]),parseInt(sv[2]),parseInt(sv[3])];
					w = $(window).width(); h = $(window).height();
					if (s14viewer) {
						s14viewer.forcedView( v[0]+v[2]/2, v[1]+v[3]/2, (w/v[2]+h/v[3])/2 );
					}
				}
				else { s14viewer.image_viewer.forcedviewdata = null; }
			}
			catch (e) { s14viewer.image_viewer.forcedviewdata = null; }
		},
		forcedPage: function (target_element_id, pageset) {
			// 強制ページ操作
			var s14viewer = Stack.member[target_element_id];
			if (s14viewer) {
				s14viewer.forcedPage( pageset );
			}
		},
		updateFrame: function (){
			for (var key in Stack.member){

				var s14viewer = Stack.member[key];
				var _ui = s14viewer.UIParam;
				var _vars = s14viewer.VIEWParam;

				if (_vars.SizeFixed) {
					if (typeof window.s14vUpdateSize !== "undefined") window.s14vUpdateSize(0,0);
				}
				$(window).scrollTop(0);

				var viewer_elem = s14viewer.parent_dom_node; // _ui.UI_Elementと同じ
				if (!_vars.SizeFixed) {
					if (typeof window.s14vAdjustSize !== "undefined"){
						var _adjust = window.s14vAdjustSize();
						$(viewer_elem).css({"left":"0","top":"0","margin":"0","width":_adjust["width"]+"px","height":_adjust["height"]+"px"});
						s14viewer.parent_dom.offsetx = $(viewer_elem).offset().left;
						s14viewer.parent_dom.offsety = $(viewer_elem).offset().top;
						s14viewer.width = s14viewer.parent_dom.width = _adjust["width"];
						s14viewer.height = s14viewer.parent_dom.height = _adjust["height"];
					}
					else {
						s14viewer.parent_dom.offsetx = $(viewer_elem).offset().left;
						s14viewer.parent_dom.offsety = $(viewer_elem).offset().top;
						s14viewer.width = s14viewer.parent_dom.width = $(viewer_elem).width();
						s14viewer.height = s14viewer.parent_dom.height = $(viewer_elem).height();
					}
				}
				else {
					s14viewer.parent_dom.offsetx = $(viewer_elem).offset().left;
					s14viewer.parent_dom.offsety = $(viewer_elem).offset().top;
					s14viewer.width = s14viewer.parent_dom.width = $(viewer_elem).width();
					s14viewer.height = s14viewer.parent_dom.height = $(viewer_elem).height();
				}
				s14viewer.updateStage();
				if (!_vars.SizeFixed) {
					if (typeof window.s14vUpdateSize !== "undefined") {
						if (s14viewer.annote_fl) s14viewer.annote_fl.updateSize(s14viewer.width,s14viewer.height - 122);
						window.s14vUpdateSize(s14viewer.width,s14viewer.height);
					}
				}
			}
		},
		orientationChangeHandler: function () {
			if (window.orientation == 0 || window.orientation == 180){ document.body.setAttribute("orient", "portrait"); }
			else { document.body.setAttribute("orient", "landscape"); }
			ShimakumaViewer.updateFrame();
		},
		hideTool: function(){
			$(".s14c_editor").hide();
			$(".s14c_annote").hide();
		},
		showTool: function(){
			for (var key in Stack.member){
				var s14viewer = Stack.member[key];
				//var _ui = s14viewer.UIParam;
				var _vars = s14viewer.VIEWParam;
				if (_vars.UseAnnoteEditor) {
					$(".s14c_editor").fadeIn();
					break;
				}
			}
			$(".s14c_annote").fadeIn();
		}
	});

	$(window).on("resize",function(event){
		ShimakumaViewer.updateFrame();
	});
	$(window).on("orientationchange", function(event){
		ShimakumaViewer.orientationChangeHandler();
	});

	setTimeout(function(){
		ShimakumaViewer.updateFrame();
		ShimakumaViewer.showTool();
	},2000);

});

}(window, window.jQuery, IPALLETORG.Shimakuma.Viewers, IPALLETORG.Shimakuma.Viewer, IPALLETORG.Shimakuma.Indexer, IPALLETORG.Util));
