# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1906r2
## - Date: 2019-06-10
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3.1906) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

import os
import io
import datetime
import re
import json
import urllib
from gluon.sanitizer import sanitize

from PIL import Image
import pyvips


mr_datahelper = local_import('mr_datahelper', reload=MR_CONF['RELOAD'])
mr_helper = local_import('mr_helper', reload=MR_CONF['RELOAD'])
mr_manifesthelper = local_import('mr_iiifmanifesthelper', reload=MR_CONF['RELOAD'])


def __precheck():
    """
    該当しなければログインを通過
    2018-11
    """
    if auth.user.id < 5 and not ( request.env.remote_addr in configuration.get('myconfig.allowances') or request.env.remote_addr.startswith(configuration.get('myconfig.local_ip')) ):
        redirect(URL('staff','user',args=['logout']))

    if session.auth.user is not None and session.groupid is None:
        session.groupid = db(db.auth_membership.user_id==session.auth.user.id).select().first().group_id

    # 制限
    if session.groupid > MR_CONF['GROUP_EDITOR']:
        redirect(URL('staff','user',args=['logout']))


@auth.requires_login()
def user():
    """
    ユーザー認証
    2018-11
    """
    auth.settings.controller = 'staff'
    return dict(form=auth())


@auth.requires_login()
def index():
    """
    トップ,ページ
    2018-11/2019-06
    """
    __precheck()

    # 引数（ページID）の取得
    pageid = 1  #デフォルト
    if len(request.args) > 0:
        pageid = request.args(0, cast=int) or 1

    # ページの内容（ページ・セクション）一覧
    # ページがpageidであるページセクション（複数）の取得
    da = mr_datahelper.d_d_page(dbm, pageid)

    dom_div = DIV(_class='m-content')

    title = da['title'] or T('Undefined')

    for d_d in da['array']:

        dom_section = TAG.section(
                        *[H2(mr_helper.__helper_br(v['value'])) for v in d_d['title']]
                        ,DIV(
                            *[P(mr_helper.__helper_br(v['value']),_class='') for v in d_d['description']]
                            ,_class='m-div-text'
                        )
                        ,DIV(
                            SPAN(T(d_d['date'][0]['label']),': ',XML(d_d['date'][0].get('value','')) or XML('&mdash;'))
                            ,XML('&nbsp'),'|',XML('&nbsp;'),SPAN(T(d_d['creator'][0]['label']),': ',XML(d_d['creator'][0].get('value','')) or XML('&mdash;'))
                            ,_class='m-div-info'
                        )
                        ,_class='m-page-section'
                    )
        dom_div.append(dom_section)

    # サイドメニュー索引の作成
    dom_sidemenu = __get_sidemenu()

    return dict(sidemenu=dom_sidemenu, title=title, dom=dom_div)


def __form_search():
    """
    検索フォーム（最小）
    2018-11
    """
    form = FORM(
                DIV(
                    DIV(
                        INPUT(
                            _type='search'
                            ,_placeholder=T('Search words')
                            ,_name='q'
                            ,_class='form-control'
                        )
                        ,_class='col col-8'
                    )
                    ,DIV(
                        TAG.button(
                            I(_class='fa fa-search')
                            ,T('Search')
                            ,_type='submit'
                            ,_name='dosearch'
                            ,_class='btn btn-primary'
                        )
                        ,_class='col col-4'
                    )
                    ,_class='formgroup row m-search-box'
                )
            )

    return form


@auth.requires_login()
def items():
    """
    アイテム・リスト
    2018-11/2019-06
    """
    __precheck()

    # 引数（コレクションID）の取得
    collid = 0  #デフォルト
    if len(request.args) > 0:
        collid = request.args(0, cast=int) or 0

    l_query = []

    form = __form_search()

    if form.accepts(request, session, keepvalues=True):
        #response.flash = T('form accepted')
        l_query = sanitize(form.vars.get('q')).split()

    elif form.errors:
        response.flash = T('form has errors')
    else:
        #response.flash = T('please fill the form')
        pass

    # コレクション指定リソース一覧
    #da = mr_datahelper.d_d_collection(dbm, collid, l_query)  # Deprecated(3.1906)
    da = mr_datahelper.d_d_finder(dbm, collid, l_query, (session.groupid < MR_CONF['GROUP_USER']))

    session.imgs = {}

    # コレクションがcollidであるリソース（複数）の取得
    dom_div = DIV(_class='m-content')

    title = da['title'] or T('Undefined')

    for d_d in da['array']:

        dom_items = TAG.dl(_class='col col-12')
        for ky in d_d['keyset']:
            if not ky in ['title','description']:
                if ky in d_d and d_d[ky]['value'] is not None:
                    dom_item1 = TAG.dt(d_d[ky].get('label',T('(Undefined)')))
                    dom_item2 = TAG.dd(d_d[ky].get('value',''))
                    dom_items.append(dom_item1)
                    dom_items.append(dom_item2)

        dom_resource = DIV(
                        DIV(
                            __image_ul_for_items(session, d_d)
                            ,_class='col'
                        )
                        ,DIV(
                            H4(A(d_d['title'].get('value','')
                                ,_href=URL('item',args=[d_d['subid']])
                                )
                            )
                            ,DIV(
                                P(mr_helper.__helper_br(d_d['description'].get('value',[''])),_class='col col-12')
                                ,dom_items
                                ,_class='row'
                            )
                            ,_class='col'
                        )
                        ,_class='row m-resource-block'
                    )

        dom_div.append(dom_resource)

    # サイドメニュー索引の作成
    dom_sidemenu = __get_sidemenu()

    return dict(sidemenu=dom_sidemenu, title=title, dom=dom_div, form=form, da=da, q=l_query)


@auth.requires_login()
def item():
    """
    リソース・アイテム
    2018-11/2019-06
    """
    __precheck()

    # 引数（リソースID）の取得
    resourceid = 1  #デフォルト
    if len(request.args) > 0:
        resourceid = request.args(0, cast=int) or 1

    # リソース
    da = mr_datahelper.d_d_resource(dbm, resourceid, (session.groupid < MR_CONF['GROUP_USER']))

    session.imgs = {}

    # リソースがresourceidであるリソースアイテム（複数）の取得
    dom_div = DIV(_class='m-content')

    title = da['title'] or T('Undefined')

    for d_d in da['array']:

        dom_resource = DIV(
                        H2(d_d['title'].get('value',''))
                        ,DIV(
                            P(mr_helper.__helper_br(d_d['description'].get('value','')),_class='col col-12')
                            ,TABLE(*[
                                TR(TD(d_d[ky]['label'], _class='m-label'),TD(mr_helper.__helper_br(d_d[ky].get('value','')))) for ky in d_d['keyset']
                                if (ky not in ('title','description')) and (ky in d_d) and (d_d[ky]['value'] is not None)
                            ],_class='col col-12')
                            ,_class='row'
                        )
                        ,__image_ul_for_eachitem(session, d_d, ['area'], True)
                        ,DIV(
                            __get_dom_attribution_table(d_d)   # 外部Manifest対応
                            ,_class='row'
                        )
                        ,_class='m-resource-item'
                    )
        dom_div.append(dom_resource)

    # サイドメニュー索引の作成
    dom_sidemenu = __get_sidemenu()

    return dict(sidemenu=dom_sidemenu, title=title, dom=dom_div, da=da)


def __form_edit(a_id = 0, enable_format = False):
    """
    ビューア編集フォーム
    2018-11/2019-06
    """

    aopts = [OPTION(x[0],_value=x[1]) for x in ([T('Annotation'),2],)]
    if enable_format:
        aopts = [OPTION(x[0],_value=x[1]) for x in ([T('Annotation'),2],[T('Segment'),1])]

    form = FORM(
                DIV(
                    DIV(
                        INPUT(
                            _name='aname'
                            ,_placeholder=T('Annotation Name')
                            ,_class='form-control'
                        )
                        ,TEXTAREA(
                            _rows=2
                            ,_name='atext'
                            ,_placeholder=T('Text')
                            ,_class='form-control'
                        )
                        ,DIV(
                            INPUT(
                                #_type='text'
                                _name='aarea'
                                ,_placeholder=T('Area')
                                ,_class='form-control col-7'
                                ,requires=IS_NOT_EMPTY()
                            )
                            ,INPUT(
                                #_type='text'
                                _name='arot'
                                #,_placeholder=T('Rotate')
                                ,_value='0'
                                ,_class='form-control col-3'
                            )
                            ,_class="row m-edit-control"
                        )
                    )
                    ,DIV(
                        SELECT(
                            aopts
                            ,_name='atype'
                            ,_value=2
                            ,value=2
                            ,_class='form-control col-4'
                        )
                        ,SELECT(
                            [OPTION(x[0],_value=x[1]) for x in ([T('New'),'new'],[T('Update'),'update'],[T('Delete'),'delete'])]
                            ,_name='afunc'
                            ,_value='new'
                            ,value='new'
                            ,_class='form-control col-2'
                        )
                        ,TAG.button(
                            T('Action')
                            #,_type='submit'
                            ,_name='doentry'
                            ,_class='btn m-primary col-3'
                        )
                        #,TAG.button(
                        #    T('Cancel')
                        #    ,_name='docancel'
                        #    ,_class='btn col-3'
                        #)
                        ,_class="row m-edit-control"
                    )
                    ,_class='formgroup m-entry-box'
                )
                ,hidden=dict(baseid='1',canvasid='',aid=str(a_id))
            )

    return form


@auth.requires_login()
def editor():
    """
    アノテーション編集
    2019-06
    """
    var_r_id = 1
    var_f_id = 1
    var_a_id = 0
    var_ids = [1,1,1,1]
    var_external = False

    var_target = tuple(request.args)

    if var_target in session.imgs:
        var_ids = session.imgs[var_target]
        (var_r_id,var_folder_id,var_f_id,var_a_id) = var_ids

    var_manifest = None
    var_f_manifest = None

    var_folder = None
    var_name = None
    var_format = None

    #var_on_annote = False
    var_accept = False
    var_mes = T('Fill Label.')

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            # IIIF Manifest
            if request.args[1]=='external':
                r_row = dbm.mr_resources[var_r_id]
                if r_row.mr_manifest_id:
                    var_manifest = r_row.mr_manifest_id
                else:
                    var_manifest = r_row.mr_manifest_link
                var_external = True
            else:
                var_manifest = '/'.join(request.args)
        else:
            var_folder = sanitize(request.args(0))
            var_name = sanitize(request.args(1))
            var_format = sanitize(request.args(2))
        #if 'annote' in request.args:
        #    var_on_annote = True

    form = __form_edit(var_a_id, True) #, (var_format=='tif' or var_format=='jp2'))

    if form.accepts(request, session, keepvalues=False):

        var_a_id = int(request.vars.get('aid') or 0)
        var_area = sanitize(form.vars.get('aarea')).split(',')
        var_arot = int(form.vars.get('arot') or 0.0)
        var_name = sanitize(form.vars.get('aname'))
        var_text = sanitize(form.vars.get('atext'))
        var_f_id = int(request.vars.get('baseid') or 1)
        var_f = request.vars.get('canvasid')
        if var_f.startswith('http://') or var_f.startswith('https://'):
            var_f_manifest = var_f

        var_type = 'rect'
        if int(form.vars.get('atype') or 2) == 1:
            var_type = 'area'
        var_function = sanitize(form.vars.get('afunc','new'))
        if var_function not in ('new','update','delete',):
            var_function = 'new'

        d = {}
        d.setdefault('mr_annote_area', [int(v or 0) for v in var_area])
        d.setdefault('mr_annote_rotation', var_arot)
        d.setdefault('mr_name', var_name)
        d.setdefault('mr_text', var_text)
        #d.setdefault('mr_name', var_name)
        d.setdefault('mr_annote_type', var_type)    # area,rect
        if var_type == 'rect':
            d.setdefault('mr_annote_data', [int(v) for v in var_area])
        d.setdefault('mr_resource_id', var_r_id)
        d.setdefault('mr_file_id', var_f_id)

        if var_external:
            d.setdefault('mr_manifest_id', var_manifest)
            d.setdefault('mr_manifest_canvas_id', var_f_manifest)

        d.setdefault('mr_open', True)

        try:
            if var_function == 'delete':
                dbm((dbm.mr_annotes.id>1) & (dbm.mr_annotes.id==var_a_id)).delete()
                var_mes = T('Success delete.')
            else:
                dbm.mr_annotes.update_or_insert((dbm.mr_annotes.id>1) & (dbm.mr_annotes.id==var_a_id),**dbm.mr_annotes._filter_fields(d))
                if var_a_id > 1:
                    var_mes = T('Success update.')
                else:
                    var_mes = T('Success entry.')
            dbm.commit()
            var_accept = True

        except:
            dbm.rollback()
            var_mes = T('Mistake entry.')

    elif form.errors:
        var_mes = T('Form has errors.')
    else:
        pass

    return dict(message=var_mes, form=form, onaccept=var_accept)


@auth.requires_login()
def viewer():
    """
    画像表示
    2018-11/2019-06
    """
    __precheck()

    var_r_id = 1
    var_folder_id = 1
    var_f_id = 1
    var_a_id = 0
    var_ids = [1,1,1,1]
    var_external = False

    var_target = tuple(request.args)

    if var_target in session.imgs:
        var_ids = session.imgs[var_target]
        (var_r_id,var_folder_id,var_f_id,var_a_id) = var_ids

    var_manifest = None
    var_f_manifest = ''

    var_folder = None
    var_name = None
    var_format = None

    var_on_annote = False

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            # IIIF Manifest
            if request.args[1]=='external':
                r_row = dbm.mr_resources[var_r_id]
                if r_row.mr_manifest_id:
                    var_manifest = r_row.mr_manifest_id
                else:
                    var_manifest = r_row.mr_manifest_link
                var_external = True
            else:
                var_manifest = '/'.join(request.args)
        else:
            var_folder = sanitize(request.args(0))
            var_name = sanitize(request.args(1))
            var_format = sanitize(request.args(2))
        if 'annote' in request.args:
            var_on_annote = True

    return dict(vmanifest=var_manifest, vfolder=var_folder, vname=var_name, vformat=var_format, preview=UL(), subview=UL(), infoview='', idset=var_ids, external=var_external)


# ========================================
# IIIF Manifest
# 2018-11
# ========================================

@auth.requires_login()
def iiif():
    """
    IIIF Presentation API 2.1
    2018-11/2019-06
    """
    __precheck()

    # 引数（ファイルID/アノテーションID）の取得
    resourceid = 1  # Default
    folderid = 1  # Default
    fileid = 1  # Default
    annoteid = 1  # Default
    req_api_type = 'manifest.json'
    if len(request.args) > 1:
        domain = sanitize(request.args(0))
        if domain == 'annote':
            annoteid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'file':
            fileid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'folder':
            folderid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'resource':
            resourceid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        else:
            domain = 'resource'
            resourceid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))

    if req_api_type.startswith('manifest'):

        if domain == 'annote':
            da = mr_datahelper.d_d_annote(dbm, annoteid)
        elif domain == 'file':
            da = mr_datahelper.d_d_file(dbm, fileid)
        elif domain == 'folder':
            da = mr_datahelper.d_d_folder(dbm, folderid)
        else:
            da = mr_datahelper.d_d_resource(dbm, resourceid, (session.groupid < MR_CONF['GROUP_USER']))
            #da = mr_datahelper.d_d_resource(dbm, resourceid)

        # get Manifest JSON
        json_ld = mr_manifesthelper.__get_iiif_manifest(MR_CONF, da['array'])

        return response.json(json_ld)

    elif req_api_type.startswith('annotationlist'):

        if domain == 'resource':
            cvid = None
            if 'cvid' in request.vars:
                cvid = request.vars.get('cvid')

            da = mr_datahelper.d_d_canvas(dbm, cvid, resourceid)

        #elif domain == 'file':
        #    da = mr_datahelper.d_d_file(dbm, fileid)
        else:
            da = mr_datahelper.d_d_file(dbm, fileid)

        # get Annotation List JSON
        json_ld = mr_manifesthelper.__get_iiif_annotationlist(MR_CONF, da['array'])

        return response.json(json_ld)

    else:
        return response.json({})


# ========================================
# Test
# 2018-11/2019-05
# ========================================

@auth.requires_login()
def test_elementset():
    """
    要素セットを返す（評価用）
    2018-11/2019-05
    """
    # 引数の取得
    classid = 1
    if len(request.args) > 0:
        classid = request.args(0, cast=int) or 1

    return mr_datahelper.d__elementset(dbm, classid)


@auth.requires_login()
def test_datahelper():
    """
    データを返す（評価用）
    2018-11/2019-06
    """
    # 引数の取得
    ids = [1,1,1,1]
    if len(request.args) > 1:
        target = request.args[0]
        for i,v in enumerate([int(v1) for v1 in request.args(1).split(',')]):
            ids[i] = v or 1

    if target == 'page':
        return mr_datahelper.d_d_page(dbm, int(request.args(1)) or 1)
    elif target == 'collection':
        return mr_datahelper.d_d_collection(dbm, int(request.args(1)) or 1)
    elif target == 'resource':
        return mr_datahelper.d_d_resource(dbm, ids[0], (session.groupid < MR_CONF['GROUP_USER']))
    elif target == 'folder':
        return mr_datahelper.d_d_folder(dbm, ids[0])
    elif target == 'file':
        return mr_datahelper.d_d_file(dbm, ids[0])
    elif target == 'annote':
        return mr_datahelper.d_d_annote(dbm, ids[0])
    elif target == 'canvas':
        return mr_datahelper.d_d_canvas(dbm, '', int(request.args(1)) or 1)
    else:
        return dict(target=target, array=[])


# ========================================
# Side menu
# 2018-11/2019-05
# ========================================

def __get_sidemenu(a_offset=0, a_limit=20):
    """
    Side menuを取得する
    2018-11/2019-05
    """
    # サイドメニュー索引の作成
    dom_div = DIV(_class='m-leftside')

    ul = UL(_class='list-group list-group-flush m-collection')

    li = LI(A(T('Home'),_href=URL('index')),_class="list-group-item")
    ul.append(li)

    for r in dbm((dbm.mr_collections._id>1)&(dbm.mr_collections.mr_open==True)).select(orderby=[dbm.mr_collections.mr_order,dbm.mr_collections.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('items',args=[str(r.id)])),_class="list-group-item")
        ul.append(li)

    for r in dbm((dbm.mr_pages._id>1)&(dbm.mr_pages.mr_open==True)).select(orderby=[dbm.mr_pages.mr_order,dbm.mr_pages.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('index',args=[str(r.id)]),_class=""),_class="list-group-item")
        ul.append(li)

    dom_div.append(ul)

    return dom_div


# ========================================
# Thumbnail image
# 2018-11/2019-05
# ========================================

def __get_dom_icon_manifest(d_d):
    """
    Manifest link
    2018-11/2019-05
    """
    a_href = ['iiif',d_d['role'],str(d_d['subid']),'manifest.json']
    a_manifest = SPAN(A(
        IMG(
            _src=URL('static','mr_images/iiif_logo.png')
            ,_width='32'
        )
        ,_href=URL('iiif',args=[d_d['role'],d_d['subid'],'manifest.json'])
        ,_target='_blank'
        ,_title='IIIF-Manifest'
        )
        ,_class="m-manifest-link")

    return (a_manifest, a_href)


def __get_dom_icon_manifest_external(d_d):
    """
    Manifest link
    2019-05
    """
    a_href = ['iiif','external',str(d_d['ids'][0]),'manifest.json']
    a_manifest = SPAN(A(
        IMG(
            _src=URL('static','mr_images/iiif_logo.png')
            ,_width='32'
        )
        ,_href='%s://%s%s' % (d_d['href'][0],d_d['href'][1],d_d['href'][2])
        ,_target='_blank'
        ,_title='IIIF-Manifest'
        )
        ,_class="m-manifest-link")

    return (a_manifest, a_href, '%s://%s%s' % (d_d['href'][0],d_d['href'][1],d_d['href'][2]))


def __image_ul_for_eachitem(_session, d_d, _atypes=['area'], enable_link=False):
    """
    Thumbnail imageのHTML(UL)を生成、item用
    2018-11/2019-06
    """
    dom_file_ul = None

    if 'folders' in d_d and len(d_d['folders'])>0:

        dom_file_ul = UL(_class='m-items')

        for d_fd in d_d['folders']:

            for idx in d_fd.get('tops',[]):

                d_f = d_fd['files'][idx]

                if 'external' in d_fd['role']:

                    # Manifest link
                    (a_manifest,m_href_args,m_href) = __get_dom_icon_manifest_external(d_f)

                    # Snap image
                    img = IMG(_src='/'.join(d_f.get('snapimage',''))
                            #,_width=240
                            ,_alt=d_f['title']
                            ,_class='m-snapimage'
                        )

                else:
                    # Manifest link
                    (a_manifest,m_href_args) = __get_dom_icon_manifest(d_fd)

                    # Snap image
                    img = IMG(_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f.get('snapimage','')))
                            #,_width=240
                            ,_alt=d_f['title']
                            ,_class='m-snapimage'
                        )

                if 'external' in d_fd['role']:
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']

                elif d_fd['role']=='folder':
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']

                elif 'pdf' in d_f['href']:
                    href = '%s/resources/%s.pdf' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f['href'][:-1]))
                    _session.imgs[tuple(d_f['href'])] = d_fd['ids']

                elif d_f['format'] in ('fzp','fzp3','zoomify','dzi'):
                    #href = URL('viewer',args=d_f['href'])
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']

                #elif d_f['format'] in ('tif','jp2','jpg','png','gif'):
                else:
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']

                dom_file_li= LI(
                                DIV(
                                    DIV(
                                        A(img
                                            ,_href=href
                                            ,_target='_blank'
                                            ,_title=d_f['title']
                                        )
                                        ,a_manifest
                                        ,_label=d_f['title']
                                        ,_class='m-image m-item-snapimage'
                                        ,**{'_data-id':d_f['subid']}
                                    )
                                    ,P(
                                        d_f['title']
                                    )
                                )
                                ,_class='m-item m-item-wid240'
                            )

                dom_file_ul.append(dom_file_li)


                if 'annotes' in d_f and len(d_f['annotes'])>0:

                    for d_a in d_f['annotes']:

                        # 対象のアノテーション形式（デフォルト'area'）以外はスルー（出力抑制）
                        if d_a['annotetype'] not in _atypes: continue

                        # Manifest link
                        (a_manifest,m_href_args) = __get_dom_icon_manifest(d_a)

                        # Snap image
                        if 'tif' in d_f['format'] or 'jp2' in d_f['format']:
                            img_src = '%s%s.%s/%s/240,/%d/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(d_f['href'][:-1]),d_f['format'],','.join([str(v) for v in d_a['annotearea']]),int(d_a['annoterotation']))
                        elif 'jpg' in d_f['format']:
                            img_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_a['thumbnail']))
                        else:
                            continue

                        img = IMG(_src=img_src
                                    ,_alt=d_a['title']
                                    ,_class='m-thumbnail'
                                )
                        href = URL('viewer',args=d_f['href'])
                        var_args = d_f['href']
                        if 'tif' in d_f['format'] or 'jp2' in d_f['format']:
                            manifest_id = "iiif/annote/%s/manifest.json" % (str(d_a['subid']))
                            var_args = ['iiif','annote',str(d_a['subid']),'manifest.json']
                            href = URL('viewer',args=[manifest_id])

                        if enable_link:
                            img_obj = A(img
                                        ,_href=href
                                        ,_target='_blank'
                                        ,_title=d_a['title']
                                    )
                        else:
                            img_obj = img

                        _session.imgs[tuple(var_args)] = d_a['ids']

                        dom_file_li= LI(
                                        DIV(
                                            DIV(img_obj
                                                ,a_manifest
                                                ,_label=d_a['title']['value']
                                                ,_class='m-image m-item-thumbnail'
                                                ,**{'_data-id':d_a['subid']}
                                            )
                                            ,P(
                                                d_a['title']['value']
                                            )
                                        )
                                        ,_class='m-item m-item-wid240'
                                    )

                        dom_file_ul.append(dom_file_li)

    return dom_file_ul or ''


def __image_ul_for_items(_session, d_d):
    """
    Thumbnail imageのHTML(UL)を生成
    2018-11/2019-06
    """
    dom_file_ul = None

    if 'folders' in d_d and len(d_d['folders'])>0:

        dom_file_ul = UL(_class='m-items')

        for d_fd in d_d['folders']:

            for idx in d_fd.get('tops',[]):

                d_f = d_fd['files'][idx]

                if 'role' in d_f and d_f['role'].startswith('external'):

                    # Thumbnail image
                    img = IMG(_src=d_f.get('thumbnailuri','')
                                ,_alt=d_f['title']
                                ,_class='m-thumbnail'
                            )

                    href = URL('item',args=[d_d['subid']])

                    #_session.imgs[] = d_f['ids']

                else:

                    # Thumbnail image
                    img = IMG(_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f['thumbnail']))
                                ,_alt=d_f['title']
                                ,_class='m-thumbnail'
                            )

                    href = URL('item',args=[d_d['subid']])

                    _session.imgs[tuple(d_f['href'])] = d_f['ids']

                dom_file_li= LI(
                                DIV(
                                    DIV(
                                        A(img
                                            ,_href=href
                                        )
                                        ,_label=d_f['title']
                                        ,_class='m-image m-item-thumbnail'
                                        ,**{'_data-id':d_f['subid']}
                                    )
                                    ,P(
                                        d_f['title']
                                    )
                                )
                                ,_class='m-item m-item-wid160'
                            )

                dom_file_ul.append(dom_file_li)

    return dom_file_ul or ''


def __get_dom_attribution_table(d_d):
    """
    外部マニフェスト属性対応
    2019-05/2019-06
    """
    dom_table = None

    if d_d['role'].startswith('external'):

        dom_table = TABLE(TR(TD(T('from Manifest'),_colspan='2',_class='m-label m-item-header')),_class='col col-12')

        for ky in d_d['externalkeyvalue']:
            if ky in d_d['keyset']:
                continue
            if isinstance(d_d['externalkeyvalue'][ky],list):
                atf = True
                for d in d_d['externalkeyvalue'][ky]:
                    if d and len(d.strip())>0:
                        dom_tr= TR(
                                TD(ky, _class='m-label')
                                ,TD(XML(d))
                            )
                        dom_table.append(dom_tr)

            elif isinstance(d_d['externalkeyvalue'][ky],str):
                if len(d_d['externalkeyvalue'][ky].strip())>0:
                    dom_tr= TR(
                                TD(ky, _class='m-label')
                                ,TD(d_d['externalkeyvalue'][ky])
                            )

                    dom_table.append(dom_tr)

    return dom_table or ''


# ========================================
# Editor
# 2018-11/2019-05
# ========================================

def __mr_on_validation(form):
    """
    編集後処理
    2018-11
    """
    pass


def __mr_on_create_class(form):
    """
    クラス作成後処理
    2018-11/2019-05
    """
    if 'mr_class_id' in form.vars:
        return

    var_new_id = form.vars.id

    dbm.mr_class_elements.insert(mr_class_id = var_new_id
                                ,mr_name = 'title'
                                ,mr_title = 'Title'
                                ,mr_description = 'Title'
                                ,mr_open = True
                                )
    dbm.mr_class_elements.insert(mr_class_id = var_new_id
                                ,mr_name = 'description'
                                ,mr_title = 'Description'
                                ,mr_description = 'Description'
                                ,mr_open = True
                                )

    if ('mr_target' in form.vars) and (form.vars.mr_target == 'page'):

        dbm.mr_class_elements.insert(mr_class_id = var_new_id
                                ,mr_name = 'creator'
                                ,mr_title = 'Creator'
                                ,mr_description = 'You'
                                ,mr_open = True
                                )
        dbm.mr_class_elements.insert(mr_class_id = var_new_id
                                ,mr_name = 'created'
                                ,mr_title = 'Created'
                                ,mr_description = '20xx/xx/xx'
                                ,mr_open = True
                                )

    dbm.commit()


def __mr_on_create_section(form):
    """
    セクション作成後処理
    2018-11
    """
    if 'mr_section_id' in form.vars:
        return

    var_new_id = form.vars.id

    # Page section
    var_class_id = form.vars.mr_class_id

    var_rows = dbm(
                    dbm.mr_class_elements.mr_class_id==var_class_id
                ).select(
                    orderby=[dbm.mr_class_elements.mr_order,dbm.mr_class_elements.id]
                )
    for var_row in var_rows:
        dbm.mr_section_items.insert(mr_section_id=var_new_id
                                    ,mr_class_element_id=var_row.id
                                    ,mr_text=XML('<!-- // %s -->' % var_row.mr_description)
                                    ,mr_order=var_row.mr_order
                                    ,mr_open=var_row.mr_open
                                    )
    dbm.commit()


def __mr_on_create_resource(form):
    """
    リソース作成後処理
    2018-11
    """
    if 'mr_resource_id' in form.vars:
        return

    var_new_id = form.vars.id

    # Resource
    var_class_id = form.vars.mr_class_id

    var_rows = dbm(
                    dbm.mr_class_elements.mr_class_id==var_class_id
                ).select(
                    orderby=[dbm.mr_class_elements.mr_order,dbm.mr_class_elements.id]
                )
    for var_row in var_rows:
        dbm.mr_resource_items.insert(mr_resource_id=var_new_id
                                    ,mr_class_element_id=var_row.id
                                    ,mr_text=XML('<!-- // %s -->' % var_row.mr_description)
                                    ,mr_order=var_row.mr_order
                                    ,mr_open=var_row.mr_open
                                    )
    dbm.commit()


@auth.requires_login()
def editcollections():
    """
    コレクション編集用
    2018-11/2019-05
    """
    __precheck()

    var_name = 'collection'

    var_db = dbm.mr_collections
    var_fields = [dbm.mr_collections.id
                ,dbm.mr_collections.mr_parent_id
                ,dbm.mr_collections.mr_name
                ,dbm.mr_collections.mr_title
                ,dbm.mr_collections.mr_description
                ,dbm.mr_collections.mr_order
                ,dbm.mr_collections.mr_open
                ]

    grid = SQLFORM.grid(
                var_db
                ,fields=var_fields
                ,paginate=20
                ,searchable=True
                ,editable=True
                ,details=True
                ,deletable=lambda row: row.id > 1
                ,create=True
                #,csv=False
                ,exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV')
                    csv_with_hidden_cols=False #(ExporterCSV, 'CSV (hidden cols)')
                    #,json=(ExporterJSON, 'JSON')
                    ,xml=False #(ExporterXML, 'XML')
                    ,html=False #(ExporterHTML, 'HTML')
                    #,tsv=(ExporterTSV, 'TSV (Excel compatible)')
                    ,tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                )
                ,ui='web2py'
                ,formstyle='table3cols'
                #,buttons_placement = 'right'
                ,user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editpages():
    """
    ページ編集用
    2018-11/2019-05
    """
    __precheck()

    var_name = 'page'

    var_db = dbm.mr_pages
    var_fields = [dbm.mr_pages.id
                ,dbm.mr_pages.mr_name
                ,dbm.mr_pages.mr_title
                ,dbm.mr_pages.mr_text
                ,dbm.mr_pages.mr_order
                ,dbm.mr_pages.mr_open
                ]

    grid = SQLFORM.grid(
                var_db
                ,fields=var_fields
                ,paginate=20
                ,searchable=True
                ,editable=True
                ,details=True
                ,deletable=lambda row: row.id > 1
                ,create=True
                #,csv=False
                ,exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV')
                    csv_with_hidden_cols=False #(ExporterCSV, 'CSV (hidden cols)')
                    #,json=(ExporterJSON, 'JSON')
                    ,xml=False #(ExporterXML, 'XML')
                    ,html=False #(ExporterHTML, 'HTML')
                    #,tsv=(ExporterTSV, 'TSV (Excel compatible)')
                    ,tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                )
                ,ui='web2py'
                ,formstyle='table3cols'
                #,buttons_placement = 'right'
                ,user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editfolders():
    """
    フォルダ編集用
    2019-05
    """
    __precheck()

    var_name = 'folder'

    var_db = dbm.mr_folders
    var_links = ['mr_files']
    var_fields = [dbm.mr_folders.id
                ,dbm.mr_folders.mr_resource_ids
                ,dbm.mr_folders.mr_name
                ,dbm.mr_folders.mr_title
                ,dbm.mr_folders.mr_license
                ,dbm.mr_folders.mr_order
                ,dbm.mr_folders.mr_open

                ,dbm.mr_files.id
                ,dbm.mr_files.mr_resource_ids
                ,dbm.mr_files.mr_folder_id
                ,dbm.mr_files.mr_title
                ,dbm.mr_files.mr_license
                ,dbm.mr_files.mr_original_file_name
                ,dbm.mr_files.mr_imw
                ,dbm.mr_files.mr_imh
                ,dbm.mr_files.mr_public_file_format
                ,dbm.mr_files.mr_order
                ,dbm.mr_files.mr_open
                ]

    grid = SQLFORM.smartgrid(
                var_db
                ,fields=var_fields
                ,linked_tables=var_links
                ,paginate=20
                ,searchable=True
                ,editable=True
                ,details=True
                ,deletable=lambda row: row.id > 1
                ,create=True
                #,csv=False
                ,exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV')
                    csv_with_hidden_cols=False #(ExporterCSV, 'CSV (hidden cols)')
                    #,json=(ExporterJSON, 'JSON')
                    ,xml=False #(ExporterXML, 'XML')
                    ,html=False #(ExporterHTML, 'HTML')
                    #,tsv=(ExporterTSV, 'TSV (Excel compatible)')
                    ,tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                )
                ,ui='web2py'
                ,formstyle='table3cols'
                #,buttons_placement = 'right'
                ,user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editfiles():
    """
    ファイル編集用
    2018-11/2019-05
    """
    __precheck()

    var_name = 'file'

    var_db = dbm.mr_files
    var_fields = [dbm.mr_files.id
                ,dbm.mr_files.mr_resource_ids
                ,dbm.mr_files.mr_folder_id
                ,dbm.mr_files.mr_title
                ,dbm.mr_files.mr_license
                ,dbm.mr_files.mr_original_file_name
                ,dbm.mr_files.mr_imw
                ,dbm.mr_files.mr_imh
                ,dbm.mr_files.mr_public_file_format
                ,dbm.mr_files.mr_order
                ,dbm.mr_files.mr_open
                ]

    grid = SQLFORM.grid(
                var_db
                ,fields=var_fields
                ,paginate=20
                ,searchable=True
                ,editable=True
                ,details=True
                ,deletable=lambda row: row.id > 1
                ,create=True
                #,csv=False
                ,exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV')
                    csv_with_hidden_cols=False #(ExporterCSV, 'CSV (hidden cols)')
                    #,json=(ExporterJSON, 'JSON')
                    ,xml=False #(ExporterXML, 'XML')
                    ,html=False #(ExporterHTML, 'HTML')
                    #,tsv=(ExporterTSV, 'TSV (Excel compatible)')
                    ,tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                )
                ,ui='web2py'
                ,formstyle='table3cols'
                #,buttons_placement = 'right'
                ,user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editannotes():
    """
    アノテーション編集用
    2018-11/2019-05
    """
    __precheck()

    var_name = 'annote'

    var_db = dbm.mr_annotes
    var_fields = [dbm.mr_annotes.id
                ,dbm.mr_annotes.mr_resource_id
                ,dbm.mr_annotes.mr_file_id
                ,dbm.mr_annotes.mr_name
                ,dbm.mr_annotes.mr_text
                ,dbm.mr_annotes.mr_annote_type
                ,dbm.mr_annotes.mr_annote_area
                ,dbm.mr_annotes.mr_annote_data
                #,dbm.mr_annotes.mr_order
                ,dbm.mr_annotes.mr_open
                ]

    grid = SQLFORM.grid(
                var_db
                ,fields=var_fields
                ,paginate=20
                ,searchable=True
                ,editable=True
                ,details=True
                ,deletable=lambda row: row.id > 1
                ,create=True
                #,csv=False
                ,exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV')
                    csv_with_hidden_cols=False #(ExporterCSV, 'CSV (hidden cols)')
                    #,json=(ExporterJSON, 'JSON')
                    ,xml=False #(ExporterXML, 'XML')
                    ,html=False #(ExporterHTML, 'HTML')
                    #,tsv=(ExporterTSV, 'TSV (Excel compatible)')
                    ,tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                )
                ,ui='web2py'
                ,formstyle='table3cols'
                #,buttons_placement = 'right'
                ,user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editclasses():
    """
    クラス編集用
    2018-11
    """
    __precheck()

    var_name = 'class'

    var_db = dbm.mr_classes
    var_links = ['mr_class_elements']
    var_fields = [dbm.mr_classes.id]

    grid = SQLFORM.smartgrid(
                var_db
                #,fields=var_fields
                ,linked_tables=var_links
                ,paginate=20
                ,searchable=True
                ,editable=True
                ,details=True
                ,deletable=lambda row: row.id > 2
                ,create=True
                #,csv=False
                ,exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV')
                    csv_with_hidden_cols=False #(ExporterCSV, 'CSV (hidden cols)')
                    #,json=(ExporterJSON, 'JSON')
                    ,xml=False #(ExporterXML, 'XML')
                    ,html=False #(ExporterHTML, 'HTML')
                    #,tsv=(ExporterTSV, 'TSV (Excel compatible)')
                    ,tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                )
                ,ui='web2py'
                ,formstyle='table3cols'
                #,buttons_placement = 'right'
                ,user_signature=False
                ,onvalidation=__mr_on_validation
                ,oncreate=__mr_on_create_class
            )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editsections():
    """
    セクション編集用
    2018-11
    """
    __precheck()

    var_name = 'section'

    var_db = dbm.mr_sections
    var_links = ['mr_section_items']
    var_fields = [dbm.mr_sections.id]

    grid = SQLFORM.smartgrid(
                var_db
                #,fields=var_fields
                ,linked_tables=var_links
                ,paginate=20
                ,searchable=True
                ,editable=True
                ,details=True
                ,deletable=True
                ,create=True
                #,csv=False
                ,exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV')
                    csv_with_hidden_cols=False #(ExporterCSV, 'CSV (hidden cols)')
                    #,json=(ExporterJSON, 'JSON')
                    ,xml=False #(ExporterXML, 'XML')
                    ,html=False #(ExporterHTML, 'HTML')
                    #,tsv=(ExporterTSV, 'TSV (Excel compatible)')
                    ,tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                )
                ,ui='web2py'
                ,formstyle='table3cols'
                #,buttons_placement = 'right'
                ,user_signature=False
                ,onvalidation=__mr_on_validation
                ,oncreate=__mr_on_create_section
            )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editresources():
    """
    リソース編集用
    2018-11/2019-05
    """
    __precheck()

    var_name = 'resource'

    var_db = dbm.mr_resources
    var_links = ['mr_resource_items']
    var_fields = [dbm.mr_resources.id
                    #,dbm.mr_resources.mr_parent_id
                    ,dbm.mr_resources.mr_collection_ids
                    ,dbm.mr_resources.mr_class_id
                    ,dbm.mr_resources.mr_name
                    ,dbm.mr_resources.mr_summary
                    #,dbm.mr_resources.mr_manifest_id
                    ,dbm.mr_resources.mr_order
                    ,dbm.mr_resources.mr_open

                    ,dbm.mr_resource_items.id
                    ,dbm.mr_resource_items.mr_resource_id
                    ,dbm.mr_resource_items.mr_class_element_id
                    ,dbm.mr_resource_items.mr_text
                    ,dbm.mr_resource_items.mr_order
                    ,dbm.mr_resource_items.mr_open
                    ]

    grid = SQLFORM.smartgrid(
                var_db
                ,fields=var_fields
                ,linked_tables=var_links
                ,paginate=20
                ,searchable=True
                ,editable=True
                ,details=True
                ,deletable=lambda row: row.id > 1
                ,create=True
                #,csv=False
                ,exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV')
                    csv_with_hidden_cols=False #(ExporterCSV, 'CSV (hidden cols)')
                    #,json=(ExporterJSON, 'JSON')
                    ,xml=False #(ExporterXML, 'XML')
                    ,html=False #(ExporterHTML, 'HTML')
                    #,tsv=(ExporterTSV, 'TSV (Excel compatible)')
                    ,tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                )
                ,ui='web2py'
                ,formstyle='table3cols'
                #,buttons_placement = 'right'
                ,user_signature=False
                ,onvalidation=__mr_on_validation
                ,oncreate=__mr_on_create_resource
            )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editattributes():
    """
    補助属性編集用
    2019-05
    """
    __precheck()

    var_name = 'attribute'

    var_db = dbm.mr_attributes
    var_fields = [dbm.mr_attributes.id
                ,dbm.mr_attributes.mr_group
                ,dbm.mr_attributes.mr_title
                ,dbm.mr_attributes.mr_description
                ,dbm.mr_attributes.mr_order
                ,dbm.mr_attributes.mr_open
                ]

    grid = SQLFORM.grid(
                var_db
                ,fields=var_fields
                ,paginate=20
                ,searchable=True
                ,editable=True
                ,details=True
                ,deletable=True
                ,create=True
                #,csv=False
                ,exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV')
                    csv_with_hidden_cols=False #(ExporterCSV, 'CSV (hidden cols)')
                    #,json=(ExporterJSON, 'JSON')
                    ,xml=False #(ExporterXML, 'XML')
                    ,html=False #(ExporterHTML, 'HTML')
                    #,tsv=(ExporterTSV, 'TSV (Excel compatible)')
                    ,tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                )
                ,ui='web2py'
                ,formstyle='table3cols'
                #,buttons_placement = 'right'
                ,user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


# ========================================
# Uploader
# 2018-11/2019-05
# ========================================

def __list_files(a_offset=0,a_limit=20):
    """
    最近のファイルのリスト
    2018-11/2019-05
    """

    ITEM_LIMIT = 20

    rows = dbm(dbm.mr_files.mr_open==True
                ).select(
                    limitby=(a_offset,ITEM_LIMIT)
                    ,orderby=~dbm.mr_files.mr_create_date|~dbm.mr_files.id
                )
    count = len(rows)

    #pager = None
    #dom_pager = ''

    dom_ul=UL()

    if rows:

        for r in rows:

            # Metadata
            _title = r.mr_title
            if len(_title) == 0:
                _title = r.mr_original_file_name

            # Thumbnail
            img=XML('&nbsp;')
            if r.mr_ims is not None and '.jpg' in r.mr_ims:
                img = IMG(_src='/%s/resources/%s/%s' % (MR_CONF['IMAGE_NAME'],r.mr_subfolder,r.mr_ims)
                        ,_alt=_title
                        ,_class='m-thumbnail'
                        )

            # Link
            a_href = URL('viewer',args=[r.mr_subfolder,r.mr_iml,r.mr_public_file_format])
            if r.mr_public_file_format == 'pdf':
                a_href = '/%s/resources/%s/%s.pdf' % (MR_CONF['IMAGE_NAME'],r.mr_subfolder, r.mr_iml)

            dom_li= LI(
                        DIV(
                            DIV(
                                img
                                ,_label=_title
                                ,_class='m-image-item-thumbnail col col-5'
                                ,**{'_data-id':r.id}
                            )
                            ,DIV(
                                TABLE(
                                    TR(TD(T('Title'),_class="m-label"),TD(_title))
                                    ,TR(TD(T('Identifier'),_class="m-label"),TD(r.mr_identifier))
                                    ,TR(TD(T('Size (px)'),_class="m-label"),TD('%d,%d' % (r.mr_imw,r.mr_imh)))
                                    ,TR(TD(T('Format'),_class="m-label"),TD(r.mr_public_file_format))
                                    ,TR(TD(T('Uploaded date'),_class="m-label"),TD(r.mr_create_date))
                                    ,TR(TD(T('Original'),_class="m-label"),TD(r.mr_original_file_name))
                                    ,TR(TD(T('File license'),_class="m-label"),TD(r.mr_license))
                                    ,TR(TD(T('Note'),_class="m-label"),TD(r.mr_note))
                                )
                                ,_class='col col-7'
                            )
                            ,_class='m-image-item row'
                        )
                        ,_class='m-item'
                    )
            dom_ul.append(dom_li)

    return dom_ul


@auth.requires_login()
def uploader():
    """
    File uploader
    2018-11/2019-05
    """
    __precheck()

    # 一覧
    dom_ul = __list_files(0)

    return dict(title=T('Uploader'), dom=dom_ul, limitmb=MR_CONF['LIMIT_UPLOAD_MB'])


@auth.requires_login()
def upload_callback():
    """
    Dropzoneのための関数
    2018-11/2019-05
    """
    __precheck()

    res = None
    if 'file' in request.vars:

        f = request.vars.file

        f_entry = int(request.vars.get('entry') or 0)
        f_resource = sanitize(request.vars.get('resource',''))
        f_folder = sanitize(request.vars.get('folder',''))
        f_name = sanitize(request.vars.get('name')) or f.filename
        f_identifier = sanitize(request.vars.get('ident',''))
        f_title = sanitize(request.vars.get('title',''))
        f_collection = int(request.vars.get('collection') or 1)
        f_rotate = int(request.vars.get('rotate') or 0)*90
        f_format = int(request.vars.get('format') or 0)
        f_license = int(request.vars.get('license') or 0)
        f_order = int(request.vars.get('order') or 1)

        f_ext = ''
        if f_name.lower().endswith('.jpg'): f_ext = 'jpg'
        elif f_name.lower().endswith('.pdf'): f_ext = 'pdf'
        elif f_name.lower().endswith('.tif'): f_ext = 'tif'
        elif f_name.lower().endswith('.bmp'): f_ext = 'bmp'
        elif f_name.lower().endswith('.png'): f_ext = 'png'
        else: return json.dumps(res, separators=(',', ':'))

        o_format = 'jpg'
        #if f_format == 1: o_format = 'pdf' # auto
        if f_format == 2: o_format = 'tif'
        if f_format == 3: o_format = 'jp2'
        if f_ext == 'pdf': o_format = 'pdf'

        a_license = MR_CONF['LICENSES'][f_license]

        #a_username = None
        a_date = datetime.datetime.now()
        #a_subfolder = a_date.strftime('%Y%m%d')

        r_id = 1
        f_id = 1

        if len(f_resource)>0:

            if re.fullmatch('^[a-zA-Z0-9\.\/\-_]+$',f_resource):

                if dbm(dbm.mr_resources.mr_name==f_resource).count() == 0:

                    r_id = dbm.mr_resources.insert(
                                mr_title=f_title
                                ,mr_name=f_resource
                                ,mr_open=False
                                )
                    dbm.commit()

                else:
                    r_row = dbm(dbm.mr_resources.mr_name==f_resource).select().first()
                    r_id = r_row.id

            else:
                # エラー処理
                pass

        # folder
        if len(f_folder)==0:
            pass
        elif dbm(dbm.mr_folders.mr_name==f_folder).count() == 0:

            if re.fullmatch('^[a-zA-Z0-9\.\/\-_]+$',f_folder):

                f_id = dbm.mr_folders.insert(
                                mr_resource_ids = [r_id]
                                ,mr_name=f_folder
                                ,mr_identifier=f_identifier
                                ,mr_title=f_title
                                ,mr_description=f_title
                                ,mr_license=a_license
                                ,mr_open=True
                                )
                dbm.commit()
        else:
            f_row = dbm(dbm.mr_folders.mr_name==f_folder).select().first()
            if f_row:
                f_id = f_row.id

        a_id = dbm.mr_files.insert(
                            mr_resource_ids = [r_id]
                            ,mr_folder_id = f_id
                            ,mr_original_file=dbm.mr_files.mr_original_file.store(f.file, f.filename)
                            ,mr_original_file_name=f_name
                            ,mr_original_file_format=f_ext
                            ,mr_identifier=f_identifier
                            ,mr_title=f_title
                            ,mr_license=a_license
                            ,mr_public_file_format=o_format
                            ,mr_rotation=f_rotate
                            ,mr_create_date=a_date
                            ,mr_order=f_order
                            ,mr_open=True
                            )

        dbm.commit()

        a_file = dbm.mr_files[a_id]

        t_filenames = re.split('[\.\\/]',a_file.mr_original_file)
        #a_subfolder = t_filenames[0]+'.'+t_filenames[1]+'/'+t_filenames[2][0:2]
        a_subfolder = t_filenames[2][0:2]
        a_filename = t_filenames[2:-1]

        if f_ext in ('jpg','png','bmp','tif'):
            new_name = __make_resource(a_file, a_subfolder, o_format, f_rotate)
        elif f_ext in ('jp2'):
            new_name = __make_resource(a_file, a_subfolder, o_format, f_rotate)
        elif f_ext in ('pdf'):
            new_name = __copy_resource(a_file, a_subfolder, o_format)
        else:
            new_name = __copy_resource(a_file, a_subfolder)

        res = dict(files=[{
            "filename": f.filename
            ,"format": o_format
        }])

    return json.dumps(res, separators=(',', ':'))


def __convert(a_in, a_out, a_out_format):
    """
    Tiled Pyramid TIFF作成にはpyvipsが必要
    例：__convert('folder/sample.jpg','sample','tif')
    2018-11
    """
    try:
        # save as Tiled Pyramid TIFF
        tile_size = MR_CONF['IMG_TILE_SIZE']
        if (type(tile_size) is not int) or tile_size<128 or tile_size>512:
           tile_size = 256
        im = pyvips.Image.new_from_file(a_in)
        im.write_to_file('%s.tif' % a_out, Q=95, compression="jpeg", tile=True, pyramid=True, tile_width=tile_size)
    except:
        # save alternative as JPEG
        try:
            im = Image.open(a_in)
            im.save('%s.jpg' % a_out, 'jpeg', quality=95)
        except:
            pass


def __make_resource(a_file, store_subfolder='', make_format='jpg', image_rotate=0):
    """
    2018-11
    """
    t_filenames = a_file.mr_original_file.split('.')
    a_srcfolder = '%s.%s/%s' % (t_filenames[0],t_filenames[1],t_filenames[2][0:2])
    a_subfolder = t_filenames[2][0:2]
    a_newname = ( '%s.%s' % ('_'.join(t_filenames[2:-1]),make_format),
            '%s_%s.jpg' % ('_'.join(t_filenames[2:-1]),str(MR_CONF['IMG_SNAP_SIZE'])),
            '%s_%s.jpg' % ('_'.join(t_filenames[2:-1]),str(MR_CONF['IMG_THUMBNAIL_SIZE'])),
            '_'.join(t_filenames[2:-1]),
            make_format,)

    im = Image.open(os.path.join(MR_CONF['FILEBASE_PATH'], 'uploads', a_srcfolder, a_file.mr_original_file))
    if image_rotate>0:
        im = im.rotate(-image_rotate,False,True)
    (wid, hei) = im.size
    a_file.update_record(mr_imw=wid, mr_imh=hei, mr_subfolder=store_subfolder)

    # サブフォルダの作成
    a_path = (
            os.path.normpath(os.path.join(MR_CONF['RESOURCEBASE_PATH'], 'resources', store_subfolder)),
            os.path.normpath(os.path.join(MR_CONF['IMAGEBASE_PATH'], 'resources', store_subfolder)),
            os.path.normpath(os.path.join(MR_CONF['IMAGEBASE_PATH'], 'resources', store_subfolder)),
        )
    if not os.path.exists(a_path[0]): os.makedirs(a_path[0])
    if not os.path.exists(a_path[1]): os.makedirs(a_path[1])
    #if not os.path.exists(a_path[2]): os.makedirs(a_path[2])

    if make_format == 'tif':
        # Tiled Pyramid TIFF (IIIF/IIPSrv)
        # save to 'RESOURCEBASE_PATH'
        __convert(os.path.join(MR_CONF['FILEBASE_PATH'], 'uploads', a_srcfolder, a_file.mr_original_file), os.path.join(a_path[0], a_newname[3]), a_newname[4])
    elif make_format == 'jp2':
        # JPEG2000 (Experimental)
        # save to 'RESOURCEBASE_PATH'
        tile_size = MR_CONF['IMG_TILE_SIZE']
        if (type(tile_size) is not int) or tile_size<128 or tile_size>512:
           tile_size = 256
        im.save(os.path.join(a_path[0], '%s.%s' % (a_newname[3], a_newname[4])), 'jpeg2000', tile_size=(tile_size,tile_size))
    else:
        # JPEG (Default)
        # save to 'IMAGEBASE_PATH'
        im.save(os.path.join(a_path[1], a_newname[0]), 'jpeg', quality=95)
    a_file.update_record(mr_iml=a_newname[3], mr_imlw=wid, mr_imlh=hei)

    # リサイズ画像の作成 M,S
    im.thumbnail((MR_CONF['IMG_SNAP_SIZE'],MR_CONF['IMG_SNAP_SIZE']), Image.ANTIALIAS)
    (widM, heiM) = im.size
    im.save(os.path.join(a_path[1], a_newname[1]), 'jpeg')
    a_file.update_record(mr_imm=a_newname[1], mr_immw=widM, mr_immh=heiM)

    im.thumbnail((MR_CONF['IMG_THUMBNAIL_SIZE'],MR_CONF['IMG_THUMBNAIL_SIZE']), Image.ANTIALIAS)
    (widS, heiS) = im.size
    im.save(os.path.join(a_path[2], a_newname[2]), 'jpeg')
    a_file.update_record(mr_ims=a_newname[2], mr_imsw=widS, mr_imsh=heiS)

    return a_newname


def __getImageName(name, prefix='', postfix='', sep=''):
    """
    2018-11
    """
    return ''.join(prefix, sep, name[:name.rfind('.')], sep, postfix, name[name.rfind('.'):])


def __copy_resource(a_file, store_subfolder='', make_format='pdf'):
    """
    2018-11
    """
    import shutil

    filenames = a_file.mr_original_file.split('.')
    a_fileformat = filenames[-1].lower()
    #a_subfolder = filenames[0]+'.'+filenames[1]+'/'+filenames[2][0:2]
    a_subfolder = filenames[2][0:2]
    a_newname = ( '%s.%s' % ('_'.join(filenames[2:-1]), a_fileformat),
            '%s_%s.jpg' % ('_'.join(filenames[2:-1]),str(MR_CONF['IMG_SNAP_SIZE'])),
            '%s_%s.jpg' % ('_'.join(filenames[2:-1]),str(MR_CONF['IMG_THUMBNAIL_SIZE'])),
            '_'.join(filenames[2:-1]),
            make_format,)

    (filename, stream) = dbm.mr_files.mr_original_file.retrieve(a_file.mr_original_file)

    a_path = os.path.normpath(os.path.join(MR_CONF['IMAGEBASE_PATH'], 'resources', store_subfolder))
    if not os.path.exists(a_path): os.makedirs(a_path)

    b_path = os.path.join(a_path, a_newname[0])
    shutil.copyfileobj(stream, open(b_path,'wb'))

    a_file.update_record(mr_iml=a_newname[3], mr_subfolder=store_subfolder)

    if a_fileformat == 'pdf':
        # PDF
        # save to 'IMAGEBASE_PATH'
        im = pyvips.Image.new_from_file('%s[0]' % b_path)

        # リサイズ画像の作成 M,S
        th1 = im.thumbnail_image(MR_CONF['IMG_SNAP_SIZE'])
        th1.write_to_file(os.path.join(a_path, a_newname[1]), Q=75)
        a_file.update_record(mr_imm=a_newname[1], mr_immw=th1.width, mr_immh=th1.height)

        th2 = th1.thumbnail_image(MR_CONF['IMG_THUMBNAIL_SIZE'])
        th2.write_to_file(os.path.join(a_path, a_newname[2]), Q=75)
        a_file.update_record(mr_ims=a_newname[2], mr_imsw=th2.width, mr_imsh=th2.height)

    return a_newname
