# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1906r3
## - Date: 2019-06-15
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3.1906) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

import sys
import os
import time
import datetime
import codecs
import shutil
import unicodedata
import re
import json
from gluon.sanitizer import sanitize
from gluon.sqlhtml import PasswordWidget

mr_datahelper = local_import('mr_datahelper', reload=MR_CONF['RELOAD'])


def __precheck():
    """
    該当しなければログインを通過
    2018-11
    """
    if session.groupid is None:
        redirect(URL('staff','user',args=['logout']))

    if session.auth.user.id < 5 and not ( request.env.remote_addr in configuration.get('myconfig.allowances') or request.env.remote_addr.startswith(configuration.get('myconfig.local_ip')) ):
        redirect(URL('staff','user',args=['logout']))

    # 制限
    if session.groupid > MR_CONF['GROUP_ADMINISTRATOR']:
        redirect(URL('staff','user',args=['logout']))
    pass


@auth.requires_login()
def index():
    """
    管理ページ・トップ
    2018-11
    """
    __precheck()
    return dict()


@auth.requires_login()
def user():
    """
    ユーザー認証
    2018-11
    """
    auth.settings.controller = 'manage'
    return dict(form=auth())


# ========================================
# ユーザー管理
# 2018-11
# ========================================

def __getAnchor(func, arg, b):
    if b:
        return A(arg,_href=URL(func,args=[arg]))
    else:
        return '';


@auth.requires_login()
def listup_users():
    """
    ユーザー一覧
    2018-11
    """
    __precheck()

    table = ''

    entable = False
    if crud.has_permission('update',db.auth_user):
        entable = True

    shif = 0
    if request.env.remote_addr.startswith(configuration.get('myconfig.local_ip')):
    	shif = 1
    elif request.env.remote_addr in configuration.get('myconfig.allowances'):
        shif = 1

    rows = db((db.auth_user.id==db.auth_membership.user_id) & (db.auth_group.id==db.auth_membership.group_id) & (db.auth_group.id>session.groupid-1)).select(orderby=~db.auth_user.id)

    if shif > 0:
        table = TABLE(TR(TH(T('ID')),TH(T('Login name')),TH(T('Name')),TH(T('Group'))),
                *[TR(
                    TD(__getAnchor('edit_user',item.auth_user.id, entable),_width='50'),
                    TD(item.auth_user.username),
                    TD(item.auth_user.last_name+' '+item.auth_user.first_name),
                    TD(item.auth_group.description+' ('+item.auth_group.role+')'))
                for item in rows if item.auth_group.id < 6],
            _border='1', _sellpadding='5', _sellspacing='0')
    else:
        table = TABLE(TR(TH(T('ID')),TH(T('Login name')),TH(T('Name')),TH(T('Group'))),
                *[TR(
                    TD(__getAnchor('edit_user',item.auth_user.id, entable),_width='50'),
                    TD(item.auth_user.username),
                    TD(item.auth_user.last_name+' '+item.auth_user.first_name),
                    TD(item.auth_group.description+' ('+item.auth_group.role+')'))
                for item in rows if (item.auth_group.id < 6 and item.auth_user.id > 5)],
            _border='1', _sellpadding='5', _sellspacing='0')

    return dict(message=T('User List'),table=table,entable=entable)


@auth.requires_login()
def edit_user():
    """
    ユーザー表示・編集
    edit_user?id=<id>であればユーザーの編集表示、
    それ以外は、（エラーを含め）新規登録表示を行う。
    削除はこのバージョンでは原則として実施しない。アクセス不可にするには権限をゲストにする。
    2018-11
    """
    __precheck()

    if not crud.has_permission('update',db.auth_user):
        redirect(URL('listup_users'))
    if not request.args and not crud.has_permission('update',db.auth_user):
        redirect(URL('listup_users'))

    fields = ['username','first_name','last_name']
    labels = {'username':T('Username'),'first_name':T('Your Name'),'last_name':T('Description')}
    groups = None
    groupops = []

    try:
        record = db.auth_user(int(request.args(0)))
        groups = db(db.auth_membership.user_id==int(request.args(0))).select()
    except:
        record = {'username':'','last_name':'','first_name':'','password':''}

    if record is None:
        record = {'username':'','last_name':'','first_name':'','password':''}

    group_id = 4    #Editor
    if groups:
        group_id = int(groups[0]['group_id'])

    # 権限制限
    if record is None or session.groupid > group_id:
        redirect(URL('listup_users'))

    if True: #session.groupid>MR_CONF['GROUP_DEVELOPER']:
        groupops=[{'description':T('Developer'), 'id':'1'},
              {'description':T('Administrator'), 'id':'2'},
              {'description':T('Editor'), 'id':'3'},
              #{'description':T('User'), 'id':'4'},
              #{'description':T('Guest'), 'id':'5'}
              ]
    else:
        groupops=[{'description':T('Developer'), 'id':'1'},
              {'description':T('Administrator'), 'id':'2'},
              {'description':T('Editor'), 'id':'3'},
              {'description':T('User'), 'id':'4'},
              {'description':T('Guest'), 'id':'5'}
              ]

    form = FORM(
                TABLE(
                    *[TR(TD(T(labels[item]),_width='150'),TD(INPUT(_value=record[item],_name=item, requires=IS_NOT_EMPTY(),_width='300'))) for item in fields],
                    _border='0', _cellpadding='5', _cellspacing='0'),
                TABLE(
                    TR(TD(T('Password'),_width='150'),TD(PasswordWidget.widget(db.auth_user.password,record['password'],_width='300'))),
                    TR(TD(T('Group ID')),
                        TD(
                            SELECT(
                                *[OPTION(group['description'],_value=int(group['id'])) for group in groupops[(session.groupid - 1):]],    #権限の制限
                                value=group_id,_name='group_id'
                            )
                        )
                    ),
                    TR(
                        TD(''),
                        TD(
                            INPUT(_type='submit',_value=T('Send'),_class='btn btn-primary'),
                            INPUT(_type='button',_value=T('Cancel'),_onclick=XML("location.href='"+URL(listup_users)+"'"),_class='btn btn-secondary')
                        ),
                        _rowspan='2'),
                    _border='0', _cellpadding='5', _cellspacing='0'),
            _id='form1',_method='POST',_action='')

    delete_tr = TR(TD(T('Check to delete'),_width='150'),TD(INPUT(_name='delete_this_record',_type='checkbox',value=False),_width='300'))

    if request.args and record and record.id > 5:
        form[1][1].insert(2,delete_tr)

    message=T('Edit User')

    if form.accepts(request.vars, session):
        if not request.args and crud.has_permission('update',db.auth_user):
            id = db.auth_user.insert(**db.auth_user._filter_fields(form.vars))
            form.vars.user_id=id
            id = db.auth_membership.insert(**db.auth_membership._filter_fields(form.vars))
        elif form.vars['delete_this_record'] and crud.has_permission('delete',db.auth_user):
            # 削除
            if record and record.id > 5:
                db(db.auth_membership.user_id==record.id).delete()
                db(db.auth_user.id==record.id).delete()
        elif crud.has_permission('update',db.auth_user):
            id = db(db.auth_user.id==record['id']).update(**db.auth_user._filter_fields(form.vars))
            #form.vars.user_id=id
            id = db(db.auth_membership.user_id==record['id']).update(group_id=form.vars.group_id)
        redirect(URL('listup_users'))
    elif form.errors:
        response.flash = T('Error')
        message=T('Error')

    return dict(message=message,form=form)


# ========================================
# データベース管理
# 2018-11
# ========================================

def __copy_db():
    """
    データベースの複製
    2018-11
    """
    #if configuration.get('dbm.uri').startswith('mysql://'):
    #    if __copy_mr_sqldb():
    #        return dict(message='成功：データベースを無事に複製しました．',report=None)
    #    else:
    #        return dict(message='失敗：データベースの複製を失敗しました．開発者へお問い合わせください．',report=None)
    if configuration.get('dbm.uri').startswith('sqlite://'):
        if __copy_mr_db():
            return dict(message='成功：データベースを無事に複製しました．',report=None)
        else:
            return dict(message='失敗：データベースの複製を失敗しました．開発者へお問い合わせください．',report=None)
    else:
        return dict(message='警告：データベースの複製は行えません．開発者へお問い合わせください．',report=None)


def __copy_mr_sqldb():
    """
    データベースの複製本体
    MySQL（MariaDB）
    RESERVED
    2018-11
    """
    return False


def __copy_mr_db():
    """
    データベースの複製本体
    SQLite
    2018-11
    """
    datestr=datetime.datetime.today().strftime('_%Y%m%d_%H%M%S')
    extstr='.sqlite'

    spath=os.path.join(MR_CONF['DB_PATH'],'%s' % MR_CONF['DB_NAME']+extstr)
    dpath=os.path.join(MR_CONF['DBBACKUP_PATH'])
    fpath=os.path.join(MR_CONF['DBBACKUP_PATH'],'%s' % MR_CONF['DB_NAME']+datestr+extstr)

    if not os.path.exists(dpath):
       os.mkdir(dpath)

    try:
        shutil.copy2(spath, fpath)
        result = True
    except:
        result = False
        pass

    return result


@auth.requires_login()
def export_database():
    """
    データベース・ファイルの複製
    id#copy_apply
    id#export_cancel
    2018-11
    """
    __precheck()

    message = ''

    if len(request.args)>0:
        temp_process = sanitize(request.args[0])
        if temp_process is not None and temp_process != '':
            if temp_process == 'export':
                res_dict = __copy_db()
                message = res_dict['message']
    else:
        message = '既定の位置に、データベース・ファイルの複製（タイムスタンプ付き）を行ないます．'

    form = FORM(
                TABLE(
                    TR(
                        TD(T('Export Database'),_class='table_name'),
                        TD(INPUT(_type='button',_value=T('Export Apply'),_id='copy_apply',_class="btn btn-primary")
                        )
                    ),
                    _class='table_export'
                ),
                TABLE(
                    TR(
                        TD('',_class='table_name'),
                        TD(INPUT(_type='button',_value=T('Export Cancel'),_id='export_cancel',_class="btn btn-secondary")
                        )
                    ),
                    _class='table_export table_head'
                )
            )

    return dict(message=message,form=form)


@auth.requires_login()
def export_table():
    """
    テーブル書き出し
    クラス毎にテーブルを書き出す
    #UTF_16_LE(BOM付)ファイル
    UTF-8(BOM無)ファイル
    2018-11
    """
    __precheck()

    message = ''

    if len(request.args)>1:
        temp_process = sanitize(request.args[0])
        temp_type = int(request.args[1] or 0)  # 0:TSV (default), 1:CSV (RESERVED)
        if temp_process is not None and temp_process != '':
            if temp_process == 'export':
                res_dict = __export_alltables()
                message = res_dict['message']
    else:
        message = '既定の位置に、テーブルをバックアップします．'
        __refresh_exports()

    form = FORM(
                TABLE(
                    TR(
                        TD(T('Export Select'),_class='table_name')
                        ,TD(
                            #INPUT(_type='radio', _name='exportselect', _value='1', value='0'),T('CSV'),
                            INPUT(_type='radio', _name='exportselect', _value='0', value='0'),SPAN(T('TSV'))
                        )
                    )
                    ,TR(
                        TD(T('Export Tables'),_class='table_name')
                        ,TD(
                            INPUT(_type='button',_value=T('Export Apply'),_id='export_apply',_class='btn btn-primary')
                        )
                    )
                    ,_class='table_export'
                )
                ,TABLE(
                    TR(
                        TD('',_class='table_name')
                        ,TD(
                            INPUT(_type='button',_value=T('Export Cancel'),_id='export_cancel',_class='btn btn-secondary')
                        )
                    )
                    ,_class='table_export table_head'
                )
            )

    #ExportパスのFileリストを取得
    rows = dbm(dbm.mr_exports.mr_enabled==True).select(orderby=~dbm.mr_exports.mr_createdate)

    extable = DIV(
                    TABLE(
                        TR(
                            TH(T('In order of new'),_style='width:33%')
                            ,TH(T('File'))
                        )
                        ,*[TR(
                            TD(str(i+1))
                            ,TD(A(r.mr_filename, _href=URL(f='download',args=['data',r.mr_filename])))
                            ) for i, r in enumerate(rows) if i < 20
                        ]
                        ,_class='table_export'
                    )
                    ,TABLE(
                        TR(
                            TD('',_class='table_name')
                            ,TD(INPUT(_type='button',_value=T('Export Cancel'),_id='export_cancel',_class='btn btn-secondary')
                            )
                        )
                        ,_class='table_export table_head'
                    )
                    ,_class='table_export_div'
                )

    return dict(message=message,form=form,extable=extable)


def __export_alltables():
    """
    データベース・テーブルのExport
    2018-11
    """
    success=[]
    error=[]

    # 全てのクラスとその要素セットの辞書
    d_elements = mr_datahelper.d__elementset(dbm, 0)

    for classid in d_elements:
        if classid > 1: #undefinedは除く
            class_title = d_elements[classid]['title']
            try:
                __export_eachtable(classid, d_elements)
                success.append(class_title)
            except:
                error.append(class_title)

    # File
    try:
        __export_filetable()
        success.append('file')
    except:
        error.append('file')

    # Annotation
    try:
        __export_annotetable()
        success.append('annote')
    except:
        error.append('annote')

    # Class
    # Class element
    # Collection

    result = ' success: %d / error: %d (%s)' % (len(success),len(error),','.join(error))

    return dict(message='Result: TSV Table exported.'+result)


def __fields(classid=3):
    """
    2018-11
    """
    d_elements = mr_datahelper.d__elementset(dbm, 0)

    # 対象クラスの要素辞書
    d_element = d_elements[classid]

    # 対象テーブル
    table_name = None
    if d_element['target'] == 'page':
        table_name = 'mr_sections'
        table_pattern = dbm[table_name]._fields
    if d_element['target'] == 'resource':
        table_name = 'mr_resources'
        table_pattern = dbm[table_name]._fields

    if table_name is None:
        raise

    try:
        # テーブルの存在確認
        dbm[table_name]
    except:
        raise

    fields1 = table_pattern[0:4]
    fields2 = d_element['keyset']
    fields3 = table_pattern[4:]

    l_labels = [str(dbm[table_name][field].label) for field in fields1]
    l_labels.extend([d_elements[classid]['nameset'][n]['title'] for n in fields2])
    l_labels.extend([str(dbm[table_name][field].label) for field in fields3])

    l_fields = []
    l_fields.extend(fields1)
    l_fields.extend(['%s' % t for t in fields2])
    l_fields.extend(fields3)

    records = dbm(dbm[table_name].mr_class_id==classid).select(orderby=dbm[table_name].id) or []

    class_title = dbm.mr_classes[classid]['mr_title']

    if table_name == 'mr_resources':
        for r in records:
            cvs = []
            if r.mr_collection_ids:
                for v in r.mr_collection_ids:
                    vt = dbm.mr_collections[v]
                    if vt:
                        cvs.append(vt.mr_title)
                r.mr_collection_ids = '|'.join(cvs)
            r.mr_class_id = class_title

    elif table_name == 'mr_sections':
        for r in records:
            vt = dbm.mr_pages[r.mr_page_id]
            r.mr_page_id = vt.mr_title
            r.mr_class_id = class_title

    for record in records:

        if table_name == 'mr_resources':
            # このリソースのアイテムの取得
            records2 = dbm(
                    (dbm.mr_resource_items.mr_resource_id == record.id)
                    & dbm.mr_resource_items.mr_class_element_id.belongs(d_element['group'])
                    #& (dbm.mr_resources_items.mr_open == True)
                ).select(
                    #left=dbm.mr_class_elements.on(dbm.mr_resource_items.mr_class_element_id == dbm.mr_class_elements.id)
                )
        elif table_name == 'mr_sections':
            records2 = dbm(
                    (dbm.mr_section_items.mr_section_id == record.id)
                    & dbm.mr_section_items.mr_class_element_id.belongs(d_element['group'])
                    #& (dbm.mr_section_items.mr_open == True)
                ).select(
                    #left=dbm.mr_class_elements.on(dbm.mr_section_items.mr_class_element_id == dbm.mr_class_elements.id)
                )

        ary=[]

        for i, fid in enumerate(d_element['group']):
            for record2 in records2:
                if record2.mr_class_element_id == fid:
                    ary.append([fid, d_element['keyset'][i], record2.id])
                    break

    return dict(element=d_element,field=table_pattern,fields=fields2,ary=ary)


def __export_eachtable(classid, d_elements):
    """
    データベースのExport
    @classid: mr_classes.id
    @element_pattern: 全てのクラスとその要素セットの辞書
    2018-11
    """
    # 対象クラスの要素辞書
    d_element = d_elements[classid]

    # 対象テーブル
    table_name = None
    if d_element['target'] == 'page':
        table_name = 'mr_sections'
        table_pattern = dbm[table_name]._fields
    if d_element['target'] == 'resource':
        table_name = 'mr_resources'
        table_pattern = dbm[table_name]._fields

    if table_name is None:
        raise

    try:
        # テーブルの存在確認
        dbm[table_name]
    except:
        raise


    fields1 = table_pattern[0:4]         #dbm[table_name].fields
    fields2 = d_element['keyset']
    fields3 = table_pattern[4:]

    l_labels = [str(dbm[table_name][field].label) for field in fields1]
    l_labels.extend([d_elements[classid]['nameset'][n]['title'] for n in fields2])
    l_labels.extend([str(dbm[table_name][field].label) for field in fields3])

    l_fields = []
    l_fields.extend(fields1)
    l_fields.extend(['%s' % t for t in fields2])
    l_fields.extend(fields3)

    tsv_list = ['\t'.join(l_labels)]     #line1:label
    tsv_list.append('\t'.join([t for t in l_fields]))     #line2:id


    records = dbm(dbm[table_name].mr_class_id==classid).select(orderby=dbm[table_name].id) or []

    class_title = dbm.mr_classes[classid]['mr_title']

    if table_name == 'mr_resources':
        for r in records:
            cvs = []
            if r.mr_collection_ids:
                for v in r.mr_collection_ids:
                    vt = dbm.mr_collections[v]
                    if vt:
                        cvs.append(vt.mr_title)
                r.mr_collection_ids = '|'.join(cvs)

    elif table_name == 'mr_sections':
        for r in records:
            vt = dbm.mr_pages[r.mr_page_id]

    for record in records:

        if table_name == 'mr_resources':
            # このリソースのアイテムの取得
            records2 = dbm(
                    (dbm.mr_resource_items.mr_resource_id == record.id)
                    & dbm.mr_resource_items.mr_class_element_id.belongs(d_element['group'])
                    #& (dbm.mr_resources_items.mr_open == True)
                ).select(
                    #left=dbm.mr_class_elements.on(dbm.mr_resource_items.mr_class_element_id == dbm.mr_class_elements.id)
                )
        elif table_name == 'mr_sections':
            records2 = dbm(
                    (dbm.mr_section_items.mr_section_id == record.id)
                    & dbm.mr_section_items.mr_class_element_id.belongs(d_element['group'])
                    #& (dbm.mr_section_items.mr_open == True)
                ).select(
                    #left=dbm.mr_class_elements.on(dbm.mr_section_items.mr_class_element_id == dbm.mr_class_elements.id)
                )

        ary=[]

        for f in fields1:
            r = record.get(f)
            if isinstance(r, bool):
                ary.append(str(r * 1))
            elif isinstance(r, (int,float)):
                ary.append(str(r))
            elif isinstance(r, str):
                ary.append(re.sub(r'[\r\n]',r'\\r',r.rstrip()))
            elif isinstance(r, list):
                ary.append(','.join([str(t) for t in r]))
            else:
                #id, reference, timestamp, etc.
                ary.append(str(r))

        for fid in d_element['group']:
            for record2 in records2:
                if record2.mr_class_element_id == fid:
                    ary.append(re.sub(r'[\r\n]',r'\\r',record2.mr_text.rstrip()))
                    break

        for f in fields3:
            r = record.get(f)
            if isinstance(r, bool):
                ary.append(str(r * 1))
            elif isinstance(r, (int,float)):
                ary.append(str(r))
            elif isinstance(r, str):
                ary.append(re.sub(r'[\r\n]',r'\\r',r.rstrip()))
            elif isinstance(r, list):
                ary.append(','.join([str(t) for t in r]))
            else:
                #id, reference, timestamp, etc.
                ary.append(str(r))

        tsv_list.append('\t'.join(ary))

    filestr = MR_CONF['APP_NAME']+'_'+d_element['target']+'_'+str(classid)
    datestr = datetime.datetime.today().strftime('_%Y%m%d_%H%M%S')
    #extstr = '_utf16le_sig_tsv.txt'
    extstr = '_utf8_tsv.txt'

    dpath = os.path.join(MR_CONF['EXPORT_PATH'])
    fpath = os.path.join(MR_CONF['EXPORT_PATH'],'%s' % filestr+datestr+extstr)

    if not os.path.exists(dpath):
       os.mkdir(dpath)

    try:
        #with codecs.open(fpath, 'w', 'utf_16_le') as fd:
        #  #fd.write('\ufeff')
        #  fd.write(unicode(codecs.BOM_UTF16_LE,'utf_16_le'))
        #  for line in tsv_list:
        #      fd.write('%s\r\n' % unicode(line,'utf-8'))
        with codecs.open(fpath, 'w', 'utf-8') as fd:
          for line in tsv_list:
              #fd.write('%s\n' % unicode(line,'utf-8'))
              fd.write('%s\n' % line)

        dbm.mr_exports.insert(mr_filename=filestr+datestr+extstr)

    except:
        raise


def __export_filetable():
    """
    Export of files table
    2018-11
    """

    # 対象テーブル
    table_name = 'mr_files'
    table_pattern = dbm[table_name]._fields

    try:
        # テーブルの存在確認
        dbm[table_name]
    except:
        raise

    fields = table_pattern

    l_labels = [str(dbm[table_name][field].label) for field in fields]
    l_fields = ['%s' % t for t in fields]

    tsv_list = ['\t'.join(l_labels)]     #line1:label
    tsv_list.append('\t'.join([t for t in l_fields]))     #line2:id

    records = dbm(dbm[table_name].id>0).select(orderby=dbm[table_name].id)

    class_title = 'file'

    for record in records:

        ary=[]

        for f in fields:
            r = record.get(f)
            if isinstance(r, bool):
                ary.append(str(r * 1))
            elif isinstance(r, (int,float)):
                ary.append(str(r))
            elif isinstance(r, str):
                ary.append(re.sub(r'[\r\n]',r'\\r',r.rstrip()))
            elif isinstance(r, list):
                ary.append(','.join([str(t) for t in r]))
            else:
                #id, reference, timestamp, etc.
                ary.append(str(r))

        tsv_list.append('\t'.join(ary))

    filestr = MR_CONF['APP_NAME']+'_file'
    datestr = datetime.datetime.today().strftime('_%Y%m%d_%H%M%S')
    #extstr = '_utf16le_sig_tsv.txt'
    extstr = '_utf8_tsv.txt'

    dpath = os.path.join(MR_CONF['EXPORT_PATH'])
    fpath = os.path.join(MR_CONF['EXPORT_PATH'],'%s' % filestr+datestr+extstr)

    if not os.path.exists(dpath):
       os.mkdir(dpath)

    try:
        #with codecs.open(fpath, 'w', 'utf_16_le') as fd:
        #  #fd.write('\ufeff')
        #  fd.write(unicode(codecs.BOM_UTF16_LE,'utf_16_le'))
        #  for line in tsv_list:
        #      fd.write('%s\r\n' % unicode(line,'utf-8'))
        with codecs.open(fpath, 'w', 'utf-8') as fd:
          for line in tsv_list:
              #fd.write('%s\n' % unicode(line,'utf-8'))
              fd.write('%s\n' % line)

        dbm.mr_exports.insert(mr_filename=filestr+datestr+extstr)

    except:
        raise


def __export_annotetable():
    """
    Export of annotation table
    2018-11
    """

    # 対象テーブル
    table_name = 'mr_annotes'
    table_pattern = dbm[table_name]._fields

    try:
        # テーブルの存在確認
        dbm[table_name]
    except:
        raise

    fields = table_pattern

    l_labels = [str(dbm[table_name][field].label) for field in fields]
    l_fields = ['%s' % t for t in fields]

    tsv_list = ['\t'.join(l_labels)]     #line1:label
    tsv_list.append('\t'.join([t for t in l_fields]))     #line2:id

    records = dbm(dbm[table_name].id>0).select(orderby=dbm[table_name].id)

    class_title = 'annote'

    for record in records:

        ary=[]

        for f in fields:
            r = record.get(f)
            if isinstance(r, bool):
                ary.append(str(r * 1))
            elif isinstance(r, (int,float)):
                ary.append(str(r))
            elif isinstance(r, str):
                ary.append(re.sub(r'[\r\n]',r'\\r',r.rstrip()))
            elif isinstance(r, list):
                ary.append(','.join([str(t) for t in r]))
            else:
                #id, reference, timestamp, etc.
                ary.append(str(r))

        tsv_list.append('\t'.join(ary))

    filestr = MR_CONF['APP_NAME']+'_annote'
    datestr = datetime.datetime.today().strftime('_%Y%m%d_%H%M%S')
    #extstr = '_utf16le_sig_tsv.txt'
    extstr = '_utf8_tsv.txt'

    dpath = os.path.join(MR_CONF['EXPORT_PATH'])
    fpath = os.path.join(MR_CONF['EXPORT_PATH'],'%s' % filestr+datestr+extstr)

    if not os.path.exists(dpath):
       os.mkdir(dpath)

    try:
        #with codecs.open(fpath, 'w', 'utf_16_le') as fd:
        #  #fd.write('\ufeff')
        #  fd.write(unicode(codecs.BOM_UTF16_LE,'utf_16_le'))
        #  for line in tsv_list:
        #      fd.write('%s\r\n' % unicode(line,'utf-8'))
        with codecs.open(fpath, 'w', 'utf-8') as fd:
          for line in tsv_list:
              #fd.write('%s\n' % unicode(line,'utf-8'))
              fd.write('%s\n' % line)

        dbm.mr_exports.insert(mr_filename=filestr+datestr+extstr)

    except:
        raise


@auth.requires_login()
def export_list():
    """
    データベースのエクスポート結果一覧
    2018-11
    """
    __precheck()

    message='必要なテーブルを下記のリンクからダウンロードできます．保存の新しい順に現在あるすべてのバックアップを表示します．'

    #ExportパスのFileリストを取得
    __refresh_exports()

    rows = dbm(dbm.mr_exports).select(orderby=~dbm.mr_exports.mr_createdate)

    extable = DIV(
                    TABLE(
                        TR(
                            TD(INPUT(_type='button',_value=T('Export Cancel'),_id='export_cancel',_class='btn btn-secondary')
                            )
                        )
                        ,_class='table_export table_head'
                    )
                    ,TABLE(
                        TR(
                            TH(T('In order of new'),_style='width:33%')
                            ,TH(T('File'))
                        )
                        ,*[TR(
                            TD(str(i+1))
                            ,TD(A(r.mr_filename, _href=URL(f='download',args=['data',r.mr_filename])))
                            ) for i, r in enumerate(rows) if i < 20
                        ]
                        ,_class='table_export'

                    )
                    ,_class='table_export_div'
                )

    return dict(message=message,extable=extable)


def __refresh_exports():
    """
    エクスポート・フォルダ直下のファイルを得て、mr_exportsを更新する。
    2018-11
    """
    dbm(dbm.mr_exports).update(mr_enabled=False)

    for filename in os.listdir(MR_CONF['EXPORT_PATH']):
        if not filename.startswith(MR_CONF['APP_NAME']+'_'): continue
        if dbm(dbm.mr_exports.mr_filename==filename).count()==0:
            m = os.stat(MR_CONF['EXPORT_PATH']+filename)
            cdate = time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(m.st_ctime))
            dbm.mr_exports.insert(mr_filename=filename,mr_createdate=cdate,mr_enabled=True)
        else:
            dbm(dbm.mr_exports.mr_filename==filename).update(mr_enabled=True)


# ========================================
# テーブル更新
# 2018-11
# ========================================

@auth.requires_login()
def update_table():
    """
    テーブルの管理更新
    2018-11
    """
    __precheck()

    message = ''
    errors = []
    errors2 = []    #xid重複確認用
    errors3 = []    #folder重複確認用

    ds = []

    var_subtitle = ''
    var_target = 'resource'
    var_target_id = 1
    var_class = 3  # Metadata set (default)
    var_process = 0

    if len(request.args)>0:
        var_target = sanitize(request.args[0])
        if var_target == 'page':
            var_target_id = 2
            var_class = 2  # Page section
        elif var_target == 'file' or var_target == 'annote':
            var_target_id = 0  # Dumy (Undefined)
            var_class = 1  # Dumy (Undefined)

        if len(request.args)>1:
            var_class = int(request.args[1] or 3)
            if var_target == 'page':
                var_class = 2  # Page section
            elif var_target == 'file' or var_target == 'annote':
                var_class = 1  # Dumy (Undefined)

            if len(request.args)>2:
                temp_process = sanitize(request.args[2])
                if temp_process is not None and temp_process != '':
                    if temp_process == 'check':
                        var_process = 1
                    elif temp_process == 'update':
                        var_process = 2

    # バックアップフォルダ
    if not os.path.exists(MR_CONF['RESTORE_PATH']+'backups/'):
        os.mkdir(MR_CONF['RESTORE_PATH']+'backups/')

    filedata = 'File name:----　Update datetime:----　File size:----'

    if var_target == 'file' or var_target == 'annote':
        if os.path.exists(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt'):
            m = os.stat(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')
            filedata = 'File name:%s　Update datetime:%s　File size:%s' % (MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt',time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(m.st_mtime)),str(m.st_size))
        else:
            var_process = -1
    else:
        if os.path.exists(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt'):
            m = os.stat(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')
            filedata = 'File name:%s　Update datetime:%s　File size:%s' % (MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt',time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(m.st_mtime)),str(m.st_size))
        else:
            var_process = -1

    if var_process == 2:
        # update
        sw='0'
        if var_target == 'resource':
            (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')
            res_dict = __restore_resource(var_class, _fields, _temp)
            message = res_dict['message']
            errors = res_dict['errors']
        elif var_target == 'page':
            (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')
            res_dict = __restore_page(var_class, _fields, _temp)
            message = res_dict['message']
            errors = res_dict['errors']
        elif var_target == 'file':
            (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')
            res_dict = __restore_file(_fields, _temp)
            message = res_dict['message']
            errors = res_dict['errors']
        elif var_target == 'annote':
            (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')
            res_dict = __restore_annote(_fields, _temp)
            message = res_dict['message']
            errors = res_dict['errors']

    elif var_process == 1:
        # check
        sw='0'

        if var_target == 'file' or var_target == 'annote':
            if os.path.exists(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt'):
                try:
                    (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')

                    (line, loop, loss, dupl, news, errors, errors2, errors3, errors4) = __restore_check_file(var_target, _fields, _temp)

                    if loss==0 and line==loop and dupl==0:
                        message='検査：結果：'+str(line)+'件のデータ中、確認済：'+str(loop)+'件、エラー：'+str(loss)+'件、ID,Folder重複：'+str(dupl)+'件、新規：'+str(news)+'件　＞　更新適用が行えます．'
                    else:
                        message='検査：結果：'+str(line)+'件のデータ中、確認済：'+str(loop)+'件、エラー：'+str(loss)+'件、ID,Folder重複：'+str(dupl)+'件、新規：'+str(news)+'件　＞　データの確認が必要です．'
                except:
                    message='検査エラー：読み込みファイルの位置を確認してください．'
            else:
                sw='1'
                message='検査エラー：更新用のファイルはありません．アップロードが必要です．'
        else:
            if os.path.exists(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt'):
                try:
                    (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')

                    (line, loop, loss, dupl, news, errors, errors2, errors3, errors4) = __restore_check(var_target, var_class, _fields, _temp)

                    if loss==0 and line==loop and dupl==0:
                        message='検査：結果：'+str(line)+'件のデータ中、確認済：'+str(loop)+'件、エラー：'+str(loss)+'件、ID,Folder重複：'+str(dupl)+'件、新規：'+str(news)+'件　＞　更新適用が行えます．'
                    else:
                        message='検査：結果：'+str(line)+'件のデータ中、確認済：'+str(loop)+'件、エラー：'+str(loss)+'件、ID,Folder重複：'+str(dupl)+'件、新規：'+str(news)+'件　＞　データの確認が必要です．'
                except:
                    message='検査エラー：読み込みファイルの位置を確認してください．'
            else:
                sw='1'
                message='検査エラー：更新用のファイルはありません．アップロードが必要です．'

    else:
        # file upload (default)
        sw='1'    #選択
        message='新しくファイルをアップロードするか、現在のファイルで更新を行ないます．最初に選んでください．'

        if var_process < 0:
            message='更新用のファイルはありません．アップロードが必要です．'

    form = FORM(
                TABLE(
                    TR(
                        TD(T('Restore Select'),_class='table_name')
                        ,TD(
                            INPUT(_type='radio', _name='restoreselect', _value='1', value=sw), SPAN(T('Restore New'))
                            ,INPUT(_type='radio', _name='restoreselect', _value='0', value=sw), SPAN(T('Restore Current'))
                        )
                    )
                    ,_class='table_upload table_head'
                )
                ,TABLE(
                    TR(
                        TD(T('Target'),_class='table_name')
                        ,TD(
                            INPUT(_type='radio', _name='restoretarget', _value='1', value=var_target_id), SPAN(T('resource'))
                            ,INPUT(_type='radio', _name='restoretarget', _value='2', value=var_target_id), SPAN(T('page'))
                            ,INPUT(_type='radio', _name='restoretarget', _value='0', value=var_target_id), SPAN(T('file|annote'))
                            ,SPAN(T(''))
                            ,SELECT(
                                *[OPTION(r.mr_title,_value=r.id) for r in dbm(dbm.mr_classes.id>0).select(orderby=dbm.mr_classes.id)]
                                ,value=var_class
                                ,_name='restoreclass'
                            )
                        )
                    )
                    ,_class='table_upload table_head'
                )

                ,TABLE(
                    TR(
                        TD(T('Restore File'),_class='table_name')
                        ,TD(INPUT(_name='restorefile',_type='file',_class='input_file'))
                    )
                    ,TR(
                        TD('')
                        ,TD(INPUT(_type='submit',_value=T('Restore Upload'),_class='btn btn-primary'),INPUT(_type='reset',_value=T('Restore Upload Reset'),_class='btn btn-secondary'))
                    )
                    ,_class='table_upload'
                )

                ,TABLE(
                    TR(
                        TD(T('Restore Data'),_class='table_name')
                        ,TD(INPUT(_type='button',_value=T('Restore Check'),_id='restore_check_data',_class='btn btn-primary'))
                    )
                    ,TR(
                        TD('')
                        ,TD(_id='table_value')
                    )
                    ,TR(
                        TD('')
                        ,TD(INPUT(_type='button',_value=T('Restore Apply'),_id='restore_apply_data',_class='btn btn-primary'))
                    )
                    ,_class='table_upload'
                )

                ,TABLE(
                    TR(
                        TD('',_class='table_name')
                        ,TD(INPUT(_type='button',_value=T('Restore Cancel'),_id='restore_cancel',_class='btn btn-secondary'))
                    )
                    ,_class='table_upload table_head'
                )
                ,**{'_data-target':var_target,'_data-class':str(var_class)}
            )

    if form.process().accepted:

            fname = re.split('[\\\/]',form.vars.restorefile.filename)
            shutil.copyfileobj(form.vars.restorefile.file, open(MR_CONF['RESTORE_PATH']+'backups/'+fname[-1], 'wb'))
            if fname[-1].endswith('csv'):
                shutil.copy2(MR_CONF['RESTORE_PATH']+'backups/'+fname[-1], MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8.csv')

                m = os.stat(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8.csv')
            else:
                if var_class > 1:
                    shutil.copy2(MR_CONF['RESTORE_PATH']+'backups/'+fname[-1], MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')

                    m = os.stat(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')
                else:
                    shutil.copy2(MR_CONF['RESTORE_PATH']+'backups/'+fname[-1], MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')

                    m = os.stat(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')
            filedata = 'File name:%s　Update datatime:%s　FIle size:%s' % (fname[-1],time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(m.st_mtime)),str(m.st_size))
            sw='0'

            #response.flash = 'form accepted'
    elif form.errors:
            #response.flash = 'form has errors'
            message='Upload error：アップロードの際に不明なエラーが発生しました．'

    return dict(message=message,form=form,filedata=filedata,sw=sw,subtitle=var_subtitle,errors=errors,errors2=errors2,errors3=errors3,mr_target=var_target,mr_target_id=str(var_target_id),mr_class=str(var_class))


def __restore_check(_target, _classid, _fields, _temp):
    """
    フォーマット確認(TSV,CSV)
    @_target: resource(mr_resources,mr_resource_items),page(mr_sections,mr_section_items)
    2018-11/2019-05
    """
    errors=[]
    errors2=[]  #xid重複確認用
    errors3=[]  #folder重複確認用
    errors4=[]  #フィールド・ミスマッチ

    ds=[]

    line=0
    loop=0
    loss=0
    news=0

    if _target == 'resource':
        _tables = ['mr_resources','mr_resource_items']
    elif _target == 'page':
        _tables = ['mr_sections','mr_section_items']

    xids = set()    #xid重複確認
    xids0 = [r.id for r in dbm(dbm[_tables[0]]._id>0).select()]
    xnames = set()

    _xfields = __fields(_classid)

    # _temp: text array
    if _temp:
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    dd = {}
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv in _xfields['fields']:
                            dd.setdefault(fv, row[i])
                            continue
                        elif fv not in _xfields['field']:
                            errors4.append([line,fv1])
                            continue

                        elif fv in ('id'):
                            var_xid = int(row[i] or 0)
                            #新規確認
                            if var_xid in xids0:
                                pass
                            else:
                                news+=1
                            #重複確認
                            if var_xid in xids:
                                errors2.append(var_xid)
                            elif var_xid>0:
                                xids.add(var_xid)
                        elif fv in ('mr_class_id','mr_order'):
                            d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_parent_id'):
                            d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_page_id'):
                            d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_collection_ids'):
                            rts = dbm(dbm.mr_collections.mr_title.like(row[i])).select().first()
                            if rts:
                                d.setdefault(fv, rts.id)
                            else:
                                d.setdefault(fv, 1)
                        elif fv in ('mr_open'):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        elif fv in ('mr_name','mr_summary'):
                            d.setdefault(fv, row[i])
                        elif fv in ('mr_text'):
                            d.setdefault(fv, row[i])
                        else:
                            pass

                    loop+=1

                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

    return (line, loop, loss, len(errors2)+len(errors3)+len(errors4), news, errors, errors2, errors3, errors4)


def __restore_check_file(_target, _fields, _temp):
    """
    フォーマット確認(TSV,CSV)
    @_target: file(mr_files)
    2018-11
    """
    errors=[]
    errors2=[]  #xid重複確認用
    errors3=[]  #folder重複確認用
    errors4=[]  #フィールド・ミスマッチ

    ds=[]

    line=0
    loop=0
    loss=0
    news=0

    if _target == 'file':
        _tables = ['mr_files']
    elif _target == 'annote':
        _tables = ['mr_annotes']

    xids = set()    #xid重複確認
    xids0 = [r.id for r in dbm(dbm[_tables[0]]._id>0).select()]
    xnames = set()

    _xfields = dbm[_tables[0]]._fields

    # _temp: text array
    if _temp:
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    dd = {}
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv not in _xfields:
                            errors4.append([line,fv1])
                            continue

                        elif fv in ('id'):
                            var_xid = int(row[i] or 0)
                            #新規確認
                            if var_xid in xids0:
                                pass
                            else:
                                news+=1
                            #重複確認
                            if var_xid in xids:
                                errors2.append(var_xid)
                            elif var_xid>0:
                                xids.add(var_xid)
                        elif fv in ('mr_resource_id','mr_file_id','mr_order'):
                            d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_imw','mr_imh','mr_imlw','mr_imlh','mr_immw','mr_immh','mr_imsw','mr_imsh'):
                            d.setdefault(fv, int(row[i] or 0))
                        elif fv in ('mr_annote_rotation'):
                            d.setdefault(fv, float(row[i] or 0.0))
                        elif fv in ('mr_rotation'):
                            d.setdefault(fv, int(row[i] or 0))
                        elif fv in ('mr_editor'):
                            #d.setdefault(fv, int(row[i] or 0))
                            pass
                        elif fv in ('mr_annote_area','mr_annote_data','mr_annote_color'):
                            d.setdefault(fv, [int(v) for v in row[i].split(',')])
                        elif fv in ('mr_open'):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        elif fv in ('mr_create_date','mr_update_date'):
                            pass
                        else:
                            d.setdefault(fv, row[i])

                    loop+=1

                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

    return (line, loop, loss, len(errors2)+len(errors3)+len(errors4), news, errors, errors2, errors3, errors4)


def __restore_resource(_classid, _fields, _temp):
    """
    ##データ（Tab区切りテキスト, utf_16_le_sig）をデータベースに追加で読み込む
    データ（Tab区切りテキスト, utf-8）をデータベースに追加で読み込む
    idによって更新する
    削除はここでは行なわない

    @_classid
    @_fields
    @_temp

    2018-11/2019-05
    """
    errors=[]

    line=0
    loop=0
    loss=0

    _tables = ['mr_resources','mr_resource_items']

    # ===================================
    # element (class_element_id)
    # field (target_table item name)
    # fields (element_table item name)
    # ary
    # ===================================
    _xfields = __fields(_classid)
    _group = _xfields['element']['group']

    # _temp: text array
    if _temp:
        try:
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    dd = []
                    #var_keywords = []
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv in _xfields['fields']:
                            j = _xfields['fields'].index(fv)
                            dd.append([_group[j], row[i]])
                            continue
                        elif fv not in _xfields['field']:
                            continue

                        if fv in ('id'):
                            var_xid = int(row[i] or 0)
                        elif fv in ('mr_class_id','mr_order','mr_parent_id'):
                            d.setdefault(fv, int(row[i]))
                        elif fv in ('bk_collection'):
                            rts = dbm(dbm.mr_collections.mr_title.like(row[i])).select().first()
                            if rts:
                                d.setdefault(fv, rts.id)
                            else:
                                d.setdefault(fv, 1)
                        elif fv in ('mr_open'):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        elif fv in ('mr_name','mr_summary'):
                            d.setdefault(fv, re.sub(r'\\r\\r',r'\r\n',row[i]))

                    # 新規追加もしくは更新
                    #d.setdefault('keyword','|%s|' % '|'.join(var_keywords))
                    #d.setdefault('updated_on', datetime.datetime.now());
                    dbm.mr_resources.update_or_insert(dbm.mr_resources.id==var_xid,**dbm.mr_resources._filter_fields(d))

                    for d2 in dd:
                        dbm.mr_resource_items.update_or_insert(
                            (
                                (dbm.mr_resource_items.mr_resource_id==var_xid)
                                & (dbm.mr_resource_items.mr_class_element_id==d2[0])
                            )
                            ,mr_text = re.sub(r'\\r\\r',r'\r\n',d2[1]))

                    loop+=1
                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

            dbm.commit()
            #dbm(dbm.mr_resources.removed==True).delete()

        except:
            dbm.rollback()
            return dict(message='更新エラー：読み込みファイルの内容を確認してください．',errors=errors)

    return dict(message='更新結果：'+str(loop)+'件のデータを読み込みました．（'+str(loss)+'件は読み込み失敗）',errors=errors)


def __restore_page(_classid, _fields, _temp):
    """
    ##画像データ（Tab区切りテキスト, utf_16_le_sig）をデータベースに追加で読み込む
    画像データ（Tab区切りテキスト, utf-8）をデータベースに追加で読み込む
    idによって更新する
    削除はここでは行なわない

    @_classid
    @_fields
    @_temp

    2018-11/2019-05
    """
    errors=[]

    line=0
    loop=0
    loss=0

    # ===================================
    # element (class_element_id)
    # field (target_table item name)
    # fields (element_table item name)
    # ary
    # ===================================
    _xfields = __fields(_classid)
    _group = _xfields['element']['group']

    # _temp: text array
    if _temp:
        try:
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    dd = []
                    #var_keywords = []
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv in _xfields['fields']:
                            j = _xfields['fields'].index(fv)
                            dd.append([_group[j], row[i]])
                            continue
                        elif fv not in _xfields['field']:
                            continue

                        if fv in ('id'):
                            var_xid = int(row[i] or 0)
                        elif fv in ('mr_class_id','mr_order','mr_page_id'):
                            d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_open'):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        elif fv in ('mr_name','mr_text'):
                            d.setdefault(fv, re.sub(r'\\r\\r',r'\r\n',row[i]))

                    # 新規追加もしくは更新
                    dbm.mr_sections.update_or_insert(dbm.mr_sections.id==var_xid,**dbm.mr_sections._filter_fields(d))

                    for d2 in dd:
                        dbm.mr_section_items.update_or_insert(
                            (
                                (dbm.mr_section_items.mr_section_id==var_xid)
                                & (dbm.mr_section_items.mr_class_element_id==d2[0])
                            )
                            ,mr_text = re.sub(r'\\r\\r',r'\r\n',d2[1]))

                    loop+=1
                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

            dbm.commit()
            #dbm(dbm.mr_pages.removed==True).delete()

        except:
            dbm.rollback()
            return dict(message='更新エラー：読み込みファイルの内容を確認してください．',errors=errors)

    return dict(message='更新結果：'+str(loop)+'件のデータを読み込みました．（'+str(loss)+'件は読み込み失敗）',errors=errors)


def __restore_file(_fields, _temp):
    """
    ##画像データ（Tab区切りテキスト, utf_16_le_sig）をデータベースに追加で読み込む
    画像データ（Tab区切りテキスト, utf-8）をデータベースに追加で読み込む
    idによって更新する
    削除はここでは行なわない

    @_fields
    @_temp

    2018-11
    """
    errors=[]

    line=0
    loop=0
    loss=0

    _xfields = dbm['mr_files']._fields

    # _temp: text array
    if _temp:
        try:
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    dd = []
                    #var_keywords = []
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv not in _xfields:
                            continue

                        if fv in ('id'):
                            var_xid = int(row[i] or 0)
                        elif fv in ('mr_resource_id','mr_order'):
                            d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_imw','mr_imh','mr_imlw','mr_imlh','mr_immw','mr_immh','mr_imsw','mr_imsh'):
                            d.setdefault(fv, int(row[i] or 0))
                        elif fv in ('mr_rotation'):
                            d.setdefault(fv, int(row[i] or 0))
                        elif fv in ('mr_editor'):
                             pass
                        elif fv in ('mr_open'):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        elif fv in ('mr_create_date','mr_update_date'):
                            pass
                        elif fv in ('mr_description','mr_license','mr_note'):
                            d.setdefault(fv, re.sub(r'\\r\\r',r'\r\n',row[i]))
                        else:
                            d.setdefault(fv, row[i])

                    # 新規追加もしくは更新
                    dbm.mr_files.update_or_insert(dbm.mr_files.id==var_xid,**dbm.mr_files._filter_fields(d))

                    loop+=1
                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

            dbm.commit()
            #dbm(dbm.mr_files.removed==True).delete()

        except:
            dbm.rollback()
            return dict(message='更新エラー：読み込みファイルの内容を確認してください．',errors=errors)

    return dict(message='更新結果：'+str(loop)+'件のデータを読み込みました．（'+str(loss)+'件は読み込み失敗）',errors=errors)


def __restore_annote(_fields, _temp):
    """
    ##アノテーション・データ（Tab区切りテキスト, utf_16_le_sig）をデータベースに追加で読み込む
    アノテーション・データ（Tab区切りテキスト, utf-8）をデータベースに追加で読み込む
    idによって更新する
    削除はここでは行なわない

    @_fields
    @_temp

    2018-11/2019-05
    """
    errors=[]

    line=0
    loop=0
    loss=0

    _xfields = dbm['mr_annotes']._fields

    # _temp: text array
    if _temp:
        try:
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    dd = []
                    #var_keywords = []
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv not in _xfields:
                            continue

                        if fv in ('id'):
                            var_xid = int(row[i] or 0)
                        elif fv in ('mr_resource_id','mr_file_id','mr_order'):
                            d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_annote_rotation'):
                            d.setdefault(fv, float(row[i] or 0))
                        elif fv in ('mr_annote_area','mr_annote_data','mr_annote_color'):
                            d.setdefault(fv, [int(v) for v in row[i].split(',')])
                        #elif fv in ('mr_editor'):
                        #     pass
                        elif fv in ('mr_open'):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        #elif fv in ('mr_create_date','mr_update_date'):
                        #    pass
                        elif fv in ('mr_name','mr_text'):
                            d.setdefault(fv, re.sub(r'\\r\\r',r'\r\n',row[i]))
                        else:
                            d.setdefault(fv, row[i])

                    # 新規追加もしくは更新
                    dbm.mr_annotes.update_or_insert(dbm.mr_annotes.id==var_xid,**dbm.mr_annotes._filter_fields(d))

                    loop+=1
                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

            dbm.commit()
            #dbm(dbm.mr_files.removed==True).delete()

        except:
            dbm.rollback()
            return dict(message='更新エラー：読み込みファイルの内容を確認してください．',errors=errors)

    return dict(message='更新結果：'+str(loop)+'件のデータを読み込みました．（'+str(loss)+'件は読み込み失敗）',errors=errors)


def __load_csvtext_file(filepath, codetype='utf-8-sig', sig=True):
    """
    CSVの読み込み
    行末の改行（Windows）を除き、コンマで分けた２重リストにして返す
    RESERVED
    2018-11
    """
    import csv

    fields = []
    texts = []
    first = True
    second = True
    if filepath:
        file = codecs.open(filepath, 'r', codetype)
        reader = csv.reader(file, delimiter=',', quotechar='"')
        try:
            for ary in reader:
                try:
                    if len(ary)<1:
                        pass
                    elif first and (not ary[0].isdigit() or 'id' in ary[0].lower() or '_id' in ary[0] or 'xid' in ary[0] or 'x_id' in ary[0]):           #先頭行がフィールド名の場合
                        fields = ary
                    elif second and (not ary[0].isdigit() or 'id' in ary[0].lower() or '_id' in ary[0] or 'xid' in ary[0] or 'x_id' in ary[0]):           #先頭行がフィールド名の場合
                        fields = ary
                    else:
                        texts.append(ary)
                except:
                    pass
                if not first: second = False
                if first: first=False
        finally:
            file.close()

    return (fields, texts)


def __load_tabtext_file(filepath, codetype='utf-8', sig=False):
    """
    Tab Separated Textの読み込み
    行末の改行（Windows）を除き、TAB(\t)で分けた２重リストにして返す
    2018-11
    """
    fields = []
    texts = []
    first = True
    second = True
    if filepath:
        file = codecs.open(filepath, 'r', codetype, 'ignore')
        try:
            for line in file:
                if first and sig: line = line[3:]
                line = line.rstrip('\n')
                ary = line.split('\t')
                try:
                    if len(line)<1 or len(ary)<1:
                        pass
                    elif first and (not ary[0].isdigit() or 'id' in ary[0].lower() or '_id' in ary[0] or 'xid' in ary[0] or 'x_id' in ary[0]):           #先頭行がフィールド名の場合
                        fields = [str(s).strip() for s in line.split('\t')]
                    elif second and (not ary[0].isdigit() or 'id' in ary[0].lower() or '_id' in ary[0] or 'xid' in ary[0] or 'x_id' in ary[0]):           #先頭行がフィールド名の場合
                        fields = [str(s).strip() for s in line.split('\t')]
                    else:
                        texts.append(ary)
                except:
                    pass
                if not first: second = False
                if first: first=False
        finally:
            file.close()
    return (fields, texts)


@auth.requires_login()
def download():
    """
    Exportファイルのダウンロード
    2018-11
    """
    __precheck()

    if not request.args:
        raise HTTP(404)

    target = 'EXPORT_PATH'

    name = request.args[-1]

    if sys.version_info > (3,):

        from gluon.contenttype import contenttype

        try:
            fpath = os.path.join(MR_CONF[target],'%s' % name)
            file = codecs.open(fpath, 'r', 'utf-8').read()
        except:
            raise HTTP(404)

        response.headers["Content-Type"] = contenttype(name)
        response.headers["Content-Disposition"] = "attachment; filename=%s" % name
        raise HTTP(200, file, **response.headers)

    elif sys.version_info > (2, 7):

        import contenttype

        try:
            fpath = os.path.join(MR_CONF[target],'%s' % name)
            file = open(fpath, 'r')
        except:
            raise HTTP(404)

        response.headers["Content-Type"] = contenttype.contenttype(name)
        response.headers["Content-Disposition"] = "attachment; filename=%s" % name
        stream = response.stream(file, chunk_size=64*1024, request=request)
        raise HTTP(200, stream, **response.headers)

    else:

        raise HTTP(404)
