# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1910r4
## - Date: 2019-10-23
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

import sys
import os
import time
import datetime
import codecs
import shutil
import unicodedata
import re
import json
from gluon.sanitizer import sanitize
from gluon.sqlhtml import PasswordWidget

mr_datahelper = local_import('mr_datahelper', reload=MR_CONF['RELOAD'])


def __precheck():
    """
    ログイン制御
    該当しなければログインを通過
    """
    if session.groupid is None:
        redirect(URL('staff','user',args=['logout']))

    if session.auth.user.id < 5 and not ( request.env.remote_addr in configuration.get('myconfig.allowances') or request.env.remote_addr.startswith(configuration.get('myconfig.local_ip')) ):
        redirect(URL('staff','user',args=['logout']))

    # 制限
    if session.groupid > MR_CONF['GROUP_ADMINISTRATOR']:
        redirect(URL('staff','user',args=['logout']))
    pass


# ========================================
# Main controllers
# ========================================

@auth.requires_login()
def index():
    """
    管理ページ・トップ
    """
    __precheck()
    return dict()


# ========================================
# ユーザー管理
# ========================================

def __getAnchor(func, arg, b):
    if b:
        return A(arg,_href=URL(func,args=[arg]))
    else:
        return '';


@auth.requires_login()
def listup_users():
    """
    ユーザー一覧
    """
    __precheck()

    table = ''

    entable = False
    if crud.has_permission('update',db.auth_user):
        entable = True

    shif = 0
    if request.env.remote_addr.startswith(configuration.get('myconfig.local_ip')):
    	shif = 1
    elif request.env.remote_addr in configuration.get('myconfig.allowances'):
        shif = 1

    rows = db((db.auth_user.id==db.auth_membership.user_id) & (db.auth_group.id==db.auth_membership.group_id) & (db.auth_group.id>session.groupid-1)).select(orderby=~db.auth_user.id)

    if shif > 0:
        table = TABLE(TR(TH(T('ID')),TH(T('Login name')),TH(T('Name')),TH(T('Group'))),
                *[TR(
                    TD(__getAnchor('edit_user',item.auth_user.id, entable),_width='50'),
                    TD(item.auth_user.username),
                    TD(item.auth_user.last_name+' '+item.auth_user.first_name),
                    TD(item.auth_group.description+' ('+item.auth_group.role+')'))
                for item in rows if item.auth_group.id < 6],
            _border='1', _sellpadding='5', _sellspacing='0')
    else:
        table = TABLE(TR(TH(T('ID')),TH(T('Login name')),TH(T('Name')),TH(T('Group'))),
                *[TR(
                    TD(__getAnchor('edit_user',item.auth_user.id, entable),_width='50'),
                    TD(item.auth_user.username),
                    TD(item.auth_user.last_name+' '+item.auth_user.first_name),
                    TD(item.auth_group.description+' ('+item.auth_group.role+')'))
                for item in rows if (item.auth_group.id < 6 and item.auth_user.id > 5)],
            _border='1', _sellpadding='5', _sellspacing='0')

    return dict(message=T('User List'),table=table,entable=entable)


@auth.requires_login()
def edit_user():
    """
    ユーザー表示・編集
    edit_user?id=<id>であればユーザーの編集表示、
    それ以外は、（エラーを含め）新規登録表示を行う。
    削除はこのバージョンでは原則として実施しない。アクセス不可にするには権限をゲストにする。
    """
    __precheck()

    if not crud.has_permission('update',db.auth_user):
        redirect(URL('listup_users'))
    if not request.args and not crud.has_permission('update',db.auth_user):
        redirect(URL('listup_users'))

    fields = ['username','first_name','last_name']
    labels = {'username':T('Username'),'first_name':T('Your Name'),'last_name':T('Description')}
    groups = None
    groupops = []

    try:
        record = db.auth_user(int(request.args(0)))
        groups = db(db.auth_membership.user_id==int(request.args(0))).select()
    except:
        record = {'username':'','last_name':'','first_name':'','password':''}

    if record is None:
        record = {'username':'','last_name':'','first_name':'','password':''}

    group_id = 4    #Editor
    if groups:
        group_id = int(groups[0]['group_id'])

    # 権限制限
    if record is None or session.groupid > group_id:
        redirect(URL('listup_users'))

    if session.groupid>MR_CONF['GROUP_DEVELOPER']:
        groupops=[{'description':T('Developer'), 'id':'1'},
              {'description':T('Administrator'), 'id':'2'},
              {'description':T('Editor'), 'id':'3'},
              #{'description':T('User'), 'id':'4'},
              #{'description':T('Guest'), 'id':'5'}
              ]
    else:
        groupops=[{'description':T('Developer'), 'id':'1'},
              {'description':T('Administrator'), 'id':'2'},
              {'description':T('Editor'), 'id':'3'},
              {'description':T('User'), 'id':'4'},
              {'description':T('Guest'), 'id':'5'}
              ]

    form = FORM(
                TABLE(
                    *[TR(TD(T(labels[item]),_width='150'),TD(INPUT(_value=record[item],_name=item, requires=IS_NOT_EMPTY(),_width='300'))) for item in fields],
                    _border='0', _cellpadding='5', _cellspacing='0'),
                TABLE(
                    TR(TD(T('Password'),_width='150'),TD(PasswordWidget.widget(db.auth_user.password,record['password'],_width='300'))),
                    TR(TD(T('Group ID')),
                        TD(
                            SELECT(
                                *[OPTION(group['description'],_value=int(group['id'])) for group in groupops[(session.groupid - 1):]],    #権限の制限
                                value=group_id,_name='group_id'
                            )
                        )
                    ),
                    TR(
                        TD(''),
                        TD(
                            INPUT(_type='submit',_value=T('Send'),_class='btn btn-primary'),
                            INPUT(_type='button',_value=T('Cancel'),_onclick=XML("location.href='"+URL(listup_users)+"'"),_class='btn btn-secondary')
                        ),
                        _rowspan='2'),
                    _border='0', _cellpadding='5', _cellspacing='0'),
            _id='form1',_method='POST',_action='')

    delete_tr = TR(TD(T('Check to delete'),_width='150'),TD(INPUT(_name='delete_this_record',_type='checkbox',value=False),_width='300'))

    if request.args and record and record.id > 5:
        form[1][1].insert(2,delete_tr)

    message=T('Edit User')

    if form.accepts(request.vars, session):
        if not request.args and crud.has_permission('update',db.auth_user):
            id = db.auth_user.insert(**db.auth_user._filter_fields(form.vars))
            form.vars.user_id=id
            id = db.auth_membership.insert(**db.auth_membership._filter_fields(form.vars))
        elif form.vars['delete_this_record'] and crud.has_permission('delete',db.auth_user):
            # 削除
            if record and record.id > 5:
                db(db.auth_membership.user_id==record.id).delete()
                db(db.auth_user.id==record.id).delete()
        elif crud.has_permission('update',db.auth_user):
            id = db(db.auth_user.id==record['id']).update(**db.auth_user._filter_fields(form.vars))
            #form.vars.user_id=id
            id = db(db.auth_membership.user_id==record['id']).update(group_id=form.vars.group_id)
        redirect(URL('listup_users'))
    elif form.errors:
        response.flash = T('Error')
        message=T('Error')

    return dict(message=message,form=form)


# ========================================
# Workgroup
# ========================================

@auth.requires_login()
def workgroup():
    """
    Workgroup
    ユーザーとコレクションの関係
    """
    __precheck()

    var_name = 'workgroups'

    var_db = dbm.mr_workgroups
    var_fields = [dbm.mr_workgroups.id,
                dbm.mr_workgroups.mr_user_ids,
                dbm.mr_workgroups.mr_name,
                dbm.mr_workgroups.mr_description,
                dbm.mr_workgroups.mr_order,
                dbm.mr_workgroups.mr_open
                ]

    grid = SQLFORM.grid(
                var_db,
                fields=var_fields,
                paginate=20,
                searchable=True,
                editable=MR_CONF['EDITABLE'],
                details=True,
                deletable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                create=MR_CONF['EDITABLE'],
                #csv=False,
                exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV'),
                    csv_with_hidden_cols=False, #(ExporterCSV, 'CSV (hidden cols)'),
                    #json=(ExporterJSON, 'JSON'),
                    xml=False, #(ExporterXML, 'XML'),
                    html=False, #(ExporterHTML, 'HTML'),
                    #tsv=(ExporterTSV, 'TSV (Excel compatible)'),
                    tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                ),
                ui='web2py',
                formstyle='table3cols',
                #buttons_placement = 'right',
                user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


# ========================================
# データベース管理
# ========================================

def __copy_db():
    """
    データベースの複製
    """
    #if configuration.get('dbm.uri').startswith('mysql://'):
    #    if __copy_mr_sqldb():
    #        return dict(message=T('Success')+': '+T('Duplicated database.'),report=None)
    #    else:
    #        return dict(message=T('Error')+': '+T('Database replication failed.'),report=None)
    if configuration.get('dbm.uri').startswith('sqlite://'):
        if __copy_mr_db():
            return dict(message=T('Success')+': '+T('Duplicated database.'),report=None)
        else:
            return dict(message=T('Error')+': '+T('Database replication failed.'),report=None)
    else:
        return dict(message=T('Warning')+': '+T('Database replication is not possible.'),report=None)


def __copy_mr_sqldb():
    """
    データベースの複製本体
    MySQL（MariaDB）
    RESERVED
    """
    return False


def __copy_mr_db():
    """
    データベースの複製本体
    SQLite
    """
    datestr=datetime.datetime.today().strftime('_%Y%m%d_%H%M%S')
    extstr='.sqlite'

    spath=os.path.join(MR_CONF['DB_PATH'],'%s' % MR_CONF['DB_NAME']+extstr)
    dpath=os.path.join(MR_CONF['DBBACKUP_PATH'])
    fpath=os.path.join(MR_CONF['DBBACKUP_PATH'],'%s' % MR_CONF['DB_NAME']+datestr+extstr)

    if not os.path.exists(dpath):
       os.mkdir(dpath)

    try:
        shutil.copy2(spath, fpath)
        result = True
    except:
        result = False
        pass

    return result


@auth.requires_login()
def export_database():
    """
    データベース・ファイルの複製
    id#copy_apply
    id#export_cancel
    """
    __precheck()

    message = ''

    if len(request.args)>0:
        temp_process = sanitize(request.args[0])
        if temp_process is not None and temp_process != '':
            if temp_process == 'export':
                res_dict = __copy_db()
                message = res_dict['message']
    else:
        message = T('Back up database to a defined folder with a timestamp.')

    form = FORM(
                TABLE(
                    TR(
                        TD(T('Export Database'),_class='m-table-name'),
                        TD(INPUT(_type='button',_value=T('Export Apply'),_id='copy_apply',_class="btn btn-primary")
                        )
                    ),
                    _class='m-table-export'
                ),
                TABLE(
                    TR(
                        TD('',_class='m-table-name'),
                        TD(INPUT(_type='button',_value=T('Export Cancel'),_id='export_cancel',_class="btn btn-secondary")
                        )
                    ),
                    _class='m-table-export m-table-head'
                )
            )

    return dict(message=message,form=form)


@auth.requires_login()
def export_table():
    """
    テーブル書き出し
    クラス毎にテーブルを書き出す
    #UTF_16_LE(BOM付)ファイル
    UTF-8(BOM無)ファイル
    """
    __precheck()

    message = ''
    export_tables = 'r'

    if 'table' in request.vars:
        export_tables = sanitize(request.vars.get('table'))

    if len(request.args)>1:
        temp_process = sanitize(request.args[0])
        temp_type = int(request.args[1] or 0)  # 0:TSV (default), 1:CSV (RESERVED)
        if temp_process is not None and temp_process != '':
            if temp_process == 'export':
                res_dict = __export_alltables(export_tables)
                message = res_dict['message']
    else:
        message = T('Back up tables to a defined folder.')
        __refresh_exports()

    form = FORM(
                TABLE(
                    TR(
                        TD(T('Select format'),_class='m-table-name'),
                        TD(
                            #INPUT(_type='radio', _name='exportselect', _value='1', value='0'),T('CSV'),
                            INPUT(_type='radio', _name='format', _value='0', value='0'),SPAN(T('TSV'))
                        )
                    ),
                    TR(
                        TD(T('Choice table'),_class='m-table-name'),
                        TD(
                            INPUT(_type='checkbox', _name='all', _value='', value=('rpcfams' == export_tables)),SPAN(T('All')),BR(),
                            INPUT(_type='checkbox', _name='table', _value='r', value=('r' in export_tables)),SPAN(T('Resource')),
                            INPUT(_type='checkbox', _name='table', _value='p', value=('p' in export_tables)),SPAN(T('Page section')),
                            INPUT(_type='checkbox', _name='table', _value='c', value=('c' in export_tables)),SPAN(T('Collection')),
                            INPUT(_type='checkbox', _name='table', _value='f', value=('f' in export_tables)),SPAN(T('File')),
                            INPUT(_type='checkbox', _name='table', _value='a', value=('a' in export_tables)),SPAN(T('Annotation')),
                            INPUT(_type='checkbox', _name='table', _value='m', value=('m' in export_tables)),SPAN(T('Management')),
                            INPUT(_type='checkbox', _name='table', _value='s', value=('s' in export_tables)),SPAN(T('Support')),
                        )
                    ),
                    TR(
                        TD('',_class='m-table-name'),
                        TD(
                            INPUT(_type='button',_value=T('Export Apply'),_id='export_apply',_class='btn btn-primary')
                        )
                    ),
                    _class='m-table-export'
                ),
                TABLE(
                    TR(
                        TD('',_class='m-table-name'),
                        TD(
                            INPUT(_type='button',_value=T('Export Cancel'),_id='export_cancel',_class='btn btn-secondary')
                        )
                    ),
                    _class='m-table-export m-table-head'
                )
            )

    #ExportパスのFileリストを取得
    rows = dbm(dbm.mr_exports.mr_enabled==True).select(orderby=~dbm.mr_exports.mr_createdate)

    extable = DIV(
                    TABLE(
                        TR(
                            TH(T('In order of new'),_style='width:33%'),
                            TH(T('File'))
                        ),
                        *[TR(
                            TD(str(i+1)),
                            TD(A(r.mr_filename, _href=URL(f='download',args=['data',r.mr_filename])))
                            ) for i, r in enumerate(rows) if i < 20
                        ],
                        _class='m-table-export'
                    ),
                    TABLE(
                        TR(
                            TD('',_class='m-table-name'),
                            TD(INPUT(_type='button',_value=T('Export Cancel'),_id='export_cancel',_class='btn btn-secondary')
                            )
                        ),
                        _class='m-table-export m-table-head'
                    ),
                    _class='m-table-export_div'
                )

    return dict(message=message,form=form,extable=extable, names=export_tables)


def __export_alltables(names):
    """
    データベース・テーブルのExport
    """
    success=[]
    error=[]

    # 全てのクラスとその要素セットの辞書
    d_elements = mr_datahelper.d__elementset(dbm, 0, True)

    for classid in d_elements:
        # クラスが関係するものはresourceとsection
        if classid > 1: #undefinedは除く
            class_title = d_elements[classid]['title']
            if 'r' in names and d_elements[classid]['target'] == 'resource':
                try:
                    __export_resource_table(classid, d_elements)
                    success.append(class_title)
                except:
                    error.append(class_title)

            if 'p' in names and d_elements[classid]['target'] == 'page':
                # section
                try:
                    __export_section_table(classid, d_elements)
                    success.append(class_title)
                except:
                    error.append(class_title)

    # Tables
    if 'c' in names:
        for v_table_name in ('collection','page',):
            try:
                __export_table(v_table_name)
                success.append(v_table_name)
            except:
                error.append(v_table_name)

    if 'f' in names:
        for v_table_name in ('folder','file',):
            try:
                __export_table(v_table_name)
                success.append(v_table_name)
            except:
                error.append(v_table_name)

    if 'a' in names:
        for v_table_name in ('annote',):
            try:
                __export_table(v_table_name)
                success.append(v_table_name)
            except:
                error.append(v_table_name)

    # Tables of support
    if 's' in names:
        for v_table_name in ('class','class_element',):
            try:
                __export_table(v_table_name)
                success.append(v_table_name)
            except:
                error.append(v_table_name)

    # Tables of management
    if 'm' in names:
        for v_table_name in ('resource_item','section_item','export',):
            try:
                __export_table(v_table_name)
                success.append(v_table_name)
            except:
                error.append(v_table_name)

    result = T('success: %d / error: %d (%s)') % (len(success),len(error),','.join(error) or '-')

    return dict(message=T('Result: TSV Table exported.')+' '+result)


def __fields(classid=3):
    """
    2018-11/2019-09
    """
    d_elements = mr_datahelper.d__elementset(dbm, 0, True)

    # 対象クラスの要素辞書
    d_element = d_elements[classid]

    # 対象テーブル
    table_name = None
    if d_element['target'] == 'page': # page section
        table_name = 'mr_sections'
        table_pattern = dbm[table_name]._fields
    if d_element['target'] == 'resource':
        table_name = 'mr_resources'
        table_pattern = dbm[table_name]._fields

    if table_name is None:
        raise

    try:
        # テーブルの存在確認
        dbm[table_name]
    except:
        raise

    fields1 = table_pattern[0:-2]
    fields2 = d_element['keyset']
    fields3 = table_pattern[-2:]

    l_labels = [str(dbm[table_name][field].label) for field in fields1]
    l_labels.extend([d_elements[classid]['nameset'][n]['title'] for n in fields2])
    l_labels.extend([str(dbm[table_name][field].label) for field in fields3])

    l_fields = []
    l_fields.extend(fields1)
    l_fields.extend(['%s' % t for t in fields2])
    l_fields.extend(fields3)

    return dict(element=d_element,field=table_pattern,fields=fields2)


def __export_resource_table(classid, d_elements):
    """
    Export resource table
    """
    # 対象クラスの要素辞書
    d_element = d_elements[classid]

    # 対象テーブル
    table_name = 'mr_resources'
    table_pattern_org = dbm[table_name]._fields

    try:
        # テーブルの存在確認
        dbm[table_name]
        table_pattern = [v for v in table_pattern_org if not v.startswith('mr_keyword')]
    except:
        raise


    fields1 = table_pattern[0:-2]
    fields2 = d_element['keyset']
    fields3 = table_pattern[-2:]

    l_labels = [str(dbm[table_name][field].label) for field in fields1]
    l_labels.extend([d_elements[classid]['nameset'][n]['title'] for n in fields2])
    l_labels.extend([str(dbm[table_name][field].label) for field in fields3])

    l_fields = []
    l_fields.extend(fields1)
    l_fields.extend(['%s' % t for t in fields2])
    l_fields.extend(fields3)

    tsv_list = ['\t'.join(l_labels)]     #line1:label
    tsv_list.append('\t'.join([t for t in l_fields]))     #line2:id


    records = dbm(dbm[table_name].mr_class_id==classid).select(orderby=dbm[table_name].id) or []

    class_title = dbm.mr_classes[classid]['mr_title']

    for record in records:

        #if (a_table_name == 'resource') and ('mr_collection_ids' in record) and record.mr_collection_ids:
        #    cvs = []
        #    for v in record.mr_collection_ids:
        #        vt = dbm.mr_collections[v]
        #        if vt:
        #            cvs.append(vt.mr_title)
        #    record.mr_collection_ids = '|'.join(cvs)

        #if a_table_name == 'section':
        #    vt = dbm.mr_pages[record.mr_page_id]
        #    record.mr_page_id = vt.mt_title

        records2 = dbm(
                (dbm.mr_resource_items.mr_resource_id == record.id)
                & dbm.mr_resource_items.mr_class_element_id.belongs(d_element['group'])
                #& (dbm.mr_resources_items.mr_open == True)
            ).select(
                #left=dbm.mr_class_elements.on(dbm.mr_resource_items.mr_class_element_id == dbm.mr_class_elements.id)
            )

        if records2:

            ary=[]

            for f in fields1:
                if f.startswith('mr_keyword'):
                    continue
                r = record.get(f)
                if isinstance(r, bool):
                    ary.append(str(r * 1))
                elif isinstance(r, (int,float)):
                    ary.append(str(r))
                elif isinstance(r, str):
                    ary.append(re.sub(r'[\r\n]',r'\\r',r.rstrip()))
                elif isinstance(r, list):
                    ary.append(','.join([str(t) for t in r]))
                else:
                    #id, reference, timestamp, etc.
                    ary.append(str(r))

            for fid in d_element['group']:
                value = None
                for record2 in records2:
                    if record2.mr_class_element_id == fid:
                        if record2.mr_text is not None:
                            value = re.sub(r'[\r\n]',r'\\r',record2.mr_text.rstrip())
                            break
                ary.append(value or '')

            for f in fields3:
                r = record.get(f)
                if isinstance(r, bool):
                    ary.append(str(r * 1))
                elif isinstance(r, (int,float)):
                    ary.append(str(r))
                elif isinstance(r, str):
                    ary.append(re.sub(r'[\r\n]',r'\\r',r.rstrip()))
                elif isinstance(r, list):
                    ary.append(','.join([str(t) for t in r]))
                else:
                    #id, reference, timestamp, etc.
                    ary.append(str(r))

            tsv_list.append('\t'.join(ary))

    filestr = MR_CONF['APP_NAME']+'_'+d_element['target']+'_'+str(classid)
    datestr = datetime.datetime.today().strftime('_%Y%m%d_%H%M%S')
    #extstr = '_utf16le_sig_tsv.txt'
    extstr = '_utf8_tsv.txt'

    dpath = os.path.join(MR_CONF['EXPORT_PATH'])
    fpath = os.path.join(MR_CONF['EXPORT_PATH'],'%s' % filestr+datestr+extstr)

    if not os.path.exists(dpath):
       os.mkdir(dpath)

    try:
        #with codecs.open(fpath, 'w', 'utf_16_le') as fd:
        #  #fd.write('\ufeff')
        #  fd.write(unicode(codecs.BOM_UTF16_LE,'utf_16_le'))
        #  for line in tsv_list:
        #      fd.write('%s\r\n' % unicode(line,'utf-8'))
        with codecs.open(fpath, 'w', 'utf-8') as fd:
          for line in tsv_list:
              #fd.write('%s\n' % unicode(line,'utf-8'))
              fd.write('%s\n' % line)

        dbm.mr_exports.insert(mr_filename=filestr+datestr+extstr)

    except:
        raise


def __export_section_table(classid, d_elements):
    """
    Export section table
    """
    # 対象クラスの要素辞書
    d_element = d_elements[classid]

    # 対象テーブル
    table_name = 'mr_sections'
    table_pattern = dbm[table_name]._fields

    try:
        # テーブルの存在確認
        dbm[table_name]
    except:
        raise


    fields1 = table_pattern[0:-2]
    fields2 = d_element['keyset']
    fields3 = table_pattern[-2:]

    l_labels = [str(dbm[table_name][field].label) for field in fields1]
    l_labels.extend([d_elements[classid]['nameset'][n]['title'] for n in fields2])
    l_labels.extend([str(dbm[table_name][field].label) for field in fields3])

    l_fields = []
    l_fields.extend(fields1)
    l_fields.extend(['%s' % t for t in fields2])
    l_fields.extend(fields3)

    tsv_list = ['\t'.join(l_labels)]     #line1:label
    tsv_list.append('\t'.join([t for t in l_fields]))     #line2:id


    records = dbm(dbm[table_name].mr_class_id==classid).select(orderby=dbm[table_name].id) or []

    class_title = dbm.mr_classes[classid]['mr_title']

    for record in records:

        #if a_table_name == 'section':
        #    vt = dbm.mr_pages[record.mr_page_id]
        #    record.mr_page_id = vt.mt_title

        records2 = dbm(
                (dbm.mr_section_items.mr_section_id == record.id)
                & dbm.mr_section_items.mr_class_element_id.belongs(d_element['group'])
                #& (dbm.mr_sections_items.mr_open == True)
            ).select(
                #left=dbm.mr_class_elements.on(dbm.mr_section_items.mr_class_element_id == dbm.mr_class_elements.id)
            )

        if records2:

            ary=[]

            for f in fields1:
                if 'keyword' in f:
                    continue
                r = record.get(f)
                if isinstance(r, bool):
                    ary.append(str(r * 1))
                elif isinstance(r, (int,float)):
                    ary.append(str(r))
                elif isinstance(r, str):
                    ary.append(re.sub(r'[\r\n]',r'\\r',r.rstrip()))
                elif isinstance(r, list):
                    ary.append(','.join([str(t) for t in r]))
                else:
                    #id, reference, timestamp, etc.
                    ary.append(str(r))

            for fid in d_element['group']:
                value = None
                for record2 in records2:
                    if record2.mr_class_element_id == fid:
                        if record2.mr_text is not None:
                            value = re.sub(r'[\r\n]',r'\\r',record2.mr_text.rstrip())
                            break
                ary.append(value or '')

            for f in fields3:
                r = record.get(f)
                if isinstance(r, bool):
                    ary.append(str(r * 1))
                elif isinstance(r, (int,float)):
                    ary.append(str(r))
                elif isinstance(r, str):
                    ary.append(re.sub(r'[\r\n]',r'\\r',r.rstrip()))
                elif isinstance(r, list):
                    ary.append(','.join([str(t) for t in r]))
                else:
                    #id, reference, timestamp, etc.
                    ary.append(str(r))

            tsv_list.append('\t'.join(ary))

    #filestr = MR_CONF['APP_NAME']+'_'+d_element['target']+'_'+str(classid)
    filestr = MR_CONF['APP_NAME']+'_section_'+str(classid)
    datestr = datetime.datetime.today().strftime('_%Y%m%d_%H%M%S')
    #extstr = '_utf16le_sig_tsv.txt'
    extstr = '_utf8_tsv.txt'

    dpath = os.path.join(MR_CONF['EXPORT_PATH'])
    fpath = os.path.join(MR_CONF['EXPORT_PATH'],'%s' % filestr+datestr+extstr)

    if not os.path.exists(dpath):
       os.mkdir(dpath)

    try:
        #with codecs.open(fpath, 'w', 'utf_16_le') as fd:
        #  #fd.write('\ufeff')
        #  fd.write(unicode(codecs.BOM_UTF16_LE,'utf_16_le'))
        #  for line in tsv_list:
        #      fd.write('%s\r\n' % unicode(line,'utf-8'))
        with codecs.open(fpath, 'w', 'utf-8') as fd:
          for line in tsv_list:
              #fd.write('%s\n' % unicode(line,'utf-8'))
              fd.write('%s\n' % line)

        dbm.mr_exports.insert(mr_filename=filestr+datestr+extstr)

    except:
        raise


def __export_table(a_table_name):
    """
    Export of table
    """

    # 対象テーブル
    if a_table_name in ('class',):
        target_name = '%s' % a_table_name
        table_name = 'mr_%ses' % a_table_name
    elif a_table_name in ('page','collection',):
        target_name = '%ss' % a_table_name
        table_name = 'mr_%ss' % a_table_name
    else:
        target_name = '%s' % a_table_name
        table_name = 'mr_%ss' % a_table_name

    table_pattern = dbm[table_name]._fields

    try:
        # テーブルの存在確認
        dbm[table_name]
    except:
        raise

    fields = table_pattern

    l_labels = [str(dbm[table_name][field].label) for field in fields]
    l_fields = ['%s' % t for t in fields]

    tsv_list = ['\t'.join(l_labels)]     #line1:label
    tsv_list.append('\t'.join([t for t in l_fields]))     #line2:id

    records = dbm(dbm[table_name].id>0).select(orderby=dbm[table_name].id)

    for record in records:

        ary=[]

        for f in fields:
            r = record.get(f)
            if isinstance(r, bool):
                ary.append(str(r * 1))
            elif isinstance(r, (int,float)):
                ary.append(str(r))
            elif isinstance(r, str):
                ary.append(re.sub(r'[\r\n]',r'\\r',r.rstrip()))
            elif isinstance(r, list):
                ary.append(','.join([str(t) for t in r]))
            else:
                #id, reference, timestamp, etc.
                ary.append(str(r))

        tsv_list.append('\t'.join(ary))

    filestr = MR_CONF['APP_NAME']+'_'+target_name
    datestr = datetime.datetime.today().strftime('_%Y%m%d_%H%M%S')
    #extstr = '_utf16le_sig_tsv.txt'
    extstr = '_utf8_tsv.txt'

    dpath = os.path.join(MR_CONF['EXPORT_PATH'])
    fpath = os.path.join(MR_CONF['EXPORT_PATH'],'%s' % filestr+datestr+extstr)

    if not os.path.exists(dpath):
       os.mkdir(dpath)

    try:
        #with codecs.open(fpath, 'w', 'utf_16_le') as fd:
        #  #fd.write('\ufeff')
        #  fd.write(unicode(codecs.BOM_UTF16_LE,'utf_16_le'))
        #  for line in tsv_list:
        #      fd.write('%s\r\n' % unicode(line,'utf-8'))
        with codecs.open(fpath, 'w', 'utf-8') as fd:
          for line in tsv_list:
              #fd.write('%s\n' % unicode(line,'utf-8'))
              fd.write('%s\n' % line)

        dbm.mr_exports.insert(mr_filename=filestr+datestr+extstr)

    except:
        raise


@auth.requires_login()
def export_list():
    """
    データベースのエクスポート結果一覧
    """
    __precheck()

    message=T('You can download the table file from the link below. They are displayed in order from the newest.')

    #ExportパスのFileリストを取得
    __refresh_exports()

    rows = dbm(dbm.mr_exports).select(orderby=~dbm.mr_exports.mr_createdate)

    extable = DIV(
                    TABLE(
                        TR(
                            TD(INPUT(_type='button',_value=T('Export Cancel'),_id='export_cancel',_class='btn btn-secondary')
                            )
                        ),
                        _class='m-table-export m-table-head'
                    ),
                    TABLE(
                        TR(
                            TH(T('In order of new'),_style='width:33%'),
                            TH(T('File'))
                        ),
                        *[TR(
                            TD(str(i+1)),
                            TD(A(r.mr_filename, _href=URL(f='download',args=['data',r.mr_filename])))
                            ) for i, r in enumerate(rows) if i < 20
                        ],
                        _class='m-table-export'

                    ),
                    _class='m-table-export_div'
                )

    return dict(message=message,extable=extable)


def __refresh_exports():
    """
    エクスポート・フォルダ直下のファイルを得て、mr_exportsを更新する。
    """
    dbm(dbm.mr_exports).update(mr_enabled=False)

    for filename in os.listdir(MR_CONF['EXPORT_PATH']):
        if not filename.startswith(MR_CONF['APP_NAME']+'_'): continue
        if dbm(dbm.mr_exports.mr_filename==filename).count()==0:
            m = os.stat(MR_CONF['EXPORT_PATH']+filename)
            cdate = time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(m.st_ctime))
            dbm.mr_exports.insert(mr_filename=filename,mr_createdate=cdate,mr_enabled=True)
        else:
            dbm(dbm.mr_exports.mr_filename==filename).update(mr_enabled=True)


# ========================================
# テーブル更新
# ========================================

@auth.requires_login()
def update_table():
    """
    テーブルの管理更新
    """
    __precheck()

    message = ''
    errors = []
    errors2 = []    #xid重複確認用
    errors3 = []    #folder重複確認用

    ds = []

    var_subtitle = ''
    var_target = 'undefined'
    var_target_id = 0
    var_class = 1 # undefined (default)
    var_process = 0

    if len(request.args)>0:
        var_target = sanitize(request.args[0])
        if var_target == 'section':
            var_target_id = 1
            var_class = 2  # Page section (default)
        elif var_target == 'resource':
            var_target_id = 2
            var_class = 3  # Resource (default)
        else:
            # Other target
            pass

        if len(request.args)>1:
            var_class = int(request.args[1] or 1)

            if len(request.args)>2:
                temp_process = sanitize(request.args[2])
                if temp_process is not None and temp_process != '':
                    if temp_process == 'check':
                        var_process = 1
                    elif temp_process == 'update':
                        var_process = 2

    # バックアップフォルダ
    if not os.path.exists(MR_CONF['RESTORE_PATH']+'backups/'):
        os.mkdir(MR_CONF['RESTORE_PATH']+'backups/')

    filedata = 'File name:----　Update datetime:----　File size:----'

    if var_target == 'resource' or var_target == 'section':
        if os.path.exists(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt'):
            m = os.stat(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')
            filedata = 'File name:%s　Update datetime:%s　File size:%s' % (MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt',time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(m.st_mtime)),str(m.st_size))
        else:
            var_process = -1
    else:
        if os.path.exists(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt'):
            m = os.stat(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')
            filedata = 'File name:%s　Update datetime:%s　File size:%s' % (MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt',time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(m.st_mtime)),str(m.st_size))
        else:
            var_process = -1


    if var_process == 2:
        # update
        sw='0'
        if var_target == 'resource':
            (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')
            res_dict = __restore_resource(var_class, _fields, _temp)
            message = res_dict['message']
            errors = res_dict['errors']
        elif var_target == 'section':
            (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')
            res_dict = __restore_section(var_class, _fields, _temp)
            message = res_dict['message']
            errors = res_dict['errors']
        elif var_target == 'file':
            (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')
            res_dict = __restore_file(_fields, _temp)
            message = res_dict['message']
            errors = res_dict['errors']
        elif var_target == 'annote':
            (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')
            res_dict = __restore_annote(_fields, _temp)
            message = res_dict['message']
            errors = res_dict['errors']
        else:
            (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')
            res_dict = __restore_table(var_target, _fields, _temp)
            message = res_dict['message']
            errors = res_dict['errors']

    elif var_process == 1:
        # check
        sw='0'

        if var_target == 'resource' or var_target == 'section':
            if os.path.exists(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt'):
                try:
                    (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')

                    (line, loop, loss, dupl, news, errors, errors2, errors3, errors4) = __restore_check_with_class(var_target, var_class, _fields, _temp)

                    if loss==0 and line==loop and dupl==0:
                        message=(T('Inspection results: %d lines, Checked: %d lines, Error: %d lines, Id/Folder duplucate: %d lines, New data: %d lines') % (line,loop,loss,dupl,news,))+' -- '+T('OK')+' -- '+T('Updates can be applied.')
                    else:
                        message=(T('Inspection results: %d lines, Checked: %d lines, Error: %d lines, Id/Folder duplucate: %d lines, New data: %d lines') % (line,loop,loss,dupl,news,))+' -- '+T('Warning')+' -- '+T('Data confirmation is required.')+'\n'+','.join(_fields)
                except:
                    message=T('Inspection error')+': '+T('Check the location of the read file.')
            else:
                sw='1'
                message=T('Inspection error')+': '+T('There is no file suitable for updating.')
        else:
            if os.path.exists(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt'):
                try:
                    (_fields, _temp) = __load_tabtext_file(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')

                    (line, loop, loss, dupl, news, errors, errors2, errors3, errors4) = __restore_check(var_target, _fields, _temp)

                    if loss==0 and line==loop and dupl==0:
                        message=(T('Inspection results: %d lines, Checked: %d lines, Error: %d lines, Id/Folder duplucate: %d lines, New data: %d lines') % (line,loop,loss,dupl,news,))+' -- '+T('OK')+' -- '+T('Updates can be applied.')
                    else:
                        message=(T('Inspection results: %d lines, Checked: %d lines, Error: %d lines, Id/Folder duplucate: %d lines, New data: %d lines') % (line,loop,loss,dupl,news,))+' -- '+T('Warning')+' -- '+T('Data confirmation is required.')
                except:
                    message=T('Inspection error')+': '+T('Check the location of the read file.')
            else:
                sw='1'
                message=T('Inspection error')+': '+T('There is no file suitable for updating.')

    else:
        # file upload (default)
        sw='1'    #選択
        message=T('Upload a new file or update with the current file. Please choose first.')

        if var_process < 0:
            message=T('There is no update file. ')+T('Upload is required. ')

    rows = dbm(dbm.mr_classes.id>1).select(orderby=dbm.mr_classes.id)
    options = []
    for row in rows:
        if row.mr_target=='page':
            options.append(OPTION('%d: %s' % (row.id,row.mr_title,),_value='%s,%d' % ('section',row.id,)))
        else:
            options.append(OPTION('%d: %s' % (row.id,row.mr_title,),_value='%s,%d' % (row.mr_target,row.id,)))

    form = FORM(
                TABLE(
                    TR(
                        TD(T('Restore select'),_class='m-table-name'),
                        TD(
                            INPUT(_type='radio', _name='restoreselect', _value='1', value=sw), SPAN(T('Restore New')),
                            INPUT(_type='radio', _name='restoreselect', _value='0', value=sw), SPAN(T('Restore Current'))
                        )
                    ),
                    _class='m-table-upload m-table-head'
                ),
                TABLE(
                    TR(
                        TD(T('Table target'),_class='m-table-name'),
                        TD(
                            INPUT(_type='radio', _name='restoretarget', _value=2, value=var_target_id), SPAN(T('Resource')),
                            INPUT(_type='radio', _name='restoretarget', _value=1, value=var_target_id), SPAN(T('Page section')),
                            LABEL(T('Class'),_class='mx-3 ml-5'),
                            SELECT(
                                OPTION('',_value='0,1'),
                                options,
                                value=var_class,
                                _name='restoreclass'
                            ),
                            BR(),
                            INPUT(_type='radio', _name='restoretarget', _value=0, value=var_target_id), SPAN(T('Other')),
                            LABEL(T('Target'),_class='mx-3 ml-5'),
                            SELECT(
                                OPTION('',_value=0),
                                OPTION('folder'),
                                OPTION('file'),
                                OPTION('annote'),
                                #OPTION('attrgroup'),
                                #OPTION('attribute'),
                                OPTION('class'),
                                OPTION('class_element'),
                                OPTION('collection'),
                                OPTION('page'),
                                value=var_target,
                                _name='restoreother'
                            )
                        )
                    ),
                    _class='m-table-upload m-table-head'
                ),

                TABLE(
                    TR(
                        TD(T('Restore file'),_class='m-table-name'),
                        TD(INPUT(_name='restorefile',_type='file',_class='m-input-file'))
                    ),
                    TR(
                        TD(''),
                        TD(INPUT(_type='submit',_value=T('Restore Upload'),_class='btn btn-primary'),INPUT(_type='reset',_value=T('Restore Upload Reset'),_class='btn btn-secondary'))
                    ),
                    _class='m-table-upload'
                ),

                TABLE(
                    TR(
                        TD(T('Restore work'),_class='m-table-name'),
                        TD(INPUT(_type='button',_value=T('Restore Check'),_id='restore_check_data',_class='btn btn-primary'))
                    ),
                    TR(
                        TD(''),
                        TD(_id='restore_file_status')
                    ),
                    TR(
                        TD(''),
                        TD(INPUT(_type='button',_value=T('Restore Apply'),_id='restore_apply_data',_class='btn btn-primary'))
                    ),
                    _class='m-table-upload'
                ),

                TABLE(
                    TR(
                        TD('',_class='m-table-name'),
                        TD(INPUT(_type='button',_value=T('Restore Cancel'),_id='restore_cancel',_class='btn btn-secondary'))
                    ),
                    _class='m-table-upload m-table-head'
                ),
                **{'_data-target':var_target,'_data-class':str(var_class)}
            )

    if form.process().accepted:

            fname = re.split('[\\\/]',form.vars.restorefile.filename)
            shutil.copyfileobj(form.vars.restorefile.file, open(MR_CONF['RESTORE_PATH']+'backups/'+fname[-1], 'wb'))
            if fname[-1].endswith('csv'):
                shutil.copy2(MR_CONF['RESTORE_PATH']+'backups/'+fname[-1], MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8.csv')

                m = os.stat(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8.csv')
            else:
                if var_class > 1:
                    shutil.copy2(MR_CONF['RESTORE_PATH']+'backups/'+fname[-1], MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')

                    m = os.stat(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_'+str(var_class)+'_utf8_tsv.txt')
                else:
                    shutil.copy2(MR_CONF['RESTORE_PATH']+'backups/'+fname[-1], MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')

                    m = os.stat(MR_CONF['RESTORE_PATH']+MR_CONF['APP_NAME']+'_'+var_target+'_utf8_tsv.txt')
            filedata = 'File name:%s　Update datatime:%s　FIle size:%s' % (fname[-1],time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(m.st_mtime)),str(m.st_size))
            sw='0'

            #response.flash = 'form accepted'
    elif form.errors:
            #response.flash = 'form has errors'
            message=T('Upload error')+': '+T('Unknown error has occurred while uploading. ')

    return dict(message=message,form=form,filedata=filedata,sw=sw,subtitle=var_subtitle,errors=errors,errors2=errors2,errors3=errors3,mr_target=var_target,mr_target_id=str(var_target_id),mr_class=str(var_class))


def __restore_check_with_class(_target, _classid, _fields, _temp):
    """
    フォーマット確認(TSV)
    resource, section用
    """
    errors=[]
    errors2=[]  #xid重複確認用
    errors3=[]  #folder重複確認用
    errors4=[]  #フィールド・ミスマッチ

    ds=[]

    line=0
    loop=0
    loss=0
    news=0

    if _target == 'resource':
        _tables = ['mr_resources','mr_resource_items']
    elif _target == 'section':
        _tables = ['mr_sections','mr_section_items']

    xids = set()    #xid重複確認
    xids0 = [r.id for r in dbm(dbm[_tables[0]]._id>0).select()]
    xnames = set()

    _xfields = __fields(_classid)

    if _temp:   # text array
        for row in _temp:
            line+=1
            if len(row)!=len(_fields):
                errors.append(line)
                loss+=1
                continue

            try:
                d = {}
                dd = {}
                var_xid = 0
                for i, fv1 in enumerate(_fields):
                    if '.' in fv1:
                        fv = (fv1.split('.'))[-1]
                    else:
                        fv = fv1

                    if fv in _xfields['fields']:
                        dd.setdefault(fv, row[i])
                        continue
                    elif fv not in _xfields['field']:
                        errors4.append([line,fv1])
                        continue

                    elif fv in ('id',):
                        var_xid = int(row[i] or 0)
                        #新規確認
                        if var_xid in xids0:
                            pass
                        else:
                            news+=1
                        #重複確認
                        if var_xid in xids:
                            errors2.append(var_xid)
                        elif var_xid>0:
                            xids.add(var_xid)
                    elif fv in ('mr_class_id','mr_order',):
                        if row[i].isdigit():
                            d.setdefault(fv, int(row[i]))
                    elif fv in ('mr_parent_id',):
                        if row[i].isdigit():
                            d.setdefault(fv, int(row[i]))
                    elif fv in ('mr_page_id',):
                        if row[i].isdigit():
                            d.setdefault(fv, int(row[i]))
                    elif fv in ('mr_collection_ids',):
                        if re.match('(\d+,?)+',row[i]):
                            d.setdefault(fv, [int(v) for v in row[i].split(',')])
                        #elif re.match('([a-xA-Z0-9_\-\.]+,?)+',row[i]):
                        #    ids = []
                        #    for v in row[i].split(','):
                        #        r = dbm(dbm.mr_collections.mr_title.like(v)).select().first()
                        #        if r:
                        #            ids.append(r.id)
                        #    if len(ids)>0:
                        #        d.setdefault(fv, ids)
                    elif fv in ('mr_open',):
                        if 't' in str(row[i]).lower() or '1' in str(row[i]):
                            d.setdefault(fv, True)
                        else:
                            d.setdefault(fv, False)
                    elif fv in ('mr_name','mr_summary',):
                        d.setdefault(fv, row[i] or '')
                    elif fv in ('mr_text',):
                        d.setdefault(fv, row[i] or '')
                    else:
                        d.setdefault(fv, row[i] or '')
                        pass

                loop+=1

            except:
                errors.append(line)     # データ部分のみ、1から始まる行数
                loss+=1

    return (line, loop, loss, len(errors2)+len(errors3)+len(errors4), news, errors, errors2, errors3, errors4)


def __restore_check(_target, _fields, _temp):
    """
    フォーマット確認(TSV)
    2018-11/2019-08
    """
    errors=[]
    errors2=[]  #xid重複確認用
    errors3=[]  #folder重複確認用
    errors4=[]  #フィールド・ミスマッチ
    errors5=[]  #フィールド・ミスマッチ

    ds=[]

    line=0
    loop=0
    loss=0
    news=0

    if _target == 'class':
        _table = 'mr_classes'
    else:
        _table = 'mr_%ss' % _target

    xids = set()    #xid重複確認
    xids0 = [r.id for r in dbm(dbm[_table].id>0).select()]
    xnames = set()

    _xfields = dbm[_table]._fields

    if _temp:   # text array
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    dd = {}
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv not in _xfields:
                            errors4.append([line,fv1])
                            continue

                        elif fv in ('id',):
                            var_xid = int(row[i] or 0)
                            #新規確認
                            if var_xid in xids0:
                                pass
                            else:
                                news+=1
                            #重複確認
                            if var_xid in xids:
                                errors2.append(var_xid)
                            elif var_xid>0:
                                xids.add(var_xid)
                        elif fv in ('mr_parent_id','mr_class_id','mr_class_element_id','mr_resource_id','mr_file_id','mr_folder_id','mr_section_id','mr_class_element_id','mr_order',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i] or 1))
                        elif fv in ('mr_rank','mr_search_rank',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i] or 1))
                        elif fv in ('mr_imw','mr_imh','mr_imlw','mr_imlh','mr_immw','mr_immh','mr_imsw','mr_imsh',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i] or 0))
                        elif fv in ('mr_annote_rotation',):
                            d.setdefault(fv, float(row[i] or 0.0))
                        elif fv in ('mr_rotation',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i] or 0))
                        elif fv in ('mr_editor',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i] or 1))
                        elif fv in ('mr_resource_id',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i] or 1))
                        elif fv in ('mr_annote_area','mr_annote_data','mr_annote_color',):
                            if re.match('(\d+,?)+',row[i]):
                                d.setdefault(fv, [int(v) for v in row[i].split(',')])
                        elif fv in ('mr_delegates',):
                            if re.match('(\d+,?)+',row[i]):
                                d.setdefault(fv, [int(v) for v in row[i].split(',')])
                        elif fv in ('mr_open',):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        elif fv in ('mr_create_date','mr_update_date',):
                            pass
                        else:
                            d.setdefault(fv, row[i] or '')

                    loop+=1

                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

    return (line, loop, loss, len(errors2)+len(errors3)+len(errors4), news, errors, errors2, errors3, errors4)


def __restore_resource(_classid, _fields, _temp):
    """
    ##データ（Tab区切りテキスト, utf_16_le_sig）をデータベースに追加で読み込む
    データ（Tab区切りテキスト, utf-8）をデータベースに追加で読み込む
    idによって更新する
    削除はここでは行なわない
    """
    errors=[]

    line=0
    loop=0
    loss=0

    _xfields = __fields(_classid)
    _group = _xfields['element']['group']  # list of class element ids

    errors2=[]

    line2=0
    loop2=0
    loss2=0

    l_elems = []
    d_elems = {}

    if _temp:  # text array
        try:
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    dd = []  # resource_items,メタデータ更新用
                    #var_keywords = []
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv in _xfields['fields']:        # keyset (items)
                            # 現状では、項目nameの重複には対応できず（descriptionが2つの場合など）
                            j = _xfields['fields'].index(fv)
                            dd.append([_group[j], row[i]])  # [mr_class_items.id, value]
                            continue
                        elif fv not in _xfields['field']:   # table_pattern (= mr_resources._fields)
                            continue

                        if fv in ('id',):
                            var_xid = int(row[i] or 0)
                        elif fv in ('mr_class_id','mr_order','mr_parent_id'):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_relations',):
                            pass
                        elif fv in ('mr_collection_ids',):
                            if re.match('(\d+,?)+',row[i]):
                                d.setdefault(fv, [int(v) for v in row[i].split(',')])
                            #elif re.match('([a-xA-Z0-9_\-\.]+,?)+',row[i]):
                            #    ids = []
                            #    for v in row[i].split(','):
                            #        r = dbm(dbm.mr_collections.mr_title.like(v)).select().first()
                            #        if r:
                            #            ids.append(r.id)
                            #    if len(ids)>0:
                            #        d.setdefault(fv, ids)
                        elif fv in ('mr_open',):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        elif fv in ('mr_name','mr_summary',):
                            d.setdefault(fv, re.sub(r'\\r\\r',r'\r\n',row[i] or ''))
                        else:
                            d.setdefault(fv, row[i] or '')

                    # 新規追加もしくは更新
                    #d.setdefault('keyword','|%s|' % '|'.join(var_keywords))
                    #d.setdefault('updated_on', datetime.datetime.now());
                    newid = dbm.mr_resources.update_or_insert(dbm.mr_resources.id==var_xid,**dbm.mr_resources._filter_fields(d))

                    if (var_xid == 0) or (var_xid != newid):
                        var_xid = newid

                    # アイテムの保存
                    l_elems.append(var_xid)
                    d_elems[var_xid] = dd

                    loop+=1
                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

            dbm.commit()

        except:
            dbm.rollback()
            return dict(message=T('Update error')+': '+T('Check the contents of the update file.'),errors=errors)


        try:
            # アイテムの更新
            for var_xid in l_elems:
                dd = d_elems[var_xid]
                try:
                    for d2 in dd:
                        dbm.mr_resource_items.update_or_insert(
                            (
                                (dbm.mr_resource_items.mr_resource_id==var_xid)
                                & (dbm.mr_resource_items.mr_class_element_id==d2[0])
                            ),
                            mr_resource_id = var_xid,
                            mr_class_element_id = d2[0],
                            mr_text = re.sub(r'\\r\\r',r'\r\n',d2[1]),
                            mr_open = True
                            )
                        pass
                    loop2+=1
                except:
                    errors2.append(line)     # データ部分のみ、1から始まる行数
                    loss2+=1

            dbm.commit()
            #dbm(dbm.mr_resources.removed==True).delete()

        except:
            dbm.rollback()
            return dict(message=T('Update error part 2')+': '+T('Check the contents of the update file part 2.'),errors=errors2)

    return dict(message=T('Update results')+': '+T('Success %d line(s), Failed %d line(s)') % (loop, loss,), errors=errors)


def __restore_section(_classid, _fields, _temp):
    """
    ##画像データ（Tab区切りテキスト, utf_16_le_sig）をデータベースに追加で読み込む
    画像データ（Tab区切りテキスト, utf-8）をデータベースに追加で読み込む
    idによって更新する
    削除はここでは行なわない
    """
    errors=[]

    line=0
    loop=0
    loss=0

    _xfields = __fields(_classid)
    _group = _xfields['element']['group']  # list of class element ids

    if _temp:  # text array
        try:
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    dd = []  # section_items,メタデータ更新用
                    #var_keywords = []
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv in _xfields['fields']:        # keyset (items)
                            # 現状では、項目nameの重複には対応できず（descriptionが2つの場合など）
                            j = _xfields['fields'].index(fv)
                            dd.append([_group[j], row[i]])  # [mr_class_items.id, value]
                            continue
                        elif fv not in _xfields['field']:   # table_pattern (= mr_sections._fields)
                            continue

                        if fv in ('id',):
                            var_xid = int(row[i] or 0)
                        elif fv in ('mr_class_id','mr_order','mr_page_id',):
                            d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_open',):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        elif fv in ('mr_name','mr_text',):
                            d.setdefault(fv, re.sub(r'\\r\\r',r'\r\n',row[i] or ''))
                        else:
                            d.setdefault(fv, row[i] or '')

                    # 新規追加もしくは更新
                    dbm.mr_sections.update_or_insert(dbm.mr_sections.id==var_xid,**dbm.mr_sections._filter_fields(d))

                    # アイテムの更新
                    for d2 in dd:
                        dbm.mr_section_items.update_or_insert(
                            (
                                (dbm.mr_section_items.mr_section_id==var_xid)
                                & (dbm.mr_section_items.mr_class_element_id==d2[0])
                            ),
                            mr_text = re.sub(r'\\r\\r',r'\r\n',d2[1]),
                            mr_open = True
                            )

                    loop+=1
                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

            dbm.commit()
            #dbm(dbm.mr_pages.removed==True).delete()

        except:
            dbm.rollback()
            return dict(message=T('Update error')+': '+T('Check the contents of the update file.'),errors=errors)

    return dict(message=T('Update results')+': '+T('Success %d line(s), Failed %d line(s)') % (loop, loss,),errors=errors)


def __restore_table(_target, _fields, _temp):
    """
    ##画像データ（Tab区切りテキスト, utf_16_le_sig）をデータベースに追加で読み込む
    画像データ（Tab区切りテキスト, utf-8）をデータベースに追加で読み込む
    idによって更新する
    削除はここでは行なわない
    """
    errors=[]

    line=0
    loop=0
    loss=0

    if _target == 'class':
        _table = 'mr_classes'
    else:
        _table = 'mr_%ss' % _target

    _xfields = dbm[_table]._fields

    if _temp:   # text array
        try:
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    #var_keywords = []
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv not in _xfields:
                            continue

                        if fv in ('id',):
                            var_xid = int(row[i] or 0)
                        elif fv in ('mr_parent_id','mr_class_id','mr_class_element_id','mr_resource_id','mr_file_id','mr_folder_id','mr_section_id','mr_class_element_id','mr_order',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_rank','mr_search_rank',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i] or 1))
                        elif fv in ('mr_resource_id',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i] or 1))
                        #elif fv in ('mr_editor',):
                        #     pass
                        elif fv in ('mr_delegates',):
                            if re.match('(\d+,?)+',row[i]):
                                d.setdefault(fv, [int(v) for v in row[i].split(',')])
                        elif fv in ('mr_open',):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        #elif fv in ('mr_create_date','mr_update_date'):
                        #    pass
                        elif fv in ('mr_description','mr_license','mr_note',):
                            d.setdefault(fv, re.sub(r'\\r\\r',r'\r\n',row[i] or ''))
                        else:
                            d.setdefault(fv, row[i] or '')

                    # 新規追加もしくは更新
                    dbm[_table].update_or_insert(dbm[_table].id==var_xid,**dbm[_table]._filter_fields(d))

                    loop+=1
                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

            dbm.commit()
            #dbm(dbm.mr_files.removed==True).delete()

        except:
            dbm.rollback()
            return dict(message=T('Update error')+': '+T('Check the contents of the update file.'),errors=errors)

    return dict(message=T('Update results')+': '+T('Success %d line(s), Failed %d line(s)') % (loop, loss,),errors=errors)


def __restore_file(_fields, _temp):
    """
    ##画像データ（Tab区切りテキスト, utf_16_le_sig）をデータベースに追加で読み込む
    画像データ（Tab区切りテキスト, utf-8）をデータベースに追加で読み込む
    idによって更新する
    削除はここでは行なわない
    """
    errors=[]

    line=0
    loop=0
    loss=0

    _xfields = dbm['mr_files']._fields

    if _temp:  # text array
        try:
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    #var_keywords = []
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv not in _xfields:
                            continue

                        if fv in ('id',):
                            var_xid = int(row[i] or 0)
                        elif fv in ('mr_folder_id','mr_version','mr_order',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_imw','mr_imh','mr_imlw','mr_imlh','mr_immw','mr_immh','mr_imsw','mr_imsh',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i] or 0))
                        elif fv in ('mr_rotation',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i] or 0))
                        #elif fv in ('mr_editor'):
                        #    pass
                        elif fv in ('mr_resource_id',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i] or 0))
                        #elif fv in ('mr_resource_ids',):
                        #    if re.match('(\d+,?)+',row[i]):
                        #        d.setdefault(fv, [int(v) for v in row[i].split(',')])
                        elif fv in ('mr_open',):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        #elif fv in ('mr_create_date','mr_update_date'):
                        #    pass
                        elif fv in ('mr_description','mr_license','mr_note',):
                            d.setdefault(fv, re.sub(r'\\r\\r',r'\r\n',row[i] or ''))
                        else:
                            d.setdefault(fv, row[i] or '')

                    # 新規追加もしくは更新
                    dbm.mr_files.update_or_insert(dbm.mr_files.id==var_xid,**dbm.mr_files._filter_fields(d))

                    loop+=1
                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

            dbm.commit()
            #dbm(dbm.mr_files.removed==True).delete()

        except:
            dbm.rollback()
            return dict(message=T('Update error')+': '+T('Check the contents of the update file.'),errors=errors)

    return dict(message=T('Update results')+': '+T('Success %d line(s), Failed %d line(s)') % (loop, loss,),errors=errors)


def __restore_annote(_fields, _temp):
    """
    ##画像データ（Tab区切りテキスト, utf_16_le_sig）をデータベースに追加で読み込む
    画像データ（Tab区切りテキスト, utf-8）をデータベースに追加で読み込む
    idによって更新する
    削除はここでは行なわない
    """
    errors=[]

    line=0
    loop=0
    loss=0

    _xfields = dbm['mr_annotes']._fields

    if _temp:  # text array
        try:
            for row in _temp:
                line+=1
                if len(row)!=len(_fields):
                    errors.append(line)
                    loss+=1
                    continue

                try:
                    d = {}
                    #var_keywords = []
                    var_xid = 0
                    for i, fv1 in enumerate(_fields):
                        if '.' in fv1:
                            fv = (fv1.split('.'))[-1]
                        else:
                            fv = fv1

                        if fv not in _xfields:
                            continue

                        if fv in ('id',):
                            var_xid = int(row[i] or 0)
                        elif fv in ('mr_resource_id','mr_file_id','mr_order',):
                            if row[i].isdigit():
                                d.setdefault(fv, int(row[i]))
                        elif fv in ('mr_annote_rotation',):
                            d.setdefault(fv, float(row[i] or 0.0))
                        elif fv in ('mr_annote_area','mr_annote_data','mr_annote_color',):
                            if re.match('(\d+,?)+',row[i]):
                                d.setdefault(fv, [int(v) for v in row[i].split(',')])
                        #elif fv in ('mr_editor'):
                        #     pass
                        elif fv in ('mr_open',):
                            if 't' in str(row[i]).lower() or '1' in str(row[i]):
                                d.setdefault(fv, True)
                            else:
                                d.setdefault(fv, False)
                        #elif fv in ('mr_create_date','mr_update_date'):
                        #    pass
                        elif fv in ('mr_name','mr_text',):
                            d.setdefault(fv, re.sub(r'\\r\\r',r'\r\n',row[i] or ''))
                        else:
                            d.setdefault(fv, row[i] or '')

                    # 新規追加もしくは更新
                    dbm.mr_annotes.update_or_insert(dbm.mr_annotes.id==var_xid,**dbm.mr_annotes._filter_fields(d))

                    loop+=1
                except:
                    errors.append(line)     # データ部分のみ、1から始まる行数
                    loss+=1

            dbm.commit()
            #dbm(dbm.mr_files.removed==True).delete()

        except:
            dbm.rollback()
            return dict(message=T('Update error')+': '+T('Check the contents of the update file.'),errors=errors)

    return dict(message=T('Update results')+': '+T('Success %d line(s), Failed %d line(s)') % (loop, loss,),errors=errors)


def __load_csvtext_file(filepath, codetype='utf-8-sig', sig=True):
    """
    CSVの読み込み
    行末の改行（Windows）を除き、コンマで分けた２重リストにして返す
    RESERVED
    """
    import csv

    fields = []
    texts = []
    first = True
    second = True
    if filepath:
        file = codecs.open(filepath, 'r', codetype)
        reader = csv.reader(file, delimiter=',', quotechar='"')
        try:
            for ary in reader:
                try:
                    if len(ary)<1:
                        pass
                    elif first and (not ary[0].isdigit() or 'id' in ary[0].lower() or '_id' in ary[0] or 'xid' in ary[0] or 'x_id' in ary[0]):           #先頭行がフィールド名の場合
                        fields = ary
                    elif second and (not ary[0].isdigit() or 'id' in ary[0].lower() or '_id' in ary[0] or 'xid' in ary[0] or 'x_id' in ary[0]):           #先頭行がフィールド名の場合
                        fields = ary
                    else:
                        texts.append(ary)
                except:
                    pass
                if not first: second = False
                if first: first=False
        finally:
            file.close()

    return (fields, texts)


def __load_tabtext_file(filepath, codetype='utf-8', sig=False):
    """
    Tab Separated Textの読み込み
    行末の改行（Windows）を除き、TAB(\t)で分けた２重リストにして返す
    """
    fields = []
    texts = []
    first = True
    second = True
    if filepath:
        file = codecs.open(filepath, 'r', codetype, 'ignore')
        try:
            for line in file:
                if first and sig: line = line[3:]
                line = line.rstrip('\n')
                ary = line.split('\t')
                try:
                    if len(line)<1 or len(ary)<1:
                        pass
                    elif first and (not ary[0].isdigit() or 'id' in ary[0].lower() or '_id' in ary[0] or 'xid' in ary[0] or 'x_id' in ary[0]):           #先頭行がフィールド名の場合
                        fields = [str(s).strip() for s in line.split('\t')]
                    elif second and (not ary[0].isdigit() or 'id' in ary[0].lower() or '_id' in ary[0] or 'xid' in ary[0] or 'x_id' in ary[0]):           #先頭行がフィールド名の場合
                        fields = [str(s).strip() for s in line.split('\t')]
                    else:
                        texts.append(ary)
                except:
                    pass
                if not first: second = False
                if first: first=False
        finally:
            file.close()
    return (fields, texts)


@auth.requires_login()
def download():
    """
    Exportファイルのダウンロード
    """
    __precheck()

    if not request.args:
        raise HTTP(404)

    target = 'EXPORT_PATH'

    name = request.args[-1]

    if sys.version_info > (3,):

        from gluon.contenttype import contenttype

        try:
            fpath = os.path.join(MR_CONF[target],'%s' % name)
            file = codecs.open(fpath, 'r', 'utf-8').read()
        except:
            raise HTTP(404)

        response.headers["Content-Type"] = contenttype(name)
        response.headers["Content-Disposition"] = "attachment; filename=%s" % name
        raise HTTP(200, file, **response.headers)

    elif sys.version_info > (2, 7):

        import contenttype

        try:
            fpath = os.path.join(MR_CONF[target],'%s' % name)
            file = open(fpath, 'r')
        except:
            raise HTTP(404)

        response.headers["Content-Type"] = contenttype.contenttype(name)
        response.headers["Content-Disposition"] = "attachment; filename=%s" % name
        stream = response.stream(file, chunk_size=64*1024, request=request)
        raise HTTP(200, stream, **response.headers)

    else:

        raise HTTP(404)
