# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1910
## - Date: 2019-10-19
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

import os
import sys


def index():
    return dict()


def getCript(value):

    #from gluon.utils import get_digest
    import hmac
    import hashlib

    (alg, key) = auth.settings.hmac_key.split(':')
    if sys.version_info > (3,):
        #hmacobj = hmac.new(bytes(key,'ascii'), bytes(value,'ascii'), get_digest(alg))
        hmacobj = hmac.new(bytes(key,'ascii'), bytes(value,'ascii'), hashlib.sha512)
    else:
        #hmacobj = hmac.new(key, value, get_digest(alg))
        hmacobj = hmac.new(key, value, hashlib.sha512)
    return hmacobj.hexdigest()


def setup_users():

    if db(db.auth_user.id > 0).count() < 1:

            #try:
            #auth.settings.create_user_groups = True

            # auth.add_group(role, description='')
            # ----------------------------
            # db.auth_group:
            #   id, id
            #   role, string
            #   description, text
            # ----------------------------
            auth.add_group('developer',T('Developer'))
            auth.add_group('admin',T('Administrator'))
            auth.add_group('editor',T('Editor'))
            auth.add_group('user',T('User'))
            auth.add_group('guest',T('Guest'))


            # auth.get_or_create_user(keys)
            # ----------------------------
            # db.auth_user:
            #   id, id
            #   first_name, string
            #   last_name, string
            #   email, string
            #   password, password
            #   registration_key, string
            #   reset_password_key, string
            #   registration_id, string
            # ----------------------------
            # （重要・注意）公開時には初期パスワードは安全なものに設定してください。
            auth.get_or_create_user({'username':'root','first_name':'Root','last_name':'(Default)','email':None,'password':getCript('root')})
            auth.get_or_create_user({'username':'admin','first_name':'Admin','last_name':'(Default)','email':None,'password':getCript('admin')})
            auth.get_or_create_user({'username':'editor','first_name':'Editor','last_name':'(Default)','email':None,'password':getCript('editor')})
            auth.get_or_create_user({'username':'user','first_name':'User','last_name':'(Default)','email':None,'password':getCript('user')})
            auth.get_or_create_user({'username':'guest','first_name':'Guest','last_name':'(Default)','email':None,'password':getCript('guest')})


            # add_membership(self, group_id=None, user_id=None, role=None)
            # ----------------------------
            # db.auth_membership:
            #   id, id
            #   user_id, reference auth_user
            #   group_id, reference auth_group
            # ----------------------------
            auth.add_membership(1,1,'developer')
            auth.add_membership(2,2,'administrator')
            auth.add_membership(3,3,'trust')
            auth.add_membership(4,4,'guest')
            auth.add_membership(5,5,'public')


            # add_permission(group_id, name='any', table_name='', record_id=0)
            # ----------------------------
            # db.auth_permission:
            # id, id
            # group_id, reference auth_group
            # name, string
            # table_name, string
            # record_id, integer
            # ----------------------------
            auth.add_permission(1,'read','auth_user')
            auth.add_permission(1,'select','auth_user')
            auth.add_permission(1,'create','auth_user')
            auth.add_permission(1,'update','auth_user')
            auth.add_permission(1,'delete','auth_user')

            auth.add_permission(1,'read','auth_group')
            auth.add_permission(1,'select','auth_group')
            auth.add_permission(1,'create','auth_group')
            auth.add_permission(1,'update','auth_group')
            auth.add_permission(1,'delete','auth_group')

            auth.add_permission(2,'read','auth_user')
            auth.add_permission(2,'select','auth_user')
            auth.add_permission(2,'create','auth_user')
            auth.add_permission(2,'update','auth_user')
            auth.add_permission(2,'delete','auth_user')

            auth.add_permission(3,'read','auth_user')
            auth.add_permission(3,'select','auth_user')
            auth.add_permission(3,'update','auth_user')

            auth.add_permission(4,'read','auth_user')


            return dict(message='Success: ユーザーを初期化しました. パスワードを必ず変更してください.',report=None)

            #except:
            #return dict(message=T('Error: ユーザーを初期化中にエラー.'))

    else:
        return dict(message='Warning: ユーザーの初期化は既に終了しています. 初期化する場合は管理者に依頼してください.',report=None)


def setup_folders():

    fcount = 0

    # Create work folders
    dirs = [ MR_CONF['BASE_PATH']             # /path/to/datad
            ,MR_CONF['IMAGEBASE_PATH']        # /path/to/imaged
            ,MR_CONF['IMAGE_PATH']            # /path/to/imaged
            ,MR_CONF['RESOURCEBASE_PATH']     # /path/to/imaged/resources
            ,MR_CONF['FILEBASE_PATH']         # /path/to/filed
            ,MR_CONF['FILEBASE_PATH']+'/uploads'
            ,MR_CONF['DBBACKUP_PATH']         # /path/to/datad/backups
            ,MR_CONF['EXPORT_PATH']           # /path/to/datad/exports
            ,MR_CONF['RESTORE_PATH']          # /path/to/datad/restores
            ,MR_CONF['RESTORE_PATH']+'/backups'
        ]

    try:
        for vdir in dirs:
            if not os.path.exists(vdir):
                os.makedirs(vdir)
                fcount += 1

        if fcount > 0:
            return dict(message='Success: ワーク・フォルダを初期化／追加しました.',report=None)
        else:
            return dict(message='Warning: ワーク・フォルダの初期化／追加は既に終了しています. 作成の必要はありません. 再初期化する場合は管理者に依頼してください.',report=None)

    except:
        return dict(message=T('Error: ワーク・フォルダの初期化／追加中にエラー.'))
