# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1910r5
## - Date: 2019-11-24
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

import os
import io
import datetime
import re
import json
import urllib
from gluon.sanitizer import sanitize

from PIL import Image
import pyvips


mr_datahelper = local_import('mr_datahelper', reload=MR_CONF['RELOAD'])
mr_helper = local_import('mr_helper', reload=MR_CONF['RELOAD'])
mr_manifesthelper = local_import('mr_iiifmanifesthelper', reload=MR_CONF['RELOAD'])


def __precheck():
    """
    ログイン制御
    該当しなければログインを通過
    """
    if session.auth.user.id < 5 and not ( request.env.remote_addr in configuration.get('myconfig.allowances') or request.env.remote_addr.startswith(configuration.get('myconfig.local_ip')) ):
        redirect(URL('default','user',args=['logout']))

    if session.auth.user is not None and session.groupid is None:
        session.groupid = db(db.auth_membership.user_id==session.auth.user.id).select().first().group_id

        # ワークグループ
        if session.workgroup is None:

            if not MR_CONF['WORKGROUP'] or session.groupid <= MR_CONF['GROUP_ADMINISTRATOR']:
                # 管理者はすべての閲覧と操作
                rows = dbm(dbm.mr_collections).select()
                session.workgroup = {'collection':[r.id for r in dbm(dbm.mr_collections).select(dbm.mr_collections.id)],'page':[r.id for r in dbm(dbm.mr_pages).select(dbm.mr_pages.id)]}
            else:
                # ワークグループの設定
                rows = dbm(dbm.mr_workgroups.mr_user_ids.contains(session.auth.user.id)).select()
                if rows:
                    list_c = []
                    list_p = []
                    for r in rows:
                        if r.mr_collection_ids and len(r.mr_collection_ids)>0:
                            list_c.extend(r.mr_collection_ids)
                        if r.mr_page_ids and len(r.mr_page_ids)>0:
                            list_p.extend(r.mr_page_ids)
                    session.workgroup = {'collection':[n for n in set(list_c)],'page':[n for n in set(list_p)]}
                else:
                    session.workgroup = {'collection':[1],'page':[1]}

    # 制限
    if session.groupid == MR_CONF['GROUP_USER']:
        MR_CONF['EDITABLE'] = False
    elif session.groupid > MR_CONF['GROUP_EDITOR']:
        # only guest group
        redirect(URL('default','user',args=['logout']))


# ========================================
# Access
# ========================================

@auth.requires_login()
def user():
    """
    ユーザー認証
    """
    if len(request.args) > 0:
        if request.args[0] == 'logout':
            #session.auth = None
            #session.groupid = None
            session = None

    auth.settings.controller = 'staff'
    return dict(form=auth())


# ========================================
# Main controllers
# ========================================

@auth.requires_login()
def index():
    """
    トップ, ページ
    """
    __precheck()

    # 引数（ページID）の取得
    pageid = 1  #デフォルト
    if len(request.args) > 0:
        pageid = request.args(0, cast=int) or 1

    # ワークグループの確認
    if (pageid < 1) or (pageid not in session.workgroup['page']):
        redirect(URL('staff','index',args=[],vars={}))

    # ページの内容（ページ・セクション）一覧
    # ページがpageidであるページセクション（複数）の取得
    da = mr_datahelper.d_d_page(dbm, pageid)

    div_main = DIV(_class='main m-content')

    for d_d in da['array']:

        div_section = TAG.section(
                        DIV(
                            A('[%s]' % T('Edit'),
                                _href=URL('onsection',extension='load',args=[d_d['subid']]),
                                cid='ymbody',
                                #TAG.button('[%s]' % T('Edit'),
                                #_type='button',
                                _class='btn btn-link',
                                **{'_data-toggle':'modal','_data-target':'#ymeditor','_data-targetid':d_d['subid']}
                            ),
                            _class='m-edit-link'
                        ),
                        *[H2(mr_helper.__helper_br(v['value'])) for v in d_d['title'][0:1]],
                        DIV(
                            *[P(mr_helper.__helper_br(v['value']),_class='') for v in d_d['description']]
                        ),
                        DIV(
                            SPAN(T(d_d['date'][0]['label']),': ',XML(d_d['date'][0].get('value','')) or XML('&mdash;')),
                            XML('&nbsp'),'|',XML('&nbsp;'),SPAN(T(d_d['creator'][0]['label']),': ',XML(d_d['creator'][0].get('value','')) or XML('&mdash;')),
                            _class='m-page-section-info'
                        ),
                        _class='m-page-section'
                    )
        div_main.append(div_section)

    # サイドメニュー索引の作成
    ul_sidemenu = __get_sidemenu()

    return dict(sidemenu=ul_sidemenu, main=div_main)


@auth.requires_login()
def page():
    redirect(URL('index',args=request.args))


@auth.requires_login()
def wiki():
    if session.groupid < MR_CONF['GROUP_ADMINISTRATOR']:
        # only developer group
        auth.wikimenu() # add wiki to the menu
    return auth.wiki()


def __form_search(v_offset):
    """
    検索フォーム（最小）
    """
    form = FORM(
                DIV(
                    DIV(
                        DIV(
                            DIV(
                                INPUT(
                                    _type='checkbox',
                                    _name='cross',
                                    _value='0',
                                    value=False,
                                    _class='form-check-input'
                                ),
                                LABEL(
                                    T('Cross search'),
                                    _class='form-check-label ml-2'
                                ),
                                _class='form-check form-check-inline text-left w-100'
                            ),
                            _class='col-12 col-sm-2 px-2 my-2'
                        ),
                        DIV(
                            INPUT(
                                _type='search',
                                _placeholder=T('Search words'),
                                _name='q',
                                _class='form-control w-100'
                            ),
                            _class='col-9 col-sm-7 px-2'
                        ),
                        DIV(
                            TAG.button(
                                I(_class='fa fa-search',**{'_aria-hidden':'true'}),' ',
                                SPAN(T('Search'),_class='d-none d-sm-inline'),
                                _type='button',
                                _name='dosearch',
                                _class='btn btn-primary w-100'
                            ),
                            _class='col-3 col-md-3 px-2'
                        ),
                        _class='row formgroup'
                    ),
                    _class='container'
                ),
                hidden=dict(wi='0',offset=v_offset),
                _method='POST',
                _class='form-inline',
            )

    return form


def __pager(count, var_offset, var_limit, var_from, var_args=None, var_wid=0, keys=None):
    """
    ページネーション
    """
    PAGE_LIM = 3
    a_block = count // var_limit
    if count % var_limit > 0: a_block += 1
    pager = [x for x in range(0, a_block)]
    pager.insert(0, var_offset // var_limit)

    #jtx = lambda x : URL(f=var_from,args=var_args,vars=dict(offset=str(var_limit*x)))
    jtx = lambda x : "javascript:pager(%d)" % (var_limit*x,)

    # Previous
    var_prev = pager[0] - 1
    var_prev10 = pager[0] - 10
    if var_prev < 0:
        var_prev = 0
        var_prev10 = 0
        item_prev=LI(I('',_class='fa fa-caret-left fa-lg'),_id='m-pagerPrev',_class='m-pager-hidden1 m-pager-tl')
        item_prev10=LI(I('',_class='fa fa-backward'),_id='m-pagerPrev10',_class='m-pager-hidden1 m-pager-tl')
        item_first=LI(I('',_class='fa fa-step-backward'),_id='m-pagerFirst',_class='m-pager-hidden1 m-pager-tl')
    else:
        item_prev=LI(A(I('',_class='fa fa-caret-left fa-lg'),_href=jtx(var_prev)),_id='m-pagerPrev',_class='m-pager-tl')
        if var_prev10 < 0:
            var_prev10 = 0
            item_prev10=LI(I('',_class='fa fa-backward'),_id='m-pagerPrev10',_class='m-pager-hidden1 m-pager-tl')
        else:
            item_prev10=LI(A(I('',_class='fa fa-backward'),_href=jtx(var_prev10)),_id='m-pagerPrev10',_class='m-pager-tl')
        item_first=LI(A(I('',_class='fa fa-step-backward'),_href=jtx(0)),_id='m-pagerFirst',_class='m-pager-tl')

    # Next
    var_next = pager[0] + 1
    var_next10 = pager[0] + 10
    if var_next > pager[-1]:
        var_next = pager[-1]
        var_next10 = pager[-1]
        item_next=LI(I('',_class='fa fa-caret-right fa-lg'),_id='m-pagerNext',_class='m-pager-hidden1 m-pager-tl')
        item_next10=LI(I('',_class='fa fa-forward'),_id='m-pagerNext10',_class='m-pager-hidden1 m-pager-tl')
        item_last=LI(I('',_class='fa fa-step-forward'),_id='m-pagerLast',_class='m-pager-hidden1 m-pager-tl')
    else:
        item_next=LI(A(I('',_class='fa fa-caret-right fa-lg'),_href=jtx(var_next)),_id='m-pagerNext',_class='m-pagertl')
        if var_next10 > pager[-1]:
            var_prev10 = pager[-1]
            item_next10=LI(I('',_class='fa fa-forward'),_id='m-pagerNext10',_class='m-pager-hidden1 m-pager-tl')
        else:
            item_next10=LI(A(I('',_class='fa fa-forward'),_href=jtx(var_next10)),_id='m-pagerNext10',_class='m-pager-tl')
        item_last=LI(A(I('',_class='fa fa-step-forward'),_href=jtx(pager[-1])),_id='m-pagerLast',_class='m-pager-tl')

    ys = 1    # shift
    y = pager[0]
    ye = PAGE_LIM + 1

    if y > PAGE_LIM - 1:
        ys = y - (PAGE_LIM - 3) // 2
        ye = ys + PAGE_LIM
        if ye > len(pager): ys = len(pager) - PAGE_LIM

    if ys > 1:
        item_prev_over=LI(DIV(XML('&hellip;')),_class='m-pager-off m-pager-tl')
    else:
        item_prev_over=LI('',_class='m-pager-off')

    if len(pager)>ye:
        item_next_over=LI(DIV(XML('&hellip;')),_class='m-pager-off m-pager-tl')
    else:
        item_next_over=LI('',_class='m-pager-off')

    pageritem = UL(
            item_first,
            item_prev10,
            item_prev,
            item_prev_over,
            [LI(A(DIV(str(x + 1)),_href=jtx(x))) for x in pager[ys:y + 1]],
            LI(DIV(str(y + 1)),_class='m-pager-current'),
            [LI(A(DIV(str(x + 1)),_href=jtx(x))) for x in pager[y + 2:ye]],
            item_next_over,
            item_next,
            item_next10,
            item_last,
            _id='mPager',**{'_data-current':y,'_data-index':str(var_offset),'_data-count':str(count)}
        )

    return (pager, pageritem)


@auth.requires_login()
def items():
    """
    アイテム・リスト
    """
    __precheck()

    # 引数（コレクションID）の取得
    collid = 0  #デフォルト
    if len(request.args) > 0:
        collid = request.args(0, cast=int) or 0

    # ワークグループの確認
    if (collid < 2) or (collid not in session.workgroup['collection']):
        redirect(URL('staff','index',args=[],vars={}))

    # 変数
    var_offset = 0
    var_limit = 20
    var_wid = 0

    l_query = []
    var_cross = 1

    count = 0
    count_all = 0

    pager = None
    pageritem = None

    if request.vars:
        var_offset = int(request.vars.get('offset') or 0)
        #var_limit = int(request.vars.get('limit') or 20)
        var_wid = int(request.vars.get('wi') or 0)

    form = __form_search(var_offset)

    if form.accepts(request, session, keepvalues=True):
        #response.flash = T('form accepted')
        l_query = sanitize(form.vars.get('q')).split()
        var_cross = int(form.vars.get('cross') or 1)

    elif form.errors:
        response.flash = T('form has errors')
    else:
        #response.flash = T('please fill the form')
        pass

    # コレクション指定リソース一覧
    da = mr_datahelper.d_d_finder(dbm, collid * var_cross, l_query, (session.groupid < MR_CONF['GROUP_USER']), var_offset, var_limit)

    session.imgs = {}

    # 移動
    session.moves = None
    l_moves = []

    # コレクションがcollidであるリソース（複数）の取得
    div_main = DIV(_class='main m-content')

    count_all = da['result']['all']

    if len(da['array']) > 0:

        count = len(da['array'])
        (pager, pageritem) = __pager(count_all, var_offset, var_limit, 'items', request.args, var_wid)

        for d_d in da['array']:

            dl_meta = TAG.dl()
            for ky in d_d['keyset']:
                if not ky in ['title','description']:
                    if ky in d_d and d_d[ky]['value'] is not None:
                        dl_meta.append(TAG.dt(d_d[ky].get('label',T('(Undefined)'))))
                        dl_meta.append(TAG.dd(mr_helper.__helper_br(d_d[ky].get('value',''))))

            imgs = __image_ul_for_items(session, d_d)

            if imgs:

                div_resource = DIV(
                            DIV(
                                imgs,
                                _class='col-12 col-sm-6 col-md-5 text-center'
                            ),
                            DIV(
                                H2(
                                    A(d_d['title'].get('value',''),
                                        _href=URL('item',args=[d_d['subid']])
                                    ),
                                    _class='m-title'
                                ),
                                DIV(
                                    P(mr_helper.__helper_br(d_d['description'].get('value',['']))),
                                    dl_meta
                                ),
                                _class='col-12 col-sm-6 col-md-7 mt-3 mt-sm-2'
                            ),
                            _class='row m-resource-item m-resource-block'
                        )

            else:

                div_resource = DIV(
                            DIV(
                                H2(
                                    A(d_d['title'].get('value',''),
                                        _href=URL('item',args=[d_d['subid']])
                                    ),
                                    _class='m-title'
                                ),
                                DIV(
                                    P(mr_helper.__helper_br(d_d['description'].get('value',['']))),
                                    dl_meta
                                ),
                                _class='col'
                            ),
                            _class='row m-resource-item m-resource-block'
                        )

            div_main.append(div_resource)

            l_moves.append(d_d['subid'])

    else:

        div_resource = DIV(
                    DIV(
                        P(T('No result.')),
                        _class='col'
                    ),
                    _class='row m-resource-item m-resource-block'
                )

        div_main.append(div_resource)
        pageritem = ''

    session.moves = l_moves
    session.dbparams = [collid,var_offset]

    # サイドメニュー索引の作成
    ul_sidemenu = __get_sidemenu()

    return dict(sidemenu=ul_sidemenu, main=div_main, form=form, pager=pager, pageritem=pageritem, result=[var_offset + 1, var_offset + count, count, count_all], q=da['result']['q'] or [])


@auth.requires_login()
def item():
    """
    リソース・アイテム
    """
    __precheck()

    # 引数（リソースID）の取得
    resourceid = 1  #デフォルト
    if len(request.args) > 0:
        resourceid = request.args(0, cast=int) or 1

    var_collid = 1
    var_offset = 0

    # リソース,ワークグループ指定
    da = mr_datahelper.d_d_resource(dbm, resourceid, set(session.workgroup['collection']), (session.groupid < MR_CONF['GROUP_USER']))

    session.imgs = {}

    # リソースがresourceidであるリソースアイテム（複数）の取得
    div_main = DIV(_class='main m-content')

    for d_d in da['array']:

        imgs = __image_ul_for_eachitem(session, d_d, ['area'], True) or ''

        div_editor = DIV(
                        A('[%s]' % T('Edit'),
                            _href=URL('onresource',extension='load',args=[d_d['subid']]),
                            cid='ymbody',
                            #TAG.button('[%s]' % T('Edit'),
                            #_type='button',
                            _class='btn btn-link',
                            **{'_data-toggle':'modal','_data-target':'#ymeditor','_data-targetid':d_d['subid']}
                        ),
                        _class='m-edit-link'
                    )

        div_main.append(div_editor)

        div_resource = DIV(
                        H2(d_d['title'].get('value','')),
                        DIV(
                            P(mr_helper.__helper_br(d_d['description'].get('value',''))),
                            TABLE(*[
                                TR(TD(d_d[ky]['label'], _class='m-label'),TD(mr_helper.__helper_br(d_d[ky].get('value','')))) for ky in d_d['keyset']
                                if (ky not in ('title','description')) and (ky in d_d) and (d_d[ky]['value'] is not None)
                            ],_class='w-100')
                        ),
                        imgs,
                        DIV(
                            __get_table_external_attributions(d_d)   # 外部Manifest対応
                        ),
                        _class='m-resource-item'
                    )

        div_main.append(div_resource)

    # 移動
    span_prev = SPAN(T('Prev.'))
    span_next = SPAN(T('Next'))

    if session.moves:
        l_moves = session.moves
        idx = l_moves.index(resourceid)
        if idx > 0:
            span_prev = A(SPAN(T('Prev.')),_href=URL('item',args=[l_moves[idx-1]]))
        if idx < len(l_moves) - 1:
            span_next = A(SPAN(T('Next')),_href=URL('item',args=[l_moves[idx+1]]))

    if session.dbparams:
        [var_collid, var_offset] = session.dbparams

    # サイドメニュー索引の作成
    ul_sidemenu = __get_sidemenu()

    return dict(sidemenu=ul_sidemenu, main=div_main, prev=span_prev, next=span_next, collectionid=var_collid, message=da['message'], targetname=resourceid)


def __form_edit(a_id = 0, enable_format = False):
    """
    ビューア編集フォーム
    """

    aopts = [OPTION(x[0],_value=x[1]) for x in ([T('Annotation'),2],)]
    if enable_format:
        aopts = [OPTION(x[0],_value=x[1]) for x in ([T('Annotation'),2],[T('Segment'),1])]

    if MR_CONF['EDITABLE']:
        btsubmit = TAG.button(
            T('Action'),
            #_type='submit',
            _name='doentry',
            _class='btn m-primary col-3'
        )

    else:
        btsubmit = TAG.button(
            T('Action'),
            #_type='submit',
            _name='doentry',
            _disabled='disabled',
            _class='btn m-primary col-3'
        )

    form = FORM(
                DIV(
                    DIV(
                        INPUT(
                            _name='aname',
                            _placeholder=T('Annotation Name'),
                            _class='form-control'
                        ),
                        INPUT(
                            _type='text',
                            _placeholder=T('Label'),
                            _name='q',
                            _autocomplete='off',
                            _value='',
                            value='',
                            _class='form-control', #autocomplete',
                            _id='alabel'
                        ),
                        TEXTAREA(
                            _rows=2,
                            _name='atext',
                            _placeholder=T('Text'),
                            _class='form-control'
                        ),
                        DIV(
                            INPUT(
                                #_type='text',
                                _name='aarea',
                                _placeholder=T('Area'),
                                _class='form-control col-7',
                                requires=IS_NOT_EMPTY()
                            ),
                            INPUT(
                                #_type='text',
                                _name='arot',
                                #_placeholder=T('Rotate'),
                                _value='0',
                                _class='form-control col-3'
                            ),
                            _class="row m-edit-control"
                        )
                    ),
                    DIV(
                        SELECT(
                            aopts,
                            _name='atype',
                            _value=2,
                            value=2,
                            _class='form-control col-4'
                        ),
                        SELECT(
                            [OPTION(x[0],_value=x[1]) for x in ([T('New'),'new'],[T('Update'),'update'],[T('Delete'),'delete'])],
                            _name='afunc',
                            _value='new',
                            value='new',
                            _class='form-control col-2'
                        ),
                        btsubmit,
                        #TAG.button(
                        #    T('Action'),
                        #    #_type='submit',
                        #    _name='doentry',
                        #    _class='btn m-primary col-3'
                        #),
                        #TAG.button(
                        #    T('Cancel'),
                        #    ,_name='docancel'
                        #    ,_class='btn col-3'
                        #)
                        _class="row m-edit-control"
                    ),
                    _class='formgroup m-entry-box'
                ),
                hidden=dict(baseid='1',canvasid='',aid=str(a_id))
            )

    return form


@auth.requires_login()
def editor():
    """
    アノテーション編集
    """
    var_r_id = 1
    var_f_id = 1
    var_a_id = 0
    var_ids = [1,1,1,1]
    var_external = False

    var_target = tuple(request.args)

    if var_target in session.imgs:
        var_ids = session.imgs[var_target]
        (var_r_id,var_folder_id,var_f_id,var_a_id) = var_ids

    var_manifest = None
    var_f_manifest = None

    var_folder = None
    var_name = None
    var_format = None

    #var_on_annote = False
    var_accept = False
    var_mes = T('Fill Label.')

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            # IIIF Manifest
            if request.args[1]=='external':
                r_row = dbm.mr_resources[var_r_id]
                if r_row.mr_manifest_id:
                    var_manifest = r_row.mr_manifest_id
                else:
                    var_manifest = r_row.mr_manifest_link
                var_external = True
            else:
                var_manifest = '/'.join(request.args)
        else:
            var_folder = sanitize(request.args(0))
            var_name = sanitize(request.args(1))
            var_format = sanitize(request.args(2))
        #if 'annote' in request.args:
        #    var_on_annote = True

    form = __form_edit(var_a_id, True) #, (var_format=='tif' or var_format=='jp2'))

    if form.accepts(request, session, keepvalues=False) and MR_CONF['EDITABLE']:

        var_a_id = int(request.vars.get('aid') or 0)
        var_area = sanitize(form.vars.get('aarea')).split(',')
        var_arot = int(form.vars.get('arot') or 0.0)
        var_name = sanitize(form.vars.get('aname'))
        var_label = sanitize(form.vars.get('q'))
        var_text = sanitize(form.vars.get('atext'))
        var_f_id = int(request.vars.get('baseid') or 1)
        var_f = request.vars.get('canvasid')
        if var_f.startswith('http://') or var_f.startswith('https://'):
            var_f_manifest = var_f

        var_type = 'rect'
        if int(form.vars.get('atype') or 2) == 1:
            var_type = 'area'
        var_function = sanitize(form.vars.get('afunc','new'))
        if var_function not in ('new','update','delete',):
            var_function = 'new'
        if var_function == 'new':
            var_a_id = 0

        d = {}
        d.setdefault('mr_annote_area', [int(v or 0) for v in var_area])
        d.setdefault('mr_annote_rotation', var_arot)
        d.setdefault('mr_name', var_name)
        d.setdefault('mr_text', '%s\r\n%s' % (var_label,var_text))
        #d.setdefault('mr_name', var_name)
        d.setdefault('mr_annote_type', var_type)    # area,rect
        if var_type == 'rect':
            d.setdefault('mr_annote_data', [int(v) for v in var_area])
        d.setdefault('mr_resource_id', var_r_id)
        d.setdefault('mr_file_id', var_f_id)

        if var_external:
            d.setdefault('mr_manifest_id', var_manifest)
            d.setdefault('mr_manifest_canvas_id', var_f_manifest)

        d.setdefault('mr_open', True)

        try:
            if var_function == 'delete':
                dbm((dbm.mr_annotes.id>1) & (dbm.mr_annotes.id==var_a_id)).delete()
                var_mes = T('Success delete.')
            else:
                dbm.mr_annotes.update_or_insert((dbm.mr_annotes.id>1) & (dbm.mr_annotes.id==var_a_id),**dbm.mr_annotes._filter_fields(d))
                if var_a_id > 1:
                    var_mes = T('Success update.')
                else:
                    var_mes = T('Success entry.')
            dbm.commit()
            var_accept = True

        except:
            dbm.rollback()
            var_mes = T('Mistake entry.')

    elif form.errors:
        var_mes = T('Form has errors.')
    else:
        pass

    return dict(message=var_mes, form=form, onaccept=var_accept)


@auth.requires_login()
def viewer():
    """
    画像表示
    """
    __precheck()

    var_r_id = 1
    var_folder_id = 1
    var_f_id = 1
    var_a_id = 0
    var_ids = [1,1,1,1]
    var_external = False

    var_target = tuple(request.args)

    if var_target in session.imgs:
        var_ids = session.imgs[var_target]
        (var_r_id,var_folder_id,var_f_id,var_a_id) = var_ids

    var_manifest = None
    var_f_manifest = ''

    var_folder = None
    var_name = None
    var_format = None

    var_on_annote = False

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            # IIIF Manifest
            if request.args[1]=='external':
                r_row = dbm.mr_resources[var_r_id]
                if r_row.mr_manifest_id:
                    var_manifest = r_row.mr_manifest_id
                else:
                    var_manifest = r_row.mr_manifest_link
                var_external = True
            else:
                var_manifest = '/'.join(request.args)
        else:
            var_folder = sanitize(request.args(0))
            var_name = sanitize(request.args(1))
            var_format = sanitize(request.args(2))
        if 'annote' in request.args:
            var_on_annote = True

    return dict(vmanifest=var_manifest, vfolder=var_folder, vname=var_name, vformat=var_format, preview=UL(), subview=UL(), infoview='', idset=var_ids, external=var_external)


def viewer_mirador():
    """
    画像表示
    Mirador Viewer（Experimantal)
    """
    var_external = False

    var_manifest = None

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            var_manifest = '/'.join(request.args)

    return dict(vmanifest=var_manifest, external=var_external)


# ========================================
# Menu
# ========================================

def __get_sidemenu(a_offset=0, a_limit=20):
    """
    Side menuを取得する
    """
    ul = UL(_class='list-group list-group-flush m-menu')

    #li = LI(A(T('Home'),_href=URL('index')),_class="list-group-item")
    #ul.append(li)

    for r in dbm((dbm.mr_collections._id>1)&(dbm.mr_collections.mr_open==True)&dbm.mr_collections.id.belongs(session.workgroup['collection'])).select(orderby=[dbm.mr_collections.mr_order,dbm.mr_collections.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('items',args=[str(r.id)])),_class="list-group-item")
        ul.append(li)

    for r in dbm((dbm.mr_pages._id>1)&(dbm.mr_pages.mr_open==True)&dbm.mr_pages.id.belongs(session.workgroup['page'])).select(orderby=[dbm.mr_pages.mr_order,dbm.mr_pages.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('index',args=[str(r.id)]),_class=""),_class="list-group-item")
        ul.append(li)

    return ul


# ========================================
# IIIF Manifest
# ========================================

@auth.requires_login()
def iiif():
    """
    IIIF Presentation API 2.1
    """
    __precheck()

    # 引数（ファイルID/アノテーションID）の取得
    resourceid = 1  # Default
    folderid = 1  # Default
    fileid = 1  # Default
    annoteid = 1  # Default
    req_api_type = 'manifest.json'
    if len(request.args) > 1:
        domain = sanitize(request.args(0))
        if domain == 'annote':
            annoteid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'file':
            fileid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'folder':
            folderid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'resource':
            resourceid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        else:
            domain = 'resource'
            resourceid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))

    if req_api_type.startswith('manifest'):

        if domain == 'annote':
            da = mr_datahelper.d_d_annote(dbm, annoteid)
        elif domain == 'file':
            da = mr_datahelper.d_d_file(dbm, fileid, set(session.workgroup['collection']))
        elif domain == 'folder':
            da = mr_datahelper.d_d_folder(dbm, folderid, set(session.workgroup['collection']))
        else:
            da = mr_datahelper.d_d_resource(dbm, resourceid, set(session.workgroup['collection']), (session.groupid < MR_CONF['GROUP_USER']))
            #da = mr_datahelper.d_d_resource(dbm, resourceid, set(session.workgroup['collection']))

        # get Manifest JSON
        json_ld = mr_manifesthelper.__get_iiif_manifest(MR_CONF, da['array'])

        #return response.json(json_ld)
        return json.dumps(json_ld, ensure_ascii=False)

    elif req_api_type.startswith('annotationlist'):

        if domain == 'resource':
            cvid = None
            if 'cvid' in request.vars:
                cvid = request.vars.get('cvid')

            da = mr_datahelper.d_d_canvas(dbm, cvid, resourceid)

        #elif domain == 'file':
        #    da = mr_datahelper.d_d_file(dbm, fileid)
        else:
            #da = mr_datahelper.d_d_file(dbm, fileid)
            return response.json({})

        # get Annotation List JSON
        json_ld = mr_manifesthelper.__get_iiif_annotationlist(MR_CONF, da['array'])

        #return response.json(json_ld)
        return json.dumps(json_ld, ensure_ascii=False)

    else:
        return response.json({})


# ========================================
# Test
# ========================================

@auth.requires_login()
def test_elementset():
    """
    要素セットを返す（評価用）
    """
    # 引数の取得
    classid = 1
    if len(request.args) > 0:
        classid = request.args(0, cast=int) or 1

    return mr_datahelper.d__elementset(dbm, classid)


@auth.requires_login()
def test_datahelper():
    """
    データを返す（評価用）
    """
    # 引数の取得
    ids = [1,1,1,1]
    if len(request.args) > 1:
        target = request.args[0]
        for i,v in enumerate([int(v1) for v1 in request.args(1).split(',')]):
            ids[i] = v or 1

    if target == 'page':
        return mr_datahelper.d_d_page(dbm, int(request.args(1)) or 1)
    elif target == 'collection':
        return mr_datahelper.d_d_collection(dbm, int(request.args(1)) or 1)
    elif target == 'resource':
        return mr_datahelper.d_d_resource(dbm, ids[0], set(session.workgroup['collection']), (session.groupid < MR_CONF['GROUP_USER']))
    elif target == 'folder':
        return mr_datahelper.d_d_folder(dbm, ids[1])
    elif target == 'file':
        return mr_datahelper.d_d_file(dbm, ids[2])
    elif target == 'annote':
        return mr_datahelper.d_d_annote(dbm, ids[3])
    elif target == 'canvas':
        return mr_datahelper.d_d_canvas(dbm, '', int(request.args(1)) or 1)
    else:
        return dict(target=target, array=[])


# ========================================
# Manifest link
# ========================================

def __get_dom_icon_manifest(d_d):
    """
    Manifest link
    """
    a_href = ['iiif',d_d['role'],str(d_d['subid']),'manifest.json']
    a_manifest = SPAN(A(
        IMG(
            _src=URL('static','mr_images/iiif_logo.png'),
            _width='32'
        ),
        _href=URL('iiif',args=[d_d['role'],d_d['subid'],'manifest.json']),
        _target='_blank',
        _title='IIIF-Manifest'
        ),
        _class="m-manifest-link")

    return (a_manifest, a_href)


def __get_dom_icon_manifest_external(d_d):
    """
    Manifest link
    """
    a_href = ['iiif','external',str(d_d['ids'][0]),'manifest.json']
    a_manifest = SPAN(A(
        IMG(
            _src=URL('static','mr_images/iiif_logo.png'),
            _width='32'
        ),
        _href='%s://%s%s' % (d_d['href'][0],d_d['href'][1],d_d['href'][2]),
        _target='_blank',
        _title='IIIF-Manifest'
        ),
        _class="m-manifest-link")

    return (a_manifest, a_href, '%s://%s%s' % (d_d['href'][0],d_d['href'][1],d_d['href'][2]))


# ========================================
# Viewer icon
# ========================================

def __test_format(fcontains, refs):
    """
    フォーマットの含有テスト
    """
    b = False
    for v in fcontains:
        if v in refs:   #参照
            b = True
            break;
    return b


def __get_shimakuma_icon(fcontains, m_href_args):
    """
    Shimakuma link
    """
    if __test_format(fcontains, ('tif','jp2','jpg','fzp','fzp3','dzi','zoomify','external',)):
        a_viewer = SPAN(A(
            IMG(
                _src=URL('static','mr_libs/shimakuma/shimakuma-logo.png'),
                _width='30',_height='30'
            ),
            _href=URL('viewer',args=m_href_args),
            _target='_blank',
            _title='Shimakuma viewer'
            ),
            _class="m-viewer-link m-viewer-link-dark")
    else:
        a_viewer = ''

    return a_viewer


def __get_mirador_icon(fcontains, m_href_args):
    """
    Mirador link (Experimental)
    """
    if __test_format(fcontains, ('tif','jpg','external',)):
        a_viewer = SPAN(A(
            IMG(
                _src=URL('static','mr_libs/mirador/mirador-logo.png'),
                _width='30',_height='30'
            ),
            _href=URL('viewer_mirador',args=m_href_args),
            _target='_blank',
            _title='Mirador viewer'
            ),
            _class="m-viewer-link m-viewer-link-dark")
    else:
        a_viewer = ''

    return a_viewer


# ========================================
# Thumbnail image
# ========================================

def __image_ul_for_eachitem(_session, d_d, _atypes=['area'], enable_link=False):
    """
    Thumbnail imageのHTML(UL)を生成、item用
    """
    ul_file = None

    if 'folders' in d_d and len(d_d['folders'])>0:

        ul_file = UL(_class='m-image-items')

        for d_fd in d_d['folders']:

            for idx in d_fd.get('tops',[]):

                d_f = d_fd['files'][idx]

                if 'external' in d_fd['role']:

                    # Manifest link
                    (a_manifest,m_href_args,m_href) = __get_dom_icon_manifest_external(d_f)

                    # Snap image
                    img = IMG(_src='/'.join(d_f.get('snapimage','')),
                            #_width=240,
                            _alt=d_f['title'],
                            _class='m-snapimage'
                        )

                else:
                    # Manifest link
                    (a_manifest,m_href_args) = __get_dom_icon_manifest(d_fd)

                    # Snap image
                    img = IMG(_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f.get('snapimage',''))),
                            #_width=240,
                            _alt=d_f['title'],
                            _class='m-snapimage'
                        )

                if 'external' in d_fd['role']:
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']
                    d_f['format'] = 'external'

                elif d_fd['role']=='folder':
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']

                elif 'pdf' in d_f['href']:
                    href = '%s/resources/%s.pdf' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f['href'][:-1]))
                    _session.imgs[tuple(d_f['href'])] = d_fd['ids']

                elif d_f['format'] in ('fzp','fzp3','zoomify','dzi'):
                    #href = URL('viewer',args=d_f['href'])
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']

                #elif d_f['format'] in ('tif','jp2','jpg','png','gif'):
                else:
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']

                li_file= LI(
                                DIV(
                                    DIV(
                                        A(img,
                                            _href=href,
                                            _target='_blank',
                                            _title=d_f['title']
                                        ),
                                        a_manifest,
                                        _label=d_f['title'],
                                        _class='m-image m-image-snapimage',
                                        **{'_data-id':d_f['subid']}
                                    ),
                                    P(
                                        d_f['title']
                                    ),
                                    #DIV(
                                    #    __get_shimakuma_icon([d_f['format']], m_href_args),
                                    #    __get_mirador_icon([d_f['format']], m_href_args)
                                    #)
                                ),
                                _class='m-image-item m-image-item-wid320'
                            )

                ul_file.append(li_file)


                # セグメント
                if 'annotes' in d_f and len(d_f['annotes'])>0:

                    for d_a in d_f['annotes']:

                        # 対象のアノテーション形式（デフォルト'area'）以外はスルー（出力抑制）
                        if d_a['annotetype'] not in _atypes: continue

                        # Manifest link
                        (a_manifest,m_href_args) = __get_dom_icon_manifest(d_a)

                        # Snap image
                        if 'tif' in d_f['format'] or 'jp2' in d_f['format']:
                            img_src = '%s%s.%s/%s/240,/%d/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(d_f['href'][:-1]),d_f['format'],','.join([str(v) for v in d_a['annotearea']]),int(d_a['annoterotation']))
                        elif 'jpg' in d_f['format']:
                            img_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_a['thumbnail']))
                        else:
                            continue

                        img = IMG(_src=img_src,
                                    _alt=d_a['title'],
                                    _class='m-thumbnail'
                                )
                        href = URL('viewer',args=d_f['href'])
                        var_args = d_f['href']
                        if 'tif' in d_f['format'] or 'jp2' in d_f['format']:
                            manifest_id = "iiif/annote/%s/manifest.json" % (str(d_a['subid']))
                            var_args = ['iiif','annote',str(d_a['subid']),'manifest.json']
                            href = URL('viewer',args=[manifest_id])

                        if enable_link:
                            img_obj = A(img,
                                        _href=href,
                                        _target='_blank',
                                        _title=d_a['title']
                                    )
                        else:
                            img_obj = img

                        _session.imgs[tuple(var_args)] = d_a['ids']

                        li_file = LI(
                                        DIV(
                                            DIV(img_obj,
                                                a_manifest,
                                                _label=d_a['title']['value'],
                                                _class='m-image m-image-thumbnail',
                                                **{'_data-id':d_a['subid']}
                                            ),
                                            P(
                                                d_a['title']['value']
                                            ),
                                            DIV(
                                                __get_shimakuma_icon([d_f['format']], m_href_args),
                                                __get_mirador_icon([d_f['format']], m_href_args)
                                            )
                                        ),
                                        _class='m-image-item m-image-item-wid160'
                                    )

                        ul_file.append(li_file)

    return ul_file


def __image_ul_for_items(_session, d_d):
    """
    Thumbnail imageのHTML(UL)を生成
    """
    ul_file = None

    if 'folders' in d_d and len(d_d['folders'])>0:

        ul_file = UL(_class='m-image-items')

        for d_fd in d_d['folders']:

            for idx in d_fd.get('tops',[]):

                d_f = d_fd['files'][idx]

                if 'role' in d_f and d_f['role'].startswith('external'):

                    # Thumbnail image
                    img = IMG(_src=d_f.get('thumbnailuri',''),
                                _alt=d_f['title'],
                                _class='m-thumbnail'
                            )

                    href = URL('item',args=[d_d['subid']])

                    #_session.imgs[] = d_f['ids']

                else:

                    # Thumbnail image
                    img = IMG(_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f['thumbnail'])),
                                _alt=d_f['title'],
                                _class='m-thumbnail'
                            )

                    href = URL('item',args=[d_d['subid']])

                    _session.imgs[tuple(d_f['href'])] = d_f['ids']

                li_file = LI(
                                DIV(
                                    DIV(
                                        A(img,
                                            _href=href
                                        ),
                                        _label=d_f['title'],
                                        _class='m-image m-image-thumbnail',
                                        **{'_data-id':d_f['subid']}
                                    ),
                                    P(
                                        d_f['title'],
                                        _class='d-none d-sm-block'
                                    )
                                ),
                                _class='m-image-item m-image-item-wid160'
                            )

                ul_file.append(li_file)

    return ul_file


# ========================================
# External contents
# ========================================

def __get_table_external_attributions(d_d):
    """
    外部マニフェスト属性テーブル
    """
    table = None

    if d_d['role'].startswith('external'):

        table = TABLE(TR(TD(T('from Manifest'),_colspan='2',_class='m-label m-label-header')),_class='col')

        for ky in d_d['externalkeyvalue']:
            if ky in d_d['keyset']:
                continue
            if isinstance(d_d['externalkeyvalue'][ky],list):

                for d in d_d['externalkeyvalue'][ky]:
                    if d and len(d.strip())>0:
                        tr= TR(
                                TD(ky, _class='m-label'),
                                TD(XML(d))
                            )
                        table.append(tr)

            elif isinstance(d_d['externalkeyvalue'][ky],str):
                if len(d_d['externalkeyvalue'][ky].strip())>0:
                    tr= TR(
                                TD(ky, _class='m-label'),
                                TD(d_d['externalkeyvalue'][ky])
                            )

                    table.append(tr)

    return table or ''


# ========================================
# Edit table
# ========================================

def __mr_on_validation(form):
    """
    編集後処理
    """
    pass


def __mr_on_create_class(form):
    """
    クラス作成後処理
    """
    if 'mr_class_id' in form.vars:
        return

    var_new_id = form.vars.id

    dbm.mr_class_elements.insert(mr_class_id = var_new_id,
                                mr_name = 'title',
                                mr_title = 'Title',
                                mr_description = 'Title',
                                mr_open = True
                                )
    dbm.mr_class_elements.insert(mr_class_id = var_new_id,
                                mr_name = 'description',
                                mr_title = 'Description',
                                mr_description = 'Description',
                                mr_open = True
                                )

    if ('mr_target' in form.vars) and (form.vars.mr_target == 'page'):

        dbm.mr_class_elements.insert(mr_class_id = var_new_id,
                                mr_name = 'creator',
                                mr_title = 'Creator',
                                mr_description = 'You',
                                mr_open = True
                                )
        dbm.mr_class_elements.insert(mr_class_id = var_new_id,
                                mr_name = 'created',
                                mr_title = 'Created',
                                mr_description = '20xx/xx/xx',
                                mr_open = True
                                )

    dbm.commit()


def __mr_on_create_collection(form):
    """
    コレクション作成後処理
    """
    var_new_id = form.vars.id

    if MR_CONF['WORKGROUP'] and session.groupid > MR_CONF['GROUP_ADMINISTRATOR']:
        # ワークグループの設定が必要
        pass
    else:
        # 管理者はすべての閲覧と操作
        if var_new_id not in session.workgroup['collection']:
            if form.vars.mr_open:
                if session.workgroup:
                    session.workgroup['collection'].append(var_new_id)


def __mr_on_create_section(form):
    """
    セクション作成後処理
    """
    if 'mr_section_id' in form.vars:
        return

    var_new_id = form.vars.id

    # Page section
    var_class_id = form.vars.mr_class_id

    var_rows = dbm(
                    dbm.mr_class_elements.mr_class_id==var_class_id
                ).select(
                    orderby=[dbm.mr_class_elements.mr_order,dbm.mr_class_elements.id]
                )
    for var_row in var_rows:
        dbm.mr_section_items.insert(mr_section_id=var_new_id,
                                    mr_class_element_id=var_row.id,
                                    mr_text=XML('<!-- // %s -->' % var_row.mr_description),
                                    mr_order=var_row.mr_order,
                                    mr_open=var_row.mr_open
                                    )
    dbm.commit()


def __mr_on_create_resource(form):
    """
    リソース作成後処理
    """
    if 'mr_resource_id' in form.vars:
        return

    var_new_id = form.vars.id

    # Resource
    var_class_id = form.vars.mr_class_id

    var_rows = dbm(
                    dbm.mr_class_elements.mr_class_id==var_class_id
                ).select(
                    orderby=[dbm.mr_class_elements.mr_order,dbm.mr_class_elements.id]
                )
    for var_row in var_rows:
        dbm.mr_resource_items.insert(mr_resource_id=var_new_id,
                                    mr_class_element_id=var_row.id,
                                    mr_text=XML('<!-- // %s -->' % var_row.mr_description),
                                    mr_order=var_row.mr_order,
                                    mr_open=var_row.mr_open
                                    )
    dbm.commit()


@auth.requires_login()
def editcollections():
    """
    コレクション編集用
    """
    __precheck()

    var_name = 'collection'

    var_db = dbm.mr_collections
    var_fields = [dbm.mr_collections.id,
                dbm.mr_collections.mr_parent_id,
                dbm.mr_collections.mr_name,
                dbm.mr_collections.mr_title,
                dbm.mr_collections.mr_description,
                dbm.mr_collections.mr_order,
                dbm.mr_collections.mr_open
                ]

    grid = SQLFORM.grid(
                var_db,
                fields=var_fields,
                paginate=20,
                searchable=True,
                editable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                details=True,
                deletable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                create=MR_CONF['EDITABLE'],
                #csv=False,
                exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV'),
                    csv_with_hidden_cols=False, #(ExporterCSV, 'CSV (hidden cols)'),
                    #json=(ExporterJSON, 'JSON'),
                    xml=False, #(ExporterXML, 'XML'),
                    html=False, #(ExporterHTML, 'HTML'),
                    #tsv=(ExporterTSV, 'TSV (Excel compatible)'),
                    tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                ),
                ui='web2py',
                formstyle='table3cols',
                #buttons_placement = 'right',
                user_signature=False,
                oncreate=__mr_on_create_collection
                )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editpages():
    """
    ページ編集用
    """
    __precheck()

    var_name = 'page'

    var_db = dbm.mr_pages
    var_fields = [dbm.mr_pages.id,
                dbm.mr_pages.mr_name,
                dbm.mr_pages.mr_title,
                dbm.mr_pages.mr_text,
                dbm.mr_pages.mr_order,
                dbm.mr_pages.mr_open
                ]

    grid = SQLFORM.grid(
                var_db,
                fields=var_fields,
                paginate=20,
                searchable=True,
                editable=MR_CONF['EDITABLE'],
                details=True,
                deletable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                create=MR_CONF['EDITABLE'],
                #csv=False,
                exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV'),
                    csv_with_hidden_cols=False, #(ExporterCSV, 'CSV (hidden cols)'),
                    #json=(ExporterJSON, 'JSON'),
                    xml=False, #(ExporterXML, 'XML'),
                    html=False, #(ExporterHTML, 'HTML'),
                    #tsv=(ExporterTSV, 'TSV (Excel compatible)'),
                    tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                ),
                ui='web2py',
                formstyle='table3cols',
                #buttons_placement = 'right',
                user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editfolders():
    """
    フォルダ編集用
    """
    __precheck()

    var_name = 'folder'

    var_db = dbm.mr_folders
    var_links = ['mr_files']
    var_fields = [dbm.mr_folders.id,
                dbm.mr_folders.mr_resource_id,
                dbm.mr_folders.mr_name,
                dbm.mr_folders.mr_title,
                dbm.mr_folders.mr_license,
                dbm.mr_folders.mr_order,
                dbm.mr_folders.mr_open,

                dbm.mr_files.id,
                dbm.mr_files.mr_resource_id,
                dbm.mr_files.mr_folder_id,
                dbm.mr_files.mr_title,
                dbm.mr_files.mr_license,
                dbm.mr_files.mr_original_file_name,
                dbm.mr_files.mr_imw,
                dbm.mr_files.mr_imh,
                dbm.mr_files.mr_public_file_format,
                dbm.mr_files.mr_order,
                dbm.mr_files.mr_open
                ]

    grid = SQLFORM.smartgrid(
                var_db,
                fields=var_fields,
                linked_tables=var_links,
                paginate=20,
                searchable=True,
                editable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                details=True,
                deletable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                create=MR_CONF['EDITABLE'],
                #csv=False,
                exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV'),
                    csv_with_hidden_cols=False, #(ExporterCSV, 'CSV (hidden cols)'),
                    #json=(ExporterJSON, 'JSON'),
                    xml=False, #(ExporterXML, 'XML'),
                    html=False, #(ExporterHTML, 'HTML'),
                    #tsv=(ExporterTSV, 'TSV (Excel compatible)'),
                    tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                ),
                ui='web2py',
                formstyle='table3cols',
                #buttons_placement = 'right',
                user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editfiles():
    """
    ファイル編集用
    """
    __precheck()

    var_name = 'file'

    var_db = dbm.mr_files
    var_fields = [dbm.mr_files.id,
                dbm.mr_files.mr_resource_id,
                dbm.mr_files.mr_folder_id,
                dbm.mr_files.mr_identifier,
                dbm.mr_files.mr_title,
                dbm.mr_files.mr_license,
                dbm.mr_files.mr_original_file_name,
                dbm.mr_files.mr_imw,
                dbm.mr_files.mr_imh,
                dbm.mr_files.mr_public_file_format,
                dbm.mr_files.mr_order,
                dbm.mr_files.mr_open
                ]

#    dbm.mr_files.mr_resource_id.requires = IS_LIST_OF()

#    dbm.mr_files.mr_resource_id.widget = SQLFORM.widgets.autocomplete(request, dbm.mr_resources.mr_name, id_field=dbm.mr_resources.id)

#    dbm.mr_files.mr_folder_id.requires = IS_IN_DB(dbm,
#        dbm.mr_folders,
#        dbm.mr_folders._format,
#        orderby=[~dbm.mr_folders.mr_order,~dbm.mr_folders._id])

#    dbm.mr_files.mr_folder_id.widget = SQLFORM.widgets.autocomplete(request, dbm.mr_folders.mr_name, id_field=dbm.mr_folders.id)

    grid = SQLFORM.grid(
                var_db,
                fields=var_fields,
                paginate=20,
                searchable=True,
                editable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                details=True,
                deletable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                create=MR_CONF['EDITABLE'],
                #csv=False,
                exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV'),
                    csv_with_hidden_cols=False, #(ExporterCSV, 'CSV (hidden cols)'),
                    #json=(ExporterJSON, 'JSON'),
                    xml=False, #(ExporterXML, 'XML'),
                    html=False, #(ExporterHTML, 'HTML'),
                    #tsv=(ExporterTSV, 'TSV (Excel compatible)'),
                    tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                ),
                ui='web2py',
                formstyle='table3cols',
                #buttons_placement = 'right',
                user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editannotes():
    """
    アノテーション編集用
    """
    __precheck()

    var_name = 'annote'

    var_db = dbm.mr_annotes
    var_fields = [dbm.mr_annotes.id,
                dbm.mr_annotes.mr_resource_id,
                dbm.mr_annotes.mr_file_id,
                dbm.mr_annotes.mr_name,
                dbm.mr_annotes.mr_text,
                dbm.mr_annotes.mr_annote_type,
                dbm.mr_annotes.mr_annote_area,
                dbm.mr_annotes.mr_annote_data,
                #dbm.mr_annotes.mr_order,
                dbm.mr_annotes.mr_open
                ]

    grid = SQLFORM.grid(
                var_db,
                fields=var_fields,
                paginate=20,
                searchable=True,
                editable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                details=True,
                deletable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                create=MR_CONF['EDITABLE'],
                #csv=False,
                exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV'),
                    csv_with_hidden_cols=False, #(ExporterCSV, 'CSV (hidden cols)'),
                    #json=(ExporterJSON, 'JSON'),
                    xml=False, #(ExporterXML, 'XML'),
                    html=False, #(ExporterHTML, 'HTML'),
                    #tsv=(ExporterTSV, 'TSV (Excel compatible)'),
                    tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                ),
                ui='web2py',
                formstyle='table3cols',
                #buttons_placement = 'right',
                user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editclasses():
    """
    クラス編集用
    """
    __precheck()

    var_name = 'class'

    var_db = dbm.mr_classes
    var_links = ['mr_class_elements']
    var_fields = [dbm.mr_classes.id]

    grid = SQLFORM.smartgrid(
                var_db,
                #fields=var_fields,
                linked_tables=var_links,
                paginate=20,
                searchable=True,
                editable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                details=True,
                deletable=MR_CONF['EDITABLE'] and (lambda row: row.id > 2),
                create=MR_CONF['EDITABLE'],
                selectable=lambda ids:__class_duplicate(ids),
                selectable_submit_button=T('Duplicate'),
                #csv=False,
                exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV'),
                    csv_with_hidden_cols=False, #(ExporterCSV, 'CSV (hidden cols)'),
                    #json=(ExporterJSON, 'JSON'),
                    xml=False, #(ExporterXML, 'XML'),
                    html=False, #(ExporterHTML, 'HTML'),
                    #tsv=(ExporterTSV, 'TSV (Excel compatible)'),
                    tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                ),
                ui='web2py',
                formstyle='table3cols',
                #buttons_placement = 'right',
                user_signature=False,
                onvalidation=__mr_on_validation,
                oncreate=__mr_on_create_class
            )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editsections():
    """
    セクション編集用
    """
    __precheck()

    var_name = 'section'

    var_db = dbm.mr_sections
    var_links = ['mr_section_items']
    var_fields = [dbm.mr_sections.id]

    grid = SQLFORM.smartgrid(
                var_db,
                #fields=var_fields,
                linked_tables=var_links,
                paginate=20,
                searchable=True,
                editable=MR_CONF['EDITABLE'],
                details=True,
                deletable=MR_CONF['EDITABLE'],
                create=MR_CONF['EDITABLE'],
                selectable=lambda ids:__section_duplicate(ids),
                selectable_submit_button=T('Duplicate'),
                #csv=False,
                exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV'),
                    csv_with_hidden_cols=False, #(ExporterCSV, 'CSV (hidden cols)'),
                    #json=(ExporterJSON, 'JSON'),
                    xml=False, #(ExporterXML, 'XML'),
                    html=False, #(ExporterHTML, 'HTML'),
                    #tsv=(ExporterTSV, 'TSV (Excel compatible)'),
                    tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                ),
                ui='web2py',
                formstyle='table3cols',
                #buttons_placement = 'right',
                user_signature=False,
                onvalidation=__mr_on_validation,
                oncreate=__mr_on_create_section
            )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editresources():
    """
    リソース編集用
    """
    __precheck()

    var_name = 'resource'

    var_db = dbm.mr_resources
    var_links = ['mr_resource_items']
    var_fields = [dbm.mr_resources.id,
                    #dbm.mr_resources.mr_parent_id,
                    dbm.mr_resources.mr_collection_ids,
                    dbm.mr_resources.mr_class_id,
                    dbm.mr_resources.mr_name,
                    dbm.mr_resources.mr_summary,
                    #dbm.mr_resources.mr_manifest_id,
                    dbm.mr_resources.mr_order,
                    dbm.mr_resources.mr_open,

                    dbm.mr_resource_items.id,
                    dbm.mr_resource_items.mr_resource_id,
                    dbm.mr_resource_items.mr_class_element_id,
                    dbm.mr_resource_items.mr_text,
                    dbm.mr_resource_items.mr_order,
                    dbm.mr_resource_items.mr_open
                    ]

    #query = dbm.mr_class_id==2
    #dbm.mr_class_elements.mr_class_id.requires = IS_IN_DB(dbm(query),
    #    dbm.mr_classes._id,
    #    '%(mr_title)s',
    #    orderby=[dbm.mr_classes.mr_order,dbm.mr_classes._id]
    #    )

    grid = SQLFORM.smartgrid(
                var_db,
                fields=var_fields,
                linked_tables=var_links,
                paginate=20,
                searchable=True,
                editable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                details=True,
                deletable=MR_CONF['EDITABLE'] and (lambda row: row.id > 1),
                create=MR_CONF['EDITABLE'],
                selectable=lambda ids:__resource_duplicate(ids),
                selectable_submit_button=T('Duplicate'),
                #csv=False,
                exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV'),
                    csv_with_hidden_cols=False, #(ExporterCSV, 'CSV (hidden cols)'),
                    #json=(ExporterJSON, 'JSON'),
                    xml=False, #(ExporterXML, 'XML'),
                    html=False, #(ExporterHTML, 'HTML'),
                    #tsv=(ExporterTSV, 'TSV (Excel compatible)'),
                    tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                ),
                ui='web2py',
                formstyle='table3cols',
                #buttons_placement = 'right',
                user_signature=False,
                onvalidation=__mr_on_validation,
                oncreate=__mr_on_create_resource
            )

    #heading = grid.elements('th')
    #if heading:
    #    heading[0].append(TAG.button(T('Duplicate'),_type='button', _id='checkall'))

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editattrgroups():
    """
    補助属性グループ編集用
    """
    __precheck()

    var_name = 'attrgroup'

    var_db = dbm.mr_attrgroups
    var_fields = [dbm.mr_attrgroups.id,
                dbm.mr_attrgroups.mr_name,
                dbm.mr_attrgroups.mr_title,
                dbm.mr_attrgroups.mr_description,
                dbm.mr_attrgroups.mr_order,
                dbm.mr_attrgroups.mr_open
                ]

    grid = SQLFORM.grid(
                var_db,
                fields=var_fields,
                paginate=20,
                searchable=True,
                editable=MR_CONF['EDITABLE'],
                details=True,
                deletable=MR_CONF['EDITABLE'],
                create=MR_CONF['EDITABLE'],
                #csv=False,
                exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV'),
                    csv_with_hidden_cols=False, #(ExporterCSV, 'CSV (hidden cols)'),
                    #json=(ExporterJSON, 'JSON'),
                    xml=False, #(ExporterXML, 'XML'),
                    html=False, #(ExporterHTML, 'HTML'),
                    #tsv=(ExporterTSV, 'TSV (Excel compatible)'),
                    tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                ),
                ui='web2py',
                formstyle='table3cols',
                #buttons_placement = 'right',
                user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


@auth.requires_login()
def editattributes():
    """
    補助属性編集用
    """
    __precheck()

    var_name = 'attribute'

    var_db = dbm.mr_attributes
    var_fields = [dbm.mr_attributes.id,
                dbm.mr_attributes.mr_group,
                dbm.mr_attributes.mr_title,
                dbm.mr_attributes.mr_description,
                dbm.mr_attributes.mr_order,
                dbm.mr_attributes.mr_open
                ]

    grid = SQLFORM.grid(
                var_db,
                fields=var_fields,
                paginate=20,
                searchable=True,
                editable=MR_CONF['EDITABLE'],
                details=True,
                deletable=MR_CONF['EDITABLE'],
                create=MR_CONF['EDITABLE'],
                #csv=False,
                exportclasses=dict(
                    #csv=(ExporterCSV, 'CSV'),
                    csv_with_hidden_cols=False, #(ExporterCSV, 'CSV (hidden cols)'),
                    #json=(ExporterJSON, 'JSON'),
                    xml=False, #(ExporterXML, 'XML'),
                    html=False, #(ExporterHTML, 'HTML'),
                    #tsv=(ExporterTSV, 'TSV (Excel compatible)'),
                    tsv_with_hidden_cols=False #(ExporterTSV, 'TSV (Excel compatible, hidden cols)')
                ),
                ui='web2py',
                formstyle='table3cols',
                #buttons_placement = 'right',
                user_signature=False
                )

    return dict(grid=grid,dbname=var_name)


# ========================================
# Uploader
# ========================================

def __list_files(a_offset=0,a_limit=20):
    """
    最近のファイルのリスト
    """

    ITEM_LIMIT = 20

    rows = dbm(dbm.mr_files.mr_open==True
                ).select(
                    limitby=(a_offset,ITEM_LIMIT),
                    orderby=~dbm.mr_files.mr_create_date|~dbm.mr_files.id
                )
    count = len(rows)

    #pager = None
    #dom_pager = ''

    ul = UL()

    if rows:

        for r in rows:

            # Metadata
            _title = r.mr_title
            if len(_title) == 0:
                _title = r.mr_original_file_name

            # Thumbnail
            img=XML('&nbsp;')
            if r.mr_ims is not None and '.jpg' in r.mr_ims:
                img = IMG(_src='/%s/resources/%s/%s' % (MR_CONF['IMAGE_NAME'],r.mr_subfolder,r.mr_ims),
                        _alt=_title,
                        _class='m-thumbnail'
                        )

            # Link
            a_href = URL('viewer',args=[r.mr_subfolder,r.mr_iml,r.mr_public_file_format])
            if r.mr_public_file_format == 'pdf':
                a_href = '/%s/resources/%s/%s.pdf' % (MR_CONF['IMAGE_NAME'],r.mr_subfolder, r.mr_iml)

            li= LI(
                        DIV(
                            DIV(
                                img,
                                _label=_title,
                                _class='m-image-item-thumbnail col col-5',
                                **{'_data-id':r.id}
                            ),
                            DIV(
                                TABLE(
                                    TR(TD(T('Title'),_class="m-label"),TD(_title)),
                                    TR(TD(T('Identifier'),_class="m-label"),TD(r.mr_identifier)),
                                    TR(TD(T('Size (px)'),_class="m-label"),TD('%d,%d' % (r.mr_imw,r.mr_imh))),
                                    TR(TD(T('Format'),_class="m-label"),TD(r.mr_public_file_format)),
                                    TR(TD(T('Uploaded date'),_class="m-label"),TD(r.mr_create_date)),
                                    TR(TD(T('Original'),_class="m-label"),TD(r.mr_original_file_name)),
                                    TR(TD(T('File license'),_class="m-label"),TD(r.mr_license)),
                                    TR(TD(T('Note'),_class="m-label"),TD(r.mr_note))
                                ),
                                _class='col col-7'
                            ),
                            _class='m-image-item row'
                        ),
                        _class='m-item'
                    )
            ul.append(li)

    return ul


@auth.requires_login()
def uploader():
    """
    File uploader
    2018-11/2019-05
    """
    __precheck()

    # 一覧
    dom_ul = __list_files(0)

    return dict(title=T('Uploader'), dom=dom_ul, limitmb=MR_CONF['LIMIT_UPLOAD_MB'])


@auth.requires_login()
def upload_callback():
    """
    Dropzoneのための関数
    2018-11/2019-10
    """
    __precheck()

    res = None
    if 'file' in request.vars:

        f = request.vars.file

        f_entry = int(request.vars.get('entry') or 0)
        f_resource = sanitize(request.vars.get('resource',''))
        f_folder = sanitize(request.vars.get('folder',''))
        f_name = sanitize(request.vars.get('name')) or f.filename
        f_identifier = sanitize(request.vars.get('ident',''))
        f_title = sanitize(request.vars.get('title',''))
        f_collection = int(request.vars.get('collection') or 1)
        f_rotate = int(request.vars.get('rotate') or 0)*90
        f_format = int(request.vars.get('format') or 0)
        f_license = int(request.vars.get('license') or 0)
        f_order = int(request.vars.get('order') or 1)

        f_ext = ''
        if f_name.lower().endswith('.jpg'): f_ext = 'jpg'
        elif f_name.lower().endswith('.pdf'): f_ext = 'pdf'
        elif f_name.lower().endswith('.tif'): f_ext = 'tif'
        elif f_name.lower().endswith('.bmp'): f_ext = 'bmp'
        elif f_name.lower().endswith('.png'): f_ext = 'png'
        else: return json.dumps(res, separators=(',', ':'))

        o_format = 'jpg'
        #if f_format == 1: o_format = 'pdf' # auto
        if f_format == 2: o_format = 'tif'
        if f_format == 3: o_format = 'jp2'
        if f_ext == 'pdf': o_format = 'pdf'

        a_license = MR_CONF['LICENSES'][f_license]

        #a_username = None
        a_date = datetime.datetime.now()
        #a_subfolder = a_date.strftime('%Y%m%d')

        if f_identifier == '':
            lastrecord = dbm(dbm.mr_files._id>0).select(orderby=~dbm.mr_files._id).first()
            f_identifier = 'a%06d_%s' % (lastrecord.id+1, a_date.strftime('%Y%m%d_%H%M%S'),)

        r_id = 1
        f_id = 1

        if len(f_resource)>0:

            if re.fullmatch('^[a-zA-Z0-9\.\/\-_]+$',f_resource):

                if dbm(dbm.mr_resources.mr_name==f_resource).count() == 0:

                    r_id = dbm.mr_resources.insert(
                                mr_title=f_title,
                                mr_name=f_resource,
                                mr_open=False
                                )
                    dbm.commit()

                else:
                    r_row = dbm(dbm.mr_resources.mr_name==f_resource).select().first()
                    r_id = r_row.id

            else:
                # エラー処理
                pass

        # folder
        if len(f_folder)==0:
            pass
        elif dbm(dbm.mr_folders.mr_name==f_folder).count() == 0:

            if re.fullmatch('^[a-zA-Z0-9\.\/\-_]+$',f_folder):

                f_id = dbm.mr_folders.insert(
                                mr_resource_id = r_id,
                                mr_name=f_folder,
                                mr_identifier=f_identifier,
                                mr_title=f_title,
                                mr_description=f_title,
                                mr_license=a_license,
                                mr_open=True
                                )
                dbm.commit()
        else:
            f_row = dbm(dbm.mr_folders.mr_name==f_folder).select().first()
            if f_row:
                f_id = f_row.id

        a_id = dbm.mr_files.insert(
                            mr_resource_id = r_id,
                            mr_folder_id = f_id,
                            mr_original_file=dbm.mr_files.mr_original_file.store(f.file, f.filename),
                            mr_original_file_name=f_name,
                            mr_original_file_format=f_ext,
                            mr_identifier=f_identifier,
                            mr_title=f_title,
                            mr_license=a_license,
                            mr_public_file_format=o_format,
                            mr_rotation=f_rotate,
                            mr_create_date=a_date,
                            mr_order=f_order,
                            mr_open=True
                            )

        dbm.commit()

        a_file = dbm.mr_files[a_id]

        t_filenames = re.split('[\.\\/]',a_file.mr_original_file)
        #a_subfolder = t_filenames[0]+'.'+t_filenames[1]+'/'+t_filenames[2][0:2]
        a_subfolder = t_filenames[2][0:2]
        a_filename = t_filenames[2:-1]

        if f_ext in ('jpg','png','bmp','tif'):
            new_name = __make_resource(a_file, a_subfolder, o_format, f_rotate)
        elif f_ext in ('jp2'):
            new_name = __make_resource(a_file, a_subfolder, o_format, f_rotate)
        elif f_ext in ('pdf'):
            new_name = __copy_resource(a_file, a_subfolder, o_format)
        else:
            new_name = __copy_resource(a_file, a_subfolder)

        res = dict(files=[{
            "filename": f.filename,
            "format": o_format
        }])

    return json.dumps(res, separators=(',', ':'))


def __convert(a_in, a_out, a_out_format):
    """
    Tiled Pyramidal TIFF作成にはpyvipsが必要
    例：__convert('folder/sample.jpg','sample','tif')
    2018-11/2019-10
    """
    try:
        # save as Tiled Pyramidal TIFF
        tile_size = MR_CONF['IMG_TILE_SIZE']
        if (type(tile_size) is not int) or tile_size<128 or tile_size>512:
           tile_size = 256  # default (libvips's default is 128)
        im = pyvips.Image.new_from_file(a_in)
        im.write_to_file('%s.tif' % a_out, Q=MR_CONF['IMG_Q'], compression="jpeg", tile=True, pyramid=True, tile_width=tile_size, tile_height=tile_size)
    except:
        # save alternative as JPEG
        try:
            im = Image.open(a_in)
            im.save('%s.jpg' % a_out, 'jpeg', quality=MR_CONF['IMG_Q'])
        except:
            pass


def __make_resource(a_file, store_subfolder='', make_format='jpg', image_rotate=0):
    """
    2018-11
    """
    t_filenames = a_file.mr_original_file.split('.')
    a_srcfolder = '%s.%s/%s' % (t_filenames[0],t_filenames[1],t_filenames[2][0:2])
    a_subfolder = t_filenames[2][0:2]
    a_newname = ( '%s.%s' % ('_'.join(t_filenames[2:-1]),make_format),
            '%s_%s.jpg' % ('_'.join(t_filenames[2:-1]),str(MR_CONF['IMG_SNAP_SIZE'])),
            '%s_%s.jpg' % ('_'.join(t_filenames[2:-1]),str(MR_CONF['IMG_THUMBNAIL_SIZE'])),
            '_'.join(t_filenames[2:-1]),
            make_format, )

    im = Image.open(os.path.join(MR_CONF['FILEBASE_PATH'], 'uploads', a_srcfolder, a_file.mr_original_file))
    if image_rotate>0:
        im = im.rotate(-image_rotate,False,True)
    (wid, hei) = im.size
    a_file.update_record(mr_imw=wid, mr_imh=hei, mr_subfolder=store_subfolder)

    # サブフォルダの作成
    a_path = (
            os.path.normpath(os.path.join(MR_CONF['RESOURCEBASE_PATH'], 'resources', store_subfolder)),
            os.path.normpath(os.path.join(MR_CONF['IMAGEBASE_PATH'], 'resources', store_subfolder)),
            os.path.normpath(os.path.join(MR_CONF['IMAGEBASE_PATH'], 'resources', store_subfolder)),
        )
    if not os.path.exists(a_path[0]): os.makedirs(a_path[0])
    if not os.path.exists(a_path[1]): os.makedirs(a_path[1])
    #if not os.path.exists(a_path[2]): os.makedirs(a_path[2])

    if make_format == 'tif':
        # Tiled Pyramidal TIFF (IIIF/IIPImage)
        # save to 'RESOURCEBASE_PATH'
        __convert(os.path.join(MR_CONF['FILEBASE_PATH'], 'uploads', a_srcfolder, a_file.mr_original_file), os.path.join(a_path[0], a_newname[3]), a_newname[4])
    elif make_format == 'jp2':
        # JPEG2000 (Experimental)
        # save to 'RESOURCEBASE_PATH'
        tile_size = MR_CONF['IMG_TILE_SIZE']
        if (type(tile_size) is not int) or tile_size<128 or tile_size>512:
           tile_size = 128
        im.save(os.path.join(a_path[0], '%s.%s' % (a_newname[3], a_newname[4])), 'jpeg2000', tile_size=(tile_size,tile_size))
    else:
        # JPEG (Default)
        # save to 'IMAGEBASE_PATH'
        im.save(os.path.join(a_path[1], a_newname[0]), 'jpeg', quality=MR_CONF['IMG_Q'])
    a_file.update_record(mr_iml=a_newname[3], mr_imlw=wid, mr_imlh=hei)

    # リサイズ画像の作成 M,S
    im.thumbnail((MR_CONF['IMG_SNAP_SIZE'],MR_CONF['IMG_SNAP_SIZE']), Image.ANTIALIAS)
    (widM, heiM) = im.size
    im.save(os.path.join(a_path[1], a_newname[1]), 'jpeg')
    a_file.update_record(mr_imm=a_newname[1], mr_immw=widM, mr_immh=heiM)

    im.thumbnail((MR_CONF['IMG_THUMBNAIL_SIZE'],MR_CONF['IMG_THUMBNAIL_SIZE']), Image.ANTIALIAS)
    (widS, heiS) = im.size
    im.save(os.path.join(a_path[2], a_newname[2]), 'jpeg')
    a_file.update_record(mr_ims=a_newname[2], mr_imsw=widS, mr_imsh=heiS)

    return a_newname


def __getImageName(name, prefix='', postfix='', sep=''):
    """
    ファイル名を得る
    """
    return ''.join(prefix, sep, name[:name.rfind('.')], sep, postfix, name[name.rfind('.'):])


def __copy_resource(a_file, store_subfolder='', make_format='pdf'):
    """
    そのまま複製
    """
    import shutil

    filenames = a_file.mr_original_file.split('.')
    a_fileformat = filenames[-1].lower()
    #a_subfolder = filenames[0]+'.'+filenames[1]+'/'+filenames[2][0:2]
    a_subfolder = filenames[2][0:2]
    a_newname = ( '%s.%s' % ('_'.join(filenames[2:-1]), a_fileformat),
            '%s_%s.jpg' % ('_'.join(filenames[2:-1]),str(MR_CONF['IMG_SNAP_SIZE'])),
            '%s_%s.jpg' % ('_'.join(filenames[2:-1]),str(MR_CONF['IMG_THUMBNAIL_SIZE'])),
            '_'.join(filenames[2:-1]),
            make_format )

    (filename, stream) = dbm.mr_files.mr_original_file.retrieve(a_file.mr_original_file)

    a_path = os.path.normpath(os.path.join(MR_CONF['IMAGEBASE_PATH'], 'resources', store_subfolder))
    if not os.path.exists(a_path): os.makedirs(a_path)

    b_path = os.path.join(a_path, a_newname[0])
    shutil.copyfileobj(stream, open(b_path,'wb'))

    a_file.update_record(mr_iml=a_newname[3], mr_subfolder=store_subfolder)

    if a_fileformat == 'pdf':
        # PDF
        # save to 'IMAGEBASE_PATH'
        im = pyvips.Image.new_from_file('%s[0]' % b_path)

        # リサイズ画像の作成 M,S
        th1 = im.thumbnail_image(MR_CONF['IMG_SNAP_SIZE'])
        th1.write_to_file(os.path.join(a_path, a_newname[1]), Q=75)
        a_file.update_record(mr_imm=a_newname[1], mr_immw=th1.width, mr_immh=th1.height)

        th2 = th1.thumbnail_image(MR_CONF['IMG_THUMBNAIL_SIZE'])
        th2.write_to_file(os.path.join(a_path, a_newname[2]), Q=75)
        a_file.update_record(mr_ims=a_newname[2], mr_imsw=th2.width, mr_imsh=th2.height)

    return a_newname


# ======================
# In-page editor
# ======================

def __get_form_disabled_input(a_id, a_name, a_label, a_text, a_validators=None):

    validators = []
    if a_validators:
        validators.extend(a_validators)

    div = DIV(
                LABEL(a_label,_class='col-sm-2 col-form-label'),
                DIV(
                    INPUT(_value='',value=a_text or '',
                        _type='text',
                        _name='%s_%d' % (a_name,a_id,),
                        _class='form-control',
                        requires=validators,
                        **{'_disabled':''}
                        #**{'_readonly':''}
                    ),
                    _class='col-sm-10'
                ),
                _id=a_id,
                _class='form-group row'
            )
    return div


def __get_form_input(a_id, a_name, a_label, a_text, a_validators=None):

    validators = []
    if a_validators:
        validators.extend(a_validators)

    div = DIV(
                LABEL(a_label,_class='col-sm-2 col-form-label'),
                DIV(
                    INPUT(_value='',value=a_text or '',
                        _type='text',
                        _name='%s_%d' % (a_name,a_id,),
                        _class='form-control',
                        requires=validators
                    ),
                    _class='col-sm-10'
                ),
                _id=a_id,
                _class='form-group row'
            )
    return div


def __get_form_text(a_id, a_name, a_label, a_text, var_row=3):
    if a_text and len(a_text) < 20:
        var_row = 2
    div = DIV(
                LABEL(a_label,_class='col-sm-2 col-form-label'),
                DIV(
                    TEXTAREA(_value='',value=a_text,
                        _rows=var_row,
                        _name='%s_%d' % (a_name,a_id,),
                        _class='form-control'
                    ),
                    _class='col-sm-10'
                ),
                _class='form-group row'
            )
    return div


def __get_form_select(a_id, a_name, a_label, a_text, a_options):
    div = DIV(
                LABEL(a_label,_class='col-sm-2 col-form-label'),
                DIV(
                    SELECT(
                        [OPTION(x[0],_value=x[1]) for x in a_options],
                        _value='',value=a_text,
                        _name='%s_%d' % (a_name,a_id,),
                        _class='form-control'
                    ),
                    _class='col-sm-10'
                ),
                _class='form-group row'
            )
    return div


def __resource_form_processing(form):
    pass


@auth.requires_login()
def onresource():
    """
    リソース編集
    """
    __precheck()

    # 引数（リソースID）の取得
    resourceid = 1  #デフォルト
    if len(request.args) > 0:
        resourceid = request.args(0, cast=int) or 1

    form = None
    names = [] # form name

    var_accept = False

    # このリソース
    row_resource = dbm.mr_resources[resourceid]

    if row_resource:

        # ワークグループ
        if len(session.workgroup['collection'])>0:
            intercol = set(row_resource.mr_collection_ids or [])
            intercol.intersection_update(set(session.workgroup['collection']))
            if len(intercol) == 0:
                return dict(form=None, onaccept=False, resourceid=resourceid)

        d_elements = mr_datahelper.d__elementset(dbm, row_resource.mr_class_id)

        # このリソースのアイテムの取得
        rows_items = dbm((dbm.mr_resource_items.mr_open == True)
                    & (dbm.mr_resource_items.mr_resource_id == row_resource.id)
                    & dbm.mr_resource_items.mr_class_element_id.belongs(d_elements['group'])
                ).select(
                    left=dbm.mr_class_elements.on(dbm.mr_resource_items.mr_class_element_id == dbm.mr_class_elements.id),
                    #limitby=(a_offset,a_limit),
                    #orderby_on_limitby=False,
                    orderby=[dbm.mr_resource_items.mr_order,dbm.mr_resource_items.id]
                )

        rows_folders = dbm((dbm.mr_folders.mr_open == True)
                    & (dbm.mr_folders.mr_resource_id == row_resource.id)
                    ).select()

        #files = []
        rows_files = dbm((dbm.mr_files.mr_open == True)
                    & (dbm.mr_files.mr_resource_id == row_resource.id)
                    ).select()
        #if rows_files:
        #    for rowf in rows_files:
        #        files.append('%d: %s' % (rowf.id, rowf.mr_name))

        form_divs = DIV(_id='formcontainer',_class='container')

        if MR_CONF['EDITABLE']:
            btsubmit = TAG.button(
                T('Save changes'),
                _type='submit',
                _class='btn btn-primary mx-2'
            )
        else:
            btsubmit = TAG.button(
                T('Save changes'),
                _type='submit',
                _disabled='disabled',
                _class='btn btn-primary mx-2'
            )

        form = FORM(form_divs,
                    DIV(
                        btsubmit,
                        #TAG.button(
                        #    T('Save changes'),
                        #    _type='submit',
                        #    _class='btn btn-primary mx-2'
                        #),
                        TAG.button(
                            T('Reset'),
                            _type='reset',
                            _class='btn btn-secondary mx-2'
                        ),
                         _class="formgroup text-center"
                    ),
                    _method='POST',
                    _name='editform'
                )

        form_divs.append(H5(T('Resource'),':'))

        validators = [
            #IS_NOT_IN_DB(dbm, 'mr_resources.mr_name'),
            #IS_MATCH('^[a-zA-Z0-9\-_]*$',error_message=T('using half-width and characters in the ranges a-z, A-Z, 0-9 or - (hyphen) or _ (underscore)')),
            #IS_MATCH('^[a-z0-9]+(?:-[a-z0-9]+)*$',error_message=T('must be slug')),
            IS_SLUG(maxlen=80, check=True, error_message=T('must be slug')),
        ]

        names.append('mr_name_%d' % row_resource.id)
        form_divs.append(__get_form_input(row_resource.id, 'mr_name', T('Resource name'), row_resource.mr_name, validators))

        names.append('mr_summary_%d' % row_resource.id)
        form_divs.append(__get_form_text(row_resource.id, 'mr_summary', T('Resource summary'), row_resource.mr_summary, 2))

        form_divs.append(HR())
        form_divs.append(H5(T('Images'),':'))

        file_edit = DIV(
                        LABEL('',_class='col-sm-2 col-form-label'),
                        DIV(
                            TAG.button('[%s] (%d)' % (T('Folder'),len(rows_folders)),
                                        _type='button',
                                        _class='btn btn-link',
                                        _id='mrFolderEdit',
                                        **{'_data-toggle':'collapse','_data-target':'#ymc1','_data-targetid':row_resource.id,'_aria-expanded':'false','_aria-controls':'ymc1'}
                            ),
                            TAG.button('[%s] (%d)' % (T('File'),len(rows_files)),
                                        _type='button',
                                        _class='btn btn-link',
                                        _id='mrFileEdit',
                                        **{'_data-toggle':'collapse','_data-target':'#ymc2','_data-targetid':row_resource.id,'_aria-expanded':'false','_aria-controls':'ymc2'}
                            ),
                            _class='col-sm-10'
                        ),
                        _class='form-group row'
                    )

        form_divs.append(file_edit)

        select1 = __selectfolder(row_resource.id)
        select2 = __selectfile(row_resource.id)

        folder_edit_body = DIV(select1,_id='ymc1',_class='collapse',**{'_data-parent':'#formcontainer'})
        file_edit_body = DIV(select2,_id='ymc2',_class='collapse',**{'_data-parent':'#formcontainer'})

        form_divs.append(folder_edit_body)
        form_divs.append(file_edit_body)

        form_divs.append(HR())
        form_divs.append(H5(T('Metadata'),':'))

        if rows_items:

            for row_item in rows_items:

                if row_item.mr_resource_items.mr_open and row_item.mr_class_elements.mr_open:
                    a_label = '%s' % row_item.mr_class_elements.mr_title
                else:
                    a_label = '(%s)' % row_item.mr_class_elements.mr_title

                names.append('%s_%d' % (row_item.mr_class_elements.mr_name,row_item.mr_resource_items.id,))

                form_divs.append(__get_form_text(row_item.mr_resource_items.id, row_item.mr_class_elements.mr_name, a_label, row_item.mr_resource_items.mr_text,5))


    #if form.process(onvalidation=__resource_form_processing).accepted:
    #if form.accepts(request, session, keepvalues=True):
    if form.process(formname='editform').accepted and MR_CONF['EDITABLE']:

        try:
            d = {}
            for v in names:
                if '_' in v:
                    vs = v.split('_')

                    if len(vs) >= 3 and vs[0] == 'mr':
                        var_fm_name = '_'.join(vs[:-1])
                        var_fm_val = sanitize(form.vars.get(v))
                        if row_resource[var_fm_name] != var_fm_val:
                            d.setdefault(var_fm_name, var_fm_val)

                    if len(vs) == 2:
                        var_fm_name = vs[0] or ''
                        var_fm_id = int(vs[1]) or 0
                        var_fm_val = sanitize(form.vars.get(v))

                        if var_fm_id > 0:
                            upd_record = dbm.mr_resource_items[var_fm_id]
                            if upd_record and upd_record.mr_text != var_fm_val:
                                upd_record.update_record(mr_text=var_fm_val)

            if var_fm_id > 1 and len(d) > 0:
                #dbm.mr_resources.update_or_insert(dbm.mr_resources.id==row_resource.id,**dbm.mr_resources._filter_fields(d))
                dbm(dbm.mr_resources.id==row_resource.id).validate_and_update(**dbm.mr_resources._filter_fields(d))

            dbm.commit()
            response.flash = T('Success update.')
            var_accept = True
            response.js = 'setTimeout(function(){ jQuery("#ymeditor").slideUp("fast",function(){ setTimeout(function(){ window.location.reload(); },500) }); },500);'
        except:
            dbm.rollback()
            response.flash = T('Error on edit.')

    return dict(form=form, onaccept=var_accept, resourceid=resourceid)


@auth.requires_login()
def onsection():
    """
    セクション編集
    """
    __precheck()

    # 引数（セクションID）の取得
    sectionid = 1  #デフォルト
    if len(request.args) > 0:
        sectionid = request.args(0, cast=int) or 1

    form = None
    names = [] # form name

    var_accept = False

    # このセクション
    row_section = dbm.mr_sections[sectionid]

    if row_section:

        # ワークグループ確認
        if row_section.mr_page_id not in session.workgroup['page']:
            return dict(form=None, onaccept=False)

        d_elements = mr_datahelper.d__elementset(dbm, row_section.mr_class_id)

        # このセクションのアイテムの取得
        rows_items = dbm((dbm.mr_section_items.mr_open == True)
                    & (dbm.mr_section_items.mr_section_id == sectionid)
                    & dbm.mr_section_items.mr_class_element_id.belongs(d_elements['group'])
                ).select(
                    left=dbm.mr_class_elements.on(dbm.mr_section_items.mr_class_element_id == dbm.mr_class_elements.id),
                    #limitby=(a_offset,a_limit),
                    #orderby_on_limitby=False,
                    orderby=[dbm.mr_section_items.mr_order,dbm.mr_section_items.id]
                )

        form_divs = DIV(_class='container')

        if MR_CONF['EDITABLE']:
            btsubmit = TAG.button(
                T('Save changes'),
                _type='submit',
                _class='btn btn-primary mx-2'
            )
        else:
            btsubmit = TAG.button(
                T('Save changes'),
                _type='submit',
                _disabled='disabled',
                _class='btn btn-primary mx-2'
            )

        form = FORM(form_divs,
                    DIV(
                        btsubmit,
                        #TAG.button(
                        #    T('Save changes'),
                        #    _type='submit',
                        #    _class='btn btn-primary mx-2'
                        #),
                        TAG.button(
                            T('Reset'),
                            _type='reset',
                            _class='btn btn-secondary mx-2'
                        ),
                         _class="formgroup text-center"
                    ),
                    _method='POST',
                    _action='#'
                )

        form_divs.append(H5(T('Page section'),':'))

        validators = [
            #IS_NOT_IN_DB(dbm, 'mr_sections.mr_name'),
            #IS_MATCH('^[a-zA-Z0-9\-_]*$',error_message=T('using half-width and characters in the ranges a-z, A-Z, 0-9 or - (hyphen) or _ (underscore)')),
            #IS_MATCH('^[a-z0-9]+(?:-[a-z0-9]+)*$',error_message=T('must be slug')),
            IS_SLUG(maxlen=80, check=True, error_message=T('must be slug')),
        ]

        names.append('mr_name_%d' % row_section.id)
        form_divs.append(__get_form_input(row_section.id, 'mr_name', T('Page section name'), row_section.mr_name, validators))

        names.append('mr_text_%d' % row_section.id)
        form_divs.append(__get_form_text(row_section.id, 'mr_text', T('Page section note'), row_section.mr_text, 2))

        form_divs.append(HR())
        form_divs.append(H5(T('Metadata'),':'))

        if rows_items:

            for row_item in rows_items:

                if row_item.mr_section_items.mr_open and row_item.mr_class_elements.mr_open:
                    a_label = '%s' % row_item.mr_class_elements.mr_title
                else:
                    a_label = '(%s)' % row_item.mr_class_elements.mr_title

                names.append('%s_%d' % (row_item.mr_class_elements.mr_name,row_item.mr_section_items.id,))

                form_divs.append(__get_form_text(row_item.mr_section_items.id, row_item.mr_class_elements.mr_name, a_label, row_item.mr_section_items.mr_text,7))


    #if form.process(onvalidation=__resource_form_processing).accepted:
    if form.accepts(request, session, keepvalues=True) and MR_CONF['EDITABLE']:

        try:
            d = {}
            for v in names:
                if '_' in v:
                    vs = v.split('_')

                    if len(vs) >= 3 and vs[0] == 'mr':
                        var_fm_name = '_'.join(vs[:-1])
                        var_fm_val = sanitize(form.vars.get(v))
                        if row_section[var_fm_name] != var_fm_val:
                            d.setdefault(var_fm_name, var_fm_val)

                    elif len(vs) == 2:
                        var_fm_name = vs[0] or ''
                        var_fm_id = int(vs[1] or 0)
                        var_fm_val = sanitize(form.vars.get(v))

                        if var_fm_id > 0:
                            upd_record = dbm.mr_section_items[var_fm_id]
                            if upd_record and upd_record.mr_text != var_fm_val:
                                upd_record.update_record(mr_text=var_fm_val)

            if row_section.id > 1 and len(d) > 0:
                #dbm.mr_sections.update_or_insert(dbm.mr_sections.id==row_section.id,**dbm.mr_sections._filter_fields(d))
                dbm(dbm.mr_sections.id==row_section.id).validate_and_update(**dbm.mr_sections._filter_fields(d))

            dbm.commit()
            #response.flash = T('Success update.')
            var_accept = True
            response.js = 'setTimeout(function(){ jQuery("#ymeditor").slideUp("fast",function(){ setTimeout(function(){ window.location.reload(); },500) }); },500);'
        except:
            dbm.rollback()
            response.flash = T('Error on edit.')

    return dict(form=form, onaccept=var_accept)


# =============================
# Dupricate
# =============================

def __class_duplicate(ids):
    """
    クラスの複製
    """
    srcs = dbm(dbm.mr_classes.id.belongs(ids)).select(dbm.mr_classes.ALL,orderby=dbm.mr_classes.id)

    if srcs and len(srcs)>0:
        for src in srcs:
            newid = dbm.mr_classes.insert(**dbm.mr_classes._filter_fields(src))

            items = dbm(
                        (dbm.mr_class_elements.mr_class_id == src.id)
                    ).select(
                        orderby=dbm.mr_class_elements.id
                    )

            if items:

                for item in items:
                    item.update(mr_class_id = newid)
                    dbm.mr_class_elements.insert(**dbm.mr_class_elements._filter_fields(item))


def __resource_duplicate(ids):
    """
    リソースの複製
    """
    srcs = dbm(dbm.mr_resources.id.belongs(ids)).select(dbm.mr_resources.ALL,orderby=dbm.mr_resources.id)

    if srcs and len(srcs)>0:
        for src in srcs:
            newid = dbm.mr_resources.insert(**dbm.mr_resources._filter_fields(src))

            items = dbm(
                        (dbm.mr_resource_items.mr_resource_id == src.id)
                    ).select(
                        orderby=dbm.mr_resource_items.id
                    )

            if items:

                for item in items:
                    item.update(mr_resource_id = newid)
                    dbm.mr_resource_items.insert(**dbm.mr_resource_items._filter_fields(item))


def __section_duplicate(ids):
    """
    ページ・セクションの複製
    """
    srcs = dbm(dbm.mr_sections.id.belongs(ids)).select(dbm.mr_sections.ALL,orderby=dbm.mr_sections.id)

    if srcs and len(srcs)>0:
        for src in srcs:
            newid = dbm.mr_sections.insert(**dbm.mr_sections._filter_fields(src))

            items = dbm(
                        (dbm.mr_section_items.mr_section_id == src.id)
                    ).select(
                        orderby=dbm.mr_section_items.id
                    )

            if items:

                for item in items:
                    item.update(mr_section_id = newid)
                    dbm.mr_section_items.insert(**dbm.mr_section_items._filter_fields(item))

"""
def selectform():
    "
    Relational select box
    "

    if len(request.args) > 0:
        _id = request.args(0, cast=int) or 1

    table1 = dbm.mr_files
    field1 = dbm.mr_files.mr_resource_id
    table2 = dbm.mr_resources
    field2 = dbm.mr_resources.mr_name

    record2 = dbm.mr_files[_id]

    rows2 = dbm(dbm.mr_resources.id == record2.mr_resource_id).select()
    option2 = [OPTION('%d: %s' % (r.id,r.mr_name,),_value=r.id) for r in rows2]

    select1 = SELECT(_name='sel1',_size='10',_multiple='multiple',_class='col-5')
    select2 = SELECT(option2,_name='sel2',_value='',value='',_size='10',_multiple='multiple',_class='col-5')

    form = FORM(
                DIV(
                    DIV(
                        DIV(
                            INPUT(_value='',_type='search',_name='filter',_class='form-control'),
                            _class='col-7 col-sm-5'
                        ),
                        DIV(
                            TAG.button(T('Filter'),_type='submit',_class='btn btn-secondary w-75'),
                            _class='col-4 col-sm-2 text-center'
                        ),
                        _class='form-row form-group p-2'
                    ),
                    DIV(
                        select1,
                        DIV(
                            TAG.button(T('Add'),' ',I('',_class='fa fa-angle-right',**{'_aria-hidden':'true'}),_type='button',_id='seladd',_class='d-block btn w-75 btn-secondary m-2 mx-auto'),
                            TAG.button(I('',_class='fa fa-angle-left',**{'_aria-hidden':'true'}),' ',T('Del.'),_type='button',_id='seldel',_class='d-block btn w-75 btn-secondary m-2 mx-auto'),
                            _class='col-2 text-center p-2'
                        ),
                        select2,
                        _class='form-row form-group p-2'
                    ),
                    DIV(
                        TAG.button(T('Apply'),_type='button',_id='apply',_class='btn btn-primary ml-auto'),
                        _class='form-row form-group text-right mb-0 p-2'
                    ),
                    _class='container border p-2'
                ),
                _name='fileform',
                hidden=dict(action=0,sels='')
            )

    rows = None

    if form.process(formname='fileform').accepted:

        var_submit = int(request.vars.get('action')) or 0

        if var_submit > 0:

            var_sels = request.vars.get('sels')
            var_upd = [int(n.strip()) for n in var_sels.split(',') if n.isdigit()]
            if len(var_upd)>0:
                record2.update_record(mr_resource_id = var_upd[0])

            #var_sels = request.vars.get('sels')
            #var_upd = [int(n.strip()) for n in var_sels.split(',') if n.isdigit()]
            #record2.update_record(mr_relations = var_upd)

            rows3 = dbm(dbm.mr_resources.id == record2.mr_resource_id).select()
            options = [OPTION('%d: %s' % (r.id,r.mr_name,),_value=r.id) for r in rows3]
            select2.elements('option',replace=None)
            for opt in options:
                select2.append(opt)

            response.flash = ','.join([str(n) for n in var_upd])

        else:
            var_q = form.vars.get('filter')
            rows = dbm(
                        dbm.mr_resources.mr_name.like('%'+var_q+'%')
                    ).select(
                        orderby=dbm.mr_resources.id
                    )
            options = [OPTION('%d: %s' % (r.id,r.mr_name,),_value=r.id) for r in rows if r is not None]
            select1.elements('option',replace=None)
            for opt in options:
                select1.append(opt)

            response.flash = var_q

    return dict(form=form,rows=rows)
"""

def __selectfolder(resourceid):
    """
    Relational select box
    """

    row_folder = dbm((dbm.mr_folders.mr_open==True)
                & (dbm.mr_folders.mr_resource_id == resourceid)
                ).select()

    option1 = [OPTION('%d: %s' % (r.id,r.mr_name,),_value=r.id) for r in row_folder]

    rows_folder = dbm((dbm.mr_folders.mr_open==True)
                & dbm.mr_folders.mr_relations.contains(resourceid)
                ).select()

    relation1 = [OPTION('%d: %s' % (r.id,r.mr_name,),_value=r.id) for r in rows_folder]


    select1 = DIV(
                SELECT(_name='src1',_size='8',_multiple='multiple',_class='form-control'),
                _class='col-5'
            )
    select2 = DIV(
                LABEL(T('Folder'),_class='small my-1'),SELECT(option1,_name='sel1',_value='',value='',_class='form-control'),
                LABEL(T('Relation'),_class='small my-1'),SELECT(relation1,_name='dest1',_value='',value='',_size='3',_multiple='multiple',_class='form-control'),
                _class='col-5'
            )

    if MR_CONF['EDITABLE']:
        btapply = TAG.button(T('Apply'),_type='button',_id='apply1',_class='btn btn-primary ml-auto')
    else:
        btapply = TAG.button(T('Apply'),_type='button',_id='apply1',_disabled='disabled',_class='btn btn-primary ml-auto')

    div = DIV(
        DIV(
            DIV(
                INPUT(_value='',_type='search',_name='q1',_class='form-control'),
                _class='col-7 col-sm-5'
            ),
            DIV(
                TAG.button(T('Filter'),_type='button',_id='filter1',_class='btn btn-sm btn-secondary w-75 mt-1'),
                _class='col-4 col-sm-2 text-center'
            ),
            _class='form-row form-group p-2'
        ),
        DIV(
            select1,
            DIV(
                TAG.button(T('Set'),' ',I('',_class='fa fa-angle-right',**{'_aria-hidden':'true'}),_type='button',_id='set1',_class='d-block btn btn-sm w-75 btn-secondary mx-2 mt-3 mb-4 mx-auto'),
                TAG.button(T('Add'),' ',I('',_class='fa fa-angle-right',**{'_aria-hidden':'true'}),_type='button',_id='add1',_class='d-block btn btn-sm w-75 btn-secondary m-2 mx-auto'),
                TAG.button(I('',_class='fa fa-angle-left',**{'_aria-hidden':'true'}),' ',T('Del.'),_type='button',_id='del1',_class='d-block btn btn-sm w-75 btn-secondary m-2 mx-auto'),
                _class='col-2 text-center p-2'
            ),
            select2,
            _class='form-row form-group p-2'
        ),
        DIV(
            btapply,
            #TAG.button(T('Apply'),_type='button',_id='apply1',_class='btn btn-primary ml-auto'),
            _class='form-row form-group text-right mb-0 p-2'
        ),
        _class='container border p-2'
    )

    return div


def __selectfile(resourceid):
    """
    Relational select box
    """

    row_file = dbm((dbm.mr_files.mr_open==True)
                & (dbm.mr_files.mr_resource_id == resourceid)
                ).select()

    option2 = [OPTION('%d: %s' % (r.id,r.mr_identifier,),_value=r.id) for r in row_file]

    rows_file = dbm((dbm.mr_files.mr_open==True)
                & dbm.mr_files.mr_relations.contains(resourceid)
                ).select()

    relation2 = [OPTION('%d: %s' % (r.id,r.mr_identifier,),_value=r.id) for r in rows_file]


    select1 = DIV(
                SELECT(_name='src2',_size='8',_multiple='multiple',_class='form-control'),
                _class='col-5'
            )
    select2 = DIV(
                LABEL(T('File'),_class='small my-1'),SELECT(option2,_name='sel2',_value='',value='',_class='form-control'),
                LABEL(T('Relation'),_class='small my-1'),SELECT(relation2,_name='dest2',_value='',value='',_size='3',_multiple='multiple',_class='form-control'),
                _class='col-5'
            )

    if MR_CONF['EDITABLE']:
        btapply = TAG.button(T('Apply'),_type='button',_id='apply2',_class='btn btn-primary ml-auto')
    else:
        btapply = TAG.button(T('Apply'),_type='button',_id='apply2',_disabled='disabled',_class='btn btn-primary ml-auto')

    div = DIV(
        DIV(
            DIV(
                INPUT(_value='',_type='search',_name='q2',_class='form-control'),
                _class='col-7 col-sm-5'
            ),
            DIV(
                TAG.button(T('Filter'),_type='button',_id='filter2',_class='btn btn-sm btn-secondary w-75 mt-1'),
                _class='col-4 col-sm-2 text-center'
            ),
            _class='form-row form-group p-2'
        ),
        DIV(
            select1,
            DIV(
                TAG.button(T('Set'),' ',I('',_class='fa fa-angle-right',**{'_aria-hidden':'true'}),_type='button',_id='set2',_class='d-block btn btn-sm w-75 btn-secondary mx-2 mt-3 mb-4 mx-auto'),
                TAG.button(T('Add'),' ',I('',_class='fa fa-angle-right',**{'_aria-hidden':'true'}),_type='button',_id='add2',_class='d-block btn btn-sm w-75 btn-secondary m-2 mx-auto'),
                TAG.button(I('',_class='fa fa-angle-left',**{'_aria-hidden':'true'}),' ',T('Del.'),_type='button',_id='del2',_class='d-block btn btn-sm w-75 btn-secondary m-2 mx-auto'),
                _class='col-2 text-center p-2'
            ),
            select2,
            _class='form-row form-group p-2'
        ),
        DIV(
            btapply,
            #TAG.button(T('Apply'),_type='button',_id='apply2',_class='btn btn-primary ml-auto'),
            _class='form-row form-group text-right mb-0 p-2'
        ),
        _class='container border p-2'
    )

    return div


@auth.requires_login()
def getfolder():
    __precheck()

    var_q = request.vars.get('q')
    rows = dbm(
                dbm.mr_folders.mr_name.like('%'+var_q+'%')
                | dbm.mr_folders.mr_title.like('%'+var_q+'%')
            ).select(
                orderby=dbm.mr_folders.id
            )
    json = [[r.id,r.mr_name] for r in rows if r is not None]
    return response.json(json)


@auth.requires_login()
def getfile():
    __precheck()

    var_q = request.vars.get('q')
    rows = dbm(
                dbm.mr_files.mr_identifier.like('%'+var_q+'%')
                | dbm.mr_files.mr_title.like('%'+var_q+'%')
            ).select(
                orderby=dbm.mr_files.id
            )
    json = [[r.id,r.mr_identifier] for r in rows if r is not None]
    return response.json(json)


@auth.requires_login()
def setrelation():
    """
    update folder/file relation
    """
    __precheck()

    result = [[],[], 0]
    TARGET = ['mr_folders','mr_files']

    var_target = TARGET[int(request.vars.get('target') or 1)] # default: mr_files

    var_rid = int(request.vars.get('rid') or 1)
    var_sels = sanitize(request.vars.get('sels'))
    var_upd = [int(n.strip()) for n in var_sels.split(',') if n.isdigit()]

    result.append([var_rid,var_upd])

    # 主関連
    rows1 = dbm(dbm[var_target].mr_resource_id == var_rid).select()
    # 削除する対象（リソースのidを関連に含む対象の数）
    rows2 = dbm(dbm[var_target].mr_relations.contains(var_rid)).select()
    # 追加する対象
    rows3 = dbm(dbm[var_target].id.belongs(var_upd[1:])).select()

    try:
        # 主関連の更新
        for r in rows1:
            r.update_record(mr_resource_id = 1)
            result[0].append(r.id)
        if var_upd[0] > 1:
            dbm(dbm[var_target].id == var_upd[0]).update(mr_resource_id = var_rid)
            result[1].append(var_upd[0])

        # 関連更新
        for r in rows2:
            # 現状の削除
            l = r.mr_relations or []
            l.remove(var_rid)
            r.update_record(mr_relations = l)
            result[0].append(r.id)
        for r in rows3:
            l = r.mr_relations or []
            #if l is None:
            #    l = []
            l.append(var_rid)
            l.sort()
            r.update_record(mr_relations = l)
            result[1].append(r.id)
        dbm.commit()
        result[2]=1
    except:
        dbm.rollback()
        result[2]=0

    return response.json(result)
