# coding: UTF-8

require 'm2w_common'

require 'style/hikidoc/hikidoc'

require 'cgi'

#=本文のフォーマット変換を行います。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: formatter.rb 38 2011-06-01 12:40:15Z yutaka_at_home $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

class Formatter

	attr_reader :has_plugin_contents

	def preformat (buffer)
		result = m2w_encode(HikiDoc.to_xhtml(buffer, M2W_HIKI_OPTIONS), M2W_XMLRPC_ENCODING)

		@has_plugin_contents = (%r!<div class="plugin">{{(.+)\}\}</div>! =~ result)
		@commentout_contents = Formatter.get_commentout_contents(buffer)

		if @has_plugin_contents then
			return result
		else
			return @commentout_contents + result
		end
	end

	def postformat(buffer, vars)
		buffers = buffer.split(/\r\n|\r|\n/)
		result = ""
		buffers.each do |line|
			if /<(div|span) class="plugin">/ =~ line then
				plugin_type = $1

				case plugin_type
				when "div"
					if %r!<div class="plugin">{{(.+)\}\}</div>! =~ line then
						plugin_contents = $1
						result = result + Formatter.call_plugin(plugin_contents, vars)
					end
				when "span"
					while 0 < line.length
						if %r!^(.*?)<span class="plugin">{{(.+?)\}\}</span>(.*)$! =~ line then
							left = $1
							plugin_contents = $2
							right = $3

							result = result + left + Formatter.call_inline_plugin(plugin_contents, vars)
							line = right
						else
							result = result + line
							break
						end
					end
				end
			else
				result = result + line + "\n"
			end
  	end

		return @commentout_contents + result
	end

	def Formatter.get_plugin_clsssname(name)
		return name.slice(0, 1).upcase + name.slice(1, name.length - 1)
	end

	def Formatter.call_plugin(contents, vars)
		begin
			if /^ *([a-zA-Z_][0-9a-zA-Z_]*) *$/ =~ contents then
				return eval("#{Formatter.get_plugin_clsssname($1)}_plugin").new.plugin_contents(nil, vars)
			elsif /^ *([a-zA-Z_][0-9a-zA-Z_]*) *\((.+)\)$/ =~ contents then
				return eval("#{Formatter.get_plugin_clsssname($1)}_plugin").new.plugin_contents($2, vars)
			else
				return "<!-- #{contents} -->"
			end
		rescue => e
			return "<!-- #{contents} : error message = #{e.message} -->"
		end
	end

	def Formatter.call_inline_plugin(contents, vars)
		begin
			if /(^[a-zA-Z_][0-9a-zA-Z_]*$)/ =~ contents then
				return eval("#{Formatter.get_plugin_clsssname($1)}_plugin").new.plugin_contents_inline(nil, vars)
			elsif /^([a-zA-Z_][0-9a-zA-Z_]*)\((.+)\)$/ =~ contents then
				return eval("#{Formatter.get_plugin_clsssname($1)}_plugin").new.plugin_contents_inline($2, vars)
			else
				return "<!-- #{contents} -->"
			end
		rescue => e
			return "<!-- #{contents} : error message = #{e.message} -->"
		end
	end

	def Formatter.get_commentout_contents(buffer)
		return "<!-- " + CGI.escapeHTML(buffer) + "-->"
	end

end
