# coding: UTF-8

require 'net/smtp'
require 'mailutils/mail_processor'

#=メール通知
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_mail_sender.rb 102 2011-06-27 11:08:50Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

class Mail2WeblogMailSender

	def initialize(smtp_server_address, smtp_server_port, smtp_security_type, smtp_server_user, smtp_server_password, smtp_pop3before_smtp_server_address, smtp_pop3before_smtp_server_port, smtp_pop3before_smtp_server_user, smtp_pop3before_smtp_server_password)
		@smtp_server_address = smtp_server_address
		@smtp_server_port = smtp_server_port
		@smtp_security_type = smtp_security_type
		@smtp_server_user = smtp_server_user
		@smtp_server_password = smtp_server_password
		@smtp_pop3before_smtp_server_address = smtp_pop3before_smtp_server_address
		@smtp_pop3before_smtp_server_port = smtp_pop3before_smtp_server_port
		@smtp_pop3before_smtp_server_user = smtp_pop3before_smtp_server_user
		@smtp_pop3before_smtp_server_password = smtp_pop3before_smtp_server_password
	end

	def sendmail(mail)
		if @smtp_security_type == 'POPbeforeSMTP' then
			pop = Net::POP3.new(@smtp_pop3before_smtp_server_address, @smtp_pop3before_smtp_server_port)
			pop.start(@smtp_pop3before_smtp_server_user, @smtp_pop3before_smtp_server_password)
			pop.finish
		end

		if @smtp_security_type == 'SMTP-AUTH' then
			Net::SMTP.start(@smtp_server_address, @smtp_server_port, @smtp_server_address, @smtp_server_user, @smtp_server_password, :login) do |smtp|
				smtp.send_message(
					MailProcessor.make(mail), mail.from_address.address, MailProcessor.make_address_list(mail.to_addresses)
				)
			end
		else
			Net::SMTP.start(@smtp_server_address, @smtp_server_port, @smtp_server_address) do |smtp|
				smtp.send_message(
					MailProcessor.make(mail), mail.from_address.address, MailProcessor.make_address_list(mail.to_addresses)
				)
			end
		end
	end

end
