# coding: UTF-8

require 'style/formatter'

require 'xmlrpc/client'

#=metaWeblog API を使った標準の投稿用拡張モジュールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: fc2_post_extension.rb 81 2011-06-23 13:25:31Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogPostExtension

	attr_reader :report

	def initialize(parent)
		@parent = parent
		@report = {}
	end

	def post(header, content, attachments, blogid)
		M2W_LOGGER.info("Start  post ... http://#{@parent.host}#{@parent.address}, blogid = #{blogid}")

		server = XMLRPC::Client.new(@parent.host, @parent.address)

		post_before(server, header, content, attachments, blogid)

		formatter = Formatter.new(@parent.encoding)
		header['description'] = formatter.preformat(content)

		# ブログ本文を投稿する
		M2W_LOGGER.info("Start  metaWeblog.newPost ...")
		postid = server.call("metaWeblog.newPost", blogid, @parent.username, @parent.password, header, 1)
		@report[:postid] = postid
		M2W_LOGGER.info("Finish metaWeblog.newPost ... postid = #{postid}")

		# 添付ファイルを投稿する
		attachment_urls = nil
		if attachments.size > 0 then
			attachment_urls = {}
			attachment_index = 1
			attachments.each do |attachment|
				M2W_LOGGER.info("Start  metaWeblog.newMediaObject ... index = #{attachment_index}, filename = #{attachment.filename}")
				media_result = attachment_urls[attachment_index] = server.call("metaWeblog.newMediaObject", blogid, @parent.username, @parent.password,
					{"bits" => XMLRPC::Base64.new(attachment.content), "name" => @parent.get_attachment_filepath(postid, attachment_index, attachment.filename)}
				)
				if media_result != nil then
					attachment_urls[attachment_index] = media_result['url']
				end
				M2W_LOGGER.info("Finish metaWeblog.newMediaObject ...")
				attachment_index = attachment_index + 1
			end
			@report[:attachment_urls] = attachment_urls.clone
		end

		# ブログ本文のプラグインを有効化して再編集する
		# ※ 再編集する理由は、一度投稿しないと postid をプラグインに伝えられないからである
		if formatter.has_plugin_contents then
			vars = {:blogid => blogid, :postid => postid, :encoding => @parent.encoding}
			vars = vars.merge(header)
			if attachment_urls != nil then
				vars[:attachment_urls] = attachment_urls
			end
			M2W_LOGGER.info("Start  metaWeblog.editPost ...")
			header['description'] = formatter.postformat(header['description'], vars)
			edit_successed = server.call("metaWeblog.editPost", postid, @parent.username, @parent.password, header, 1)
			@report[:edit_successed] = edit_successed
			M2W_LOGGER.info("Finish metaWeblog.editPost ... result = #{edit_successed}")
		end

		post_after(server, header, content, attachments, blogid, postid)

		return true
	end

	def post_before(server, header, content, attachments, blogid)
	end

	def post_after(server, header, content, attachments, blogid, postid)
	end

end
