# coding: UTF-8

require 'xmlrpc/client'

#=はてなダイアリーのためのブログ編集投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary_edit.rb 235 2011-08-22 00:18:41Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiaryEdit_WeblogPlugin

	attr_reader :report

	def initialize(parent)
		@parent = parent
		@report = {}
	end

	def header_alias
		return {}
	end

	def edit(header, content, attachments, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#edit ... endpoint = #{@parent.endpoint}, header = #{header.to_s}")

		result = false

		client = @parent.client
		formatter = @parent.formatter

		postid = header['postid']
		header.delete('postid')

		if postid != nil then
			before(client, header, content, attachments, postid)

			# 事前フォーマットする
			entry_content = formatter.preformat(
				content,
				@parent.mail_sender.make_content(header, content),
				attachments != nil && !attachments.empty?)

			header = @parent.mail_parser.get_alias_header(header, M2W_HATENA_DIARY_POST_HEADER_ALIAS)

			# ブログ記事を投稿する
			M2W_LOGGER.debug("Start  AtomPub.update_entry")
			update_entry = Atom::Entry.new(:content => entry_content.encode('BINARY', 'BINARY'))
			update_entry.title = header['title'].encode('BINARY', 'BINARY') if header['title'] != nil
			M2W_LOGGER.debug("entry = #{update_entry.to_s}")
			entry_uri = client.update_entry(@parent.entry_collection_uri + "/" + postid, update_entry)
			@report[:postid] = postid
			@report[:attachment_urls] = nil
			M2W_LOGGER.debug("Finish AtomPub.update_entry ... entry_uri = #{entry_uri}, postid = #{postid}")

			after(client, header, content, attachments, postid)
			result = true
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = #{result}")
		return result
	end

	def before(client, header, content, attachments, postid)
	end

	def after(client, header, content, attachments, postid)
	end

end
