# coding: UTF-8

#=メール解析
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_mail_parser.rb 191 2011-08-10 13:35:32Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Mail2WeblogMailParser

	def initialize(subject_header, subject_separator, header_alias = {})
		@subject_header = subject_header
		@subject_separator = subject_separator
		if header_alias != nil then
			@header_alias = header_alias.clone
		else
			@header_alias = {}
		end
	end

	def parse_subject(subject)
		if @subject_header != nil then
			if subject =~ /^#{@subject_header}#{@subject_separator}(.+?)#{@subject_separator}(.+?)$/ then
				command_name = $1
				param = $2
				return [command_name, param]
			elsif subject =~ /^#{@subject_header}#{@subject_separator}(.+?)$/ then
				command_name = $1
				return [command_name, '']
			end
		else
			if subject =~ /^(.+?)#{@subject_separator}(.+?)$/ then
				command_name = $1
				param = $2
				return [command_name, param]
			else
				return [subject, '']
			end
		end

		return nil
	end

	def escaped_prefix_content(content, first_line)
		lines = content.split(/\r\n|\r|\n/)

		# first_line が見つかるまでヘッダーを除去する
		result = ""
		index = 0
		while index < lines.size
			if /^(> *)?#{first_line}/ =~ lines[index] then
				break
			end

			index = index + 1
		end

		# > 
		while index < lines.size
			if /^(> *)?(.+)$/ =~ lines[index] then
				result << $2
			end

			if index != lines.size - 1 then
				result << "\n"
			end

			index = index + 1
		end

		return result
	end

	def parse_content(content, header_alias_plus)
		buffers = content.split(/\r\n|\r|\n/)
		header_alias = @header_alias.merge(header_alias_plus)

		# ヘッダーを読み込む（改行までがヘッダー）
		header = {}
		i = 0
		while i < buffers.size && buffers[i] != ''
			line = buffers[i]

			if line =~ /^([0-9a-zA-Z_]+?)#{@subject_separator}(.*)$/ then
				key = $1
				value = $2
				if header_alias.has_key?(key) then
					header[header_alias[key]] = value
				else
					header[key] = value
				end
			else
				break
			end

			i = i + 1
		end

		# 空行を読み飛ばす
		while i < buffers.size && buffers[i] == ''
			i = i + 1
		end

		# 本文を読み込む
		content = ''
		while i < buffers.size
			content << buffers[i]

			if i != buffers.size - 1 then
				content << "\n"
			end

			i = i + 1
		end

		return [header, content]
	end

	def get_alias_header(header, header_alias)
		if header.kind_of?(Hash) then
			result = {}
			header.each do |key, value|
				if header_alias.has_key?(key) then
					result[header_alias[key]] = value
				else
					result[key] = value
				end
			end
			return result
		elsif header.kind_of?(Array) then
			result = []
			index = 0
			while index < header.size
				key = header[index]
				value = header[index + 1]

				if header_alias.has_key?(key) then
					result[header_alias[key]] = value
				else
					result[key] = value
				end

				index = index + 1
			end
			return result
		end

		return nil
	end

end
