# coding: UTF-8

require 'mailutils/mail_processor'

#=メールを基にブログへのコマンドを発行するブログコマンド
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: weblog_command.rb 194 2011-08-11 13:36:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
#
# 発行するコマンドの種類は、メールタイトル（Subject ヘッダー）で判断します。
#
# 想定するメールタイトルのフォーマットは以下の通りです。
#
# header:コマンド名:パラメータ
#
# hedaer は、コンストラクタで指定した任意の文字列です。
# 本クラスは、メールタイトルが上記フォーマットにマッチしないメールを無視します。
#
# 該当するメールであることが分かった場合は、コマンド名に応じた処理を実行します。
# コマンドの詳細は、コマンドを実行する各クラスを参照してください。
#
# コマンドが成功したと認識した場合、本クラスはメールボックスから該当のメールを削除します。
class WeblogCommand

	def initialize(weblog, mail_parser, mail_sender, plugin_manager)
		@weblog = weblog
		@mail_parser = mail_parser
		@mail_sender = mail_sender
		@plugin_manager = plugin_manager
	end

	def run(m)
		mail = MailProcessor.parse(m.pop, M2W_SYSTEM_INNER_ENCODING)
		begin
			subject_parsed_result = @mail_parser.parse_subject(mail.escaped_prefix_subject)
			if subject_parsed_result != nil then
				command_name = subject_parsed_result[0]
				param = subject_parsed_result[1]

				M2W_LOGGER.info("Processing ... #{mail.subject}")

				command = @plugin_manager.get_command_plugin(command_name)
				if command != nil then
					command.weblog = @weblog if command.respond_to?("weblog=")
					command.mail_parser = @mail_parser if command.respond_to?("mail_parser=")
					command.mail_sender = @mail_sender if command.respond_to?("mail_sender=")
					command.plugin_manager = @plugin_manager if command.respond_to?("plugin_manager=")
					command.mail = mail if command.respond_to?("mail=")
					command.param = param if command.respond_to?("param=")

					if command.run() then
						M2W_LOGGER.info("Successed")
					else
						M2W_LOGGER.info("Failed")
					end
				else
					M2W_LOGGER.error("不明なコマンド(#{command_name})を実行しようとしました。")
					if M2W_REPLY then
						@mail_sender.sendmail_as_command("error", nil, {}, "不明なコマンド(#{command_name})を実行しようとしました。", mail.from_address, [])
					end
				end

				m.delete
			end
		rescue => e
			M2W_LOGGER.error("ブログコマンド実行中に予測不能なエラーが発生しました。")
			M2W_LOGGER.error(e)
			M2W_LOGGER.error(m.pop)
			m.delete
			if M2W_REPLY then
				@mail_sender.sendmail_as_command("error", nil, {}, "ブログコマンド実行中に予測不能なエラーが発生しました。", mail.from_address, [])
			end
		end

		return true
	end

end
