# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog'
require 'plugin/weblog/movable_type/movable_type_edit'
require 'plugin/weblog/movable_type/movable_type_post'

M2W_WEBLOG_MT_DEFAULT_ENCODING = 'UTF-8'
M2W_WEBLOG_MT_CATEGORIES = 'categories'
M2W_WEBLOG_MT_ATTACHMENT_ROOT_PATH = 'attachments/'

#=Movable Type のためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: movable_type.rb 241 2011-08-25 15:48:27Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MovableType_WeblogPlugin < MetaWeblog_WeblogPlugin

	def initialize(endpoint = M2W_WEBLOG_ENDPOINT, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_WEBLOG_MT_DEFAULT_ENCODING, attachment_root_path = M2W_WEBLOG_MT_ATTACHMENT_ROOT_PATH)
		super
	end

	def header_alias_for_post
		return {'keys' => 'mt_keywords', 'tags' => 'mt_tags', 'cats' => M2W_WEBLOG_MT_CATEGORIES}
	end

	# 添付ファイルのパスを取得します。
	def get_attachment_filepath(postid, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}/#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_post_plugin()
		return MovableTypePost_WeblogPlugin.new(self)
	end

	# ブログ記事編集用のプラグインを取得します。
	def get_edit_plugin()
		return MovableTypeEdit_WeblogPlugin.new(self)
	end

	# ブログ記事にカテゴリを設定する
	def set_post_categories(client, blogid, postid, categories)
		if categories != nil then
			M2W_LOGGER.debug("Start  mt.getCategoryList ... categories = #{categories}")
			category_map = get_category_map(client.call("mt.getCategoryList", blogid, username, password))
			M2W_LOGGER.debug("Finish mt.getCategoryList ... category_map = #{category_map}")

			M2W_LOGGER.debug("Start  mt.setPostCategories ... categories = #{categories}")
			result = client.call(
				"mt.setPostCategories",
				postid, username, password,
				get_category_array(categories, category_map))
			M2W_LOGGER.debug("Finish mt.setPostCategories")
		end
	end

	# ブログ記事の再構築を行う
	def publish_post(client, postid)
		M2W_LOGGER.debug("Start  mt.publishPost ... postid = #{postid}")
		result = client.call("mt.publishPost", postid, username, password)
		M2W_LOGGER.debug("Finish mt.publishPost ...")
	end

	def get_category_map(categories)
		result = {}
		# カテゴリ名はカテゴリＩＤにマップする
		categories.each do |category|
			result[category['categoryId']] = category['categoryId']
		end

		# カテゴリＩＤはそのままカテゴリＩＤにマップする
		#
		# （※）
		# このカテゴリマップ作成の順番は、
		# カテゴリ名にカテゴリＩＤと重複するものが存在する場合、カテゴリ名を優先するということを意味する。
		# 恐らくはレアケースと思われるが、人間へのわかりやすさという観点からそう決定する。
		categories.each do |category|
			result[category['categoryName']] = category['categoryId']
		end
		return result
	end

	def get_category_array(categories, category_map)
		result = []
		categories.split(",").each do |category|
			if category_map.has_key?(category) then
				result.push({"categoryId" => category_map[category]})
			else
				# 存在しないカテゴリは無視する
			end
		end
		return result
	end

end
