# coding: UTF-8

require 'xmlrpc_support/xmlrpc_parser'
require 'plugin/weblog/movable_type/movable_type'
require 'plugin/weblog/word_press/word_press_edit'
require 'plugin/weblog/word_press/word_press_post'

M2W_WEBLOG_WORDPRESS_DEFAULT_ENCODING = 'UTF-8'
M2W_WEBLOG_WORDPRESS_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_WEBLOG_WORDPRESS_XMLRPC_ENCODING = 'UTF-8'

#=WordPress のためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: word_press.rb 241 2011-08-25 15:48:27Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class WordPress_WeblogPlugin < MovableType_WeblogPlugin

	def initialize(endpoint = M2W_WEBLOG_ENDPOINT, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_WEBLOG_WORDPRESS_DEFAULT_ENCODING, attachment_root_path = M2W_WEBLOG_WORDPRESS_ATTACHMENT_ROOT_PATH)
		super
	end

	def header_alias_for_post
		return {'keys' => 'mt_keywords', 'cats' => M2W_WEBLOG_MT_CATEGORIES}
	end

	def client
		result = super
		result.set_parser(XMLRPCParser.new(M2W_WEBLOG_WORDPRESS_XMLRPC_ENCODING))
		return result
	end

	# 添付ファイルのパスを取得します。
	def get_attachment_filepath(postid, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_post_plugin()
		return WordPressPost_WeblogPlugin.new(self)
	end

	# ブログ記事編集用のプラグインを取得します。
	def get_edit_plugin()
		return WordPressEdit_WeblogPlugin.new(self)
	end

end
