# coding: UTF-8

require 'm2w_plugin_manager'
require 'plugin/weblog/meta_weblog/meta_weblog_post'
require 'style/formatter'
require 'xmlrpc_support/xmlrpc_writer'

require 'time'
require 'uri'

M2W_META_WEBLOG_DEFAULT_ENCODING = 'UTF-8'
M2W_META_WEBLOG_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_META_WEBLOG_THUMBNAIL_ROOT_PATH = 'thumbs'
M2W_META_WEBLOG_POST_HEADER_ALIAS = {
  'tit' => 'title',
  'dat' => 'dateCreated',
}

#=metaWeblog API を使った標準のウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblog_WeblogPlugin

	attr_accessor :mail_parser
	attr_accessor :mail_sender
	attr_accessor :plugin_manager

	attr_reader :endpoint
	attr_reader :username
	attr_reader :password
	attr_reader :encoding
	attr_reader :attachment_root_path

	def initialize(endpoint = M2W_WEBLOG_ENDPOINT, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_META_WEBLOG_DEFAULT_ENCODING, attachment_root_path = M2W_META_WEBLOG_ATTACHMENT_ROOT_PATH, thumbnail_root_path = M2W_META_WEBLOG_THUMBNAIL_ROOT_PATH)
		@endpoint = endpoint
		@username = username
		@password = password
		@encoding = encoding
		@attachment_root_path = attachment_root_path
		@thumbnail_root_path = thumbnail_root_path
	end

	def client
		uri = URI.parse(@endpoint)
		result = XMLRPC::Client.new(uri.host, uri.path)
		# result.set_writer(XMLRPCWriter.new(M2W_SYSTEM_INNER_ENCODING))
		return result
	end

	def formatter
		return Formatter.new(@plugin_manager)
	end

	# 文字列を日付に直します。
	def parse_date(date)
		return Time.iso8601(date)
	end

	# 日付を文字列に直します。
	def get_date(date)
		return date.strftime('%Y%m%dT%H:%M:%S')
	end

	# 添付ファイルのデフォルトのパスを取得します。
	def get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# 添付ファイルのパスを取得します。
	def get_attachment_filepath(postid, dateCreated, attachment_index, attachment_filename)
		default = get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		if @plugin_manager != nil then
			return @plugin_manager.get_weblog_filepath('attachment_url', postid, dateCreated, attachment_index, attachment_filename, default)
		else
			return default
		end
	end

	# サムネイルのデフォルトのパスを取得します。
	def get_thumbnail_default_filepath(postid, dateCreated, attachment_index, thumbnail_filename)
		return "#{@thumbnail_root_path}#{postid}_#{attachment_index}#{File.extname(thumbnail_filename)}"
	end

	# サムネイルのパスを取得します。
	def get_thumbnail_filepath(postid, dateCreated, attachment_index, attachment_filename)
		default = get_thumbnail_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		if @plugin_manager != nil then
			return @plugin_manager.get_weblog_filepath('thumbnail_url', postid, dateCreated, attachment_index, attachment_filename, default)
		else
			return default
		end
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_post_plugin()
		return MetaWeblogPost_WeblogPlugin.new(self)
	end

	# ブログ記事取得用のプラグインを取得します。
	def get_get_plugin()
		return MetaWeblogGet_WeblogPlugin.new(self)
	end

	# ブログ記事編集用のプラグインを取得します。
	def get_edit_plugin()
		return MetaWeblogEdit_WeblogPlugin.new(self)
	end

end
