# coding: UTF-8

#=blogger API
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Blogger

	def initialize(client, username, password, encoding)
		@client = client
		@username = username
		@password = password
		@encoding = encoding
	end

	def get_users_blogs(appkey = "")
		blogs = @client.call("blogger.getUsersBlogs", appkey, @username, @password)
		result = {}
		blogs.each do |blog|
			result[blog["blogid"]] = Blog.new(blog["blogid"].encode(@encoding), blog["url"].encode(@encoding), blog["blogName"].encode(@encoding))
		end
		return result
	end

end

class Blog

	attr_reader :blogid
	attr_reader :url
	attr_reader :blog_name

	def initialize(blogid, url, blog_name)
		@blogid = blogid
		@url = url
		@blog_name = blog_name
	end

end
