# encoding: UTF-8

require 'xmlrpc/client'

#=XML-RPC 用のパーサ
#
# 文字エンコードのサポートを行います。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class XMLRPCParser < XMLRPC::XMLParser::AbstractStreamParser

	def initialize(encoding = nil)
		require "rexml/document"
		@parser_class = StreamListener
		@encoding = encoding
	end

	def parseMethodResponse(str)
		parser = @parser_class.new(@encoding)
		parser.parse(str)
		raise "No valid method response!" if parser.method_name != nil
		if parser.fault != nil
			# is a fault structure
			[false, parser.fault]
		else
			# is a normal return value
			raise "Missing return value!" if parser.params.size == 0
			raise "Too many return values. Only one allowed!" if parser.params.size > 1
			[true, parser.params[0]]
		end
	end

	def parseMethodCall(str)
		parser = @parser_class.new(@encoding)
		parser.parse(str)
		raise "No valid method call - missing method name!" if parser.method_name.nil?
		[parser.method_name, parser.params]
	end

	class StreamListener
		include XMLRPC::XMLParser::StreamParserMixin

		alias :tag_start :startElement
		alias :tag_end :endElement
		alias :text :character
		alias :cdata :character

		def initialize(encoding = nil)
			super()
			@encoding = encoding
		end

		def method_missing(*a)
			# ignore
		end

		def parse(str)
			if @encoding != nil then
				str.encode(@encoding, @encoding)
				encoding = @encoding
			else
				encoding = str.encoding
			end

			if str =~ /^<\?xml(.+)\?>(.+)$/m then
				decl = $1
				content = $2

				if decl !~ /encoding=['"].+['"]/ then
					str = %Q!<?xml #{decl} encoding="#{encoding}"?>#{content}!
				end
			end

			parser = REXML::Document.parse_stream(str, self)
		end
	end

end
