# encoding: UTF-8

require 'xmlrpc/client'

#=XML-RPC 用のライター
#
# 文字エンコードのサポートを行います。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class XMLRPCWriter < XMLRPC::XMLWriter::Simple

	def initialize(encoding)
		@encoding = encoding
	end

	def pi(name, *params)
		if @encoding == nil && params.join(" ") !~ /encoding/ then
			return "<?#{name} " + params.join(" ") + " ?>"
		else
			return "<?#{name} " + params.join(" ") + %Q! encoding="#{@encoding}"?>!
		end
	end

end
