# coding: UTF-8

require 'plugin/format/lib/format_plugin_warning'

require 'net/http'

M2W_NIKO_HOST = 'ext.nicovideo.jp'
M2W_NIKO_PORT = 80
M2W_NIKO_WATCH_BASE_URL = 'http://www.nicovideo.jp/watch/sm'
M2W_NIKO_GETTHUMBINFO_BASE_URL = 'http://ext.nicovideo.jp/api/getthumbinfo/sm'
M2W_NIKO_THUMB_BASE_URL = 'http://ext.nicovideo.jp/thumb/sm'
M2W_NIKO_RESPONSE_ENCODING = 'UTF-8'

#=ニコニコ動画へのサムネイルを貼り付ける書式プラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
#
# 参考）ニコニコ動画APIとは - getthumbinfo, 
# http://dic.nicovideo.jp/a/%E3%83%8B%E3%82%B3%E3%83%8B%E3%82%B3%E5%8B%95%E7%94%BBapi
class Nico_FormatPlugin

	def plugin_contents(param, vars)
		iframe = get_iframe(param)
		return "<div>#{iframe}</div>"
	end

	def plugin_contents_inline(param, vars)
		return get_iframe(param)
	end

	def get_iframe(param)
		title = get_title(param)

		if title != nil then
			return %Q!<iframe width="312" height="176" src="#{M2W_NIKO_THUMB_BASE_URL}#{param}" scrolling="no" style="border:solid 1px #CCC;" frameborder="0"><a href="#{M2W_NIKO_WATCH_BASE_URL}#{param}">#{title}</a></iframe>!
		else
			raise FormatPluginWarning.new(
				"ニコニコ動画タイトル取得不可(動画ＩＤ = #{param})",
				"ニコニコ動画のタイトルが取得できませんでした（動画ＩＤ = #{param}）。")
		end
	end

	def get_title(param)
		response = Net::HTTP.start(M2W_NIKO_HOST, M2W_NIKO_PORT) do |http|
		  http.get("#{M2W_NIKO_GETTHUMBINFO_BASE_URL}#{param}")
		end

		case response
		when Net::HTTPSuccess
			if %r!<title>(.+)</title>!m =~ response.body then
				return $1.encode(M2W_SYSTEM_INNER_ENCODING, M2W_NIKO_RESPONSE_ENCODING)
			end
		else
			return nil
		end
	end

end
