# coding: UTF-8

require 'plugin/weblog/hatena_diary/hatena_diary_formatter'

require 'atomutil/atomutil'

M2W_HATENA_DIARY_POST_HEADER_ALIAS = {
  'tit' => 'title',
}

M2W_HATENA_DIARY_ATTACHMENT_ROOT_PATH = 'attrs'

#=はてなダイアリーのためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiary_WeblogPlugin

	attr_accessor :mail_parser
	attr_accessor :mail_sender
	attr_accessor :plugin_manager

	attr_reader :endpoint
	attr_reader :entry_collection_uri
	attr_reader :username
	attr_reader :password

	def initialize(
			endpoint = M2W_WEBLOG_ENDPOINT,
			entry_collection_uri = M2W_WEBLOG_ENTRY_COLLECTION_URI,
			username = M2W_WEBLOG_USERNAME,
			password = M2W_WEBLOG_PASSWORD,
			attachment_root_path = M2W_HATENA_DIARY_ATTACHMENT_ROOT_PATH)
		@endpoint = endpoint
		@username = username
		@password = password
		@entry_collection_uri = entry_collection_uri
	end

	def client
		auth = Atompub::Auth::Wsse.new(:username => @username, :password => @password)
		return Atompub::Client.new(:auth => auth)
	end

	def formatter
		return HatenaDiaryFormatter.new(@plugin_manager)
	end

	def get_post_plugin()
		return HatenaDiaryPost_WeblogPlugin.new(self)
	end

	def get_get_plugin()
		return HatenaDiaryGet_WeblogPlugin.new(self)
	end

	def get_edit_plugin()
		return HatenaDiaryEdit_WeblogPlugin.new(self)
	end

end
