# coding: UTF-8

require 'plugin/weblog/lib/standard_command'
require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/meta_weblog/lib/meta_weblog_post_common'

#=metaWeblog API を使った標準のブログ編集投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogEdit_WeblogPlugin < StandardCommand_WeblogPlugin
	include MetaWeblogPostCommon

	def header_alias
		return M2W_META_WEBLOG_POST_HEADER_ALIAS
	end

	def edit(original_content, header, content, contents, attachments, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#edit ... endpoint = #{@parent.endpoint}, blogid = #{blogid}, header = #{header.to_s}")

		if blogid == '' && @parent.default_blogid != nil && @parent.default_blogid != '' then
			blogid = @parent.default_blogid
		end

		if blogid == '' then
			M2W_LOGGER.error("ブログＩＤが指定されていません。")
			@errors.push(WeblogPluginError.new(
				"ブログＩＤ未指定",
				"ブログＩＤが未指定でした。"))
			return false
		end

		client = @parent.client
		formatter = @parent.formatter
		postid = header['postid']

		if postid != nil then
			begin
				before(client, header, content, attachments, blogid, postid)

				vars = {:blogid => blogid, :postid => postid, :encoding => @parent.encoding, M2W_FORMAT_PLUGIN_CONF_HEADER_NAME => header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME]}
				vars.merge!(header)

				# 書式プラグインの事前処理を行う
				formatter.preset(
					original_content, content, contents, vars, @errors, @warnings)

				# 投稿日付を取得する
				dateCreated = @parent.parse_date(header['dateCreated'], Time.now, @errors, @warnings)
				if header['dateCreated'] != nil then
					header['dateCreated'] = @parent.get_date(dateCreated)
				end

				# 添付ファイルを投稿する
				(attachment_urls, thumbnail_urls) = post_attachments(client, @parent.username, @parent.password, blogid, postid, header, vars, attachments, dateCreated, @errors, @warnings)
				vars[:attachment_urls] = attachment_urls
				vars[:thumbnail_urls] = thumbnail_urls

				# 書式変換を行う
				begin
					formatted_contents = nil
					formatted_contents = formatter.format(
						original_content, content, contents, vars, @errors, @warnings)
					header.merge!(formatted_contents)
				rescue Exception => e
					M2W_LOGGER.error("ブログ記事の書式変換に失敗しました。")
					M2W_LOGGER.error(e)
					@errors.push(WeblogPluginError.new(
						"書式変換エラー(メッセージ = #{e.message})",
						"ブログ記事の書式変換に失敗しました(メッセージ = #{e.message})。"))
					M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = false")
					return false
				end

				# ブログ記事を編集投稿する
				begin
					M2W_LOGGER.debug("Start  metaWeblog.editPost ...")
					result = client.call("metaWeblog.editPost", postid, @parent.username, @parent.password, get_header_for_post(header), 1)
					M2W_LOGGER.debug("Finish metaWeblog.editPost ... result = #{result}")
				rescue Exception => e
					M2W_LOGGER.error("ブログ記事の編集投稿に失敗しました。")
					M2W_LOGGER.error(e)
					@errors.push(WeblogPluginError.new(
						"ブログ記事編集エラー(メッセージ = #{e.message})",
						"ブログ記事の編集に失敗しました(メッセージ = #{e.message})。"))
					M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = false")
					return false
				end

				after(client, header, content, attachments, blogid, postid)

				@report[:original_content] = original_content
				@report[:postid] = postid.to_s
				@report[:attachment_urls] = attachment_urls
				@report[:thumbnail_urls] = thumbnail_urls
				@report[:title] = header['title']

				M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = true")
				return true
			rescue Exception => e
				M2W_LOGGER.error("ブログ記事の編集に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"ブログ記事編集エラー(メッセージ = #{e.message})",
					"ブログ記事の編集に失敗しました(メッセージ = #{e.message})。"))
			end
		else
			@errors.push(WeblogPluginError.new(
				"投稿ＩＤ未指定エラー",
				"投稿ＩＤが未指定です。"))
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = false")
		return false
	end

	def before(client, header, content, attachments, blogid, postid)
	end

	def after(client, header, content, attachments, blogid, postid)
	end

end
