# coding: UTF-8

require 'plugin/weblog/lib/standard_command'

require 'open-uri'

#=metaWeblog API を使った標準のブログ記事取得用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogGet_WeblogPlugin < StandardCommand_WeblogPlugin

	def header_alias
		return {}
	end

	def get(header, content, attachments, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#get ... endpoint = #{@parent.endpoint}, header = #{header.to_s}")
		result = false

		if blogid == '' && @parent.default_blogid != nil && @parent.default_blogid != '' then
			blogid = @parent.default_blogid
		end

		if blogid == '' then
			M2W_LOGGER.error("ブログＩＤが指定されていません。")
			@errors.push(WeblogPluginError.new(
				"ブログＩＤ未指定",
				"ブログＩＤが未指定でした。"))
			return false
		end

		client = @parent.client
		formatter = @parent.formatter

		postid = header['postid']

		before(client, header, content, attachments, blogid, postid)

		# ブログ記事情報を取得する
		begin
			M2W_LOGGER.debug("Start  metaWeblog.getPost ... postid = #{postid}")
			post = client.call("metaWeblog.getPost", postid, @parent.username, @parent.password)
			@report[:postid] = postid.to_s
			@report[:link] = post['link']
			M2W_LOGGER.debug("Finish metaWeblog.getPost ... result = #{post.to_s}")
		rescue => e
			M2W_LOGGER.error("ブログ記事の取得に失敗しました。")
			M2W_LOGGER.error(e)
			@errors.push(WeblogPluginError.new(
				"ブログ記事取得エラー(メッセージ = #{e.message})",
				"ブログ記事の取得に失敗しました(メッセージ = #{e.message})。"))
			return false
		end

		# ブログ記事情報を解析する
		(version, wikicontent) = formatter.get_uncommentout_content(post['description'])
		if wikicontent != nil then
			@report[:original_content] = wikicontent
			result = true
		end
		attachment_urls = formatter.get_uncommentout_attachment_urls_content(post['description'])
		@report[:attachments] = get_attachments(attachment_urls)

		after(client, header, content, attachments, blogid, postid)

		M2W_LOGGER.debug("Finish #{self.class.name}#get ... result = #{result}")
		return result
	end

	def before(client, header, content, attachments, blogid, postid)
	end

	def after(client, header, content, attachments, blogid, postid)
	end

	def get_attachments(urls)
		M2W_LOGGER.debug("Start  #{self.class.name}#get_attachments ... urls = #{urls.to_s}")
		result = []

		urls.each do |index, url|
			begin
				if url != nil then
					open(url, 'rb') do |f|
						attachment_content = f.gets(nil)
						if %r!/([^/]+)$! =~ url then
							attachment_filename = $1
							M2W_LOGGER.debug("attachment ... index = #{index.to_i - 1}, filename = #{attachment_filename}")
							result[index.to_i - 1] = MailAttachment.new(attachment_filename, attachment_content)
						end
					end
				else
					M2W_LOGGER.debug("no attachment ... index = #{index.to_i - 1}")
					result[index.to_i - 1] = nil
				end
			rescue => e
				M2W_LOGGER.error("添付ファイルの取得に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"添付ファイル取得エラー(メッセージ = #{e.message})",
					"添付ファイルの取得に失敗しました(メッセージ = #{e.message})。"))
			end
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#get_attachments ... result = #{result.size}")
		return result
	end

end
