# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog'
require 'plugin/weblog/movable_type/movable_type_edit'
require 'plugin/weblog/movable_type/movable_type_post'

M2W_WEBLOG_MT_DEFAULT_ENCODING = 'UTF-8'
M2W_WEBLOG_MT_CATEGORIES = 'categories'
M2W_WEBLOG_MT_ATTACHMENT_ROOT_PATH = 'attachments/'
M2W_WEBLOG_MT_THUMBNAIL_ROOT_PATH = 'thumbnails/'

#=Movable Type のためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MovableType_WeblogPlugin < MetaWeblog_WeblogPlugin

	def initialize(
			endpoint = M2W_WEBLOG_ENDPOINT,
			username = M2W_WEBLOG_USERNAME,
			password = M2W_WEBLOG_PASSWORD,
			encoding = M2W_WEBLOG_MT_DEFAULT_ENCODING,
			attachment_root_path = M2W_WEBLOG_MT_ATTACHMENT_ROOT_PATH,
			thumbnail_root_path = M2W_WEBLOG_MT_THUMBNAIL_ROOT_PATH,
			default_blogid = M2W_WEBLOG_DEFAULT_BLOGID)
		super
	end

	def header_alias_for_post
		return {'keys' => 'mt_keywords', 'tags' => 'mt_tags', 'cats' => M2W_WEBLOG_MT_CATEGORIES}
	end

	# 添付ファイルのデフォルトのパスを取得します。
	def get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}/#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# サムネイルのデフォルトのパスを取得します。
	def get_thumbnail_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@thumbnail_root_path}#{postid}/#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_post_plugin()
		return MovableTypePost_WeblogPlugin.new(self)
	end

	# ブログ記事編集用のプラグインを取得します。
	def get_edit_plugin()
		return MovableTypeEdit_WeblogPlugin.new(self)
	end

	# ブログ記事にカテゴリを設定する
	def set_post_categories(client, blogid, postid, categories, errors, warnings)
		if categories != nil then
			begin
				M2W_LOGGER.debug("Start  mt.getCategoryList ... categories = #{categories}")
				category_map = get_category_map(client.call("mt.getCategoryList", blogid, username, password), errors, warnings)
				M2W_LOGGER.debug("Finish mt.getCategoryList ... category_map = #{category_map}")

				M2W_LOGGER.debug("Start  mt.setPostCategories ... categories = #{categories}")
				result = client.call(
					"mt.setPostCategories",
					postid, username, password,
					get_category_array(categories, category_map, errors, warnings))
				M2W_LOGGER.debug("Finish mt.setPostCategories")
			rescue => e
				M2W_LOGGER.error("カテゴリの設定に失敗しました。")
				M2W_LOGGER.error(e)
				errors.push(WeblogPluginError.new(
					"カテゴリ設定エラー(メッセージ = #{e.message})",
					"カテゴリの設定に失敗しました(メッセージ = #{e.message})。"))
			end
		end

		return [errors, warnings]
	end

	# ブログ記事の再構築を行う
	def publish_post(client, postid, errors, warnings)
		begin
			M2W_LOGGER.debug("Start  mt.publishPost ... postid = #{postid}")
			result = client.call("mt.publishPost", postid, username, password)
			M2W_LOGGER.debug("Finish mt.publishPost ...")
		rescue => e
			M2W_LOGGER.error("ブログ記事の事前書式変換に失敗しました。")
			M2W_LOGGER.error(e)
			errors.push(WeblogPluginError.new(
				"事前書式変換エラー(メッセージ = #{e.message})",
				"ブログ記事の事前書式変換に失敗しました(メッセージ = #{e.message})。"))
		end
	end

	def get_category_map(categories, errors, warnings)
		result = {}
		# カテゴリ名はカテゴリＩＤにマップする
		categories.each do |category|
			result[category['categoryId']] = category['categoryId']
		end

		# カテゴリＩＤはそのままカテゴリＩＤにマップする
		#
		# （※）
		# このカテゴリマップ作成の順番は、
		# カテゴリ名にカテゴリＩＤと重複するものが存在する場合、カテゴリ名を優先するということを意味する。
		# 恐らくはレアケースと思われるが、人間へのわかりやすさという観点からそう決定する。
		categories.each do |category|
			result[category['categoryName']] = category['categoryId']
		end
		return result
	end

	def get_category_array(categories, category_map, errors, warnings)
		result = []

		categories.split(",").each do |category|
			if category_map.has_key?(category) then
				result.push({"categoryId" => category_map[category]})
			else
				warnings.push(WeblogPluginError.new(
					"カテゴリ不在(カテゴリ = #{category})",
					"カテゴリが存在しませんでした(カテゴリ = #{category})。"))
			end
		end

		return result
	end

end
