# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog_edit'

#=Movable Type のためのブログ記事編集用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MovableTypeEdit_WeblogPlugin < MetaWeblogEdit_WeblogPlugin

	def header_alias
		result = super
		return result.merge(@parent.header_alias_for_post)
	end

	def before(client, header, content, attachments, blogid, postid)
		@categories = header[M2W_WEBLOG_MT_CATEGORIES]
		header.delete(M2W_WEBLOG_MT_CATEGORIES)
	end

	def after(client, header, content, attachments, blogid, postid)
		@parent.set_post_categories(client, blogid, postid, @categories, @errors, @warnings)
		@parent.publish_post(client, postid, @errors, @warnings)
	end

end
